#ifndef UTIL_H
#define UTIL_H

#define white  0
#define black  1
#define false  0
#define true   1


/*  MACRO definitions */

#define DEFAULT_NEWLINE_PREFIX "DEBUG: "

#ifndef MAX
#define MAX(a,b)     ((a) > (b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b)     ((a) < (b) ? (a) : (b))
#endif
#define SET(a,b)                     \
  do {                               \
    (a) |= (b);                      \
    Log("Set   0x%x\n", (b)); \
  } while (0)
#define CLEAR(a,b)                   \
  do {                               \
    (a) &= ~(b);                     \
    Log("Clear 0x%x\n", (b)); \
  } while (0)


/* Draw score can be used to penalise draws if desired */
#define	DRAWSCORE   0 
#define MATERIAL(board,side)     ((board)->material[(side)] - (board)->material[1^(side)])
//#define PHASEINIT(board)	     (MAX(0,(8 - ((board)->material[white]+(board)->material[black]) / 1150)))
//#define PHASE(board)	     (board->phase)


#define SideToMove(GameCnt) ((GameCnt)%2==0?white:black)


#define ks 0
#define qs 1
#define INFIN  99999
#define MATE	  9999
#define MATESCORE(a)	((a) > MATE-255  || (a) < -MATE+255)


#define MAXPLYDEPTH   250
#define MAXMOVES      200
#define MAXGAMEDEPTH  600
#define MAXFEN        600
#define MAXPV          30
#define SANSZ 8 /* longest move is "exf8=Q+" so 7+1 */

 /*
  * Define macro for declaring 64bit constants for compilers not using ULL
  */


#ifdef _MSC_VER
   #define ULL(x) ((uint64_t)(x))
#else
   #define ULL(x) x ## ULL
#endif

#define StartFen "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1"

void Output(char  *fmt, ...);
void OutputConsole(char  *fmt, ...);

// [VdB] Some elementary functions borrowed from Polyglot. 
// Written by Fabien Letouzey.

void my_string_set(const char ** variable, const char string[]);
int  my_string_case_equal(const char string_1[], const char string_2[]);
int  my_string_equal(const char string_1[], const char string_2[]);
void my_string_clear(const char ** variable);
void my_string_append(char **dst, const char *src);
void my_path_join(char *join_path, const char *path, const char *file);
void my_machine(char *hostname);

/* from polyglot */

#undef ASSERT
#ifdef DEBUG
#include <assert.h>
#  define ASSERT(a) { if(!(a)) {Log("file \"%s\", line %d, assertion \"" #a "\" failed\n",__FILE__,__LINE__); assert(a);}}
#else
#  define ASSERT(a)
#endif

// [VdB] Made this bigger

#define MAXSTR 4096
#define TOKENS 3

#if defined(_MSC_VER) || defined(__MINGW32__) || defined(__MINGW64__)
#  define S64_FORMAT "%I64d"
#  define U64_FORMAT "%016I64x"
#else
#  define S64_FORMAT "%lld"
#  define U64_FORMAT "%016llx"
#endif


void gnuchess_set_option(const char *name, const char *value);
void my_sleep(int msec);

/* Input parser */
void split_input(char *inputstr);
int tokeneq(const char *s, const char *t);

// variables

extern char *token[TOKENS];



#endif
