#ifndef UCI_H
#define UCI_H

// includes

#include "board.h"

// defines

#define UCI_NOTYPE        0
#define UCI_ISREADY       1
#define UCI_POSITION      2
#define UCI_SETOPTION     3
#define UCI_GO            4
#define UCI_NEWGAME       5
#define UCI_STOP          6
#define UCI_PONDERHIT     7
#define UCI_QUIT          8
#define UCI_UCI           9

// types

typedef struct {
    int type; // isready position go setoption stop ponderhit quit ucinewgame
    board_t board[1];// position
    const char *name;      // setoption
    const char *value;     // setoption
    int wtime;       // go
    int winc;        // go
    int btime;       // go
    int binc;        // go
    int ponder;      // go
    int depth;       // go
    int nodes;       // go
    int movetime;    // go
    int movestogo;   // go
    int infinite;    // go 
    
} uci_t;

// functions

void UciClear(uci_t *uci);
void UciShow(uci_t *uci);
void UciFromString(uci_t *uci, char *s);
void UciMainLoop();

#endif
