#ifndef SORT_H
#define SORT_H

// macros

/*  The various phases during move selection  */
#define PICKHASH    1
#define PICKGEN1    2
#define PICKCAPT    3
#define PICKKILL1   4
#define PICKKILL2   5
#define PICKGEN2    6
#define PICKHIST    7
#define PICKREST    8
#define PICKCOUNTER 9
#define PICKBADCAPT 10
#define PICKDONE    11
#define PICKGENQUIETCHECKS    12
#define PICKQUIETCHECKS    13

// includes

#include "movelist.h"
#include "move.h"

// types

typedef struct {
    int phase;
    movelist_t movelist[1];
    movelist_t captures[1];
    movelist_t quietchecks[1];
    leaf *badcap;
    leaf killer1[1];
    leaf killer2[1];
    leaf hashmv[1];
    leaf *p;
    int count;
    int killer1_invalid;
    int killer2_invalid;
#ifdef DEBUG
    movelist_t all_moves[1];
#endif 
} pickstate_t;

// functions

void PickStateInit(pickstate_t *pickstate);
void SortRoot (board_t *board, movelist_t *movelist);
int PhasePick (board_t *board, 
	       searchdata_t *searchdata, 
	       pickstate_t *pickstate,
	       leaf **p1, 
	       int ply,
	       int depth);
int PhasePick1 (board_t *board, 
		searchdata_t *searchdata, 
		pickstate_t *pickstate,
		leaf **p1, 
		int ply,
		int depth);

int PhasePickQuiesce(board_t *board, 
		     searchdata_t *searchdata, 
		     pickstate_t *pickstate,
		     leaf **p1, 
		     int ply,
		     int depth);
#endif
