#ifndef PROTOCOL_H
#define PROTOCOL_H

// macros

#define PROTOCOL_UCI    0
#define PROTOCOL_XBOARD 1

/*  Game flags */
#define QUIT      0x0001
// states
#define THINK     0x0004 /* Start thinking about a regular computer move (not pondering) */
#define MANUAL    0x0008 /* When on move wait */
#define ANALYZE   0x8000 /* In ANALYZE mode */
// flags
#define POST      0x1000 /* Display output when thinking */
#define HARD      0x4000 /* Pondering is turned on */

// includes 

#include "game.h"

// types

typedef struct {
    int protocol;
    int console;
    int TCinc;
    float TCTime;
    int TCMove;
    int SearchDepth;
    float TimeLimit[2];
    int NPS;
    int ST;
    int NextPeriod;
    int computer;
    const char *name;
    game_t game[1];
    volatile unsigned int state_flags;
    unsigned int preanalyze_flags;
    char *progname;
} protocol_t;


// variables

extern protocol_t Protocol[1];

// functions

void ProtocolInit(protocol_t *protocol);

#endif
