#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include "util.h"
#include "protocol.h"

protocol_t Protocol[1];

void ProtocolInit(protocol_t *protocol){
    char *name;
    protocol->protocol=PROTOCOL_XBOARD;
    protocol->console=isatty(fileno(stdout));
    protocol->TCinc=0;
    protocol->TCMove=40;
    protocol->TCTime=5.0;
    protocol->SearchDepth=0;
    protocol->TimeLimit[white]=60*protocol->TCTime;
    protocol->TimeLimit[black]=60*protocol->TCTime;
    protocol->NPS=0;
    protocol->ST=0;
    protocol->NextPeriod=2*protocol->TCMove;
    protocol->computer=black;
    name=getenv("LOGNAME");
    if(name){
	protocol->name=strdup(name);
    }else{
	protocol->name=strdup("Unknown");
    }
    GameInit(protocol->game);
    protocol->state_flags=0;
    protocol->progname=NULL;
    protocol->state_flags=ULL(0);
}
