#ifndef PGN_H
#define PGN_H

// includes

#include <stdio.h>
#include "game.h"

// types

typedef struct {
  FILE *fp;
  void* scanner;
}   pgn_iter_t;

// variables

extern pgn_iter_t PGNIter[1];

// functions

/*  PGN routines  */
void PGNSaveToFile (const char *file, game_t *game, const char *resultstr);
void PGNReadFromFile (game_t *game, const char *file);
void PGNIterInit(pgn_iter_t *pgn_iter);
int PGNIterStart(pgn_iter_t *pgn_iter, const char *file);
void PGNIterClose(pgn_iter_t *pgn_iter);
int PGNIterNext (pgn_iter_t *pgn_iter, game_t *game);

#endif
