
// option.h

#ifndef OPTION_H
#define OPTION_H

// includes

// defines

#define VarNb     16
#define MODE_XBOARD   (1<<0)
#define MODE_UCI      (1<<1)
#define MODE_ALL  (MODE_XBOARD|MODE_UCI)
#define MODE_NONE      0
#define OptionNb  256

#define IS_BUTTON(str) (my_string_case_equal(str,"button") ||      \
                        my_string_case_equal(str,"save")   ||      \
                        my_string_case_equal(str,"reset"))         \

#define IS_SPIN(str)   (my_string_case_equal(str,"spin") ||        \
                        my_string_case_equal(str,"slider"))        \

#define IS_STRING(str) (my_string_case_equal(str,"string") ||      \
                        my_string_case_equal(str,"path")   ||      \
                        my_string_case_equal(str,"file"))          \

// types

typedef struct {   // TODO: put back in more logical order
    const char * name;
    const char * type;
    const char * min;
    const char * max;
    const char * default_;
    const char * value;
    int var_nb;
    const char * var[VarNb];
  int mode;
} option_t;

/* all non NULL data in an option_list_t should be malloc'ed
   use "my_string_set" to fill it. 
*/

typedef struct {
    option_t options[OptionNb];
    int option_nb;
    int iter;
} option_list_t;

// variables

extern option_list_t Option[1];

// more includes

// functions


extern void         OptionInit      ();

extern int         OptionSet          (option_list_t *option,
                                         const char var[],
                                         const char val[]);
extern int         OptionSetDefault  (option_list_t *option,
                                         const char var[],
                                         const char val[]);

extern const char * OptionGet          (option_list_t *option, const char var[]);
extern const char * OptionGetDefault   (option_list_t *option, const char var[]);

extern int         OptionGetBool      (option_list_t *option, const char var[]);
extern double       OptionGetDouble    (option_list_t *option, const char var[]);
extern int          OptionGetInt       (option_list_t *option, const char var[]);
extern const char * OptionGetString    (option_list_t *option, const char var[]);

extern int         OptionIsOk         (const option_list_t *option);
extern option_t *   OptionFind         (option_list_t *option, const char var[]);
extern void         OptionClear        (option_list_t *option);
extern void         OptionInsert       (option_list_t *option, option_t *new_option);

extern void         OptionStartIter   (option_list_t *option);
extern option_t *   OptionNext         (option_list_t *option);

extern void         OptionFree         (option_t *option);

#endif 



