#ifndef MATERIAL_H
#define MATERIAL_H

// includes

#include "GCint.h"

// macros

#define MATERIAL_SIZE (9*3*3*3*2*9*3*3*3*2)

#define MATERIAL_KPK  1
#define MATERIAL_KBPK 2
#define MATERIAL_KQKP 3
#define MATERIAL_KNK  4
#define MATERIAL_KBK  5
#define MATERIAL_KBNK 6
#define MATERIAL_KNNK 7
#define MATERIAL_KBKB 8
#define MATERIAL_KBKN 9
#define MATERIAL_KNKN 10

#define MATERIAL_BB            0x1
#define MATERIAL_PAWN_ENDGAME  0x2
#define MATERIAL_WINNER_BLACK  0x4

// types

typedef struct {
    short score;
    uint8_t flags;
    uint8_t recog;
    uint8_t phase;
} material_slot_t;

// variables

extern int MaterialDelta[2][8];
extern material_slot_t  Material[MATERIAL_SIZE];


// functions

void MaterialInit(void);
int MaterialToIndex(int material[2][8]);
void MaterialFromIndex(int material[2][8], int index);

#endif
