// log.h

#ifndef LOG_H
#define LOG_H

// includes

#include <stdio.h>
#include <stdlib.h>

// types

typedef struct {
    const char *filename;
    FILE *ofp;
    int state;  // logging on/off
    int append;  
    int timestamp;
    int was_newline;
    const char *newline_prefix;
    const char *banner;
} log_t;

// variables

extern log_t LogDefault[1];
extern log_t LogDump[1];



// functions


void Log(char *fmt, ...);
void LogInit(log_t *logger);
void LogClear(log_t *logger);
void LogSetFile(log_t *logger, const char *filename);
void LogSetNewlinePrefix(log_t *logger, const char *s);
void LogSetState(log_t *logger, int state);
void LogSetTimeStamp(log_t *logger, int timestamp);
void LogString(log_t *logger, char *fmt, ...);
void LogEnsureNewline(log_t *logger);
void LogSetAppend(log_t *logger, int append);


#endif // LOG_H
