/* GNU Chess 5.0 - init.c - initialization of variables code
   Copyright (c) 1999-2002 Free Software Foundation, Inc.

   GNU Chess is based on the two research programs 
   Cobalt by Chua Kong-Sian and Gazebo by Stuart Cracraft.

   GNU Chess is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GNU Chess is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Chess; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     bug-gnu-chess@gnu.org
     cracraft@ai.mit.edu, cracraft@stanfordalumni.org, cracraft@earthlink.net
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <sys/time.h>
#include <time.h>

#include "util.h"
#include "version.h"
#include "book.h"
#include "bitboard.h"
#include "magic.h"
#include "log.h"
#include "option.h"
#include "ttable.h"
#include "ptable.h"
#include "piece.h"
#include "pgn.h"
#include "epd.h"
#include "protocol.h"
#include "hash.h"
#include "search.h"
#include "log.h"
#include "material.h"
#include "epd.h"
#include "input.h"

void Initialize (int console)
/**************************************************************************
 *
 *  The main initialization driver.
 *
 **************************************************************************/
{

   /* Initialize random number generator */
   srand((unsigned int) time(NULL));

   ProtocolInit(Protocol);
   Protocol->console=console && isatty(fileno(stdout));


   BitBoardInit();
   HashKeyInit ();

     
   OptionInit(Option);
   SearchInit(Option);

   LogInit(LogDefault);
   LogSetFile(LogDefault,OptionGet(Option,"LogFile"));
   LogSetState(LogDefault,OptionGetBool(Option,"Log"));
   LogSetTimeStamp(LogDefault,true);
   LogSetNewlinePrefix(LogDefault,DEFAULT_NEWLINE_PREFIX);
   LogSetAppend(LogDefault,OptionGetBool(Option,"LogAppend"));
   Log("\n\nOPENING LOGFILE\n***************\n\n");

   LogInit(LogDump);
   LogSetFile(LogDump,OptionGet(Option,"DumpFile"));
   LogSetState(LogDump,OptionGetBool(Option,"DumpTree"));
   LogSetAppend(LogDump,false);
   LogSetTimeStamp(LogDump,false);
   LogSetNewlinePrefix(LogDump, "");


   MagicInit();
   
   MaterialInit();

   TTableInit(TTable);
   TTableSetSizeMb(TTable,OptionGetInt(Option,"Hash"));

   PTableInit (PTable);
   PTableSetSize(PTable,PAWNSLOTS);

   EPDIterInit(EPDIter);
   PGNIterInit(PGNIter);
   InputInit (); 
   BookInit(Book);
   BookSetFile(Book,OptionGet(Option,"BookFile"));
   
   
   GameNew(Protocol->game);



}


























