// ini.h

#ifndef INI_H
#define INI_H

// includes

#include "option.h"

// macros

#define IniEntriesNb 256


// types

typedef struct {
    const char *section;
    const char *name;
    const char *value;
    const char *comment;
} ini_entry_t;

typedef struct {
    ini_entry_t entries[IniEntriesNb];
    int index;
    int iter;
} ini_t;

typedef enum {
    SYNTAX_ERROR,
    EMPTY_LINE,
    NAME_VALUE,
    EMPTY_VALUE,
    SECTION
} line_type_t;

// functions

extern void         IniInit              (ini_t *ini);
extern void         IniClear             (ini_t *ini);
extern void         IniCopy              (ini_t *dst, ini_t *src);
extern int          IniParse             (ini_t *ini, const char *filename);
extern void         IniShow              (ini_t *ini);
extern void         IniInsert            (ini_t *ini, ini_entry_t *entry);
extern void         IniInsertEx         (ini_t *ini,
                                           const char *section,
                                           const char *name,
                                           const char *value);
extern void         IniStartIter        (ini_t *ini);
extern ini_entry_t *IniNext              (ini_t *ini);
extern ini_entry_t *IniFind              (ini_t *ini,
                                           const char *section,
                                           const char *name);
extern line_type_t IniLineParse         (const char *line,
                                           char *section,
                                           char *name,
                                           char *value);

extern void IniFromOption(ini_t *ini, option_list_t *option);
void IniSave(ini_t *ini, const char *filename);

#endif // !defined INI_H

// end of ini.h
