#include <string.h>

#include "history.h"
#include "move.h"
#include "util.h"

#define HISTSCORE(d)	((d)*(d))
#define HISTORY_MAX 16384


static int HistoryIndex(board_t *board,int move){
    int index;
    ASSERT(board->cboard[FROMSQ(move)]>0);
    index=board->cboard[FROMSQ(move)]-1+6*board->side+12*TOSQ(move);
    ASSERT(0<=index && index<HISTORY_SIZE);
    return index;
	   
}

void HistoryInit(history_t *history){
    memset(history,0,sizeof(history_t));
}

void HistoryGood(history_t *history, board_t *board, int move, int depth){
    int index, index1;
    if(move & (CAPTURE | PROMOTION)){
	return;
    }
    index=HistoryIndex(board,move);
    (*history)[index] += HISTSCORE(depth)*2;
    if((*history)[index] >= HISTORY_MAX){
	for(index1=0;index1<HISTORY_SIZE;index1++){
	    (*history)[index1]=((*history)[index1]+1)/2;
	}
    }
}

void HistoryBad(history_t *history, board_t *board, int move, int depth){
    int index, index1;
    return;
    if(move & (CAPTURE | PROMOTION)){
	return;
    }
    index=HistoryIndex(board,move);
    (*history)[index] -= HISTSCORE(depth);
    if((*history)[index] <= -HISTORY_MAX){
	for(index1=0;index1<HISTORY_SIZE;index1++){
	    (*history)[index1]=((*history)[index1]-1)/2;
	}
    }
}

int HistoryGet(history_t *history, board_t *board, int move){
    int index;
    index=HistoryIndex(board,move);
    return (*history)[index];
}

