// game.h

#ifndef GAME_H
#define GAME_H

// includes

#include "board.h"
#include "game.h"

// macros

#define MAXGAMEDEPTH 600
#define R_WHITE_WINS 1
#define R_BLACK_WINS 2
#define R_DRAW 3
#define R_NORESULT 4

// types

/*
 * GameRec records an individual move made in the game; an entire
 * Game is a set of GameRec's:
 */


typedef struct
{
  int move;    /* The actual move made; this is NOT the move count! */
  float et;     /* elapsed time */
  char *comments;
} GameRec;


typedef struct {
  int InitialGameCnt;
  const char *InitialFen;
  int RealGameCnt;
  int white_rating;
  int black_rating;
  int result;
  const char *result_str;
  const char *event;
  const char *site;
  const char *date;
  const char *round;
  const char *white_name;
  const char *black_name;
  const char *white_ELO;
  const char *black_ELO;
  const char *white_title;
  const char *black_title;
  const char *othertags;
  const char *initial_comments; 
  // XXX
  GameRec boards[MAXGAMEDEPTH];
} game_t;

// variables

// extern game_t Game[1];


// functions

void GameInit(game_t *game);
void GameNew(game_t *game);
void GameSetBoard(game_t *game, char *fen);
void GameShow (game_t *game);
char* GameToString (game_t *game); /* The returned string must be freed! */
void BoardFromGame(board_t *board, game_t *game, int gamecnt);
void GameSave (game_t *game, const char *file);

#endif 
