/* GNU Chess 5.0 - book.h - book symbolic definitions
   Copyright (c) 1999-2002 Free Software Foundation, Inc.

   GNU Chess is based on the two research programs 
   Cobalt by Chua Kong-Sian and Gazebo by Stuart Cracraft.

   GNU Chess is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GNU Chess is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Chess; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     bug-gnu-chess@gnu.org
     cracraft@ai.mit.edu, cracraft@stanfordalumni.org, cracraft@earthlink.net
*/

// book.h

#ifndef BOOK_H
#define BOOK_H

// includes

#include "stdio.h"
#include "GCint.h"
#include "board.h"
#include "movelist.h"


/* Book types */

#define BOOK_UNKNOWN     0
#define BOOK_POLYGLOT    2
#define BOOK_INVALID     3
#define BOOK_GNUCHESS    4

// types

/*
 * Return values (errorcodes) for the book routines,
 * maybe one should have a global enum of errorcodes
 */
enum {
  BOOK_SUCCESS,
  BOOK_EFORMAT,  /* Wrong format (e.g. produced by older version) */
  BOOK_EMIDGAME, /* Move is past the opening book's move limit */ 
  BOOK_EIO,      /* I/O error, e.g. caused by wrong permissions */
  BOOK_EFULL,    /* Book hash is full, new position was not added. */
  BOOK_ENOBOOK,  /* No book present */
  BOOK_ENOMOVES, /* No moves found (in BookQuery() only) */
  BOOK_ENOMEM,    /* Memory allocation failed */
  BOOK_OVERFLOW   /* Too many wins draws or losses */
};

typedef struct {
    int type;
    // polyglot book data
    FILE *pg_file;
    // gnuchess book data
    const char *filename;
    struct hashtype {
	uint16_t wins;
	uint16_t losses;
	uint16_t draws;
	HashType key;
	uint32_t move;
    } *bookpos;
    int digest_bits;
    int bookcnt;
    int bookhashcollisions;
    int newpos, existpos;		
} book_t;


// variables

extern book_t Book[1];

// functions

int BookBuilderOpen(book_t *book);
int BookBuilder (book_t *book, 
		 board_t *board, 
		 uint32_t move,
		 short result);

int BookBuilderClose(book_t *book);
void BookAdd (const char *file, const char *bookfile);

const char *BookFind(void);

void  BookInit(book_t *book);
void BookSetFile(book_t *book, const char *filename);
void BookQuery (book_t *book,board_t *board,movelist_t *movelist);
void BookConvert(const char *dst_file, const char *src_file);
void BookShow(book_t *book);


#endif 


