/* GNU Chess 5.0 - book.h - book symbolic definitions
   Copyright (c) 1999-2002 Free Software Foundation, Inc.

   GNU Chess is based on the two research programs 
   Cobalt by Chua Kong-Sian and Gazebo by Stuart Cracraft.

   GNU Chess is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GNU Chess is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Chess; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     bug-gnu-chess@gnu.org
     cracraft@ai.mit.edu, cracraft@stanfordalumni.org, cracraft@earthlink.net
*/

// board.h

#ifndef BOARD_H
#define BOARD_H

// includes

#include "bitboard.h"
#include "hash.h"

// macros

#define BOARD_PLAYING 0
#define BOARD_WHITE_WINS 1
#define BOARD_BLACK_WINS 2
#define BOARD_3FOLD_REPETITION 3
#define BOARD_50MOVERULE 4
#define BOARD_STALEMATE 5

#define BOARD_FIRST -1
#define BOARD_LAST -2

#define MAXSTACK 105

/* constants for Board */
#define WKINGCASTLE   0x0001
#define WQUEENCASTLE  0x0002
#define BKINGCASTLE   0x0004
#define BQUEENCASTLE  0x0008
#define WCASTLE	      (WKINGCASTLE | WQUEENCASTLE)
#define BCASTLE	      (BKINGCASTLE | BQUEENCASTLE)



// types

/*
 * Board represents an entire board's state, and is structured to
 * simplify analysis:
 */

typedef struct 
{
    BitBoard b[2][7];      /* piece/pawn positions by side (0=white, 1=black)
			      and then by piece (1=pawn..6=king). For example,
			      b[white][knight] has bits set for every board
			      position occupied by a White Knight. */
    BitBoard friends[2];   /* Friendly (this side's) pieces */
    BitBoard blocker;      /* friends[0]|friends[1] */
    short ep;              /* Location of en passant square */
    short flag;            /* Flags related to castle privileges */
    short side;            /* Color of side on move: 0=white, 1=black */
    short material[2];     /* Total material by side not inc. king */
    short pmaterial[2];    /* Total non pawn material by side not inc. king */
    short castled[2];      /* True (1) if side is castled */
    short king[2];         /* Location of king 0 - a1 .. 63 - h8 */
    int cboard[64];        /* cboard[i] returns the piece on square i. */
    int Mvboard[64];       /* Mvboard[i] returns the number of times the piece
			      on square i has moved.*/
    int Game50; /* The last value of GameCnt (a count of half-moves)
		   that castled, captured, or moved a pawn */
    int GameCnt;
    int in_check;
    int xin_check;
    HashType HashKey;
    HashType PawnHashKey;
    int material_index;
    int phase;
    
    HashType stack[MAXSTACK]; 
} board_t; 

// more includes

//#include "game.h"

// functions

int BoardFromFen (board_t *board, const char *fen);
void BoardToFen (board_t *board, char *fen);
int BoardState(board_t *board);
int BoardRepeat(board_t *board);
int BoardIsEqual(board_t *first, board_t *second);
short BoardValidate (board_t *board);
void BoardShow(board_t *board);
void BoardHashKeyUpdate (board_t *board);
void BoardUpdateBlockers(board_t *board);
void BoardUpdateMaterialIndex(board_t *board);
void BoardUpdateFriends (board_t *board);
void BoardUpdateCBoard (board_t *board);
void BoardUpdateMvboard (board_t *board);
void BoardCopy(board_t *dst_board, board_t *src_board);

#endif 


