// TestAndTune.h: interface for the TestAndTune class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TESTANDTUNE_H__C9BC0527_FB60_4203_94B8_C0D58A9FBEA6__INCLUDED_)
#define AFX_TESTANDTUNE_H__C9BC0527_FB60_4203_94B8_C0D58A9FBEA6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Engine.h"
#include "Constants.h"
#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "EvaluationParameters.h"

class TestAndTune  
{

private:

	Engine* engine1;
	Engine* engine2;

	int engine1Wins, draws, engine2Wins;
	int TestPopulationMembers(int member1Index, int member2Index, int milisecondsPerMove, EvaluationParameters* member1, EvaluationParameters* member2);
	
	void SaveMembers(int c, EvaluationParameters* population[POPULATION_SIZE]);
	int LoadMembers(EvaluationParameters* population[POPULATION_SIZE]);
	void SaveAverageAndDesviation(EvaluationParameters* population[POPULATION_SIZE]);
	
public:
	TestAndTune();
	virtual ~TestAndTune();
	void TestNGames(int secondsPerMove, int numberOfGames);
	void EvolutionaryTuning(int generations);
	EvaluationParameters* GetAverageFromMembersFile();
};

#endif // !defined(AFX_TESTANDTUNE_H__C9BC0527_FB60_4203_94B8_C0D58A9FBEA6__INCLUDED_)
