// TestAndTune.cpp: implementation of the TestAndTune class.
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "TestAndTune.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

TestAndTune::TestAndTune()
{
}


TestAndTune::~TestAndTune()
{
}

int gameCount;
void TestAndTune::EvolutionaryTuning(int generations)
{
	gameCount = 0;

	srand(unsigned(time(NULL)));
	int generationNumber = 0;
		
	//Population size of POPULATION_SIZE members
	EvaluationParameters* population[POPULATION_SIZE];
	for (int m = 0; m<POPULATION_SIZE; m++)
	{
		EvaluationParameters* member = new EvaluationParameters();
		population[m] = member;
	}

	//The default member is in the last position of the population.
	int c = LoadMembers(population);
	if (c==-1)
	{	
		population[POPULATION_SIZE-1] = new EvaluationParameters();
		for (int m = 0; m<(POPULATION_SIZE-1); m++)
		{
			population[m]->GenerateRandomly();
		}
		SaveMembers(0, population);
		SaveAverageAndDesviation(population);
		c=0;
	}
	
	while (generationNumber < generations)
	{	
		generationNumber++;
		for (c; c<(POPULATION_SIZE-1); c++)
		{
			SaveMembers(c, population);

			int randNumber = (rand() % (POPULATION_SIZE-c));
			if (randNumber>0)
				randNumber--;
		
			int i = c + 1 + randNumber;
		
			EvaluationParameters* memberc = population[c];
			EvaluationParameters* memberi = population[i];
			
			int matchResult = TestPopulationMembers(c, i, 3000, memberc, memberi);
			
			//member c win the match
			if (matchResult > 0)
			{
				if (matchResult == 2)
					population[i] = memberc->Mutate(population, 2);	 //a R=2 mutated member c replace member i
				else
				{
					population[i] = memberc->Mutate(population, 1);  //a R=1 mutated member c replace member i
					population[c] = memberc->Mutate(population, 0.2);//member c mutate by R=0,2
				}

			}
			//member i win the match
			else if (matchResult < 0)
			{
				if (matchResult == -2)
					population[c] = memberi->Mutate(population, 2);  //a R=2 mutated member i replace member c
				else
				{
					population[c] = memberi->Mutate(population, 1);  //a R=1 mutated member i replace member c
					population[i] = memberc->Mutate(population, 0.2);//member i mutate by R=0,2
				}
			}
			//the match finish draw
			else
			{
				population[c] = memberc->Mutate(population, 0.5);  //member c mutate by R=0,5
				population[i] = memberi->Mutate(population, 0.5);  //member i mutate by R=0,5
			}
		}

		for (int j=0; j<POPULATION_SIZE; j++)
		{
			int reverseIndex = POPULATION_SIZE-1-j;
			if (j<reverseIndex)
			{
				EvaluationParameters* indexMember = population[j];
				EvaluationParameters* reverseIndexMember = population[reverseIndex];

				population[j] = reverseIndexMember;
				population[reverseIndex] = indexMember;
			}
			else
				break;
		}
		
		//Save the members after each generation.
		c=0;
		SaveMembers(0, population);
		SaveAverageAndDesviation(population);
		
	}
}

void TestAndTune::SaveAverageAndDesviation(EvaluationParameters* population[POPULATION_SIZE])
{
	ofstream info_file("C:\\average_and_desviation.txt",ios::app);
	
	double parameterAverage=0;
	double parameterSum=0;
	double parameterDesviation=0;
	double parameterDesviationSum=0;
	double totalParametersDesviation=0;

	EvaluationParameters defaultEp;

	//Do the proccess for each of the n parameters
	for (int parameter=0; parameter<EVALUATION_PARAMETERS_COUNT; parameter++)
	{
		parameterDesviationSum=0;
		parameterSum=0;

		for (int member=0; member<POPULATION_SIZE; member++)
			parameterSum += population[member]->GetParameterByIndex(parameter);
		
		parameterAverage = parameterSum/POPULATION_SIZE;

		info_file << (parameter+1) << ": default=" << defaultEp.GetParameterByIndex(parameter);
		info_file << ", av=" << parameterAverage << ", sd=";

		for (int member=0; member<POPULATION_SIZE; member++)
			parameterDesviationSum += pow(population[member]->GetParameterByIndex(parameter)-parameterAverage, 2);
		
		parameterDesviation = sqrt(parameterDesviationSum/(POPULATION_SIZE-1));
		info_file << parameterDesviation << endl;	

		totalParametersDesviation += parameterDesviation;
	}
	
	info_file << endl << "TOTAL DESVIATION=" << totalParametersDesviation << endl;
	info_file << endl << endl;
	info_file.close();
}

void TestAndTune::SaveMembers(int c, EvaluationParameters* population[POPULATION_SIZE])
{
	fstream members_file("C:\\members.txt",ios::out);
	members_file << c << endl;
	members_file << endl;

	for (int member=0; member<POPULATION_SIZE; member++)
	{
		for(int parameter=0; parameter<EVALUATION_PARAMETERS_COUNT; parameter++)
			members_file << population[member]->GetParameterByIndex(parameter) << endl;

		members_file << endl;
	}
	
	members_file.close();
}

int TestAndTune::LoadMembers(EvaluationParameters* population[POPULATION_SIZE])
{
	int parameterCout = 0;
	int memberCount = 0;
	int lineNumber = 0;
	string line;

	int retVal = -1;

	ifstream members_file("C:\\members.txt");
	if (members_file.is_open())
	{
		while (! members_file.eof())
		{
			getline(members_file,line);
			if (line != "")
			{
				if (lineNumber == 0)
					retVal = atoi(line.c_str());
				else
				{
					population[memberCount]->SetParameterByIndex(parameterCout,atoi(line.c_str()));

					parameterCout++;
					if (parameterCout == EVALUATION_PARAMETERS_COUNT)
					{
						parameterCout = 0;
						memberCount++;
					}

					if (memberCount == POPULATION_SIZE)
						break;
				}
				lineNumber++;
			}
		}
	}

	if (memberCount < POPULATION_SIZE)
		retVal = -1;

	members_file.close();
	return retVal;
}

EvaluationParameters* TestAndTune::GetAverageFromMembersFile()
{
	EvaluationParameters* population[POPULATION_SIZE];
	for (int m = 0; m<POPULATION_SIZE; m++)
	{
		EvaluationParameters* member = new EvaluationParameters();
		population[m] = member;
	}

	LoadMembers(population);
	EvaluationParameters p;
	return p.GetAverageFromPopulation(population);
}

int TestAndTune::TestPopulationMembers(int member1Index, int member2Index, int milisecondsPerMove, EvaluationParameters* member1, EvaluationParameters* member2)
{	
	time_t rawtime;
	struct tm * timeinfo;
	char buffer [80];
	
	bool gameEnded = false;
	bool engine1PlayWhite, whiteToPlay;
	int movesPerLine, moveCount = 0;

	Move move;

	engine1 = new Engine(member1, 32);
	engine2 = new Engine(member2, 32);

	engine1Wins = 0;
	engine2Wins = 0;

	engine1PlayWhite = true;

	ofstream evolution_file;
	evolution_file.open("C:\\Evolution.pgn",ios::app);

	for (int game=1; game<=2; game++)
	{
		time ( &rawtime );
		timeinfo = localtime ( &rawtime );
		gameCount++;

		engine1->NewGame(false);
		engine2->NewGame(false);

		cout << endl;
	
		strftime(buffer,80,"%d/%m/%Y %H:%M:%S",timeinfo);
		cout << buffer << " game " << gameCount << " started: ";
			
		whiteToPlay = true;
		moveCount = 0;
		movesPerLine = 0;
		gameEnded = false;

		if (game > 1)
		{
			evolution_file << endl;
			evolution_file << endl;
		}

		evolution_file << "[Event \"GFCC Test\"]" << endl;
		evolution_file << "[Site \"Home\"]" << endl;
		
		strftime(buffer,80,"%Y.%m.%d",timeinfo);
		evolution_file << "[Date \"" << buffer << "\"]" << endl;
		evolution_file << "[Round \"" << game << "\"]" << endl;
		evolution_file << "[White \"";
		
		if (engine1PlayWhite)
		{
			evolution_file << "Member " << (member1Index+1);
			cout << "Member " << (member1Index+1) << " vs. ";
		}
		else
		{
			evolution_file << "Member " << (member2Index+1);
			cout << "Member " << (member2Index+1) << " vs. ";
		}

		evolution_file << "\"]" << endl;
		evolution_file << "[Black \"";
		
		if (engine1PlayWhite)
		{
			evolution_file << "Member " << (member2Index+1);
			cout << "Member " << (member2Index+1) << endl;
		}
		else
		{
			evolution_file << "Member " << (member1Index+1);
			cout << "Member " << (member1Index+1) << endl;
		}

		evolution_file << "\"]" << endl;
		evolution_file << "[Result \"*\"]" << endl;

		strftime(buffer,80,"%X",timeinfo);
		evolution_file << "[Time \"" << buffer << "\"]" << endl;
		evolution_file << endl;

		if (engine1PlayWhite)
			move = engine1->GetBestMoveFixedTime(milisecondsPerMove);
		else
			move = engine2->GetBestMoveFixedTime(milisecondsPerMove);
	
		while (!gameEnded)
		{
			if (moveCount == 120)
				gameEnded = true;

			if (((engine1->GameStatus == WHITE_CHECKMATED || engine1->GameStatus == WHITE_RESIGN) && engine1PlayWhite) ||
				((engine1->GameStatus == BLACK_CHECKMATED || engine1->GameStatus == BLACK_RESIGN) && !engine1PlayWhite))
			{
				engine2Wins++;
				cout << endl << "Member " << (member2Index+1) << " wins" << endl;
				gameEnded = true;
			}
			else if (((engine2->GameStatus == WHITE_CHECKMATED || engine2->GameStatus == WHITE_RESIGN) && !engine1PlayWhite) ||
					 ((engine2->GameStatus == BLACK_CHECKMATED || engine2->GameStatus == BLACK_RESIGN) && engine1PlayWhite))
			{
				engine1Wins++;
				cout << endl << "Member " << (member1Index+1) << " wins" << endl;
				gameEnded = true;
			}
			else if ((engine1->GameStatus == DRAW_BY_REPETITION || engine1->GameStatus == DRAW_BY_SOLEMATE) ||
				     (engine2->GameStatus == DRAW_BY_REPETITION || engine2->GameStatus == DRAW_BY_SOLEMATE))
			{
				cout << endl << "Draw" << endl;
				gameEnded = true;
			}
			else
			{
				engine1->board->MakeMove(move);
				engine2->board->MakeMove(move);

				if (whiteToPlay)
				{
					if (movesPerLine == 4)
					{
						movesPerLine = 0;
						evolution_file << endl;
					}

					moveCount++;
					movesPerLine++;
					evolution_file << moveCount;
					evolution_file << ". ";
					cout << ".";
				}			
			
				evolution_file <<	move.ToString();
				evolution_file << " ";

				whiteToPlay = !whiteToPlay;
				if (whiteToPlay)
					move = (engine1PlayWhite)? engine1->GetBestMoveFixedTime(milisecondsPerMove):engine2->GetBestMoveFixedTime(milisecondsPerMove);
				else
					move = (engine1PlayWhite)? engine2->GetBestMoveFixedTime(milisecondsPerMove):engine1->GetBestMoveFixedTime(milisecondsPerMove);
			}
		}
		engine1PlayWhite = !engine1PlayWhite;
	}

	evolution_file << endl;
	evolution_file << endl;

	evolution_file.close();

	delete engine1;
	delete engine2;

	return 	engine1Wins-engine2Wins;
}

void TestAndTune::TestNGames(int milisecondsPerMove, int numberOfGames)
{
	time_t rawtime;
	struct tm * timeinfo;
	char buffer [80];
	
	bool gameEnded = false;
	
	bool engine1PlayWhite, whiteToPlay;
	int movesPerLine, moveCount = 0;

	Move move;

	///////// Evaluation parameters setup /////////////

	EvaluationParameters* ep1 = GetAverageFromMembersFile();

	//Default parameters
	EvaluationParameters* ep2 = new EvaluationParameters();

	engine1 = new Engine(ep1, 32);
	engine2 = new Engine(ep2, 32);

	///////////////////////////////////////////////////

	engine1Wins = 0;
	engine2Wins = 0;
	engine1PlayWhite = true;

	fstream file_op("C:\\Testing.pgn",ios::out);

	for (int game=1; game<=numberOfGames; game++)
	{
		time ( &rawtime );
		timeinfo = localtime ( &rawtime );

		engine1->NewGame(true);
		engine2->NewGame(true);

		cout << endl;
		cout << "game " << game << " started ";
	
		whiteToPlay = true;
		moveCount = 0;
		movesPerLine = 0;
		gameEnded = false;

		if (game > 1)
		{
			file_op << endl;
			file_op << endl;
		}

		file_op << "[Event \"GFCC Test\"]" << endl;
		file_op << "[Site \"Home\"]" << endl;

		strftime(buffer,80,"%Y.%m.%d",timeinfo);
		file_op << "[Date \"" << buffer << "\"]" << endl;
		file_op << "[Round \"" << game << "\"]" << endl;
		file_op << "[White \"";
		
		if (engine1PlayWhite)
			file_op <<	"Engine 1";
		else
			file_op << "Engine 2";

		file_op << "\"]" << endl;
		file_op << "[Black \"";
		
		if (engine1PlayWhite)
			file_op <<	"Engine 2";
		else
			file_op << "Engine 1";

		file_op << "\"]" << endl;
		file_op << "[Result \"*\"]" << endl;

		strftime(buffer,80,"%X",timeinfo);
		file_op << "[Time \"" << buffer << "\"]" << endl;

		file_op << endl;

		if (engine1PlayWhite)
			move = engine1->GetBestMoveFixedTime(milisecondsPerMove);
		else
			move = engine2->GetBestMoveFixedTime(milisecondsPerMove);
	
		while (!gameEnded)
		{
			if (moveCount == 120)
				gameEnded = true;

			if (((engine1->GameStatus == WHITE_CHECKMATED || engine1->GameStatus == WHITE_RESIGN)  && engine1PlayWhite) ||
				((engine1->GameStatus == BLACK_CHECKMATED || engine1->GameStatus == BLACK_RESIGN) && !engine1PlayWhite))
			{
				engine2Wins++;
				cout << endl << "Engine 2 wins" << endl;
				gameEnded = true;
			}
			else if (((engine2->GameStatus == WHITE_CHECKMATED || engine2->GameStatus == WHITE_RESIGN) && !engine1PlayWhite) ||
					 ((engine2->GameStatus == BLACK_CHECKMATED || engine2->GameStatus == BLACK_RESIGN) && engine1PlayWhite))
			{
				engine1Wins++;
				cout << endl << "Engine 1 wins" << endl;
				gameEnded = true;
			}
			else if ((engine1->GameStatus == DRAW_BY_REPETITION || engine1->GameStatus == DRAW_BY_SOLEMATE) ||
				     (engine2->GameStatus == DRAW_BY_REPETITION || engine2->GameStatus == DRAW_BY_SOLEMATE))
			{
				cout << endl << "Draw" << endl;
				gameEnded = true;
			}
			else
			{
				engine1->board->MakeMove(move);
				engine2->board->MakeMove(move);

				if (whiteToPlay)
				{
					if (movesPerLine == 4)
					{
						movesPerLine = 0;
						file_op << endl;
					}

					moveCount++;
					movesPerLine++;
					file_op << moveCount;
					file_op << ". ";
					cout << ".";
				}			
			
				file_op <<	move.ToString();
				file_op << " ";

				whiteToPlay = !whiteToPlay;
				if (whiteToPlay)
					move = (engine1PlayWhite)? engine1->GetBestMoveFixedTime(milisecondsPerMove):engine2->GetBestMoveFixedTime(milisecondsPerMove);
				else
					move = (engine1PlayWhite)? engine2->GetBestMoveFixedTime(milisecondsPerMove):engine1->GetBestMoveFixedTime(milisecondsPerMove);
			}
		}
		engine1PlayWhite = !engine1PlayWhite;
	}

	file_op << endl;
	file_op << endl;
	file_op << "Engine 1 wins: " << engine1Wins << endl;
	file_op << "Engine 2 wins: " << engine2Wins << endl;
	file_op << "Draws: " << (numberOfGames-engine1Wins-engine2Wins) << endl;
	file_op.close();

	delete engine1;
	delete engine2;
}
