// Search.h: interface for the Search class.
//
//////////////////////////////////////////////////////////////////////
#if !defined(AFX_SEARCH_H__CBDA5858_EDFB_4B76_A842_C9066BCBB427__INCLUDED_)
#define AFX_SEARCH_H__CBDA5858_EDFB_4B76_A842_C9066BCBB427__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Evaluation.h"
#include "Board.h"
#include "Math.h"
#include "HashTable.h"
#include "Constants.h"
#include "EvaluationParameters.h"

#include <setjmp.h>

#define R 2

class Search  
{

private:

	int AlphaBetaNegamax(Board* board, int depth, int alpha, int beta);
	int Quiescent(Board* board, int alpha, int beta);
	void Sort(Board* board, MoveList* moves, int ply, __int64 boardKey, bool onlyCaptures);
	void UpdatePV(Move move);

	//PV variables
	Move pv[MAX_PLY][MAX_PLY];
	int pv_length[MAX_PLY];
	bool followPv;
	
	int pieceMat[2];
	int square, sideInSquare, pieceInSquare;

	int initialDepth;

	Evaluation* evaluation;
	int CountPositionReps(Board* board, __int64 hash);

	void CheckTime();
	
	int searchStopTime;
	int searchStartTime;
	jmp_buf env;

public:

	int GetMs();
	bool searchStoped;

	Move lastLine[MAX_PLY];
	int lastLineCount;

	int ply;
	int maxPly;
	int nodeCount;
	Search(EvaluationParameters* evaluationParameters, int hashSize);
	virtual ~Search();
	
	HashTable* hashTable;
	void MainSearch(Board* board, int depth, int alpha, int beta, int startTime, int stopTime);
};

#endif // !defined(AFX_SEARCH_H__CBDA5858_EDFB_4B76_A842_C9066BCBB427__INCLUDED_)
