// PrecalculatedMoveGeneration.h: interface for the PrecalculatedMoveGeneration class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PRECALCULATEDMOVEGENERATION_H__714039A6_1EC9_48DF_A197_1EA552D6B27E__INCLUDED_)
#define AFX_PRECALCULATEDMOVEGENERATION_H__714039A6_1EC9_48DF_A197_1EA552D6B27E__INCLUDED_

#include "Constants.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define ROW(x)			(x >> 3)
#define COL(x)			(x & 7)

class PrecalculatedMoveGeneration  
{
public:
	PrecalculatedMoveGeneration();
	virtual ~PrecalculatedMoveGeneration();

	//Array of precomputed directions indexed by square
	int columnUpMoves[64][8], columnDownMoves[64][8], rankRightMoves[64][8], rankLeftMoves[64][8], diagonal45Moves[64][8], diagonal135Moves[64][8], diagonal225Moves[64][8], diagonal315Moves[64][8], kingMoves[64][8], knightMoves[64][8];
	//int columnNumbers[64], rankNumbers[64];

	//Methods for generate precomputed sliding moves.
	void GenerateColumnUpMoves();
	void GenerateDiagonal45Moves();
	void GenerateRankRightMoves();
	void GenerateDiagonal135Moves();
	void GenerateColumnDownMoves();
	void GenerateDiagonal225Moves();
	void GenerateRankLeftMoves();
	void GenerateDiagonal315Moves();
	
	//Method for generate precomputed king moves
	void GenerateKingMoves();

	//Method for generate precomputed knight moves
	void GenerateKnightMoves();

};

#endif // !defined(AFX_PRECALCULATEDMOVEGENERATION_H__714039A6_1EC9_48DF_A197_1EA552D6B27E__INCLUDED_)
