// PrecalculatedMoveGeneration.cpp: implementation of the PrecalculatedMoveGeneration class.
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "PrecalculatedMoveGeneration.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

PrecalculatedMoveGeneration::PrecalculatedMoveGeneration()
{
	GenerateColumnUpMoves();
	GenerateDiagonal45Moves();
	GenerateRankRightMoves();
	GenerateDiagonal135Moves();
	GenerateColumnDownMoves();
	GenerateDiagonal225Moves();
	GenerateRankLeftMoves();
	GenerateDiagonal315Moves();

	GenerateKingMoves();
	GenerateKnightMoves();
}




PrecalculatedMoveGeneration::~PrecalculatedMoveGeneration()
{
	
}

void PrecalculatedMoveGeneration::GenerateColumnUpMoves ()
{
	int posibleSquares;
	int rank;
	for (int square=0; square<64; square++)
    {
        rank = ROW(square);
      	posibleSquares=0;
		for (int i=0; i<7-rank; i++)
		{
			 columnUpMoves[square][i] = square + 8 * (i + 1);
			 posibleSquares++;
		}
		for (int j=7; j>=posibleSquares; j--)
		{
			//Fill left direction positions whit invalid square 
			columnUpMoves[square][j] = INVALID_SQUARE;
		}
		
    }
    return;
}

void PrecalculatedMoveGeneration::GenerateColumnDownMoves()
{
	int posibleSquares;
	int rank;
    for (int square=0; square<64; square++)
    {
        rank = ROW(square);
        posibleSquares=0;
	    for (int i=0; i<rank; i++)
		{
            columnDownMoves[square][i] = square - 8 * (i + 1);
			posibleSquares++;
		}
		for (int j=7; j>=posibleSquares; j--)
		{
			columnDownMoves[square][j] = INVALID_SQUARE;
		}
    }
}

void PrecalculatedMoveGeneration::GenerateRankRightMoves()
{
	int column;
	int posibleSquares;
    for (int square=0; square<64; square++)
    {
		column = COL(square);
		posibleSquares=0;
        for (int i=0; i<7-column; i++)
		{
            rankRightMoves[square][i] = square + i + 1;
			posibleSquares++;
		}
		for (int j=7; j>=posibleSquares; j--)
		{
			rankRightMoves[square][j] = INVALID_SQUARE;
		}
    }
}

void PrecalculatedMoveGeneration::GenerateRankLeftMoves()
{
	int column;
	int posibleSquares;
    for (int square=0; square<64; square++)
    {
		column = COL(square);
		posibleSquares=0;
        for (int i=0; i<column; i++)
		{
            rankLeftMoves[square][i] = square - i - 1;
			posibleSquares++;
		}
		for (int j=7; j>=posibleSquares; j--)
		{
			rankLeftMoves[square][j] = INVALID_SQUARE;
		}
    }
}

void PrecalculatedMoveGeneration::GenerateDiagonal45Moves()
{
	int column;
	int rank;
	int posibleSquares;
	int movTo;
	for (int square=0; square<64; square++)
    {
        column = COL(square);
        rank = ROW(square);
		posibleSquares=0;
		if ((7-column)<(7-rank))
			movTo = 7-column;
		else
			movTo = 7-rank;
      
        for (int i=0; i<movTo; i++)
		{
            diagonal45Moves[square][i] = square + 9 * (i + 1);
			posibleSquares++;
		}
		for (int j=7; j>=posibleSquares; j--)
		{
			diagonal45Moves[square][j] = INVALID_SQUARE;
		}
    }
}
void PrecalculatedMoveGeneration::GenerateDiagonal135Moves()
{
	int column;
	int rank;
	int posibleSquares;
	int movTo;
	for (int square=0; square<64; square++)
    {
        column = COL(square);
        rank = ROW(square);
		posibleSquares=0;
		if ((7-column)<rank)
			movTo = 7-column;
		else
			movTo = rank;
      
        for (int i=0; i<movTo; i++)
		{
            diagonal135Moves[square][i] = square - 7 * (i + 1);
			posibleSquares++;
		}
		for (int j=7; j>=posibleSquares; j--)
		{
			diagonal135Moves[square][j] = INVALID_SQUARE;
		}
    }
}
void PrecalculatedMoveGeneration::GenerateDiagonal225Moves()
{
	int column;
	int rank;
	int posibleSquares;
	int movTo;
	for (int square=0; square<64; square++)
    {
        column = COL(square);
        rank = ROW(square);
		posibleSquares=0;
		if (column<rank)
			movTo = column;
		else
			movTo = rank;
      
        for (int i=0; i<movTo; i++)
		{
            diagonal225Moves[square][i] = square - 9 * (i + 1);
			posibleSquares++;
		}
		for (int j=7; j>=posibleSquares; j--)
		{
			diagonal225Moves[square][j] = INVALID_SQUARE;
		}
    }
}
void PrecalculatedMoveGeneration::GenerateDiagonal315Moves()
{
	int column;
	int rank;
	int posibleSquares;
	int movTo;
	for (int square=0; square<64; square++)
    {
        column = COL(square);
        rank = ROW(square);
		posibleSquares=0;
		if (column<(7-rank))
			movTo = column;
		else
			movTo = 7-rank;
      
        for (int i=0; i<movTo; i++)
		{
            diagonal315Moves[square][i] = square + 7 * (i + 1);
			posibleSquares++;
		}
		for (int j=7; j>=posibleSquares; j--)
		{
			diagonal315Moves[square][j] = INVALID_SQUARE;
		}
    }
}

void PrecalculatedMoveGeneration::GenerateKingMoves()
{
	int column;
	int rank;
    for (int square=0; square<64; square++)
    {
        column = COL(square);
        rank = ROW(square);

        if (square == 0)
		{
			kingMoves[square][0] = 1; kingMoves[square][1] = 9; kingMoves[square][2] = 8;
			kingMoves[square][3] = INVALID_SQUARE; kingMoves[square][4] = INVALID_SQUARE; kingMoves[square][5] = INVALID_SQUARE;
			kingMoves[square][6] = INVALID_SQUARE;kingMoves[square][7] = INVALID_SQUARE;
		}
		else if (square == 7)
		{
			kingMoves[square][0] = 6; kingMoves[square][1] = 14; kingMoves[square][2] = 15;
			kingMoves[square][3] = INVALID_SQUARE; kingMoves[square][4] = INVALID_SQUARE; kingMoves[square][5] = INVALID_SQUARE;
			kingMoves[square][6] = INVALID_SQUARE;kingMoves[square][7] = INVALID_SQUARE;
		}
		else if (square == 56)
		{
			kingMoves[square][0] = 48; kingMoves[square][1] = 49; kingMoves[square][2] = 57;
			kingMoves[square][3] = INVALID_SQUARE; kingMoves[square][4] = INVALID_SQUARE; kingMoves[square][5] = INVALID_SQUARE;
			kingMoves[square][6] = INVALID_SQUARE;kingMoves[square][7] = INVALID_SQUARE;
		}
		else if (square == 63)
		{
			kingMoves[square][0] = 62; kingMoves[square][1] = 54; kingMoves[square][2] = 55;
			kingMoves[square][3] = INVALID_SQUARE; kingMoves[square][4] = INVALID_SQUARE; kingMoves[square][5] = INVALID_SQUARE;
			kingMoves[square][6] = INVALID_SQUARE;kingMoves[square][7] = INVALID_SQUARE;
		}
		else if (rank == 0)
		{
			kingMoves[square][0] = square-1; kingMoves[square][1] = square+7; kingMoves[square][2] = square+8;
			kingMoves[square][3] = square+9; kingMoves[square][4] = square+1; kingMoves[square][5] = INVALID_SQUARE;
			kingMoves[square][6] = INVALID_SQUARE;kingMoves[square][7] = INVALID_SQUARE;
		}
		else if (rank == 7)
		{
			kingMoves[square][0] = square-1; kingMoves[square][1] = square-9; kingMoves[square][2] = square-8;
			kingMoves[square][3] = square-7; kingMoves[square][4] = square+1; kingMoves[square][5] = INVALID_SQUARE;
			kingMoves[square][6] = INVALID_SQUARE;kingMoves[square][7] = INVALID_SQUARE;
		}
		else if (column == 0)
		{
			kingMoves[square][0] = square+8; kingMoves[square][1] = square+9; kingMoves[square][2] = square+1;
			kingMoves[square][3] = square-7; kingMoves[square][4] = square-8; kingMoves[square][5] = INVALID_SQUARE;
			kingMoves[square][6] = INVALID_SQUARE;kingMoves[square][7] = INVALID_SQUARE;
		}
		else if (column == 7)
		{
			kingMoves[square][0] = square-8; kingMoves[square][1] = square-9; kingMoves[square][2] = square-1;
			kingMoves[square][3] = square+7; kingMoves[square][4] = square+8; kingMoves[square][5] = INVALID_SQUARE;
			kingMoves[square][6] = INVALID_SQUARE;kingMoves[square][7] = INVALID_SQUARE;
		}
		else
		{
			kingMoves[square][0] = square+8; kingMoves[square][1] = square+9; kingMoves[square][2] = square+1;
			kingMoves[square][3] = square-7; kingMoves[square][4] = square-8; kingMoves[square][5] = square-9;
			kingMoves[square][6] = square-1; kingMoves[square][7] = square+7;
		}
	}    
}

void PrecalculatedMoveGeneration::GenerateKnightMoves()
{
	int column;
	int rank;
    for (int square=0; square<64; square++)
    {
        column = COL(square);
        rank = ROW(square);

		if (column > 1 && column < 6 && rank > 1 && rank < 6)
		{
			knightMoves[square][0] = square + 17;knightMoves[square][1] = square + 10;
			knightMoves[square][2] = square - 6; knightMoves[square][3] = square - 15;
			knightMoves[square][4] = square - 17;knightMoves[square][5] = square - 10;
			knightMoves[square][6] = square + 6; knightMoves[square][7] = square + 15;
		}
		else if (square==0)
		{
			knightMoves[square][0] = 17; knightMoves[square][1] = 10;
			knightMoves[square][2] = INVALID_SQUARE; knightMoves[square][3] = INVALID_SQUARE;
			knightMoves[square][4] = INVALID_SQUARE; knightMoves[square][5] = INVALID_SQUARE;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (square==1)
		{
			knightMoves[square][0] = 16; knightMoves[square][1] = 18;
			knightMoves[square][2] = 11; knightMoves[square][3] = INVALID_SQUARE;
			knightMoves[square][4] = INVALID_SQUARE; knightMoves[square][5] = INVALID_SQUARE;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (square==6)
		{
			knightMoves[square][0] = 12; knightMoves[square][1] = 21;
			knightMoves[square][2] = 23; knightMoves[square][3] = INVALID_SQUARE;
			knightMoves[square][4] = INVALID_SQUARE; knightMoves[square][5] = INVALID_SQUARE;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (square==7)
		{
			knightMoves[square][0] = 22; knightMoves[square][1] = 13;
			knightMoves[square][2] = INVALID_SQUARE; knightMoves[square][3] = INVALID_SQUARE;
			knightMoves[square][4] = INVALID_SQUARE; knightMoves[square][5] = INVALID_SQUARE;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (square==8)
		{
			knightMoves[square][0] = 25; knightMoves[square][1] = 18;
			knightMoves[square][2] = 1; knightMoves[square][3] = INVALID_SQUARE;
			knightMoves[square][4] = INVALID_SQUARE; knightMoves[square][5] = INVALID_SQUARE;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (square==9)
		{
			knightMoves[square][0] = 24; knightMoves[square][1] = 26;
			knightMoves[square][2] = 19; knightMoves[square][3] = 3;
			knightMoves[square][4] = INVALID_SQUARE; knightMoves[square][5] = INVALID_SQUARE;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (square==14)
		{
			knightMoves[square][0] = 31; knightMoves[square][1] = 29;
			knightMoves[square][2] = 20; knightMoves[square][3] = 4;
			knightMoves[square][4] = INVALID_SQUARE; knightMoves[square][5] = INVALID_SQUARE;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (square==15)
		{
			knightMoves[square][0] = 30; knightMoves[square][1] = 21;
			knightMoves[square][2] = 5; knightMoves[square][3] = INVALID_SQUARE;
			knightMoves[square][4] = INVALID_SQUARE; knightMoves[square][5] = INVALID_SQUARE;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (square==48)
		{
			knightMoves[square][0] = 58; knightMoves[square][1] = 42;
			knightMoves[square][2] = 33; knightMoves[square][3] = INVALID_SQUARE;
			knightMoves[square][4] = INVALID_SQUARE; knightMoves[square][5] = INVALID_SQUARE;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (square==49)
		{
			knightMoves[square][0] = 59; knightMoves[square][1] = 43;
			knightMoves[square][2] = 34; knightMoves[square][3] = 32;
			knightMoves[square][4] = INVALID_SQUARE; knightMoves[square][5] = INVALID_SQUARE;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (square==54)
		{
			knightMoves[square][0] = 60; knightMoves[square][1] = 44;
			knightMoves[square][2] = 37; knightMoves[square][3] = 39;
			knightMoves[square][4] = INVALID_SQUARE; knightMoves[square][5] = INVALID_SQUARE;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (square==55)
		{
			knightMoves[square][0] = 61; knightMoves[square][1] = 45;
			knightMoves[square][2] = 38; knightMoves[square][3] = INVALID_SQUARE;
			knightMoves[square][4] = INVALID_SQUARE; knightMoves[square][5] = INVALID_SQUARE;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (square==56)
		{
			knightMoves[square][0] = 50; knightMoves[square][1] = 41;
			knightMoves[square][2] = INVALID_SQUARE; knightMoves[square][3] = INVALID_SQUARE;
			knightMoves[square][4] = INVALID_SQUARE; knightMoves[square][5] = INVALID_SQUARE;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (square==57)
		{
			knightMoves[square][0] = 40; knightMoves[square][1] = 42;
			knightMoves[square][2] = 51; knightMoves[square][3] = INVALID_SQUARE;
			knightMoves[square][4] = INVALID_SQUARE; knightMoves[square][5] = INVALID_SQUARE;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (square==62)
		{
			knightMoves[square][0] = 52; knightMoves[square][1] = 45;
			knightMoves[square][2] = 47; knightMoves[square][3] = INVALID_SQUARE;
			knightMoves[square][4] = INVALID_SQUARE; knightMoves[square][5] = INVALID_SQUARE;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (square==63)
		{
			knightMoves[square][0] = 53; knightMoves[square][1] = 46;
			knightMoves[square][2] = INVALID_SQUARE; knightMoves[square][3] = INVALID_SQUARE;
			knightMoves[square][4] = INVALID_SQUARE; knightMoves[square][5] = INVALID_SQUARE;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (rank==0)
		{
			knightMoves[square][0] = square + 6; knightMoves[square][1] = square + 15;
			knightMoves[square][2] = square + 17; knightMoves[square][3] = square + 10;
			knightMoves[square][4] = INVALID_SQUARE; knightMoves[square][5] = INVALID_SQUARE;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (rank==1)
		{
			knightMoves[square][0] = square - 10; knightMoves[square][1] = square + 6;
			knightMoves[square][2] = square + 15; knightMoves[square][3] = square + 17;
			knightMoves[square][4] = square + 10; knightMoves[square][5] = square - 6;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (rank==6)
		{
			knightMoves[square][0] = square - 17; knightMoves[square][1] = square -10;
			knightMoves[square][2] = square + 6; knightMoves[square][3] = square +10;
			knightMoves[square][4] = square - 6; knightMoves[square][5] = square - 15;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (rank==7)
		{
			knightMoves[square][0] = square - 17; knightMoves[square][1] = square -10;
			knightMoves[square][2] = square - 6; knightMoves[square][3] = square - 15;
			knightMoves[square][4] = INVALID_SQUARE; knightMoves[square][5] = INVALID_SQUARE;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (column==0)
		{
			knightMoves[square][0] = square-15; knightMoves[square][1] = square-6;
			knightMoves[square][2] = square+10; knightMoves[square][3] = square+17;
			knightMoves[square][4] = INVALID_SQUARE; knightMoves[square][5] = INVALID_SQUARE;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (column==1)
		{
			knightMoves[square][0] = square-17; knightMoves[square][1] = square-15;
			knightMoves[square][2] = square-6; knightMoves[square][3] = square+10;
			knightMoves[square][4] = square+17; knightMoves[square][5] = square+15;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else if (column==6)
		{
			knightMoves[square][0] = square-15; knightMoves[square][1] = square-17;
			knightMoves[square][2] = square-10; knightMoves[square][3] = square+6;
			knightMoves[square][4] = square+15; knightMoves[square][5] = square+17;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
		else
		{
			knightMoves[square][0] = square-17; knightMoves[square][1] = square-10;
			knightMoves[square][2] = square+6; knightMoves[square][3] = square+15;
			knightMoves[square][4] = INVALID_SQUARE; knightMoves[square][5] = INVALID_SQUARE;
			knightMoves[square][6] = INVALID_SQUARE; knightMoves[square][7] = INVALID_SQUARE;
		}
	}
}

