// Move.cpp: implementation of the Move class.
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "Move.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Move::Move()
{
	From = 0;
	To = 0;
	MovingPiece = 0;
	MovingSide = 0;
	PieceToPromote = 0;
	Score = 0;
	CastleMoveCode = 0;
	Check = false;
	Promote = false;
	Capture = false;
}

Move::~Move()
{
	
}

string Move::ToString()
{
	string moveString;
	AppendColumnLetter(&moveString, From);
	AppendRankNumber(&moveString, From);
	AppendColumnLetter(&moveString, To);
	AppendRankNumber(&moveString, To);

	if (Promote)
	{
		AppendPieceLetter(&moveString, PieceToPromote);
	}


	/*if (MovingPiece == PAWN)
	{
		if (Capture)
		{
			AppendColumnLetter(&moveString, From);
			moveString.append("x");
			AppendColumnLetter(&moveString, To);
			AppendRankNumber(&moveString,To);
		}
		else
		{
			AppendColumnLetter(&moveString, To);
			AppendRankNumber(&moveString,To);
		}
		if (Promote)
		{
			moveString.append("=");
			AppendPieceLetter(&moveString, PieceToPromote);
		}
	}
	else
	{
		if (CastleMoveCode == SHORT_CASTLE)
			moveString.append("0-0");
		else if (CastleMoveCode == LONG_CASTLE)
			moveString.append("0-0-0");
		else
		{
			AppendPieceLetter(&moveString, MovingPiece);
			AppendColumnLetter(&moveString, From);
			if (Capture)
				moveString.append("x");
			
			AppendColumnLetter(&moveString, To);
			AppendRankNumber(&moveString,To);

			if (Check)
				moveString.append("+");
		}
	}*/
	return moveString;
}

bool Move::IsEqual(Move move)
{
	return  Promote==move.Promote &&
			PieceToPromote==move.PieceToPromote &&
			From==move.From && To==move.To &&
			MovingSide==move.MovingSide;
}

void Move::AppendPieceLetter(string* moveString, int piece)
{
	if (piece == KNIGHT)
		moveString->append("N");
	else if (piece == BISHOP)
		moveString->append("B");
	else if (piece == ROCK)
		moveString->append("R");
	else if (piece == QUEEN)
		moveString->append("Q");
	else
		moveString->append("K");
}

void Move::AppendColumnLetter(string* moveString, int square)
{
    if ((square % 8) == 0)
        moveString->append("a");
    else if (((square + 7) % 8) == 0)
        moveString->append("b");
    else if (((square + 6) % 8) == 0)
        moveString->append("c");
    else if (((square + 5) % 8) == 0)
        moveString->append("d");
    else if (((square + 4) % 8) == 0)
        moveString->append("e");
    else if (((square + 3) % 8) == 0)
        moveString->append("f");
    else if (((square + 2) % 8) == 0)
		moveString->append("g");
    else
        moveString->append("h");
}

void Move::AppendRankNumber(string* moveString, int square)
{
    if (square <= 7)
        moveString->append("1");
    else if (square <= 15)
        moveString->append("2");
    else if (square <= 23)
        moveString->append("3");
    else if (square <= 31)
        moveString->append("4");
    else if (square <= 39)
        moveString->append("5");
    else if (square <= 47)
        moveString->append("6");
    else if (square <= 55)
        moveString->append("7");
    else 
        moveString->append("8");
}

bool Move::IsPromoteThreat()
{
	if (MovingPiece == PAWN )
	{
		if (MovingSide==WHITE)
		{
			if (To>47)
				return true;
			else
				return false;
		}
		else
		{
			if (To<16)
				return true;
			else
				return false;
		}
	}
	else
		return false;
}