// HashTable.h: interface for the HashTable class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_HASHTABLE_H__B808804A_3906_4A21_A282_CDE232996E9A__INCLUDED_)
#define AFX_HASHTABLE_H__B808804A_3906_4A21_A282_CDE232996E9A__INCLUDED_

#include "Move.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

typedef struct _Hash 
{
	__int64 key;
	unsigned char depth;
    unsigned char flags;
    signed short value;
    	
	// Best move members
	char To, From, MovingPiece, MovingSide, PieceToPromote;
	signed short Score;
	char CastleMoveCode, DestinationPiece, DestinationSide;
	bool Capture, Promote, Check;

} Hash;

class HashTable  
{
public:

	Hash *hash;
	unsigned int hashsize;

	HashTable::HashTable(int size);
	virtual ~HashTable();

	void HashTable::ResetHash();
	void AddPosition(__int64 key, int depth, int score, Move move, int flags);
	void AddPosition(__int64 key, int depth, int score, int flags);

	Hash* GetPosition(__int64 key);
	Move GetBestMove(Hash* hpos);
};

#endif // !defined(AFX_HASHTABLE_H__B808804A_3906_4A21_A282_CDE232996E9A__INCLUDED_)
