// HashTable.cpp: implementation of the HashTable class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "HashTable.h"

#define HP(x) (((unsigned int)(x))%hashsize)

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
HashTable::HashTable(int size)
{
	hashsize=size*(1<<20)/sizeof(Hash);
	hash=new Hash[hashsize];

	if(hash!=NULL)
	{
		ResetHash();
	}
}

HashTable::~HashTable()
{
	delete hash;
}

void HashTable::AddPosition(__int64 key, int depth, int score, Move move, int flags)
{
	if (hashsize != 0)
	{
		Hash *hpos = &(hash[HP(key)]);

		if (hpos->depth > depth && hpos->key == key)
			return;

		hpos->key = key;
		//Store the best move in hash
		hpos->Capture = move.Capture;
		hpos->CastleMoveCode = move.CastleMoveCode;
		hpos->Check = move.Check;
		hpos->DestinationPiece = move.DestinationPiece;
		hpos->DestinationSide = move.DestinationSide;
		hpos->From = move.From;
		hpos->MovingPiece = move.MovingPiece;
		hpos->MovingSide = move.MovingSide;
		hpos->PieceToPromote = move.PieceToPromote;
		hpos->Promote = move.Promote;
		hpos->To = move.To;
				
		hpos->value = score;
		hpos->flags = flags;
		hpos->depth = depth;
	}
}

void HashTable::AddPosition(__int64 key, int depth, int score, int flags)
{
	Move nullMove;
	AddPosition(key, depth, score, nullMove, flags);
}

Move HashTable::GetBestMove(Hash* hpos)
{
	Move bestMove;
	bestMove.Capture = hpos->Capture;
	bestMove.CastleMoveCode= hpos->CastleMoveCode;
	bestMove.Check = hpos->Check;
	bestMove.DestinationPiece = hpos->DestinationPiece;
	bestMove.DestinationSide = hpos->DestinationSide;
	bestMove.From = hpos->From;
	bestMove.MovingPiece = hpos->MovingPiece;
	bestMove.MovingSide	= hpos->MovingSide;
	bestMove.PieceToPromote	= hpos->PieceToPromote;
	bestMove.Promote = hpos->Promote;
	bestMove.To = hpos->To;
	return bestMove;
}

Hash* HashTable::GetPosition(__int64 key)
{
	if (hashsize == 0)
		return NULL;

	Hash *hpos=&(hash[HP(key)]);
    if (hpos->key == key) 
	{
		//Near to the root node, the score was calculated deeper
        return hpos;
        
    }
    return NULL;
}

void HashTable::ResetHash()
{
	memset(hash,0,sizeof(Hash)*hashsize);
}
