// GFC.cpp : Defines the entry point for the console application.
//
#include "stdafx.h"
#include "Move.h"
#include "Engine.h"
#include "TestAndTune.h"
#include "GFC.h"

#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <fstream>

using namespace std;

Engine* mainEngine;

int main()
{
	int engineSide;
	char s[256];
	Move m;

	printf("\n");
	printf("GFC Chess engine, \"The Brain\"\n");
	printf("version 0.8 rev 2 JA, 21/5/07\n");
	printf("Copyright 2007 Guillermo Filia\n");
	printf("Win32 Msvc compile by Jim Ablett 24-05-09\n");
	printf("\n");
	printf("\"help\" displays a list of commands.\n");
	printf("\n");

	///**/*TestAndTune* tat = new TestAndTune();
	//EvaluationParameters* ev = tat->GetAverageFromMembersFile();
	mainEngine = new Engine(/*ev, */32);
	mainEngine->NewGame(true);
	mainEngine->Post = true;

	engineSide = EMPTY;
	
	int max_time = 5000;
	int max_depth = MAX_DEPTH;

	for (;;) 
	{
		//computer's turn 
		if (mainEngine->board->sideToMove == engineSide) 
		{  			
			//think about the move and make it
			m =	mainEngine->GetBestMove(max_time, max_depth);
			if (mainEngine->GameStatus != ON_PLAYING) 
			{
				engineSide = EMPTY;
				print_move(m, mainEngine->LastMoveDepth, mainEngine->LastMoveMaxPly, true);
				string result = GetResultString(mainEngine->GameStatus);
				printf(result.c_str());
				continue;
			}

			print_move(m, mainEngine->LastMoveDepth, mainEngine->LastMoveMaxPly, true);
			mainEngine->board->MakeMove(m);
			continue;
		}

		// get user input
		printf("gfc> ");
		if (scanf("%s", s) == EOF)
			return 0;
		if (!strcmp(s, "go")) 
		{
			engineSide = mainEngine->board->sideToMove;
			continue;
		}
		if (!strcmp(s, "off")) 
		{
			engineSide = EMPTY;
			continue;
		}
		
		if (!strcmp(s, "st")) 
		{
			scanf("%d", &max_time);
			max_time *= 1000;
			max_depth = MAX_DEPTH;
			continue;
		}
		if (!strcmp(s, "sd")) 
		{
			scanf("%d", &max_depth);
			max_time = MAX_TIME * 1000;
			continue;
		}
		if (!strcmp(s, "evolution"))
		{
			delete mainEngine;
			int generations;
			scanf("%d", &generations);
			TestAndTune* tat = new TestAndTune();
			tat->EvolutionaryTuning(generations);

			return 0;
		}
		if (!strcmp(s, "undo")) 
		{
			if (mainEngine->board->moveCount==0)
				continue;
			engineSide = EMPTY;
			mainEngine->board->TakeBackMove();
			continue;
		}
		if (!strcmp(s, "new")) 
		{
			engineSide = EMPTY;
			mainEngine->NewGame(true);
			continue;
		}
		if (!strcmp(s, "test")) 
		{
			delete mainEngine;
			int gamesNumber;
			scanf("%d", &gamesNumber);
			
			TestAndTune* test = new TestAndTune();
			test->TestNGames(2000, gamesNumber);

			return 0;
		}
		if (!strcmp(s, "quit")) 
		{
			printf("Program quit\n");
			break;
		}
		if (!strcmp(s, "xboard")) 
		{
			xboard();
			break;
		}
		if (!strcmp(s, "help")) 
		{
			printf("go - computer plays for the side to move\n");
			printf("off - computer stops playing\n");
			printf("st n - search for n seconds per move\n");
			printf("sd n - search whit n depth per move\n");
			printf("undo - takes back a move\n");
			printf("new - starts a new game\n");
			printf("test n - test n games with the testAndTune tool\n");
			printf("quit - quit the program\n");
			printf("evolution n - learn from sefl-play during n generations of a 50 members population\n");
			printf("xboard - switch to XBoard mode\n");
			printf("Enter moves in coordinate notation, e.g., e2e4, e7e8Q\n");
			continue;
		}

		//maybe the user entered a move? 
		m = parse_move(s);
		if (m.From == m.To)
			printf("Illegal move.\n");
		else 
		{
			mainEngine->board->MakeMove(m);
		}
	}

	delete mainEngine;
	return 0;
}

void xboard()
{	
	char line[256], command[256];
	int post = 0;
	bool force = false;
	int max_time = MAX_TIME * 1000;
	int max_depth = 5;
	Move m;
	int computer_side = EMPTY;
	int otim;

	signal(SIGINT, SIG_IGN);

	mainEngine->NewGame(true);
		
	printf("\n");
	fstream file_op("C:\\xboard.txt",ios::out);

	for (;;) 
	{
		fflush(stdout);
		if (!force && mainEngine->board->sideToMove == computer_side) 
		{
			m =	mainEngine->GetBestMove(max_time, max_depth);
			if (mainEngine->GameStatus != ON_PLAYING) 
			{
				computer_side = EMPTY;
				printf("move %s\n", m.ToString().c_str());
				
				string result = GetResultString(mainEngine->GameStatus);
				printf(result.c_str());
				
				file_op << "engine move " << m.ToString() << endl;
				file_op << result << endl;
				
				continue;
			}

			printf("move %s\n", m.ToString().c_str());
			mainEngine->board->MakeMove(m);
			
			string result = GetResultString(mainEngine->GameStatus);
			if (result != "")
			{
				printf(result.c_str());
				file_op << result << endl;
			}

			file_op << "engine move " << m.ToString() << endl;
			continue;
		}
		if (!fgets(line, 256, stdin))
			return;
		if (line[0] == '\n')
			continue;

		sscanf(line, "%s", command);
		if (!strcmp(command, "xboard"))
		{
			file_op << "xboard" << endl;
			continue;
		}
		if (!strcmp(command, "new")) 
		{
			mainEngine->NewGame(true);
			force = false;
			computer_side = BLACK;

			file_op << "new" << endl;
			continue;
		}
		if (!strcmp(command, "quit"))
		{
			file_op << "quit" << endl;
			file_op.close();
			return;
		}
		if (!strcmp(command, "force")) 
		{
			force = true;
			computer_side = EMPTY;

			file_op << "force" << endl;
			continue;
		}
		if (!strcmp(command, "white")) 
		{
			mainEngine->board->sideToMove = WHITE;
			computer_side = BLACK;

			file_op << "white" << endl;
			continue;
		}
		if (!strcmp(command, "black")) 
		{
			mainEngine->board->sideToMove = BLACK;
			computer_side = WHITE;

			file_op << "black" << endl;
			continue;
		}
		if (!strcmp(command, "st")) 
		{
			sscanf(line, "st %d", &max_time);
			max_time *= 1000;
			max_depth = MAX_DEPTH;

			file_op << "st " << max_time <<endl;
			continue;
		}
		if (!strcmp(command, "sd")) 
		{
			sscanf(line, "sd %d", &max_depth);
			max_time = MAX_TIME * 1000;

			file_op << "sd " << max_depth << endl;
			continue;
		}
		if (!strcmp(command, "time")) 
		{
			sscanf(line, "time %d", &max_time);
			max_time *= 10;
			max_time /= 30;
			max_depth = MAX_DEPTH;

			file_op << "time " << max_time << endl;
			continue;
		}
		if (!strcmp(command, "otim")) 
		{
			sscanf(line, "otim %d", &otim);

			file_op << "otim " << otim << endl;
			continue;
		}
		if (!strcmp(command, "go")) 
		{
			force = false;
			computer_side = mainEngine->board->sideToMove;

			file_op << "go" << endl;
			continue;
		}
		if (!strcmp(command, "hint")) 
		{
			m =	mainEngine->GetBestMove(max_time, max_depth);
			if (mainEngine->GameStatus != ON_PLAYING)
				continue;

			printf("Hint: %s\n", m.ToString().c_str());

			file_op << "Hint " << m.ToString() << endl;
			continue;
		}
		if (!strcmp(command, "undo")) 
		{
			if (mainEngine->board->moveCount == 0)
				continue;
			
			mainEngine->board->TakeBackMove();

			file_op << "undo" << endl;
			continue;
		}
		if (!strcmp(command, "remove")) 
		{
			if (mainEngine->board->moveCount < 2)
				continue;
			
			mainEngine->board->TakeBackMove();
			mainEngine->board->TakeBackMove();

			file_op << "remove" << endl;
			continue;
		}
		if (!strcmp(command, "post")) 
		{
			mainEngine->Post = true;
			continue;
		}
		if (!strcmp(command, "nopost")) 
		{
			mainEngine->Post = false;
			continue;
		}
	
		m = parse_move(line);
		if (m.From == m.To)
		{
			printf("Error (unknown command): %s\n", command);
			file_op << "Error (unknown command): " << command << "\n" << endl;
		}
		else 
		{
			mainEngine->board->MakeMove(m);

			//!Esto creo que esta al pedo
			string result = GetResultString(mainEngine->GameStatus);
			if (result != "")
			{
				printf(result.c_str());
				file_op << result << endl;
			}

			file_op << "XBoard move " << m.ToString() << endl;
		}	
	}

	file_op.close();
}


string GetResultString(int gameStatus)
{
	if (gameStatus == WHITE_CHECKMATED)
		return "0-1 {Black mates}\n";
	else if (gameStatus == BLACK_CHECKMATED)
		return "1-0 {White mates}\n";
	if (gameStatus == WHITE_RESIGN)
		return "0-1 {White resigns}\n";
	else if (gameStatus == BLACK_RESIGN)
		return "1-0 {Black resigns}\n";
	else if (gameStatus == DRAW_BY_REPETITION)
		return "1/2-1/2 {Draw by repetition}\n";
	else if (gameStatus == DRAW_BY_SOLEMATE)
		return "1/2-1/2 {Stalemate}\n";
	else if (gameStatus == DRAW_BY_50_MOVE_RULE)
		return "1/2-1/2 {Draw by fifty move rule}\n";
	else
		return "";
}

void print_move(Move move, int moveDepth, int maxDepth,  bool printDepth)
{
	char buff[2];

	if (printDepth)
	{
		printf("Computer's move: %s", move.ToString().c_str());
		
		char* charInt = itoa(mainEngine->LastMoveDepth, buff, 10);
		printf(" depth: %s/", charInt);

		charInt = itoa(maxDepth, buff, 10);
		printf("%s\n", charInt);

	}
	else
		printf("Computer's move: %s\n", move.ToString().c_str());		
}

Move parse_move(char *s)
{
	Move move;
	int from, to, i;

	/* make sure the string looks like a move */
	if (s[0] < 'a' || s[0] > 'h' ||
		s[1] < '0' || s[1] > '9' ||
		s[2] < 'a' || s[2] > 'h' ||
		s[3] < '0' || s[3] > '9')
		return move;

	from = s[0] - 'a';
	from += 8 * (s[1] - '1');
	to = s[2] - 'a';
	to += 8 * (s[3] - '1');

	MoveList* moves = mainEngine->board->GetAllMoves();
	for (i=0; i<moves->MovesCount; i++)
	{
		Move movei = moves->AllLegalMoves[i];
		if (movei.From == from && movei.To == to) 
		{
			/* if the move is a promotion, handle the promotion piece;
			   assume that the promotion moves occur consecutively in
			   gen_dat. */
			if (movei.Promote)
			{
				switch (s[4]) 
				{
					case 'N':
						return moves->AllLegalMoves[i+3];
					case 'B':
						return moves->AllLegalMoves[i+2];
					case 'R':
						return moves->AllLegalMoves[i+1];
					default:  /* assume it's a queen */
						return movei;
				}
			}
			return movei;
		}
	}

	/* didn't find the move */
	return move;
}

