// EvaluationParameters.h: interface for the EvaluationParameters class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_EVALUATIONPARAMETERS_H__948E1FC3_BF31_4328_BF3F_0D7943EA4C6E__INCLUDED_)
#define AFX_EVALUATIONPARAMETERS_H__948E1FC3_BF31_4328_BF3F_0D7943EA4C6E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Constants.h"

class EvaluationParameters  
{

private:

	int GetIntRandomValue(int minValue, int maxValue);
	int AdjustValue(int value, int minValue, int maxValue);


public:

	int pawnValue, knightValue, bishopValue, rockValue, queenValue, kingValue;
	int doubledPawnPenalty, backwardsPawnPenalty, passedPawnBonus, passedPawnEmptyColumnBonus;
	
	int rockSemiOpenFileBonus, rockOpenFileBonus, rockSeventhBonus;
	int bishopAttackMostValuedBonus, rockAttackMostValuedBonus;

	int knightNearOpponentPieceBonusOpe, knightNearOpponentPieceBonusEnd;
	int knightSecureFromEnemyPawnsBonus, knightFarFromKingPenalty;

	int bishopExtraMaterialInEnding, bishopAttackAdyacentEnemyKingBonus;

	int hungPiecePenalty, hungPiecePenaltyEnd, blockedPiecePenalty, blockedPiecePenaltyEnd;

	int isolatedPawnAPenalty, isolatedPawnBPenalty, isolatedPawnCPenalty, isolatedPawnDPenalty;
	int isolatedPawnEPenalty, isolatedPawnFPenalty, isolatedPawnGPenalty, isolatedPawnHPenalty;
	
	int kingPawnMoved1Penalty, kingPawnMovedMoreThan1Penalty, noKingPawnPenalty;
	int kingNoEnemyPawnPenalty, kingEnemyPawn1RankClosePenalty, kingEnemyPawn2RankClosePenalty;
	int kingNearOpenFilePenalty;

	//!Ver esto
	int checkPenalty;

	EvaluationParameters();
	virtual ~EvaluationParameters();

	void GenerateRandomly();
	EvaluationParameters* Mutate(EvaluationParameters* pulation[POPULATION_SIZE], double r);
	EvaluationParameters* GetAverageFromPopulation(EvaluationParameters* pulation[POPULATION_SIZE]);

	int GetParameterByIndex(int index);
	void SetParameterByIndex(int index, double value);

};

#endif // !defined(AFX_EVALUATIONPARAMETERS_H__948E1FC3_BF31_4328_BF3F_0D7943EA4C6E__INCLUDED_)
