// EvaluationParameters.cpp: implementation of the EvaluationParameters class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "EvaluationParameters.h"
#include "Constants.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <cstdlib> 
#include <iostream>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

EvaluationParameters::EvaluationParameters()
{
	pawnValue = 100;
	knightValue = 330;
	bishopValue = 330;
	rockValue = 520;
	queenValue = 980;
	kingValue = 0;

	doubledPawnPenalty = -10;
	backwardsPawnPenalty = -8;
	passedPawnBonus = 20;
	passedPawnEmptyColumnBonus = 20;

	rockSemiOpenFileBonus = 10;
	rockOpenFileBonus = 15;
	rockSeventhBonus = 20;

	bishopAttackMostValuedBonus = 5;
	rockAttackMostValuedBonus = 5;

	knightNearOpponentPieceBonusOpe = 1;
	knightNearOpponentPieceBonusEnd = 2;
	knightSecureFromEnemyPawnsBonus = 5;
	knightFarFromKingPenalty = -1;

	bishopExtraMaterialInEnding = 10;
	bishopAttackAdyacentEnemyKingBonus = 5;

	hungPiecePenalty = -5;
	hungPiecePenaltyEnd = -20;
	blockedPiecePenalty = -5;
	blockedPiecePenaltyEnd = -20;

	isolatedPawnAPenalty = -12;
	isolatedPawnBPenalty = -14;
	isolatedPawnCPenalty = -16;
	isolatedPawnDPenalty = -20;
	isolatedPawnEPenalty = -20;
	isolatedPawnFPenalty = -16;
	isolatedPawnGPenalty = -14;
	isolatedPawnHPenalty = -12;

	kingPawnMoved1Penalty = -10;
	kingPawnMovedMoreThan1Penalty = -20;
	noKingPawnPenalty = -25;
	kingNoEnemyPawnPenalty = -15;
	kingEnemyPawn1RankClosePenalty = -10;
	kingEnemyPawn2RankClosePenalty = -5;

	kingNearOpenFilePenalty = -10;

	checkPenalty = -50;
}

EvaluationParameters::~EvaluationParameters()
{

}

void EvaluationParameters::GenerateRandomly()
{
	//Al parameters are random accoding penalty and bonusses and the know real value
	doubledPawnPenalty = GetIntRandomValue(-100, 0);
	backwardsPawnPenalty = GetIntRandomValue(-100, 0);
	passedPawnBonus = GetIntRandomValue(0, 200);
	passedPawnEmptyColumnBonus = GetIntRandomValue(0, 200);

	rockSemiOpenFileBonus = GetIntRandomValue(0, 100);
	rockOpenFileBonus = GetIntRandomValue(0, 100);
	rockSeventhBonus = GetIntRandomValue(0, 100);

	bishopAttackMostValuedBonus = GetIntRandomValue(0, 100);
	rockAttackMostValuedBonus = GetIntRandomValue(0, 100);

	knightNearOpponentPieceBonusOpe = GetIntRandomValue(0, 100);
	knightNearOpponentPieceBonusEnd = GetIntRandomValue(0, 100);
	knightSecureFromEnemyPawnsBonus = GetIntRandomValue(0, 100);
	knightFarFromKingPenalty = GetIntRandomValue(-100, 0);

	bishopExtraMaterialInEnding = GetIntRandomValue(0, 100);
	bishopAttackAdyacentEnemyKingBonus = GetIntRandomValue(0, 100);

	hungPiecePenalty = GetIntRandomValue(-100, 0);
	hungPiecePenaltyEnd = GetIntRandomValue(-100, 0);
	blockedPiecePenalty = GetIntRandomValue(-100, 0);
	blockedPiecePenaltyEnd = GetIntRandomValue(-100, 0);

	isolatedPawnAPenalty = GetIntRandomValue(-100, 0);
	isolatedPawnBPenalty = GetIntRandomValue(-100, 0);
	isolatedPawnCPenalty = GetIntRandomValue(-100, 0);
	isolatedPawnDPenalty = GetIntRandomValue(-100, 0);
	isolatedPawnEPenalty = GetIntRandomValue(-100, 0);
	isolatedPawnFPenalty = GetIntRandomValue(-100, 0);
	isolatedPawnGPenalty = GetIntRandomValue(-100, 0);
	isolatedPawnHPenalty = GetIntRandomValue(-100, 0);
			
	kingPawnMoved1Penalty = GetIntRandomValue(-100, 0);
	kingPawnMovedMoreThan1Penalty = GetIntRandomValue(-100, 0);
	noKingPawnPenalty = GetIntRandomValue(-100, 0);
	kingNoEnemyPawnPenalty = GetIntRandomValue(-100, 0);
	kingEnemyPawn1RankClosePenalty = GetIntRandomValue(-100, 0);
	kingEnemyPawn2RankClosePenalty = GetIntRandomValue(-100, 0);
	kingNearOpenFilePenalty = GetIntRandomValue(-100, 0);
	
	checkPenalty = GetIntRandomValue(-100, 0);
}

int EvaluationParameters::GetParameterByIndex(int index)
{
	switch(index)
	{
		case 0: return doubledPawnPenalty;
		case 1: return backwardsPawnPenalty;
		case 2: return passedPawnBonus;
		case 3: return passedPawnEmptyColumnBonus;

		case 4: return rockSemiOpenFileBonus;
		case 5: return rockOpenFileBonus;
		case 6: return rockSeventhBonus;

		case 7: return bishopAttackMostValuedBonus;
		case 8: return rockAttackMostValuedBonus;

		case 9: return knightNearOpponentPieceBonusOpe;
		case 10: return knightNearOpponentPieceBonusEnd;
		case 11: return knightSecureFromEnemyPawnsBonus;
		case 12: return knightFarFromKingPenalty;

		case 13: return bishopExtraMaterialInEnding;
		case 14: return bishopAttackAdyacentEnemyKingBonus;

		case 15: return hungPiecePenalty;
		case 16: return hungPiecePenaltyEnd;
		case 17: return blockedPiecePenalty;
		case 18: return blockedPiecePenaltyEnd;
		
		case 19: return isolatedPawnAPenalty;
		case 20: return isolatedPawnBPenalty;
		case 21: return isolatedPawnCPenalty;
		case 22: return isolatedPawnDPenalty;
		case 23: return isolatedPawnEPenalty;
		case 24: return isolatedPawnFPenalty;
		case 25: return isolatedPawnGPenalty;
		case 26: return isolatedPawnHPenalty;
			
		case 27: return kingPawnMoved1Penalty;
		case 28: return kingPawnMovedMoreThan1Penalty;
		case 29: return noKingPawnPenalty;
		case 30: return kingNoEnemyPawnPenalty;
		case 31: return kingEnemyPawn1RankClosePenalty;
		case 32: return kingEnemyPawn2RankClosePenalty;
		case 33: return kingNearOpenFilePenalty;
		case 34: return checkPenalty;
	
	}
	return 0;
}

void EvaluationParameters::SetParameterByIndex(int index, double value)
{
	int iValue;
	if (value-floor(value) > 0.5)
		iValue = ceil(value);
	else
		iValue = floor(value);

	switch(index)
	{
		case 0: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				doubledPawnPenalty=iValue; break;
			}
		case 1: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				backwardsPawnPenalty=iValue; break;
			}
		case 2: 
			{
				iValue = AdjustValue(iValue, 0, 200);
				passedPawnBonus=iValue; break;
			}
		case 3: 
			{
				iValue = AdjustValue(iValue, 0, 200);
				passedPawnEmptyColumnBonus=iValue; break;
			}
		case 4: 
			{
				iValue = AdjustValue(iValue, 0, 100);
				rockSemiOpenFileBonus=iValue; break;
			}
		case 5: 
			{
				iValue = AdjustValue(iValue, 0, 100);
				rockOpenFileBonus=iValue; break;
			}
		case 6: 
			{
				iValue = AdjustValue(iValue, 0, 100);
				rockSeventhBonus=iValue; break;
			}
		case 7: 
			{
				iValue = AdjustValue(iValue, 0, 100);
				bishopAttackMostValuedBonus=iValue; break;
			}
		case 8: 
			{
				iValue = AdjustValue(iValue, 0, 100);
				rockAttackMostValuedBonus=iValue; break;
			}
		case 9: 
			{
				iValue = AdjustValue(iValue, 0, 100);
				knightNearOpponentPieceBonusOpe=iValue; break;
			}
		case 10:
			{
				iValue = AdjustValue(iValue, 0, 100);
				knightNearOpponentPieceBonusEnd=iValue; break;
			}
		case 11: 
			{
				iValue = AdjustValue(iValue, 0, 100);
				knightSecureFromEnemyPawnsBonus=iValue; break;
			}
		case 12: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				knightFarFromKingPenalty=iValue; break;
			}
		case 13: 
			{
				iValue = AdjustValue(iValue, 0, 100);
				bishopExtraMaterialInEnding=iValue; break;
			}
		case 14: 
			{
				iValue = AdjustValue(iValue, 0, 100);
				bishopAttackAdyacentEnemyKingBonus=iValue; break;
			}
		case 15: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				hungPiecePenalty=iValue; break;
			}
		case 16: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				hungPiecePenaltyEnd=iValue; break;
			}
		case 17: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				blockedPiecePenalty=iValue; break;
			}
		case 18: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				blockedPiecePenaltyEnd=iValue; break;
			}

		case 19: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				isolatedPawnAPenalty=iValue; break;
			}
		case 20: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				isolatedPawnBPenalty=iValue; break;
			}
		case 21: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				isolatedPawnCPenalty=iValue; break;
			}
		case 22: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				isolatedPawnDPenalty=iValue; break;
			}
		case 23: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				isolatedPawnEPenalty=iValue; break;
			}
		case 24: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				isolatedPawnFPenalty=iValue; break;
			}
		case 25: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				isolatedPawnGPenalty=iValue; break;
			}
		case 26: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				isolatedPawnHPenalty=iValue; break;
			}
			
		case 27: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				kingPawnMoved1Penalty=iValue; break;
			}
		case 28: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				kingPawnMovedMoreThan1Penalty=iValue; break;
			}
		case 29: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				noKingPawnPenalty=iValue; break;
			}
		case 30: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				kingNoEnemyPawnPenalty=iValue; break;
			}
		case 31: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				kingEnemyPawn1RankClosePenalty=iValue; break;
			}
		case 32: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				kingEnemyPawn2RankClosePenalty=iValue; break;
			}
		case 33: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				kingNearOpenFilePenalty=iValue; break;
			}
		case 34: 
			{
				iValue = AdjustValue(iValue, -100, 0);
				checkPenalty=iValue; break;
			}
	}
}

int EvaluationParameters::AdjustValue(int value, int minValue, int maxValue)
{
	if (value > maxValue)
		value = maxValue;
	else if (value < minValue)
		value = minValue;

	return value;
}

EvaluationParameters* EvaluationParameters::Mutate(EvaluationParameters* population[POPULATION_SIZE], double r)
{
	EvaluationParameters* mutatedClone = new EvaluationParameters();

	double parameterAverage=0;
	double parameterSum=0;

	double parameterDesviation=0;
	double parameterDesviationSum=0;

	double mutatedParameter=0;
	
	//Do the proccess for each of the n parameters
	for (int parameter=0; parameter<EVALUATION_PARAMETERS_COUNT; parameter++)
	{
		parameterDesviationSum=0;
		parameterSum=0;

		for (int member=0; member<POPULATION_SIZE; member++)
			parameterSum += population[member]->GetParameterByIndex(parameter);
		parameterAverage = parameterSum/POPULATION_SIZE;
	
		for (int member=0; member<POPULATION_SIZE; member++)
			parameterDesviationSum += pow(population[member]->GetParameterByIndex(parameter)-parameterAverage, 2);
		parameterDesviation = sqrt(parameterDesviationSum/(POPULATION_SIZE-1));

		double dRand = ((double)rand())/((double)RAND_MAX);
		if (dRand > 1 || dRand < 0)
		{
			//!! esto es por test
			int test = 1;
		}

		mutatedParameter = GetParameterByIndex(parameter) + ((dRand-0.5)*r*parameterDesviation);
		mutatedClone->SetParameterByIndex(parameter, mutatedParameter);
	}

	return mutatedClone;	
}

EvaluationParameters* EvaluationParameters::GetAverageFromPopulation(EvaluationParameters* population[POPULATION_SIZE])
{
	EvaluationParameters* average = new EvaluationParameters();
	double parameterAverage=0;
	double parameterSum=0;

	for (int parameter=0; parameter<EVALUATION_PARAMETERS_COUNT; parameter++)
	{
		parameterSum=0;

		for (int member=0; member<POPULATION_SIZE; member++)
			parameterSum += population[member]->GetParameterByIndex(parameter);
		parameterAverage = parameterSum/POPULATION_SIZE;
	
		average->SetParameterByIndex(parameter, parameterAverage);
	}
	return average;
}

int EvaluationParameters::GetIntRandomValue(int minValue, int maxValue)
{
	int randNumber = minValue + rand()%(maxValue-minValue + 1);
	return randNumber;
}
