#if !defined(AFX_EVALUATION_H__59B56213_0A1C_41C8_B274_86E23948F7F9__INCLUDED_)
#define AFX_EVALUATION_H__59B56213_0A1C_41C8_B274_86E23948F7F9__INCLUDED_

#include "Move.h"
#include "MoveList.h"
#include "Board.h"
#include "Constants.h"
#include "EvaluationParameters.h"

#include <stdio.h>
#include <string>

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

const int pawnPcSq[64] =
{	
	0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0, -40, -40,   0,   0,   0,
	1,   2,   3, -10, -10,   3,   2,   1,
	2,   4,   6,   8,   8,   6,   4,   2,
	3,   6,   9,  12,  12,   9,   6,   3,
	4,   8,  12,  16,  16,  12,   8,   4,
	5,  10,  15,  20,  20,  15,  10,   5,
	0,   0,   0,   0,   0,   0,   0,   0,
};

const int kingPcSq[64] = 
{
	  0,  20,  40, -20,   0, -20,  40,  20,
	-20, -20, -20, -20, -20, -20, -20, -20,	  
	-40, -40, -40, -40, -40, -40, -40, -40,
	-40, -40, -40, -40, -40, -40, -40, -40,
	-40, -40, -40, -40, -40, -40, -40, -40,
	-40, -40, -40, -40, -40, -40, -40, -40,
	-40, -40, -40, -40, -40, -40, -40, -40,
	-40, -40, -40, -40, -40, -40, -40, -40,
};

/*const int kingPcSqNoCastle[64] = 
{
	  0,   0,   0,   0,   0,   0,   0,   0,
	-15, -15, -15, -15, -15, -15, -15, -15,	  
	-40, -40, -40, -40, -40, -40, -40, -40,
	-40, -40, -40, -40, -40, -40, -40, -40,
	-40, -40, -40, -40, -40, -40, -40, -40,
	-40, -40, -40, -40, -40, -40, -40, -40,
	-40, -40, -40, -40, -40, -40, -40, -40,
	-40, -40, -40, -40, -40, -40, -40, -40,
};*/

const int knightPcSq[64] = 
{
	-10, -30, -10, -10, -10, -10, -30, -10,
	-10,   0,   0,   0,   0,   0,   0, -10,
	-10,   0,   5,   5,   5,   5,   0, -10,
	-10,   0,   5,  10,  10,   5,   0, -10,
	-10,   0,   5,  10,  10,   5,   0, -10,
	-10,   0,   5,   5,   5,   5,   0, -10,
	-10,   0,   0,   0,   0,   0,   0, -10,
	-10, -10, -10, -10, -10, -10, -10, -10
};

const int bishopPcSq[64] = 
{
	-10, -10, -20, -10, -10, -20, -10, -10,
	-10,   0,   0,   0,   0,   0,   0, -10,
	-10,   0,   5,   5,   5,   5,   0, -10,
	-10,   0,   5,  10,  10,   5,   0, -10,
	-10,   0,   5,  10,  10,   5,   0, -10,
	-10,   0,   5,   5,   5,   5,   0, -10,
	-10,   0,   0,   0,   0,   0,   0, -10,
	-10, -10, -10, -10, -10, -10, -10, -10,
};

const int kingEndgamePcSq[64] = 
{
	 0,  10,  20,  30,  30,  20,  10,   0,
	10,  20,  30,  40,  40,  30,  20,  10,
	20,  30,  40,  50,  50,  40,  30,  20,
	30,  40,  50,  60,  60,  50,  40,  30,
	30,  40,  50,  60,  60,  50,  40,  30,
	20,  30,  40,  50,  50,  40,  30,  20,
	10,  20,  30,  40,  40,  30,  20,  10,
	 0,  10,  20,  30,  30,  20,  10,   0
};

const int flip[64] = 
{
	56,  57,  58,  59,  60,  61,  62,  63,
	48,  49,  50,  51,  52,  53,  54,  55,
	40,  41,  42,  43,  44,  45,  46,  47,
	32,  33,  34,  35,  36,  37,  38,  39,
	24,  25,  26,  27,  28,  29,  30,  31,
	16,  17,  18,  19,  20,  21,  22,  23,
	 8,   9,  10,  11,  12,  13,  14,  15,
	 0,   1,   2,   3,   4,   5,   6,   7
};


class Evaluation
{

private:

	int pawnRank[2][10];
    int pieceMat[2];
    int pawnMat[2];

	int isolatedPawnPenalty[8];
	int whiteAttacks[64], blackAttacks[64], blankAttacks[64];

	int EvalWhitePawn(Board* board, int square);
	int EvalBlackPawn(Board* board, int square);

	int EvalWhiteKing(Board* board, int square);
	int EvalWhiteKingPawn(int offsetColumn);
	int EvalBlackKing(Board* board, int square);
	int EvalBlackKingPawn(int offsetColumn);

	void ComputeAttacks(Board* board, int square);
	int GetAttackCount(Board* board, int attacksCode);
	int GetXRayScore(Board* board, int square, int piece, int sideOfPiece);
	bool BishopAttackSquare(Board* board, int square, int attackerSquare);
	int GetAttackCount(int attacksCode);

	EvaluationParameters ep;

public:
	
	Evaluation(EvaluationParameters* evaluationParameters);
	virtual ~Evaluation();

	int pieceValue[6];

	//Evaluate methods and ariables
	int Evaluate(Board* board);
	

};

//extern Evaluation global_evaluation;

#endif