// Engine.h: interface for the Engine class.
//
//////////////////////////////////////////////////////////////////////
#if !defined(AFX_ENGINE_H__59B56213_0A1C_41C8_B274_86E23948F7F9__INCLUDED_)
#define AFX_ENGINE_H__59B56213_0A1C_41C8_B274_86E23948F7F9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Move.h"
#include "MoveList.h"
#include "Board.h"
#include "Search.h"
#include "EvaluationParameters.h"

#include <stdio.h>
#include <string.h>
//#include "data.h"


/* see the beginning of think() */
#include <setjmp.h>

const int aspiration_offset[24] = 
{
	100,
	100,
	100,
	66,
	50,
	50,
	33,
	20, 20, 20,
	20, 20, 20,
	20, 20, 20,
	20, 20, 20,
	20, 20, 20,
	20, 20,
};

class Engine  
{

private:

	Search* search;
	void SetGameStatus(Move lastMove);

	//int stop_time;
	//int start_time;


public:
	//"The Brain" most important method.
	
	Move GetBestMoveFixedTime(int miliSeconds);
	Move GetBestMoveFixedDepth(int depth);
	Move GetBestMove(int miliSeconds, int depth);

	int GetRepetitionForLast();
	int GameStatus;
	int LastMoveDepth;
	int LastMoveMaxPly;

	void NewGame(bool resetHash);

	//Move methods
	Board* board;
	
	Engine(EvaluationParameters* evaluationParameters, int hashSize);
	Engine(int hashSize);
	virtual ~Engine();

	bool Post;
};



#endif // !defined(AFX_ENGINE_H__59B56213_0A1C_41C8_B274_86E23948F7F9__INCLUDED_)
