// Engine.cpp: implementation of the Engine class.
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "Engine.h"

#include <stdio.h>
#include <time.h>

Engine::Engine(EvaluationParameters* evaluationParameters, int hashSize)
{
	board = new Board();
	search = new Search(evaluationParameters, hashSize);
	Post = false;
}
Engine::Engine(int hashSize)
{
	//Use default parameters
	EvaluationParameters* evaluationParameters = new EvaluationParameters();
	board = new Board();
	search = new Search(evaluationParameters, hashSize);
	Post = false;
}

Engine::~Engine()
{
	delete board;
	delete search;
}

void Engine::NewGame(bool resetHash)
{
	GameStatus = ON_PLAYING;
	board->InitializeBoard();
	if (resetHash)
		search->hashTable->ResetHash();
}

Move Engine::GetBestMoveFixedTime(int miliSeconds)
{	
	Move m = GetBestMove(miliSeconds, MAX_DEPTH);
	return m;
}

void Engine::SetGameStatus(Move lastMove)
{
	if (lastMove.Score == -MATE_SCORE)
		GameStatus = (lastMove.MovingSide==WHITE)? WHITE_CHECKMATED: BLACK_CHECKMATED;

	//!creo que aca no entra nunca
	else if (lastMove.Score == MATE_SCORE)
		GameStatus = (lastMove.MovingSide==BLACK)? WHITE_CHECKMATED: BLACK_CHECKMATED;
	else if (lastMove.Score <= -(MATE_SCORE-RESIGN_MARGIN))
		GameStatus = (lastMove.MovingSide==WHITE)? WHITE_RESIGN: BLACK_RESIGN;
	else if (lastMove.From == lastMove.To && lastMove.Score == 0)
		GameStatus = DRAW_BY_SOLEMATE;	
	else if (GetRepetitionForLast() >= 3)
		GameStatus = DRAW_BY_REPETITION;
	else
		GameStatus = ON_PLAYING;
}

Move Engine::GetBestMoveFixedDepth(int depth)
{
	Move m = GetBestMove(MAX_TIME, depth);
	return m;
}

Move Engine::GetBestMove(int miliSeconds, int depth)
{
	int alpha = -MATE_SCORE;
	int beta = MATE_SCORE;
	int failHighCount=0, failLowCount=0;
	Move move;

	int searchStartTime = search->GetMs();
	int searchStopTime = searchStartTime + miliSeconds;
		
	for (LastMoveDepth=1;LastMoveDepth<=depth;) 
	{
		if (failLowCount==2 && failHighCount==2)
		{
			search->MainSearch(board, LastMoveDepth, -MATE_SCORE, MATE_SCORE, searchStartTime, searchStopTime);
		}
		else
		{
			search->MainSearch(board, LastMoveDepth, alpha, beta, searchStartTime, searchStopTime);
		}

		move = search->lastLine[0];
		LastMoveMaxPly = search->maxPly;	
		
		if (Post)
		{
			printf("%d %d %d %d", LastMoveDepth, move.Score, (search->GetMs() - searchStartTime)/10, search->nodeCount);

			for (int j = 0; j < search->lastLineCount; ++j)
				printf(" %s", search->lastLine[j].ToString().c_str());
			printf("\n");
			fflush(stdout);
		}

		if (search->searchStoped)
			return move;

		if (move.Score > (MATE_SCORE-RESIGN_MARGIN) || move.Score < -(MATE_SCORE-RESIGN_MARGIN) ) 
			break;
	
		if (move.Score <= alpha) 
		{      // WRONG!
			alpha = -MATE_SCORE;
			beta = move.Score + 1;
			failLowCount++;
			continue;
		}

		if (move.Score >= beta)
		{   
			// WRONG!
			beta = MATE_SCORE;
			alpha = move.Score - 1;
			failHighCount++;
			continue;
		}
				
		alpha = move.Score - aspiration_offset[LastMoveDepth];
		beta = move.Score + aspiration_offset[LastMoveDepth];
		LastMoveDepth++;
	}

	if (LastMoveDepth>depth)
		LastMoveDepth--;

	SetGameStatus(move);
	return move;
}

int Engine::GetRepetitionForLast()
{
	int repCount = 0;
	__int64 lastKey = board->history[board->moveCount-1].key;
	
	//The last position is counted too, so this method return 1 at least.
	for (int position=0; position<board->moveCount; position++)
	{
		if (board->history[position].key == lastKey)
			repCount++;
	}
	return repCount;
}

