// Board.h: interface for the Board class.
//
//////////////////////////////////////////////////////////////////////
#if !defined(AFX_BOARD_H__E5B62834_2E93_431E_B72A_5154EB8D6958__INCLUDED_)
#define AFX_BOARD_H__E5B62834_2E93_431E_B72A_5154EB8D6958__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Constants.h"
#include "Move.h"
#include "MoveList.h"
#include "PrecalculatedMoveGeneration.h"

typedef struct _MoveRecord 
{
	__int64 key;
	char KingCastle;
	char emPassCol;
	Move move;
	bool nullMove;
	bool irreversibleMove;
} MoveRecord;

class Board  
{

private:
	
	__int64 Rand64();
	__int64 zobristTable[6][2][64];
	__int64 zobristEmPassantTable[9];
	__int64 zobristCastleTable[4][2];
	__int64 white_to_move_code;

	PrecalculatedMoveGeneration* pcmg;	
			
	void TestAndAddMove(MoveList* moves, char from, char to, char movingPiece, bool capture, char castleMoveCode);
	void AddToMoveList(MoveList* moves, char from, char to, char movingPiece, char castleMoveCode, bool capture, bool promote, char pieceToPromote);
		
	//Methos used for move sorting
	static int MoveComparer(const void* a, const void* b);

	char emPassCol;
	
public:

	Board();
	virtual ~Board();

	//Board representation
	char squarePiece[64], squareSide[64];
	char whiteKingSquare, blackKingSquare;
	char sideToMove;
	int moveCount;

	//Arrays containing sliding directions for pieces of 1, 4 and 8 directions
	int* oneDirection;
	int* fourDirections[4];
	int* eightDirections[8];
	int* squareKnightDirection;
	int* squareSlidingDirection[8];

	//This Method return the array of directions for piece and square
	void GenerateNoPawnDirections(int slidingPiece, int square);

	MoveList* GetAllMoves();
	MoveList* GetAllCaptures();

	MoveRecord history[MAX_GAME_LEGTH];
	void MakeMove(Move move);
	void TakeBackMove();

	void MakeNullMove();
	//void TakeBackNullMove();

	//Castle flag variables
	char whiteKingCastle;
	char blackKingCastle;

	int GetDistance(int square1, int square2);

	bool InCheck(int side);
	bool IsBlocked(int square);
	bool IsInAttack(int square, int sideOfSquare);

	void GenerateSquareDirections(int square);
	
	__int64 GetKey();

	//Board initialization and move generation methods
	void InitializeBoard();
	void SortMoveList(MoveList* moves);
};

#endif // !defined(AFX_BOARD_H__E5B62834_2E93_431E_B72A_5154EB8D6958__INCLUDED_)
