// search.h header file for search.cpp

#ifndef SEARCH_H
#define SEARCH_H

#define UNIT_DEPTH 64
#define DEPTH(x)  (x>>6)
#define TIME_FLAG 123456

/* extensions */
// These values can be modified by the search.par text file.
// The code to read the search.par file is in score.cpp.
int CHECK_EXT =   48;
int ONE_REPLY_TO_CHECK = 48;
int PAWN_EXT =    48;
int RE_CAPT_EXT = 48;
int MATE_EXT =    48;
int INIT_EXT =    48;
int SINGULAR_EXT = 48;

int NO_CHECK_EXT_SCORE = 600;

// Null move flag
int NULL_MOVE = 1;

// Razoring depth
int RAZOR_DEPTH = 192;

int EGTB = 0;                       // maximum tablebase pieces

int BOOK_LEARNING = 0;          // flag for book learning

// Chess Skill
int CHESS_SKILL = 100;

#if DEBUG_SEARCH
 ofstream search_outfile;
#endif

#endif  /* SEARCH_H */









