/* Header for scoring alogrithm */

#ifndef SCORE_H
#define SCORE_H

float SCORE_PAR_VERSION = 6.1;

int scores[LEARN_PARAMETERS];
int lscores[LEARN_PARAMETERS];     // flags for whether to learn each parm
int SCORE_LEARNING = 0;

int SIDE_ON_MOVE =       11;

int DOUBLED_PAWN =        3;
int WEAK_PAWN =           0;
int BACKWARD_PAWN =       4;
int PAWN_ISLAND =        13;
int PASSED_PAWN =        11;
int BISHOP_PAIR =        35;
int ROOK_CONN_OPEN =      9;
int ROOK_CONN_HALF_OPEN = 9;
int CON_PASSED_PAWNS =  185;
int OUTSIDE_PASSED_PAWN = 4;
int FREE_PASSED_PAWN =   28;
int CASTLED =             9;
int NO_POSSIBLE_CASTLE =  6;
int ROOK_MOBILITY =      15;
int QUEEN_MOBILITY =     18;
int KNIGHT_MOBILITY =    34;
int PAWN_DUO =            9;
int BOXED_IN_ROOK =      45;
int KNIGHT_OUTPOST =     11;
int BISHOP_OUTPOST =     15;
int BISHOP_MOBILITY =    36;

int KING_SIDE_DEFECTS =   3;
int QUEEN_SIDE_DEFECTS =  3;

int ROOK_OPEN_FILE =     45;
int ROOK_HALF_OPEN_FILE= 28;

int KING_ATTACKS =       15;
int EARLY_EXIT =        150;

// Outpost squares and bitmasks for setting which outposts 
// are filled
int white_outpost[8] = { 34,35,36,37,42,43,44,45 };
int outpost_score[8] = {  9, 6,15, 7, 7, 7,16, 9 };
int black_outpost[8] = { 26,27,28,29,18,19,20,21 };
unsigned char bitmask[8] = { 1,2,4,8,16,32,64,128 };

// Value of the pieces
int value[7] = { 0, 100, 458, 489, 711, 1498, 10000 };

// Piece square tables
//int piece_sq[2][7][64];

// proto-types for piece square tables, first index is for the stage of
// the game, 2nd index is for piece
// stage 0 = opening
// stage 1 = early middle-game
// stage 2 = late middle-game
// stage 3 = ending

int piece_sq[4][7][64] = {    // note values cannot exceed +127 or -127!

// Reading these is a little tricky.  These tables
// are set up to look like a chess board from white's
// point of view, but they are indexed from black's
// point of view.  The whitef array is used to
// map these values to the right squares for white.
{
//For NO_PIECE in stage 0
{
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0
},
//For PAWN in stage 0
{
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   1,   0,   1,   1,   0,   1,   0,
         4,   8,   5,  16,  16,   5,   8,   4,
        -4,  -3,  -3,  22,  22,  -3,  -3,  -4,
        -3,  -4,  -3,   4,   4,  -3,  -4,  -3,
         0,   0,  -1,  -8,  -8,  -1,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0
},
//For KNIGHT in stage 0
{
        -7,  -6,  -4,  -4,  -4,  -4,  -6,  -7,
        -5,   0,   0,   0,   0,   0,   0,  -5,
        -3,   6,   8,   7,   7,   8,   6,  -3,
        -2,   8,   9,  14,  14,   9,   8,  -2,
         0,   6,   6,  15,  15,   6,   6,   0,
        -1,   3,  17,   5,   5,  17,   3,  -1,
        -4,   0,   1,   2,   2,   1,   0,  -4,
        -7, -10,  -1,   0,   0,  -1, -10,  -7
},
//For BISHOP in stage 0
{
         0,   0,   0,   0,   0,   0,   0,   0,
         1,   0,   0,   0,   0,   0,   0,   1,
         0,   0,   8,   8,   8,   8,   0,   0,
         0,  11,   9,   7,   7,   9,  11,   0,
         0,   7,   4,  10,  10,   4,   7,   0,
         0,   0,   1,   6,   6,   1,   0,   0,
         0,   5,   0,  -1,  -1,   0,   5,   0,
         0,   0,  -2,   0,   0,  -2,   0,   0
},
//For ROOK in stage 0
{
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         1,   0,   0,   0,   0,   0,   0,   1,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   6,   9,   9,   6,   0,   0
},
//For QUEEN in stage 0
{
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         2,   0,   1,   0,   0,   1,   0,   2,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   1,   0,   0,   1,   0,   0,
         0,   0,   3,   3,   3,   3,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0
},
//For KING in stage 0
{
       -25, -25, -25, -25, -25, -25, -25, -25,
       -25, -25, -25, -25, -25, -25, -25, -25,
       -25, -25, -25, -25, -25, -25, -25, -25,
       -25, -25, -25, -25, -25, -25, -25, -25,
       -25, -25, -25, -25, -25, -25, -25, -25,
       -25, -25, -25, -25, -25, -25, -25, -25,
        -4,  -2, -25, -24, -24, -25,  -2,  -4,
         9,  19,  -3,  -7,  -7,  -3,  19,   9
} },
{
//For NO_PIECE in stage 1
{
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0
},
//For PAWN in stage 1
{
         0,   0,   0,   0,   0,   0,   0,   0,
         5,   1,   5,   1,   1,   5,   1,   5,
         7,   1,  13,   7,   7,  13,   1,   7,
         9,  16,   9,  19,  19,   9,  16,   9,
        -4,   1,  -1,  15,  15,  -1,   1,  -4,
         0,   0,  -4,   4,   4,  -4,   0,   0,
         0,   1,  -2,  -6,  -6,  -2,   1,   0,
         0,   0,   0,   0,   0,   0,   0,   0
},
//For KNIGHT in stage 1
{
       -10,  -5,  -4,  -4,  -4,  -4,  -5, -10,
        -5,   4,   4,   4,   4,   4,   4,  -5,
         0,   9,  11,  12,  12,  11,   9,   0,
         0,  17,  21,  25,  25,  21,  17,   0,
         1,   8,  10,  23,  23,  10,   8,   1,
        -1,   2,  11,   3,   3,  11,   2,  -1,
        -3,  -2,   0,   2,   2,   0,  -2,  -3,
       -10, -17,  -3,  -2,  -2,  -3, -17, -10
},
//For BISHOP in stage 1
{
         0,   0,   1,   0,   0,   1,   0,   0,
         3,   2,   0,   0,   0,   0,   2,   3,
         0,   4,   9,  13,  13,   9,   4,   0,
         1,  13,  16,  23,  23,  16,  13,   1,
         0,   4,  22,  25,  25,  22,   4,   0,
         1,   1,   4,  10,  10,   4,   1,   1,
        -1,   6,   1,   0,   0,   1,   6,  -1,
         0,   0,  -9,   0,   0,  -9,   0,   0
},
//For ROOK in stage 1
{
         0,   1,   0,   0,   0,   0,   1,   0,
         7,  15,  12,  11,  11,  12,  15,   7,
         1,   0,   0,   0,   0,   0,   0,   1,
         4,   4,   1,   2,   2,   1,   4,   4,
         3,   0,   1,   0,   0,   1,   0,   3,
         2,   3,   0,   0,   0,   0,   3,   2,
         0,   3,   0,  -2,  -2,   0,   3,   0,
        -3,   5,   2,   1,   1,   2,   5,  -3
},
//For QUEEN in stage 1
{
         0,   0,   0,   1,   1,   0,   0,   0,
         0,   0,   1,   1,   1,   1,   0,   0,
         0,   6,   1,   1,   1,   1,   6,   0,
         2,   1,   1,   4,   4,   1,   1,   2,
         2,   4,   6,   6,   6,   6,   4,   2,
         0,   0,   0,   4,   4,   0,   0,   0,
         0,   0,   8,   4,   4,   8,   0,   0,
         0,   0,  -1,  -2,  -2,  -1,   0,   0
},
//For KING in stage 1
{
       -25, -25, -25, -24, -24, -25, -25, -25,
       -25, -25, -25, -25, -25, -25, -25, -25,
       -25, -25, -25, -24, -24, -25, -25, -25,
       -24, -25, -25, -24, -24, -25, -25, -24,
       -25, -25, -24, -24, -24, -24, -25, -25,
       -26, -24, -24, -25, -25, -24, -24, -26,
         0,   0, -22, -28, -28, -22,   0,   0,
         0,  27,  -5,  -7,  -7,  -5,  27,   0
} },
{
//For NO_PIECE in stage 2
{
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0
},
//For PAWN in stage 2
{
         0,   0,   0,   0,   0,   0,   0,   0,
        55,  48,  51,  53,  53,  51,  48,  55,
        22,  19,  20,  30,  30,  20,  19,  22,
        14,  13,  11,   6,   6,  11,  13,  14,
         3,   9,   5,   1,   1,   5,   9,   3,
         1,   5,   1,   6,   6,   1,   5,   1,
         0,   5,   4,  -2,  -2,   4,   5,   0,
         0,   0,   0,   0,   0,   0,   0,   0
},
//For KNIGHT in stage 2
{
       -10,  -6,  -4,  -3,  -3,  -4,  -6, -10,
        -6,   2,   3,   4,   4,   3,   2,  -6,
        -3,   8,  10,  13,  13,  10,   8,  -3,
        -2,  14,   9,  16,  16,   9,  14,  -2,
         0,   6,   9,  16,  16,   9,   6,   0,
        -4,   3,   3,   7,   7,   3,   3,  -4,
        -6,   0,   2,   2,   2,   2,   0,  -6,
       -10, -13,  -3,  -3,  -3,  -3, -13, -10
},
//For BISHOP in stage 2
{
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   1,   0,   0,   1,   0,   0,
         3,   1,   8,  11,  11,   8,   1,   3,
         0,   8,  13,  15,  15,  13,   8,   0,
         0,  11,  10,  18,  18,  10,  11,   0,
         0,   1,   2,   4,   4,   2,   1,   0,
         0,   1,   0,   0,   0,   0,   1,   0,
         0,   0,  -7,   0,   0,  -7,   0,   0
},
//For ROOK in stage 2
{
         1,   0,   0,   0,   0,   0,   0,   1,
        14,  13,  12,  15,  15,  12,  13,  14,
         2,   0,   1,   1,   1,   1,   0,   2,
         0,   0,   0,   2,   2,   0,   0,   0,
         0,   0,  -1,   0,   0,  -1,   0,   0,
        -2,   0,  -1,  -2,  -2,  -1,   0,  -2,
        -2,  -1,  -2,  -1,  -1,  -2,  -1,  -2,
        -5,   0,   0,   0,   0,   0,   0,  -5
},
//For QUEEN in stage 2
{
         0,   0,   0,   1,   1,   0,   0,   0,
         8,  11,  10,   9,   9,  10,  11,   8,
         0,   6,   8,   7,   7,   8,   6,   0,
         1,   5,   9,  12,  12,   9,   5,   1,
         0,   5,  10,  10,  10,  10,   5,   0,
         0,   3,   7,   5,   5,   7,   3,   0,
        -1,   0,   1,   1,   1,   1,   0,  -1,
         0,   0,   0,   0,   0,   0,   0,   0
},
//For KING in stage 2
{
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   2,   2,   0,   0,   0,
         0,   1,   0,   1,   1,   0,   1,   0,
         0,   0,   2,   0,   0,   2,   0,   0,
         0,   0,   8,   1,   1,   8,   0,   0,
         0,   0,  -1,   0,   0,  -1,   0,   0
} },
{
//For NO_PIECE in stage 3
{
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0
},
//For PAWN in stage 3
{
         0,   0,   0,   0,   0,   0,   0,   0,
        94,  92,  97,  96,  96,  97,  92,  94,
        46,  50,  52,  49,  49,  52,  50,  46,
        20,  21,  24,  14,  14,  24,  21,  20,
        22,  21,  16,  11,  11,  16,  21,  22,
        12,  17,   4,  10,  10,   4,  17,  12,
        18,  19,   5,   0,   0,   5,  19,  18,
         0,   0,   0,   0,   0,   0,   0,   0
},
//For KNIGHT in stage 3
{
       -10,  -5,  -3,  -3,  -3,  -3,  -5, -10,
        -4,   2,   5,   5,   5,   5,   2,  -4,
         0,   8,  12,  10,  10,  12,   8,   0,
         0,   9,  10,  10,  10,  10,   9,   0,
        -1,   5,   8,  13,  13,   8,   5,  -1,
        -2,   2,  12,   5,   5,  12,   2,  -2,
        -7,   0,   4,   2,   2,   4,   0,  -7,
       -10,  -5,  -4,  -3,  -3,  -4,  -5, -10
},
//For BISHOP in stage 3
{
         0,   1,   0,   0,   0,   0,   1,   0,
         1,   3,   6,   8,   8,   6,   3,   1,
         0,   7,  10,  11,  11,  10,   7,   0,
         0,   7,  10,  21,  21,  10,   7,   0,
         1,   8,  11,  19,  19,  11,   8,   1,
         0,   6,   8,   8,   8,   8,   6,   0,
         1,   5,   6,   3,   3,   6,   5,   1,
         1,   0,  -2,   0,   0,  -2,   0,   1
},
//For ROOK in stage 3
{
         2,   0,   0,   0,   0,   0,   0,   2,
         8,  10,   7,  10,  10,   7,  10,   8,
         0,   0,   0,   3,   3,   0,   0,   0,
         0,   1,   0,   0,   0,   0,   1,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
         0,   0,  -1,   0,   0,  -1,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0,
        -1,   0,   1,  -1,  -1,   1,   0,  -1
},
//For QUEEN in stage 3
{
         2,   1,   0,   2,   2,   0,   1,   2,
         0,   5,   5,   5,   5,   5,   5,   0,
         0,   4,   8,   7,   7,   8,   4,   0,
         2,   6,   8,  14,  14,   8,   6,   2,
         0,   6,   6,   8,   8,   6,   6,   0,
         0,   2,   3,   3,   3,   3,   2,   0,
         0,   0,   2,   1,   1,   2,   0,   0,
         0,   0,   0,   0,   0,   0,   0,   0
},
//For KING in stage 3
{
       -25, -15, -10,   0,   0, -10, -15, -25,
       -14,   2,   4,   3,   3,   4,   2, -14,
       -10,   6,   9,  10,  10,   9,   6, -10,
         0,  10,  16,  15,  15,  16,  10,   0,
         1,   7,  11,  10,  10,  11,   7,   1,
       -11,   3,   6,  17,  17,   6,   3, -11,
       -13,   0,   2,   0,   0,   2,   0, -13,
       -26, -15, -15,  -4,  -4, -15, -15, -26
} }
};


// white reference array to access piece-sq tables
// black can access the arrays directly
int whitef[64] = {
       56, 57, 58, 59, 60, 61, 62, 63,
       48, 49, 50, 51, 52, 53, 54, 55,
       40, 41, 42, 43, 44, 45, 46, 47,
       32, 33, 34, 35, 36, 37, 38, 39,
       24, 25, 26, 27, 28, 29, 30, 31,
       16, 17, 18, 19, 20, 21, 22, 23,
        8,  9, 10, 11, 12, 13, 14, 15,
        0,  1,  2,  3,  4,  5,  6,  7
};

/* -- not currently used below

// reference arrays for pawns when king
// in on the queen side
int qs_whitef[64] = {
       63, 62, 61, 60, 59, 58, 57, 56,
       55, 54, 53, 52, 51, 50, 49, 48,
       47, 46, 45, 44, 43, 42, 41, 40,
       39, 38, 37, 36, 35, 34, 33, 32,
       31, 30, 29, 28, 27, 26, 25, 24,
       23, 22, 21, 20, 19, 18, 17, 16,
       15, 14, 13, 12, 11, 10,  9,  8,
        7,  6,  5,  4,  3,  2,  1,  0
};

int qs_blackf[64] = {
        7,  6,  5,  4,  3,  2,  1,  0,
       15, 14, 13, 12, 11, 10,  9,  8,
       23, 22, 21, 20, 19, 18, 17, 16,
       31, 30, 29, 28, 27, 26, 25, 24,
       39, 38, 37, 36, 35, 34, 33, 32,
       47, 46, 45, 44, 43, 42, 41, 40,
       55, 54, 53, 52, 51, 50, 49, 48,
       63, 62, 61, 60, 59, 58, 57, 56
};

*/

#endif /* SCORE_H */

