/* header file for hash functions */

#ifndef HASH_H
#define HASH_H

#define FLAG_A 1
#define FLAG_B 2
#define FLAG_P 3
#define HASH_MISS -21000
#define HASH_MOVE -21001

/* standard hash record - 20 bytes long */
struct hash_rec
{
  h_code key;
  short score;
  char flag;
  char depth;   // note that stored depths cannot be larger than 127
  move hmove;
  unsigned char id;
  unsigned char mate_ext;
};

/* pawn hash record - 22 bytes long */
struct pawn_rec
{
  h_code key;
  short score;
  unsigned char wposts;
  unsigned char bposts;
  unsigned char ks_defects_w;
  unsigned char qs_defects_w;
  unsigned char ks_defects_b;
  unsigned char qs_defects_b;
  unsigned char open_files;
  unsigned char half_open_files_w;
  unsigned char half_open_files_b;
  unsigned char passed_w;
  unsigned char passed_b;
  unsigned char pstage;
};

/* Number of hash related functions */
void open_hash();
void close_hash();
void set_hash_size(unsigned int Mbytes);
void put_hash(h_code *h_key, int score, int alpha, int beta, int depth, move hmove, int mate_ext);
int get_hash(h_code *h_key, int *hflag, int *hdepth, int *mate_ext, move *gmove);
int get_move(h_code *h_key);
void start_code();

/* Macro for or'ing two hash codes */
#define Or(A, B)   A ^= B;

/* hash table variables */
unsigned int TAB_SIZE = 262144;   // hash table size (entries) - override in search.par
unsigned int PAWN_SIZE = 131072;  // pawn hash sizes (entries) - override in search.par
hash_rec *hash_table;              // pointer to start of hash table
pawn_rec *pawn_table;              // pointer to start of pawn table
//
// hash codes for sides to-move, pieces, castling, en-passant, and game_stage
//
h_code hwtm, hbtm, hval[13][64];   
h_code castle_code[16], ep_code[64], stage_code[4];

int h_id = 1;  // hash code id counter to descriminate between old-current searches



#endif /* HASH_H */
