/* Functions */

#ifndef FUNCT_H
#define FUNCT_H

#include "define.h"

/* swap.cpp */
int swap(int sq, position p, int side, int from);

/* main.cpp */
void drawboard();          // draw game board and info
void takeback(int tm);
void type_moves();             // print possible moves
void type_capts();             // print possible captures
void parse_command();          // parse user's command
void make_move();              // find and make move
//void test_suite(const char *, const char *, int);             // run a test suite
void save_game();
void help();
int inter();                   // interrupt function
//void search_display(int score, long start_time, int node_count, int max_ply);
//void log_search(int score, long start_time, int node_count, int max_ply);
void write_out(const char *);   // write information to logfile
void performance();             // performance test function

/* parse.cpp */
void print_move(position p, move pmove, char mstring[10]); // print a given move
move parse_move(position p, char mstring[10]);

/* open.cpp */

/* search.cpp */
void pc_update(move pcmove, int ply);

/* score.cpp */
void set_scores(int *sc);
void score_learning(int T, int stm, game_rec *gr);

/* setup.cpp */
void set_search_param();
void set_score_value(char dummy[50], int value);
void read_scores();
void write_scores();
void gen_check_table();

/* sort.cpp */
void QuickSortBook(book_rec *Lb, book_rec *Ub);
void QuickSortMove(move_rec *Lb, move_rec *Ub);

/* book.cpp */
void build_book(position ipos);
void book_learn(int flag, game_rec *gr);
int edit_book(h_code hash_code, position *p);
move opening_book(h_code hash_code, position p, game_rec *gr);

/* util.cpp */
int GetTime();
unsigned int ibit();

/* probe.cpp */
#if TABLEBASES
int init_tb();
int probe_tb(position *p, int ply);
#endif

/* hash.cpp */
int put_move(h_code h_key, int putmove);

/*  mt19937.c */
void sgenrand(long);
double genrand();

#endif


