/* Global constants used all over the program */

#ifndef EXTERN_H
#define EXTERN_H

#include <cstdio>
#include <fstream>
using namespace std;

extern bool analyze_mode = false;

/* setup.cpp */
extern int taxi_cab[64][64];
//
// Simple tables for quick in_check? tests 
//
extern int check_table[64][64];
extern int rook_check_table[64][64];
extern int bishop_check_table[64][64];
extern int knight_check_table[64][64];
extern int slide_check_table[64][64];

extern int logging;                      // flag for logging  

/* score.h */
extern int value[7];                              // piece values, indexed by type
extern int EARLY_EXIT;
extern float SCORE_PAR_VERSION;
extern int scores[LEARN_PARAMETERS];
extern int lscores[LEARN_PARAMETERS];
extern int BAD_BISHOP, DOUBLED_PAWN, WEAK_PAWN, BACKWARD_PAWN,
           PAWN_ISLAND, PASSED_PAWN, BISHOP_PAIR, ROOK_CONN_OPEN,
           ROOK_CONN_HALF_OPEN, CON_PASSED_PAWNS, FILE_BONUS,
           HALF_FILE_BONUS, CASTLED, NO_POSSIBLE_CASTLE,
           ROOK_KING_FILE, ROOK_MOBILITY, QUEEN_MOBILITY, KNIGHT_MOBILITY,
           BISH_PAWN_BLOCK, PAWN_DUO, BOXED_IN_ROOK, KNIGHT_OUTPOST,
           BISHOP_OUTPOST, KING_SIDE_DEFECTS, QUEEN_SIDE_DEFECTS,
           MISSING_A_PAWN, MISSING_B_PAWN, MISSING_C_PAWN, MISSING_F_PAWN,
           MISSING_G_PAWN, MISSING_H_PAWN, ROOK_OPEN_FILE,
           ROOK_HALF_OPEN_FILE, KING_ATTACKS, outpost_score[8],
           proto_piece_sq[4][7][64], SIDE_ON_MOVE;
extern double TD_ALPHA, TD_LAMBDA;

/* search.h -- extensions */
extern int CAPT_EXT, CHECK_EXT, PAWN_EXT, RE_CAPT_EXT, SINGULAR_EXT;
extern int ONE_REPLY_TO_CHECK, MATE_EXT, INIT_EXT, NULL_MOVE, RAZOR_DEPTH;
extern int CHESS_SKILL;

/* other external variables */
extern char exec_path[FILENAME_MAX], BOOK_FILE[FILENAME_MAX], START_BOOK[FILENAME_MAX];
extern int MAX_LOGS, GAMBIT_SCORE, BOOK_LEARNING, SCORE_LEARNING;
extern int max_ply;
extern int THRESHOLD;  // THRESHOLD for extensions
extern int SCORE_LEARNING;

/* hash.h */
extern h_code hwtm, hbtm, hval[13][64], stage_code[4];
extern h_code castle_code[16], ep_code[64];
extern int h_id;
extern unsigned int TAB_SIZE, PAWN_SIZE;
extern unsigned int phash_count;


/* main.cpp */
extern int xboard, post;           // xboard flag, posting flag
extern int ALLEG;                  // flags from main.cpp to control the book
                                   // and playing modes
extern ofstream logfile;           // logfile


/* book.cpp */
extern int learn_count;


/* fltk_gui.cpp */
extern int FLTK_post;
extern int abortflag;
#if FLTK_GUI
#include <FL/Fl_Text_Buffer.H>
#include <FL/Fl_Text_Display.H>
extern Fl_Text_Buffer *searchout_buffer;
extern Fl_Text_Display *searchout;
#endif

#if TABLEBASES
extern char EGTB_PATH[FILENAME_MAX];
extern float CACHE_SIZE;
#endif


#endif  /* EXTERN_H */

