/* Pre-processor definitions to make the code more
   readable and easy to modify */

#ifndef DEFINE_H
#define DEFINE_H

// -------------------------------
// Program Version 
// -------------------------------
#ifdef VERS
 #define VERS2 ""
#else
 #define VERS  6.10              // program version number
 #define VERS2 "b JA"
#endif

// -------------------------------
// Some compiler specific defines
// -------------------------------
// Compiler flags for different systems
#define MSVC            0   // Selects a win95/NT compiler if set to 1
                            //   this used to work with older versions of MSVC
                            //   haven't compiled with one in several years
#define MINGW           1   // Set to 1 for GCC compiler in Windows
#define UNIX            0   // Set to 1 for all Unix systems
#define DEBUG_SEARCH    0   // Set to 1 to debug mode... quite slow


// define 64 bit integers and zero values for unsigned long long
#if MSVC
 #define ZERO 0ui64
#else
 #define __int64 long long
 #define ZERO 0ULL
#endif

// IO flags
#if MSVC
 #define IOS_IN_TEXT std::ios::in
#else 
 #define IOS_IN_TEXT ios::in
#endif

#define IOS_OUT ios::out | ios::binary
#define IOS_IN  ios::in | ios::binary

// -------------------------------
//  Tablebases
// -------------------------------
#ifndef TABLEBASES
 #define TABLEBASES   1  // Set to 1 to enable tablebase code, see
#endif                   // the file 'probe.cpp' for more details

// -------------------------------
//  FLTK GUI switch
// -------------------------------
#if MAKE_GUI
 #define FLTK_GUI 1      // compile the FLTK GUI interface
#else
 #define FLTK_GUI 0
#endif

// -------------------------------
//  General purpose defines below
// -------------------------------

#define MAXD  200                // max search depth
#define MAXT  3600000            // max search time in seconds (1000 hours default)
#define MATE 10000000            // mate score

// Maximum number of book positions in a temp file
#define BOOK_POS 50000
// Maximum number of temp files
#define TEMP_FILES 1000

// book learning threshold..
#define LEARN_SCORE    500
#define LEARN_FACTOR     5

// learning score parameters
#define LEARN_PARAMETERS 1577   // number of paramters to learn              

// maximum game length
#define MAX_GAME_PLY   6000

// Threshold for null search
#define NULL_THRESH    200

// Color flags
#define WHITE 1
#define BLACK 0

/* Piece definitions */

#define EMPTY        0
#define PAWN         1
#define KNIGHT       2
#define BISHOP       3
#define ROOK         4
#define QUEEN        5
#define KING         6

/* Piece id numbers for certain kinds of indicies */

#define BPAWN        1
#define BKNIGHT      2
#define BBISHOP      3
#define BROOK        4
#define BQUEEN       5
#define BKING        6
#define WPAWN        7
#define WKNIGHT      8
#define WBISHOP      9
#define WROOK       10
#define WQUEEN      11
#define WKING       12

/* Types of moves */

#define CAPTURE      1
#define CASTLE       2
#define EP           4
#define PAWN_PUSH2   8
#define PAWN_PUSH   16
#define PROMOTE     32

/* macros */
#define RANK(x)    ((x)>>3)        // Find the rank associated with square x
#define FILE(x)    ((x)&7)         // Find the file associated with square x
#define SQR(x,y)   ((x)+((y)<<3))       // Find square from rank x and file y

#define CHAR_FILE(x) (int(x)-97)  // convert letter character to a file
#define CHAR_ROW(x)  (int(x)-49)  // convert number character to a row

// find the id number of the piece
#define ID(x) (((x.side) > 0) ? ((x.type)+6) : (x.type) )

#define MAX(x,y) (((x) > (y)) ? (x) : (y) )
#define MIN(x,y) (((x) < (y)) ? (x) : (y) )

#define ABS(x) (((x) < 0) ? (-(x)) : (x))

#define NOMOVE       0           // no move

#endif /* DEFINE_H */













