////////////////////////////  D A B B A B A  ////////////////////////////

//
// Winboard protocol added                     - Jim Ablett [07-05-08]
//
// WB variant support added                    - Jim Ablett [10-05-08]
//
// Console epd analysis functions 
// restored, basic Winboard ICS 
// commands added                              - Jim Ablett [23-05-08]
//
// Added search & eval parameters to 
// Dabbaba.ini file, so now they are
// adjustable for tuning.                      - Jim Ablett [24-05-08]
//
// Small bugfix for epd test results &
// some cosmetic changes.                      - Jim Ablett [25-05-08]
//
// Piece values & few more adjustable 
// parameters added to Dabbaba.ini                          
// Increased size of epd file buffer.
// Some long epds were not being read
// fully because input buffer was too small
// & truncating them.                          - Jim Ablett [25-05-08]
//
// load a position (setboard) & analyze 
// working in Arena                            - Jim Ablett [31-05-08]
//
// best lines and score now displayed in 
// Arena analysis mode                         - Jim Ablett [03-06-08]
//
// Added wb 'force' command. Now Dabbaba
// can use gui opening books                   - Jim Ablett [06-06-08]  
//
// Fixed bad bug where wb protover command
// wasn't being parsed properly in Winboard    
// resulting in setboard/analyze not working   - Jim Ablett [07-06-08]        
//    
// Fixed Nightrider variant support            - Jim Ablett [27-06-08]                    
//
// Fixed bug so random opening can be turned off
// Speed of play doubled
// Improved evaluation in opening/midgame
// Adjusted values in Dabbaba.ini
// Style of play always 1
// All changes marked with "jn2008"            - Jens B N   [02-07-08]    
//
// Changed Nightrider to use variant fairy     - Jim Ablett [03-07-08]
// and set knights to use 'h' instead of 'n' 
// piece representation internally.                             
//
// Added back full variant support             - Jim Ablett [06-07-08]
// New values fron Jens added to Dabbaba.ini
//
// Added quiet position/ply depth to 
// Dabbaba.ini & set hash tables to off by
// default.                                    - Jim Ablett [15-07-08]
//
// knowledge about possible pins
// get pieces near enemy king
// Q-near changed to P-near...
// queen-near changed to pieces-near (also in dabbaba.ini)
// set magic_number via dabbaba.ini
// simple timedisposition 
// - also a fischerclock
// All major changes marked with "jn116"       - Jens B N   [16-07-08]
// 
// Adjusted some values                        - Jens B N   [17-07-08]
//
// Cleaned up pv output                        - Jim Ablett [18-07-08]
//
// Time control adjustment & pv output changes - Jim Ablett [19-07-08]
//
// Fixed time problem with ponder on.          
// Ponder is deactivated in program but was 
// still affecting time with ponder=on.
// Jen's new fischer time incorporated into
// wb level command                            
// Added new option to Dabbaba.ini to adjust
// time usage                                  - Jim Ablett [27-07-08]
// 
// Adjusted some values in the evaluation     
// New rules for connected rooks
// Last pawn important if you are a piece behind
// More search with passed pawns
//                                             - Jens B N   [28-07-08]
//
// Added Shatranj variant support              - Jim Ablett [04-08-08]
//
// Time control fix                            - Jim Ablett [05-08-08]
//
// Evaluation bugfix                           - Jens B N   [06-08-08]
//
// Time fix                                    - Jim Ablett [06-08-08]
//
// Changes to Shatranj evaluation            
// More time management adjustments            - Jim Ablett [07-08-08]
//
// Removed some noise in the evaluation        - Jens B N   [09-08-08]
//
// Removed a serious error:
//       passed pawns were only seldom evaluated!!
// Move pawns ahead in the endgame
// Place rooks on the passed pawns files
// Jim has corrected the hash-tables           - Jens B N   [12-08-08]
//
// Fixed winboard setboard command. Fen/epds
// can now be loaded and played from that 
// position.                                   - Jim Ablett [15-08-08]
//
// King safety extra important with queens on 
// the board
// Diminishing bonus for several passed pawns
// Passed pawns lowered a bit in value
// Move the most advanced passed pawns first 
// reprogrammed king_centre
// corrected errors in king_centre and 
// king_corner
//                                             - Jens B N   [17-08-08]


#include "time.h"
#include "math.h"
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "ctype.h"
#include <conio.h>
#include <malloc.h>
#include <dos.h>
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <signal.h>
#include <ctype.h>
#include <errno.h>
#include <limits.h>
#include <sys/timeb.h>
#include <assert.h>
#include <stdarg.h>


#define a1 21
#define b1 22
#define c1 23
#define d1 24
#define e1 25
#define f1 26
#define g1 27
#define h1 28
#define a2 31
#define b2 32
#define c2 33
#define d2 34
#define e2 35
#define f2 36
#define g2 37
#define h2 38
#define a3 41
#define b3 42
#define c3 43
#define d3 44
#define e3 45
#define f3 46
#define g3 47
#define h3 48
#define a4 51
#define b4 52
#define c4 53
#define d4 54
#define e4 55
#define f4 56
#define g4 57
#define h4 58
#define a5 61
#define b5 62
#define c5 63
#define d5 64
#define e5 65
#define f5 66
#define g5 67
#define h5 68
#define a6 71
#define b6 72
#define c6 73
#define d6 74
#define e6 75
#define f6 76
#define g6 77
#define h6 78
#define a7 81
#define b7 82
#define c7 83
#define d7 84
#define e7 85
#define f7 86
#define g7 87
#define h7 88
#define a8 91
#define b8 92
#define c8 93
#define d8 94
#define e8 95
#define f8 96
#define g8 97
#define h8 98

#define equal ==
#define or ||
#define exor ^
#define and &&
#define false 0
#define true 1
#define no_good_found 22222

#define int_min -30000
#define int_max +30000

#define bool int
#define NO_COLOUR        (100)
#define RESIGNTHRESHOLD (1100)
#define INI_FILENAME "dabbaba.ini"

#define xisspace(c) isspace((int)(c)) 
#define xisalpha(c) isalpha((int)(c))

static int chancellor_variant    = 0;
static int archbishop_variant    = 0;
static int nightrider_variant    = 0;
static int knightwazir_variant   = 0;
static int knightferz_variant    = 0;
static int knightdabbaba_variant = 0;
static int knightalfil_variant   = 0;
static int knightmate_variant    = 0;
static int extinct_variant       = 0;
static int gridchess_variant     = 0;
static int rooksquare_variant    = 0;
static int pawnfreeze_variant    = 0;
static int shatranj_variant      = 0;
static int fischerandom_variant  = 0;

static int variant_knight_as_wazir   = 0;
static int variant_knight_as_ferz    = 0;
static int variant_knight_as_dabbaba = 0;
static int variant_knight_as_alfil   = 0;
static int variant_chancellor        = 0;
static int variant_archbishop        = 0;
static int variant_nightrider        = 0;
static int variant_knightmate        = 0;
static int variant_extinct           = 0;
static int variant_gridchess         = 0;
static int variant_rooksquare        = 0;
static int variant_pawnfreeze        = 0;
static int variant_shatranj          = 0;
static int variant_fischerandom      = 0;

static bool variant              = false;
static bool var_extinct          = false;      

static int pawn_value              =  100;
static int knight_value            =  300;
static int bishop_value            =  320;
static int rook_value              =  500;
static int queen_value             = 1200;

static int experiment_quiet        =   0;
static int depth_quiet             =   0;
static signed char last_iteration  =   4;
static signed char last_sel_ply    =   4;
static int check_search            =   0;
static int mate_search             =  10; 
static int iterativ                =   1;
static int always_cut              =   1;
static int s_kill                  =   3;
static int swhash                  =   1; 
static int it4_qdyn                =  50;
static int full_evalu              =   1; 
static int quiet_depth             =   1;
static int skift                   =   1; 
static int exchf                   =  20; 
static int bishoppair              =  40;  
static int king_centre             =   1;  
static int king_corner             =   1; 
static int P_near_enemy_K          =   1;
static int rook_placement          =   1;
static int wmobil                  =   8;
static int wcentr                  =   6;
static int wopen                   =  16;
static int wkingsaf                =  16;  
static int wrand                   =   0; 
static int wpawn                   =   4;
static int resign_on               =   1;
static int play_style              =   1;   // changed from 2 to 1 - jn2008
static int magic                   =   0;
static int time_adjust             =   0;
static int materiel_10_0           =   0;
static int first_pp_value          =   0; // value given for the first passed pawn 


static int quiet_experiment           =   0;
static int quiet_depth_ply            =   0;
static int pawn_piece_value           =   0;
static int knight_piece_value         =   0;
static int bishop_piece_value         =   0;
static int rook_piece_value           =   0;
static int queen_piece_value          =   0;
static int brute_force_depth          =   0;
static int selective_depth            =   0;
static int check_search_depth         =   0;
static int mate_search_depth          =   0;
static int iterativ_search            =   0;
static int always_cut_search          =   0;
static int simple_killers             =   0;
static int use_hashtables             =   0;
static int magic_number               =   0;
static int selektiv_search_dynamic    =   0;
static int full_evaluation            =   0;
static int check_quiet_position_depth =   0;
static int selektiv_search_initiative =   0;
static int exchange_factor            =   0;
static int bishop_pair                =   0;
static int king_in_centre             =   0;
static int king_in_corner             =   0;
static int pieces_near_enemy_king     =   0;
static int rooks_placement            =   0;
static int mobility_weight            =   0;
static int centre_weight              =   0;
static int open_weight                =   0;
static int king_safety_weight         =   0;
static int open_random_moves_weight   =   0;
static int pawn_structure_weight      =   0;
static int resign_in_lost_position    =   0;
static int adjust_time                =   0;


static bool xboard               = false;
static bool ponder_on            = false;
static bool show_pv              = false;
static bool force_mode           = false;
static bool draw_offer           = false;
static bool icc                  = false;
static bool normal_epd           = false;
static bool analyze_on           = false;
static bool pv_on                = true;
static bool bullet               = false;
static bool use_setboard         = false;
static int max_time              =  0;
static int max_moves             = 40;
static int inc_time              =  0;
static int best_depth            =  0;
static int max_depth             =  0;
static int resigncounter         =  0;
static int my_best_score         =  0;
static int solved                =  1;
static int unsolved              =  0;
static int unsolu                =  0;
static double scoresum           =  0;
static int move_count            =  0;
static int solu                  =  0;

// prototypes
static void turn_sqavoid_false();
static void calculate_secprmove();
static void make_only_attack();
static void ReadINIFile(char *filename);
static void press_any_key_to_continue();
static void read_hash(unsigned long int key);
static void write_hash(unsigned long int key);
static void calculate_hashkey();
static void sort_pili(signed char *pili);
static void zero_to_pili(signed char *pili, signed char man);
static void add_to_pili(signed char *pili, signed char *sq);
static void change_to_pili(signed char *pili, signed char *sqfr, signed char *sqto);
static void delete_from_pili(signed char *pili, signed char *sq);
static void add_error();
static void add_pili(signed char *sq, signed char *man);
static void change_pili(signed char *sqfr, signed char *sqto, signed char *man);
static void change_castle_pili(signed char sq1, signed char sq2, signed char man);
static void delete_pili(signed char *sq, signed char *man);
static void print_line();
static void undo_move();
static void make_move(signed char *fr, signed char *to, int hop_ud);
static void skipgarbage();
static void scanf_char(signed char *ch);
static void scanf_int(int *integer);
static void scanf_string();
static void p99_secsofar();
static void writesecsofar_gi();
static void writesecsofar();
static void is_castle_allowed();
static void print_line();
static void undo_move();
static void normal_chess();
static void shatranj_chess();
static void nightrider_chess();
static void extinct_chess();
static void stationary_chess();
static void knightmate_chess();
static void chancellor_chess();
static void archbishop_chess();
static void rooksquare_chess();
static void grid_chess();
static void pawnfreeze_chess();
static void knightwazir_chess();
static void knightferz_chess() ;
static void knightdabbaba_chess();
static void knightalfil_chess();
static void show_board();
static void sq120_to_koordinat(signed char *ch1, signed char *ch2, signed char *ch3);
static void p99_a1_h8(signed char *ch1);
static void print_a1_h8(signed char *ch1);
static void sprint_a1_h8(signed char *ch1);
static void pgn_a1_h8(signed char *ch1);
static void print_kqrbnp(signed char ch1);
static void change_black_white();
static void unpack_promotion(signed char *to, signed char *to_9_10_11,signed char *promote_piece);                                      
static void w_prevalue_moves();
static void b_prevalue_moves();
static void get_next_good_move();
static void generate_moves_2(signed char *gangart, signed char ch1);
static void pawnmove_into_array(signed char *ch1, signed char *ch2, signed char prom);
static void generate_pawn_moves(signed char ch1);
static void generate_moves();
static void clear_board();
static void make_move_array();
static void get_solution(signed char w3_char);
static void remove_move(int x);
static void set_pb_guessmove_last();
static void gen_moves_ply_zero();
static void initialize_best_score();
static void nulstil();
static void roll_entries();
static void store_hash_for_3xrepeat();
static void make_array_ply_zero();
static void print_pc_speed();
static void pc_speed();
static void p99_seconds_used();
static void show_seconds_used();
static void store_pb_pos();
static void new_game();
static void print_vurdering(int vu_rd);
static void line_with_numbers();
static void print_line() ;
static void init_bewertung(void);
static void init_hash();
static void check_insufmat();
static void is_w_piece_quiet(signed char piecesquare);
static void is_b_piece_quiet(signed char piecesquare);
static void make_move(signed char *zfr, signed char *zto, int hop_ud);
static void undo_move();
static void print_best_move_ply_zero(int I_play);
static void opdat_hash(signed char fr, signed char to, signed int score);
static void new_best_move();
static void minimax();
static void gem_simple_kill(signed char *m_fr, signed char *m_to);
static void cut_off();
static void evt_cut_off();
static void everplay_setup();
static void add_movetime(double movetime, signed char no_nodes, double oppotid,double opponodes);
static void pb_undo_move_until_root();
static void computer();
static void mainline_move(signed char fr, signed char to, signed char maliout);
static void mainline(signed char maliout);
static void print_move();
static void computer_x();
static void calculate_secprmove();
static void make_display();
static void computer_and_display();
static void menu_diverse();
static void loaded_pos();
static void menu_positions();
static void winboard_analyze();
static void testfil();
static void make_real_move();
static void remove_evt_pseudomoves();
static void end_selfplay_game();
static void turn_gamesaving_on();
static void helpmenu();
static void ponder_move();
static void play_a_game();
static void main_menu();


static int KeyNum(char *key);
static int SetINIKey(char *key, char *buffer, bool default_val);
static int bioskey(void);
static int bw_index(signed char sqman);
static int everplay_and_black();
static int timepctmovesofar();
static int count_black_8_row();
static int find_move_index(signed char *fr, signed char *to);
static int square_colour(signed char *sq);
static int pre_val(int x);
static int discovered_check(signed char *fr, signed char *to, signed char *sq_k);
static int is_move_a_check(signed char *fr, signed char *to);
static int is_move_a_sel_move(signed char *fr, signed char *to);
static int sel_move(signed char *ch1, signed char *ch2);
static int pawncovered(signed char x);
static int sbauerbewertung(int feld,int reihe, int linie);
static int wbauerbewertung(int feld,int reihe, int linie);
static int how_open(signed char *rooksq);
static int bewerte_stellung();
static int opening();
static int king_safety();
static int repeat3x_draw();
static int all_pawns_on_kingfile(signed char *pilipawn, signed char kinglin);
static int bishops_on_diff_sq_colour(signed char *pilibishop);
static int dead_draw();
static int b_king_near_corner(signed char sqk, signed char *k_corner);
static int w_king_near_corner(signed char sqk, signed char *k_corner);
static int probably_draw();
static int vurdering();
static long unsigned int find_hash_id(signed int x);
static long unsigned int find_hash_idx(signed int x);
static int rooksquare_mate();
static int extinct_mate();
static int repeat_position();
static int mate_found();
static int game_evt_draw();
static int play_early_game_fast();
static int game_over();

static signed char msmoves();
static signed char quiet_position();
static signed char pb_move_guessed();
double henttid();



#ifdef _MSC_VER
#define inline
#else
#define CDECL
#endif

#define     VERSION         "1.29 JA"
#define     BUILDDATE       "19-08-08"

static void CDECL catch_sigint(int s);

static void     CDECL
                catch_sigint(int s)
{
    signal(s, catch_sigint);
}



// ***** start of dabbaba.ini *****

#define NUM_KEYS 200

char iniKeys[NUM_KEYS][150] = {
"variant_nightrider","variant_knightmate","variant_chancellor","variant_archbishop",
"variant_knight_as_wazir","variant_knight_as_ferz","variant_knight_as_dabbaba",
"variant_knight_as_alfil", "variant_extinct","variant_gridchess","variant_rooksquare",
"variant_pawnfreeze","variant_shatranj","variant_fischerandom",

"quiet_experiment","depth_quiet","pawn_piece_value","knight_piece_value","bishop_piece_value",
"rook_piece_value","queen_piece_value", "brute_force_depth","selective_depth","check_search_depth",
"mate_search_depth","iterativ_search","always_cut_search","simple_killers","use_hashtables", "magic_number",
"selektiv_search_dynamic","full_evaluation", "selektiv_search_initiative","exchange_factor",
"bishop_pair","king_in_centre", "king_in_corner","pieces_near_enemy_king","rooks_placement","mobility_weight",
"centre_weight","open_weight","king_safety_weight","open_random_moves_weight",
"pawn_structure_weight","resign_in_lost_position","adjust_time"


};

void ReadINIFile(char *filename)
{
FILE *in;
bool foundKey[NUM_KEYS];
char buffer[4000];
char key[120];
int c,i;

memset(foundKey,false, sizeof(bool)*NUM_KEYS);
memset(buffer,0,sizeof(char) * 4000);

in = fopen(filename, "r");
if(in == NULL) {
printf("\nNo %s file found - setting internal default values.\n\n", filename);
for(i = 0; i < NUM_KEYS; i++) {
}
return;
} else {
printf("\n%s found. Loading values....   \n\n", filename);	
}

for(;;) {
c = fgetc(in);
if(c == '*') {
fscanf(in, "%s %s", key, buffer);
if((i = KeyNum(key)) >= 0) { // test that key is legit
SetINIKey(key, buffer, false);
foundKey[i] = true;
memset(buffer,0,sizeof(char) * 4000);
}
}
if(c == EOF)  {
printf("\ndone. \n\n");	
break;
}
}

//	 Find all keys whose values were no explicitely set in the ini file and set them to the default
for(i = 0; i < NUM_KEYS; i++) {
if(foundKey[i] == false) SetINIKey(iniKeys[i], NULL, true);
}
fclose(in);	
}

int KeyNum(char *key) {
int i;
for(i = 0; i < NUM_KEYS; i++) {
if(!strcmp(key, (char *)iniKeys[i])) return i;
}
return -1;
}

//***** set values from dabbaba.ini ******
int SetINIKey(char *key, char *buffer, bool default_val)
{

if (!strcmp(key, "variant_nightrider")) {
		nightrider_variant = atoi(buffer);
        if (nightrider_variant) {
        variant = true;                    
        printf("\nvariant 'nightrider' selected\n");
        }}
if (!strcmp(key, "variant_knightmate")) {
		knightmate_variant = atoi(buffer);
        if (knightmate_variant) { 
        variant = true;              
        printf("\nvariant 'knightmate' selected\n");
        }} 
        
if (!strcmp(key, "variant_chancellor")) {
		chancellor_variant = atoi(buffer);
        if (chancellor_variant) { 
        variant = true;              
        printf("\nvariant 'chancellor' selected\n");
        }}  
        
if (!strcmp(key, "variant_archbishop")) {
		archbishop_variant = atoi(buffer);
        if (archbishop_variant) { 
        variant = true;              
        printf("\nvariant 'archbishop' selected\n");
        }}                                                    
		
if (!strcmp(key, "variant_knight_as_wazir")) {
		knightwazir_variant = atoi(buffer);
        if (knightwazir_variant) { 
        variant = true;              
        printf("\nvariant 'knightwazir' selected\n");
        }}
        
if (!strcmp(key, "variant_knight_as_ferz")) {
		knightferz_variant = atoi(buffer);
        if (knightferz_variant) { 
        variant = true;              
        printf("\nvariant 'knightferz' selected\n");
        }}                        
        
if (!strcmp(key, "variant_knight_as_dabbaba")) {
		knightdabbaba_variant = atoi(buffer);
        if (knightdabbaba_variant) { 
        variant = true;              
        printf("\nvariant 'knightdabbaba' selected\n");
        }}  
        
if (!strcmp(key, "variant_knight_as_alfil")) {
		knightalfil_variant = atoi(buffer);
        if (knightalfil_variant) { 
        variant = true;              
        printf("\nvariant 'knightalfil' selected\n");
        }}
      
if (!strcmp(key, "variant_extinct")) {          // not working correctly under Winboard-F (mate result) - JA
		extinct_variant = atoi(buffer);
        if (extinct_variant) { 
        variant = true;              
        printf("\nvariant 'extinct' selected\n");
        }}            

if (!strcmp(key, "variant_gridchess")) {
		gridchess_variant = atoi(buffer);
        if (gridchess_variant) { 
        variant = true;              
        printf("\nvariant 'gridchess' selected\n");
        }}

if (!strcmp(key, "variant_rooksquare")) {
		rooksquare_variant = atoi(buffer);
        if (rooksquare_variant) { 
        variant = true;              
        printf("\nvariant 'rooksquare' selected\n");
        }}

if (!strcmp(key, "variant_pawnfreeze")) {
		rooksquare_variant = atoi(buffer);
        if (pawnfreeze_variant) { 
        variant = true;              
        printf("\nvariant 'pawnfreeze' selected\n");
        }}
       
if (!strcmp(key, "variant_shatranj")) {
		shatranj_variant = atoi(buffer);
        if (shatranj_variant) { 
        variant = true;              
        printf("\nvariant 'shatranj' selected\n");
        }}       
       
       
 if (!strcmp(key, "variant_fischerandom")) {
		fischerandom_variant = atoi(buffer);
        if (fischerandom_variant) { 
        variant = true;              
        printf("\nvariant 'fischerandom' selected\n");
        }}             
  
  
        
if (!strcmp(key, "quiet_experiment")) {
	experiment_quiet = atoi(buffer);
    printf("quiet experiment             = ");
    if (experiment_quiet) printf("on\n");
    else
    printf("off\n"); 
    }
    
 if (!strcmp(key, "depth_quiet")) {
	quiet_depth_ply	        = atoi(buffer);
    if (quiet_depth_ply && experiment_quiet) {
    printf("quiet depth                  = %d\n", quiet_depth_ply);
    }}    	         	    								   
    		                                      

if (!strcmp(key, "pawn_piece_value")) {
	pawn_value	= atoi(buffer);
    printf("pawn piece value             = %d\n", pawn_value);
    }		
		
if (!strcmp(key, "knight_piece_value")) {
	knight_value	= atoi(buffer);
    printf("knight piece value           = %d\n", knight_value);
    }
    
if (!strcmp(key, "bishop_piece_value")) {
	bishop_value	= atoi(buffer);
    printf("bishop piece value           = %d\n", bishop_value);
    }		    	
    
if (!strcmp(key, "rook_piece_value")) {
	rook_value	= atoi(buffer);
    printf("rook piece value             = %d\n", rook_value);
    }		
    
if (!strcmp(key, "queen_piece_value")) {
	queen_value	= atoi(buffer);
    printf("queen piece value            = %d\n", queen_value);
    }		        	
		
if (!strcmp(key, "brute_force_depth")) {
	last_iteration	= atoi(buffer);
    printf("brute force depth            = %d", last_iteration);
    printf(" ply\n");
    }
if (!strcmp(key, "selective_depth")) {
	last_sel_ply	= atoi(buffer);
    printf("selective_depth              = %d", last_sel_ply);
    printf(" ply\n");
    }
if (!strcmp(key, "check_search_depth")) {
	check_search	= atoi(buffer);
    printf("check_search_depth           = %d", check_search);
    printf(" ply\n");
    }    		    		
if (!strcmp(key, "mate_search_depth")) {
	mate_search	    = atoi(buffer);
    printf("mate_search_depth            = %d", mate_search);
    printf(" ply\n");
    }  
if (!strcmp(key, "iterativ_search")) {
	iterativ	    = atoi(buffer);
    printf("iterativ_search              = ");
    if (iterativ) printf("on\n");
    else
    printf("off\n"); 
    }        	      			
if (!strcmp(key, "always_cut_search")) {
	always_cut   	= atoi(buffer);
    printf("always_cut_search            = ");
    if (!always_cut) {
    printf("no [only material]\n");
    }else
    if (always_cut) {
    printf("yes [always]\n");
}else{
    printf("auto\n");
}}  
if (!strcmp(key, "simple_killers")) {
	s_kill	        = atoi(buffer);
    printf("simple_killers               = ");
    if (s_kill == 1 || s_kill == 2){
    printf("%d",s_kill);
    printf(" [mate]\n");
    }else
    if (!s_kill) {
    printf("no\n");
    }else{
    printf("%d",s_kill);
    printf(" [advanced]\n");
    }}    	         	    		
if (!strcmp(key, "use_hashtables")) {                  
	swhash	        = atoi(buffer);
    printf("use_hashtables               = ");
    if (swhash) printf("yes\n");
    else
    printf("no\n");
    }   


// jn116

if (!strcmp(key, "magic_number")) {                  
	magic	        = atoi(buffer);
    printf("magic number                 = ");
    printf("%d\n",magic);
}

 	         	    				
if (!strcmp(key, "selektiv_search_dynamic")) {
	it4_qdyn	        = atoi(buffer);
    printf("selektiv search dynamic      = ");
    if (it4_qdyn == 50) {
    printf("normal\n");
    }else
    if (it4_qdyn == 100) {
    printf("off\n");         
    }else{
    printf("%d\n",it4_qdyn);
    }}   	         	    						
if (!strcmp(key, "full_evaluation")) {
	full_evalu	        = atoi(buffer);
    printf("full evaluation              = ");
    if (full_evalu) printf("yes\n");
    else
    printf("no/only material\n");
 
    }    	         	    								
				
if (!strcmp(key, "selektiv_search_initiative")) {
	skift	        = atoi(buffer);
    printf("selektiv search initiative   = ");
    if (skift) printf("yes\n");
    else
    printf("no\n");
    }    	         	    												
if (!strcmp(key, "exchange_factor")) {
	exchf	        = atoi(buffer);
	if (shatranj_variant) exchf = 50;
    printf("exchange factor              = %d\n", exchf);
    }    	         	    								
if (!strcmp(key, "bishop_pair")) {
	bishoppair	        = atoi(buffer);
	if (shatranj_variant) bishoppair = 10;
    printf("bishop pair                  = %d\n", bishoppair);
    }    	         	    								
if (!strcmp(key, "king_in_centre")) {
	king_centre	        = atoi(buffer);
    if (shatranj_variant) king_centre = 1;	
    printf("king in centre               = ");
    if (king_centre) printf("yes\n");
    else
    printf("no\n");
    }    	         	    								
if (!strcmp(key, "king_in_corner")) {
	king_corner	        = atoi(buffer);
	if (shatranj_variant) king_corner = 0;	
    printf("king in corner               = ");
    if (king_corner) printf("yes\n");
    else
    printf("no\n");
    }    	         	    								
if (!strcmp(key, "pieces_near_enemy_king")) {
	P_near_enemy_K	        = atoi(buffer);
    if (shatranj_variant) 	P_near_enemy_K = 0;
    printf("pieces near enemy king       = ");
    if (P_near_enemy_K) printf("yes\n");
    else
    printf("no\n");
    }    	         	    										
if (!strcmp(key, "rooks_placement")) {
	rook_placement	        = atoi(buffer);
	if (shatranj_variant) rook_placement = 0;
    printf("rooks placement              = ");
    if (rook_placement) printf("yes\n");
    else
    printf("no\n");
    }    	         	    										
if (!strcmp(key, "mobility_weight")) {
	wmobil	        = atoi(buffer);
	if (shatranj_variant) wmobil = 16;
    printf("mobility weight              = %d\n", wmobil);
    
    }    	         	    										
if (!strcmp(key, "centre_weight")) {
	wcentr	        = atoi(buffer);
    printf("centre weight                = %d\n", wcentr);
    }    	         	    								
if (!strcmp(key, "open_weight")) {
	wopen	        = atoi(buffer);
	if (shatranj_variant) wopen = 16;
    printf("open weight                  = %d\n", wopen);
    }    	         	    								
if (!strcmp(key, "king_safety_weight")) {
	wkingsaf	        = atoi(buffer);
    if (shatranj_variant) wkingsaf = 2;
    printf("king safety weight           = %d\n", wkingsaf);
    }    	         	    									
if (!strcmp(key, "open_random_moves_weight")) {
	wrand	        = atoi(buffer);
    if (variant) wrand = 16; // variants don't use book, so overide ini setting & randomize opening - JA 
    printf("open random moves weight     = %d", wrand);
    if (variant) printf(" [variant selected]\n");
    else
    printf("\n");
    }    	         	    									    	
if (!strcmp(key, "pawn_structure_weight")) {
	wpawn	        = atoi(buffer);
	if (shatranj_variant) wpawn = 16;
    printf("pawn structure weight        = %d\n", wpawn);
    }    	         	    									 
if (!strcmp(key, "resign_in_lost_position")) {
	resign_on	        = atoi(buffer);
    printf("resign in lost position      = ");
    if (resign_on) printf("yes\n");
    else
    printf("no\n");
    } 
  
if (!strcmp(key, "adjust_time")) {
	time_adjust	        = atoi(buffer);
    printf("adjust time value            = %d\n", time_adjust);
    }    	         	    									 										         	    									


return 0;
}

//***** end of dabbaba.ini  ****************




/*----------------------------------------------------------------------+
 |      simple random generator                                         |
 +----------------------------------------------------------------------*/

static long rnd_seed = 1;

static long random(void)
{
        long r = rnd_seed;

        r = 16807 * (r % 127773L) - 2836 * (r / 127773L);
        if (r < 0) r += 0x7fffffffL;

        return rnd_seed = r;
}

#define randomize random


/*
  From Beowulf, from Olithink
*/

int bioskey(void)
{
    static int      init = 0,
                    pipe;
    static HANDLE   inh;
    DWORD           dw;
    /* If we're running under XBoard then we can't use _kbhit() as the input
     * commands are sent to us directly over the internal pipe */

#if defined(FILE_CNT)
    if (stdin->_cnt > 0)
        return stdin->_cnt;
#endif
    if (!init) {
        init = 1;
        inh = GetStdHandle(STD_INPUT_HANDLE);
        pipe = !GetConsoleMode(inh, &dw);
        if (!pipe) {
            SetConsoleMode(inh, dw & ~(ENABLE_MOUSE_INPUT | ENABLE_WINDOW_INPUT));
            FlushConsoleInputBuffer(inh);
        }
    }
    if (pipe) {
        if (!PeekNamedPipe(inh, NULL, 0, NULL, &dw, NULL))
            return 1;
        return dw;
    } else {
        GetNumberOfConsoleInputEvents(inh, &dw);
        return dw <= 1 ? 0 : dw;
    }
}

void press_any_key_to_continue()
{
  int dum;
  printf("\n");
  printf("\n Press any key to continue...\n");
  dum = getch(); ++dum;
}



int mate_ply; // used for taking an extra iteration when a mate is found
              // hoping to see a shorter mate and get the game finished...
int save_games=false; // skal filen games.txt dannes
char p99[99]; // tekster editeres over i dette felt og udskrives
int board_x,  board_y=10;    // brttets verste venstre hjrne ('nordvest')
int square_x, square_y;
char ch, nr[2];
int xi, yi, r;
// bruges i computer-and-display og computer-x().....
int gem_full_evalu;
int q_test, keyboard_stop, time_stop;
int it_out, move_out; /* udskriv hvor dyb en sgning der blev lavet */
int noprint=false;
int evermoves_160=160;
int mpc=0; //move-ply-count
double mslim[5];      /* mate-search limits (mslim[0] is last ply)*/

signed char wbauern[10];  /* Anzahl der weisse Bauern auf einer Linie */
signed char wtuerme[10];  /* Anzahl der weisse Tuerme auf einer Linie */
signed char sbauern[10];  /* Anzahl der schwarze Bauern auf einer Linie */
signed char stuerme[10];  /* Anzahl der schwarze Tuerme auf einer Linie */
int limitpawnscore, pawninfo=false;
double pawnexceed=0, totalexcd=0;
int speedfactor; // is 10 on a 50 mhz 486
double pctid;
double startmovetime;
int tpct_it_zero; // how many pct of the time was spent in the matesearch

signed char chess_variant;
#define normal 0
#define stationary 1
#define knightmate 2
#define q_is_rn 3
#define q_is_bn 4
#define nightrider 5
#define knightwazir 6
#define knightferz 7
#define knightdabbaba 8
#define knightalfil 9
#define gridchess 11
#define pawnfreeze 1
#define more_goals 50
#define rooksquare 51
#define extinct 52
#define shatranj 12
#define fischerandom 13


#define stop 111   /* denne bruges ogs som stopklods i move_fr-array  */
#define one_step 1
#define more_steps 7

char men_letter[9]       ={'P', ' ', ' ', 'N', 'B', 'R', 'Q',   'K', '\0'};
int  nc_men_value[8]     ={0,    0,  100, 300, 305, 490, 1000, 6666}; 

signed char nc_king[20]  ={one_step,   -1,  9, 10,  11, 1,  -9, -10, -11, stop };
signed char nc_queen[20] ={more_steps, -1,  9, 10,  11, 1,  -9, -10, -11, stop};
signed char nc_rook[20]   ={more_steps, -1, 10,  1, -10, stop};
signed char nc_bishop[20] ={more_steps,  9, 11, -9, -11, stop};
signed char nc_knight[20]={one_step,    8, 19, 21,  12, -8, -19, -21, -12, stop};

signed char wazir[5]    ={  -1, +10,  +1, -10, stop};
signed char ferz[5]     ={  -9, +11,  +9, -11, stop};
signed char dabbaba[5]  ={  -2, +20,  +2, -20, stop};
signed char alfil[5]    ={ -18, +11, +18, -11, stop};   // seems to work ok - JA
//signed char alfil[5]   ={ -18, +22, +18, -22, stop};  // original causes buffer overflow - JA
signed char shatranj_ferz[6] ={one_step,  -9, +11,  +9, -11, stop};
signed char shatranj_alfil[6] ={one_step, -18, +22, +18, -22, stop};


int men_value[8]       = {0,    0,  100, 300, 305, 490, 1000, 6666};  // normal chess

signed char king[20];
signed char queen[20];
signed char rook[20];
signed char bishop[20];
signed char knight[20];


signed char *gangart; /* bruges som pointer i ovenstende 5 arrays */

signed char gen_moves_mode;
#define move_and_attack 2
#define only_attack 1


signed char status, normal_game=0, monitor=1, autoplay=2, self_play=3,
            everplay=4;
signed char gameplay_info=false;

char *arr1;                 // frste prve p hashtables...
signed char w_antselply=0;
signed char ant_sel_ply;    /* antal selektive ply i en iteration.   */
signed char first_sel_ply;  /* tidligst mulige selektive ply         */
signed char sel_ply_now;    /* true/false: er dette ply selektivt    */
signed char iteration;      /* dybde igangvrende iteration          */
signed char sgn_wh_bl;      /* 1/-1. 1 if white when ply==iteration  */
signed char only_recapture; /* skal kun generobringer prves         */
int         always;         /* +1 = ja, 0 = nej                      */
int         gem_check_search; /* depth in ply                        */
int         qdynamic;       /* grnse for udlsning af quiet move... */
int         filtrace;       /* true/false                            */
int         gameplay=false; /* true/false                            */
int         dummy_search=false; // to avoid best-move-so-far in dummy-search
int         info_out=1;     /* +1 = vis informationer p skrmen     */
int         black_8;      /* antal originale sorte brikker p 8. rkke  */
int         matesearch_score, matelvl_score;
signed char matelvl_stop=true;
int         maxpawn=0;
int         vu;
int         whole_menu=false;
signed char intern_a=32;
signed char intern_b=64;
signed char intern;
signed char intern_c=7;
signed char intern_d=15;

const signed char grid[h8+1] = {
/**    A   B   C   D   E   F   G   H     **/
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  1,  1,  2,  2,  3,  3,  4,  4,  0,   /* A1 ... H1 */
   0,  1,  1,  2,  2,  3,  3,  4,  4,  0,   /* A2 ... H2 */
   0,  5,  5,  6,  6,  7,  7,  8,  8,  0,   /* A3 ... H3 */
   0,  5,  5,  6,  6,  7,  7,  8,  8,  0,   /* A4 ... H4 */
   0,  9,  9, 10, 10, 11, 11, 12, 12,  0,   /* A5 ... H5 */
   0,  9,  9, 10, 10, 11, 11, 12, 12,  0,   /* A6 ... H6 */
   0, 13, 13, 14, 14, 15, 15, 16, 16,  0,   /* A7 ... H7 */
   0, 13, 13, 14, 14, 15, 15, 16, 16};      /* A8 ... H8 */

const int centrum[h8+1] = {
/**    A   B   C   D   E   F   G   H     **/
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  4,  0,  8, 12, 12,  8,  0,  4,  0,   /* A1 ... H1 */
   0,  4,  8, 12, 16, 16, 12,  8,  4,  0,   /* A2 ... H2 */
   0,  8, 12, 16, 20, 20, 16, 12,  8,  0,   /* A3 ... H3 */
   0, 12, 16, 20, 24, 24, 20, 16, 12,  0,   /* A4 ... H4 */
   0, 12, 16, 20, 24, 24, 20, 16, 12,  0,   /* A5 ... H5 */
   0,  8, 12, 16, 20, 20, 16, 12,  8,  0,   /* A6 ... H6 */
   0,  4,  8, 12, 16, 16, 12,  8,  4,  0,   /* A7 ... H7 */
   0,  4,  0,  8, 12, 12,  8,  0,  4};      /* A8 ... H8 */



signed char attack_w_min[h8+2]; /* mindste hvide brik der truer et felt */
signed char attack_b_min[h8+2]; /* mindste sorte brik der truer et felt */
signed char attack_w_nul[h8+2]; /* nulstiller attack_w_min              */
signed char attack_b_nul[h8+2]; /* nulstiller attack_b_min              */

signed char tablin[h8+1];       /* table of lines e7=5; b4=2 etc.       */
signed char tabrow[h8+1];       /* table of rows  e7=7; b4=4 etc.       */

char xxx[162*2];               /* her lses den stilling, der startes med */
char gem_xxx[162*2];
signed char ply, ply_1;      /* ply, ply minus en, ply minus to */

signed char wh_bl;
#define white 1
#define black -1


signed char sq[120+78];     // her er skakbrttet som 10xi2 + pb_pos
signed char *sq_idx, *sq_idx2;  /* disse pointere bruges p skakbrttet */
/* brttes felter (sq) kan indeholde disse vrdier:   */
#define w_p 2    /* white pawn o.s.v.                 */
#define w_n 3
#define w_b 4
#define w_r 5
#define w_q 6
#define w_k 7
#define b_p -2
#define b_n -3
#define b_b -4
#define b_r -5
#define b_q -6
#define b_k -7
#define sq_empty -1
#define sq_illegal 1 /* udenfor 8x8 brttet */
/* >=w_p er en hvid brik; <=b_p er en sort brik */


#define prom_q_9  111  /* ved bondeforvandling indeholder til-feltet en */
#define prom_r_9  112  /* af disse vrdier.                             */
#define prom_b_9  113  /* Forvandling er til q,r,b,n, og det sker p    */
#define prom_n_9  114  /* feltet = fra-felt + 9/10/11.                  */
#define prom_q_10 116  /* (For sort trkker man 9/10/11 fra)            */
#define prom_r_10 117
#define prom_b_10 118
#define prom_n_10 119
#define prom_q_11 121
#define prom_r_11 122
#define prom_b_11 123
#define prom_n_11 124

#define ANTSELPLY 2
#define DRAWPLY 3

#define max_ply 32
#define m_ply max_ply+4
// normalt kun +1.......

#define opening_limit 2


#define allowed 1
#define not_allowed 0

typedef struct
{signed char fr;
 signed char to;
} move;
move wmove;

typedef char *string_t;
signed char quiet; // is a position quiet? true or false.

//#define GAME_MAXINDEX 102*1000*3 // was 102
#define GAME_MAXINDEX 102
unsigned long int game_id [GAME_MAXINDEX+1];
unsigned long int game_idx[GAME_MAXINDEX+1];
int game_pointer=-1;

typedef struct
{unsigned long int hash_id;
 unsigned long int hash_idx;
 signed char       hash_fr;
 signed char       hash_to;
 signed int        hash_score;   // 30222==none
 signed char       hash_score_final; // true or false
 signed char       hash_depth;
 signed char       hash_ply;
 unsigned char     hash_mpc;
} hash_struct;


//hash_struct compa[256*1000*3];  
hash_struct compa[256];  
hash_struct hash;
int hashint[8];

char far *farp;
int far *wfarp;
int swnullmove=1;
unsigned long int uli_id, uli_idx, uli_id_index, hz, uli_sletigen;
unsigned long int hash_maxindex=2048*100, hash_totbytes, uli_sletigenx;

unsigned long int randi_id [h8+1][12];
unsigned long int randi_idx[h8+1][12];

signed char plydyb; 
signed char happens[20]={' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
                         ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', '\0'};
// check if some events happens...

typedef struct
{signed char w_o_o;
 signed char b_o_o;
 signed char w_o_o_o;
 signed char b_o_o_o;
 signed char e_p;                     /* indeholder not-allowed eller a6
                                         hvis der fx lige er spillet a7a5 */
 signed char pawnchange;              // pawns/rooks moved/captured--> true
 signed char  draw50;                 // antal spillede trk uden slag eller bondetrk
 unsigned long int hash_idx;
 unsigned long int hash_id;
 signed char swnullhash;
} pp;

pp p[m_ply];

signed char w_0_0          [max_ply]; /* rokaderne (not_)allowed          */
signed char w_0_0_0        [max_ply];
signed char b_0_0          [max_ply];
signed char b_0_0_0        [max_ply];
signed char e_p            [max_ply]; /* indeholder not-allowed eller a6
                                         hvis der fx lige er spillet a7a5 */


signed char ms_fr, matelvl_fr;
signed char ms_to, matelvl_to;


#define max_moves_in_table 90
signed char sel_delay      [m_ply]; /*"tller forcerede ting i x-dele"*/
signed char
     first_dynamic_sel_ply [m_ply]; /* i hvilket ply starter sel. search */
signed char sel_side       [m_ply]; /* white/black. hvem krer sel. search?*/
signed char nullmove       [m_ply]; //
signed char nullmovesq=a1;
signed char last_ply;               /* hvor dybt i ply gr vi maksimalt ned?*/
signed char king_in_check  [m_ply]; /* er kongen i skak? true/false */
signed char best_move_fr   [m_ply];
signed char best_move_to   [m_ply];

int most_recent_best_score;         // --------------------------------

int gem_sel_vurd           [m_ply]; // gem selektiv vurdering
static int best_score      [m_ply]; // bruges i mini-max
int mms                    [m_ply]; // rigtig mini-max score....
int start_best_score       [m_ply]; /* nulstiller best_score           */
int mate_score             [m_ply];

int w_materiel             [m_ply]; /* hvids materiel udover kongen    */
int b_materiel             [m_ply]; /* sorts materiel udover kongen    */
int centre                 [m_ply]; /* acc. centralisering             */
signed char mobilitet      [m_ply]; /* udfyldes nr trkkene er dannet */
char realmoves             [m_ply]; /* mobilitet minus pseudomoves     */
double mate_sch_pos        [m_ply]; /* mate search positions left      */
int random_move;                    /* random moves in the opening     */

signed char move_fr_before [m_ply]; /* indholdet af from- og to-feltet */
signed char move_to_before [m_ply]; /* inden trkket blev udfrt       */

signed char prt_fr [m_ply];         /* traekket i forrige udsk. variant*/
signed char prt_to [m_ply];         /* traekket i forrige udsk. variant*/
signed char full_line;              /* styrer fuld/blank linie         */

signed char move_pointer   [m_ply]; /* peger p nste trk */
signed char move_point; /* arbejdsindeks nr der arbejdes i trktabellen         */

signed char move_fr        [m_ply][max_moves_in_table];
signed char move_to        [m_ply][max_moves_in_table];
int  move_value            [m_ply][max_moves_in_table];
int  oldpre_value          [m_ply][max_moves_in_table];

/************** counters ******************/
double tv_nodes, tv_pseudo_moves, tv_cutoff, tv_printline, tv_last_ply;
double tv_error, filtrc_error, tv_pat, tv_repeat, tv_allnodes=0;
double tv_sessionmoves=0, tv_sessionmovetime=0;
double tv_hash_read, tv_hash_read_ok, tv_hash_read_ok_final, tv_hash_nofinal;
double tv_hash_hit;
double tv_hash_skriv, tv_hash_opdat, tv_hash_ejskriv, tv_hash_error;
int tv_non_sel_move;
double w_ever, b_ever;
// double vurd_node;   int gem_vurd;

double maxmovetime=0;             // max time for a move in the session
double wtid, btid;                // time in 1/100 sec used by w and b
double msmax;                     // max number of nodes in matesearch

int Fischerstartmin=0;            // Fischerclock - start with x minutes
int Fischersecmove=0;             // Fischerclock - add x seconds pr move
int gameinxmin=5;                 // zero or = minutes for the game
int moves_inxmin=0;               // used for x moves
int min_forxmoves=0;              //                  in y minutes

int secprmove=0;
int mateinx=0;                    // used for the mate-level
int startmateriel;                // sum of materiel - 2*K in startposition
int draw_score=0;

//****************** permanent brain ***********************
signed char pb_move_ready=false;
signed char pb_move_fr;
signed char pb_move_to;
signed char pb_on=false;
signed char pb_time_used=false;
signed char pb_sw_move_received=false;
signed char pb_sw_move_guessed=false;
double      pb_opponents_time, pb_oppo_nodes;
unsigned long int pb_count_bioskey;
unsigned long int pb_count_limit;
signed char pb_tv_1_4=0;
signed char pb_move_received[20];

#define MSPCT 20 
// max 20% of the time should be used in the matesearch
double check_time_at_nodes;       // when to do extra timecontrol
char mark_nodesstop;              // # indicates a brutal stop

// disse felter bruges til at danne legale trk nr man er i skak
signed char sq_avoid_check[h8+1]; /* true/false - hvilke felter skal man
                                     flytte til for at parere skakken */
signed char sq_checking_man;      // hvor str den skakgivende brik //
signed char checking_direction1;  /* skakgivende retning mod kongen / nul */
signed char checking_direction2;  /* ved dobbeltskakker den anden retning */
signed char sq_checked_king;      /* hvor er den truede konge             */

int w_insufmat, b_insufmat;
int trace=-30000;
FILE *fp;
FILE *gi;                         // used for gameinfo.trc
FILE *pgn;                        // used for games.txt

#define normal_move  0
signed char make2_move_status=normal_move;
#define pseudo_move  1
signed char make_move_status=normal_move;
#define make_cut_off 2
#define score_is_found 3

signed char simple_kill1_fr        [m_ply]; /* pr. ply gemmes trk, der */
signed char simple_kill1_to        [m_ply]; /* bevirker cut-off.        */
int         tv_s_kill1             [m_ply];
int         simple_kill1_vu        [m_ply]; /* hvor gode var killerne?  */
int         s_kill1_oldpre         [m_ply]; /* killerens oprindelige preval*/

signed char simple_kill2_fr        [m_ply]; /* i prevalue sttes de     */
signed char simple_kill2_to        [m_ply]; /* foran andre trk.        */
int         tv_s_kill2             [m_ply];
int         simple_kill2_vu        [m_ply]; /* hvor gode var killerne?  */
int         s_kill2_oldpre         [m_ply]; /* killerens oprindelige preval*/



/* Best-Move-And-Score-So-Far */
/*    i den frste iteration eller to puttes kun data i indeks [0], da det
      er uinteressant at det bedste trk skifter mange gange her...
      Vha disse data kan man kalde frem, hvad programmet kom frem til under
      sine beregninger...
      De kan ogs bruges til Kaufman's 1-time test, hvor han giver point
      hvis programmet har fundet det rigtige efter 30, 60, 90 og 120 sekunder.
      (0 til 4 point pr. testposition)
      */
#define bmassf_max 10

/* ved test af stillinger skal man finde (evt. undg) dette trk */
signed char solution_fr;
signed char solution_to; /* forvandling kan ikke umiddelbart klares endnu */
signed char solution_mark; /* indeholder ! eller ? - find/undg dette trk */
signed char run_test=false; /* indeholder true eller false. Krer vi test?  */
signed char solution_xxx[61];
signed char filnavn[200];
double tid, timemovestart;
int disctrace=false;
int exitsolfound=false;

signed char piliwq[13], piliwr[13], piliwb[13], piliwn[13], piliwp[13], sqwk;
signed char pilibq[13], pilibr[13], pilibb[13], pilibn[13], pilibp[13], sqbk;


int two_kings;           // value of two kings




int bw_index(signed char sqman)
{ if (sqman>w_k or sqman <b_k)
printf("\a");

  if (sqman>b_p and sqman <w_p)
  printf("\a");


  if (sqman<=b_p) return (int)(7+sqman);
  else            return (int)(4+sqman);
}



void read_hash(unsigned long int key)
{  

hash=compa[key];

     {for (hz=0; hz<=7; ++hz) *(hashint+hz)=*(farp+key*8+hz);
      memcpy(&hash, hashint, 16);

     }
}

void write_hash(unsigned long int key)
{   

     compa[key]=hash;
     {memcpy(hashint, &hash, 16);
      for (hz=0; hz<=7; ++hz) *(farp+key*8+hz)=*(hashint+hz);

     }
}

void calculate_hashkey()
{ int x;                    uli_id=uli_idx=0;
  for (x=a1; x<=h8; ++x)
    {if (sq[x]>=w_p or sq[x]<=b_p)
      {uli_idx=uli_idx exor randi_idx[x][bw_index(sq[x])];
       uli_id =uli_id  exor randi_id [x][bw_index(sq[x])];}
    }
  if (wh_bl equal black) {uli_idx=uli_idx exor randi_idx[0][0];
                          uli_id =uli_id  exor randi_id [0][0];}


  if (p[ply].e_p!=not_allowed)
     {uli_idx=uli_idx exor randi_idx[0][1];
      uli_id =uli_id  exor randi_id [0][1];}
}

void sort_pili(signed char *pili)
// makes search in testpositions and gameplay identical...
{signed char x, y, z,           *p, *q;
 for (x=0; x<=8; ++x)
  {for (y=0, p=pili; y<=8; ++y)
    {q=p+1;
     if (*p<*q) {z=*q; *q=*p; *p=z;};
     ++p;
    }
  }
}

void zero_to_pili(signed char *pili, signed char man)
{signed char x, *p; p=pili;
 for (x=0; x<=11; ++x) {*p=0; ++p;}
 *p=man;
}

void add_to_pili(signed char *pili, signed char *sq)
{*(pili+*(pili+11))=*sq; ++*(pili+11);}  // in one statement....!?

void change_to_pili(signed char *pili, signed char *sqfr, signed char *sqto)
{signed char *p; p=pili;
 loop: if (*p!=*sqfr) {++p; goto loop;} // ++p in the if-statement....!?
       *p=*sqto;
}

void delete_from_pili(signed char *pili, signed char *sq)
{signed char *p; p=pili;
 loop: if (*p!=*sq) {++p; goto loop;} // ++p in the if-statement....!?
       if   (*(p+1) equal 0) {*p=0; --*(pili+11);}
       else {--*(pili+11); *p=*(pili+*(pili+11)); *(pili+*(pili+11))=0;}
}

void add_error()
{  ++tv_error; ++filtrc_error; printf(" ******* error ******* "); }

int everplay_and_black()
{   if (status != everplay or intern equal white) return false;
    else                                          return true;}

void add_pili(signed char *sq, signed char *man)
{  if (*man>=w_p)
      {     if (*man equal w_p) add_to_pili(piliwp, sq);
       else if (*man equal w_n) add_to_pili(piliwn, sq);
       else if (*man equal w_b) add_to_pili(piliwb, sq);
       else if (*man equal w_r) add_to_pili(piliwr, sq);
       else                     add_to_pili(piliwq, sq);
      }
   else
      {     if (*man equal b_p) add_to_pili(pilibp, sq);
       else if (*man equal b_n) add_to_pili(pilibn, sq);
       else if (*man equal b_b) add_to_pili(pilibb, sq);
       else if (*man equal b_r) add_to_pili(pilibr, sq);
       else                     add_to_pili(pilibq, sq);
      }
}

void change_pili(signed char *sqfr, signed char *sqto, signed char *man)
{

   if (*man>=w_p)
      {     if (*man equal w_p) change_to_pili(piliwp, sqfr, sqto);
       else if (*man equal w_k) sqwk=*sqto;
       else if (*man equal w_n) change_to_pili(piliwn, sqfr, sqto);
       else if (*man equal w_b) change_to_pili(piliwb, sqfr, sqto);
       else if (*man equal w_r) change_to_pili(piliwr, sqfr, sqto);
       else                     change_to_pili(piliwq, sqfr, sqto);
      }
   else
      {     if (*man equal b_p) change_to_pili(pilibp, sqfr, sqto);
       else if (*man equal b_k) sqbk=*sqto;
       else if (*man equal b_n) change_to_pili(pilibn, sqfr, sqto);
       else if (*man equal b_b) change_to_pili(pilibb, sqfr, sqto);
       else if (*man equal b_r) change_to_pili(pilibr, sqfr, sqto);
       else                     change_to_pili(pilibq, sqfr, sqto);
      }
}

void change_castle_pili(signed char sq1, signed char sq2, signed char man){
     
 
//frc-jn - don't know what this is...........                               
 
   if (sq1==h1 or sq1==h8 or sq1==a1 or sq1==a8) { // make-move; not undo-move
              
    uli_sletigenx=uli_sletigenx exor randi_idx[sq1][bw_index(man)];
    uli_sletigen =uli_sletigen  exor randi_id [sq1][bw_index(man)];
    uli_sletigenx=uli_sletigenx exor randi_idx[sq2][bw_index(man)];
    uli_sletigen =uli_sletigen  exor randi_id [sq2][bw_index(man)];
   } 


           
 change_pili(&sq1, &sq2, &man);

}

void delete_pili(signed char *sq, signed char *man)
{  if (*man>=w_p)
      {     if (*man equal w_p) delete_from_pili(piliwp, sq);
       else if (*man equal w_n) delete_from_pili(piliwn, sq);
       else if (*man equal w_b) delete_from_pili(piliwb, sq);
       else if (*man equal w_r) delete_from_pili(piliwr, sq);
       else                     delete_from_pili(piliwq, sq);
      }
   else
      {     if (*man equal b_p) delete_from_pili(pilibp, sq);
       else if (*man equal b_n) delete_from_pili(pilibn, sq);
       else if (*man equal b_b) delete_from_pili(pilibb, sq);
       else if (*man equal b_r) delete_from_pili(pilibr, sq);
       else                     delete_from_pili(pilibq, sq);
      }
}

void print_line();
void undo_move();
void make_move(signed char *fr, signed char *to, int hop_ud);

void skipgarbage()
  { while ( getchar() !='\n' )   {}      }

void scanf_char(signed char *ch)
  {scanf("%c",ch); skipgarbage();}
void scanf_int(int *integer)
  {scanf("%d",integer); skipgarbage();}
void scanf_string()
  {scanf("%s",xxx); skipgarbage();}

double henttid()
// returnerer antal hundreddele sekunder siden programstart...
{return (double)(100*(clock())/CLK_TCK);}

int timepctmovesofar()

{return ((henttid()-timemovestart+pb_opponents_time) / ((double)secprmove+1));}

void p99_secsofar()
{
     sprintf(p99,"\n%8.2f sec.   ", (henttid()-timemovestart)/100);
     }


void writesecsofar_gi()
{p99_secsofar(); fprintf(gi,p99);}

void writesecsofar()
{p99_secsofar(); fprintf(fp,p99);}

      
int count_black_8_row()
{   int x=0;
    
    if (chess_variant != fischerandom) {
    if (sq[a8] equal b_r) ++x; if (sq[h8] equal b_r) ++x;
    if (sq[b8] equal b_n) ++x; if (sq[g8] equal b_n) ++x;
    if (sq[c8] equal b_b) ++x; if (sq[f8] equal b_b) ++x;
    if (sq[d8] equal b_q) ++x; if (sq[e8] equal b_k) ++x;
    
    return x;
}
    // FRC
   if (chess_variant == fischerandom) {
     if (sq[a8] equal b_r) ++x; if (sq[b8] equal b_r) ++x;
     if (sq[c8] equal b_r) ++x; if (sq[d8] equal b_r) ++x;
     if (sq[e8] equal b_r) ++x; if (sq[f8] equal b_r) ++x;
     if (sq[g8] equal b_r) ++x; if (sq[h8] equal b_r) ++x;         
     if (sq[a8] equal b_n) ++x; if (sq[b8] equal b_n) ++x; 
     if (sq[c8] equal b_n) ++x; if (sq[d8] equal b_n) ++x;
     if (sq[e8] equal b_n) ++x; if (sq[f8] equal b_n) ++x;
     if (sq[g8] equal b_n) ++x; if (sq[h8] equal b_n) ++x;   
     if (sq[a8] equal b_b) ++x; if (sq[b8] equal b_b) ++x; 
     if (sq[c8] equal b_b) ++x; if (sq[d8] equal b_b) ++x; 
     if (sq[e8] equal b_b) ++x; if (sq[f8] equal b_b) ++x;
     if (sq[g8] equal b_b) ++x; if (sq[h8] equal b_b) ++x;
     if (sq[a8] equal b_q) ++x; if (sq[b8] equal b_q) ++x;
     if (sq[c8] equal b_q) ++x; if (sq[d8] equal b_q) ++x;
     if (sq[e8] equal b_q) ++x; if (sq[f8] equal b_q) ++x;
     if (sq[g8] equal b_q) ++x; if (sq[h8] equal b_q) ++x;


//frc-jn - I use this to determine how far we are in the opening
// I would do something like this pseudocode:
// for z=a8 to h8
//     if (sq(z) < w_p ++x
// end-loop
// x=x-2       // opening over when black has only 2 pieces on the 8.th row.....
// if x<0 x=0

    
     
}

 return x;     
}    

void is_castle_allowed()
{

   if (variant ) {
               
       if (chess_variant==stationary || chess_variant==shatranj) {
   
      p[0].w_o_o=not_allowed; p[0].w_o_o_o=not_allowed;
      p[0].b_o_o=not_allowed; p[0].b_o_o_o=not_allowed;
     }
     }
}


void normal_chess()
{  chess_variant=normal;     memcpy(men_value, nc_men_value, 16);
  
   memcpy(king,   nc_king,   20);     memcpy(queen,  nc_queen,  20);
   memcpy(rook,   nc_rook,   20);     memcpy(bishop, nc_bishop, 20);
   memcpy(knight, nc_knight, 20);
   variant = false;
   }

void shatranj_chess() {
chess_variant=shatranj;
memcpy(bishop, shatranj_alfil, 6);
memcpy(queen, shatranj_ferz, 6);
//men_letter[4]='E';
//men_letter[6]='F';
men_value[2]=111; 
men_value[3]=555; 
men_value[4]=90; 
men_value[5]=925; 
men_value[6]=296; 
variant=true;
is_castle_allowed();
}

void fischerandom_chess() {
chess_variant=fischerandom;
}


void nightrider_chess() {
men_value[3]=560; 
men_letter[3]='H';
chess_variant=nightrider;
knight[0]=more_steps;
variant = true;
}

void extinct_chess() {
chess_variant=extinct;
variant = true;
var_extinct=true;
}
     
void stationary_chess() {
chess_variant=stationary; 
variant = true;
is_castle_allowed();
}

void knightmate_chess() {
memcpy(king, nc_knight, 20); 
memcpy(knight, nc_king, 20);
men_letter[7]='U';
men_letter[3]='M';
men_value[2]=74; 
men_value[3]=222; 
men_value[4]=296; 
men_value[5]=444; 
men_value[6]=851; 
chess_variant=knightmate;
variant = true;
}

void chancellor_chess() {
memcpy(queen, nc_rook, 20);
men_value[6]=900; 
chess_variant=q_is_rn; 
variant = true;
}

void archbishop_chess() {
memcpy(queen, nc_bishop, 20);
men_value[6]=800; 
chess_variant=q_is_bn; 
variant = true;
}


void rooksquare_chess() {
chess_variant=rooksquare;  
variant = true;
}

void grid_chess() {
chess_variant=gridchess;
variant = true;
}

void pawnfreeze_chess() {
chess_variant=pawnfreeze;
variant = true;
}                     

void knightwazir_chess() {
men_value[3]=500; 
chess_variant=knightwazir_variant;
memcpy(knight+9, wazir, 5);
variant = true;
}

void knightferz_chess() {
men_value[3]=500; 
chess_variant=knightferz;
memcpy(knight+9, ferz, 5);
variant = true;
}

void knightdabbaba_chess() {
men_value[3]=500; 
chess_variant=knightdabbaba;
memcpy(knight+9, dabbaba, 5);
variant = true;

}

void knightalfil_chess() {
men_value[3]=500; 
chess_variant=knightalfil;
memcpy(knight+9, alfil, 5);
variant = true;

}


          
                
              

int find_move_index(signed char *fr, signed char *to)
{int x=0;
 loop:

 if (x>200) {

              printf("\nLooooooooooop! find-move-index\n\n");
            
              happens[10]='0';
              return -1;}

 if (*fr equal move_fr [0][x] and *to equal move_to [0][x]) return x;
 ++x; goto loop;
}


void show_board()
   {
    if (!xboard) {             
    signed char empty, x, y, piece;
    printf("\n white 0-0 & 0-0-0: ");
    if (w_0_0[ply]   equal allowed) printf("+   "); else printf("-   ");
    if (w_0_0_0[ply] equal allowed) printf("+   "); else printf("-   ");
    printf("   black 0-0 & 0-0-0: ");
    if (b_0_0[ply]   equal allowed) printf("+   "); else printf("-   ");
    if (b_0_0_0[ply] equal allowed) printf("+   "); else printf("-   ");
    printf(" e.p. : ");
    if (e_p[ply] equal not_allowed) printf(" no");
    else                            print_a1_h8(&e_p[ply]);
    if (wh_bl equal white) printf("\n     white to move ");
    else                   printf("\n     black to move ");
    empty=' ';
    for (x=a8; x>=a1; x=x-10)
       {if (empty equal '*') empty=' '; else empty='*';
        printf("\n                             ");
        for (y=x; y<=x+7; ++y)
           {printf(" ");
            if (empty equal '*') empty=' '; else empty='*';
            if (sq[y] equal sq_empty)
               printf("%c",empty);
            else
              {if (sq[y]<=b_p)
                    piece=(men_letter[sq[y] * -1] - 'A' + 'a');
               else piece=(men_letter[sq[y]     ]);
               if (sq[y] equal b_p) piece=men_letter[0] - 'A' + 'a';
               if (sq[y] equal w_p) piece=men_letter[0];
               printf("%c",piece);
              }
           }
       }
   }
}


void sq120_to_koordinat(signed char *ch1, signed char *ch2, signed char *ch3)
/*                             31 (a2) =>  2(rkke)   1(linie)    */
  {*ch3=(*ch1 - 10) / 10;
   *ch2=*ch1 - 10 - (10 * *ch3);}

void p99_a1_h8(signed char *ch1)
//  danner fx 'c8' hvis funktionen bliver kaldt med signed char = 93
  {signed char ch2, ch3;
   sq120_to_koordinat(ch1, &ch2, &ch3);
   sprintf(p99,"%c%c",'a' - 1 + ch2, '0' + ch3); p99[2]=0;
  }

void print_a1_h8(signed char *ch1)
  {p99_a1_h8(ch1); printf(p99);
  }

void sprint_a1_h8(signed char *ch1)
  {p99_a1_h8(ch1); //drucke_text(p99);
  }

void pgn_a1_h8(signed char *ch1)
  {p99_a1_h8(ch1); fprintf(pgn,p99);}


int square_colour(signed char *sq)
{  if ((tablin[*sq] % 2) equal (tabrow[*sq] % 2)) return black;
   else                                           return white;
}



void print_kqrbnp(signed char ch1)
/* printer 'K' hvis input = 7(w_k), 'D' ved 6 o.s.v.  */
  {
  signed char poschar;
  
  if (!xboard) {
   poschar=ch1;
   if (poschar < 0) poschar= -1 * poschar;
  printf("%1c",men_letter[poschar]);
}
  }

void change_black_white()
  {if (wh_bl equal white) wh_bl = black;
   else                   wh_bl = white;
  }

void unpack_promotion(signed char *to, signed char *to_9_10_11,
                                      signed char *promote_piece)
  {
                                      
    if (chess_variant != shatranj) {                                      
  switch (*to)
     {
      
      case prom_q_10 : *to_9_10_11=10; *promote_piece=w_q; break;
      case prom_q_9  : *to_9_10_11=9 ; *promote_piece=w_q; break;
      case prom_q_11 : *to_9_10_11=11; *promote_piece=w_q; break;
      case prom_n_10 : *to_9_10_11=10; *promote_piece=w_n; break;
      case prom_n_9  : *to_9_10_11=9 ; *promote_piece=w_n; break;
      case prom_n_11 : *to_9_10_11=11; *promote_piece=w_n; break;
      case prom_r_10 : *to_9_10_11=10; *promote_piece=w_r; break;
      case prom_r_9  : *to_9_10_11=9 ; *promote_piece=w_r; break;
      case prom_r_11 : *to_9_10_11=11; *promote_piece=w_r; break;
      case prom_b_10 : *to_9_10_11=10; *promote_piece=w_b; break;
      case prom_b_9  : *to_9_10_11=9 ; *promote_piece=w_b; break;
      case prom_b_11 : *to_9_10_11=11; *promote_piece=w_b; break;
      
      }
      }else{
            
            
       switch (*to)      // in shatanj you can only promote pawn to a ferz - JA
     {     
      case prom_q_10 : *to_9_10_11=10; *promote_piece=w_q; break;
      case prom_q_9  : *to_9_10_11=9 ; *promote_piece=w_q; break;
      case prom_q_11 : *to_9_10_11=11; *promote_piece=w_q; break;
      case prom_n_10 : *to_9_10_11=10; *promote_piece=w_q; break;
      case prom_n_9  : *to_9_10_11=9 ; *promote_piece=w_q; break;
      case prom_n_11 : *to_9_10_11=11; *promote_piece=w_q; break;
      case prom_r_10 : *to_9_10_11=10; *promote_piece=w_q; break;
      case prom_r_9  : *to_9_10_11=9 ; *promote_piece=w_q; break;
      case prom_r_11 : *to_9_10_11=11; *promote_piece=w_q; break;
      case prom_b_10 : *to_9_10_11=10; *promote_piece=w_q; break;
      case prom_b_9  : *to_9_10_11=9 ; *promote_piece=w_q; break;
      case prom_b_11 : *to_9_10_11=11; *promote_piece=w_q; break;
      }
      
   
      
     }
  }

int pre_val(int x)
{
if (s_kill equal 2)
  {if (x equal +150 and simple_kill1_vu[ply]>(int_max-100))
              return simple_kill1_vu[ply];
   if (x equal -150 and simple_kill1_vu[ply]<(int_min+100))
              return simple_kill1_vu[ply];
   if (x equal +120 and simple_kill2_vu[ply]>(int_max-100))
              return simple_kill2_vu[ply];
   if (x equal -120 and simple_kill2_vu[ply]<(int_min+100))
              return simple_kill2_vu[ply];
  }

if (ply<2) return (x/3);
   else       return  x;
}

void w_prevalue_moves()

  {int man, w_min, b_min, pre_value;
   signed char fr, to, to_9_10_11, promote_piece;
   signed char s_kill1_fr, s_kill1_to, s_kill2_fr, s_kill2_to;

   s_kill1_fr=simple_kill1_fr[ply]; s_kill1_to=simple_kill1_to[ply];
   s_kill2_fr=simple_kill2_fr[ply]; s_kill2_to=simple_kill2_to[ply];
   if (s_kill==0) {s_kill1_fr=0; s_kill2_fr=0;}
   for (move_point=0; move_fr[ply][move_point] != stop; ++move_point)
      {fr=move_fr[ply][move_point]; to=move_to[ply][move_point];
       if (fr equal hash.hash_fr and to equal hash.hash_to)
          {pre_value=int_max+2;        ++tv_hash_hit;
           if (info_out==1 and ply==1) printf("hash-kill=");
           goto w_pre_slut;}

 //                      check denne goto.........

       if (attack_w_min[to]>=w_p) pre_value=+5;
       else                       pre_value=0;


       if (to>h8)
         {unpack_promotion(&to, &to_9_10_11, &promote_piece);
          to=fr + to_9_10_11;
          man=300;
          if (promote_piece equal w_q) pre_value += 100;
          if (promote_piece equal w_n) pre_value += 100;
          else                         pre_value += 50;
         }
       else man=men_value[sq[fr]]; /* vrdi af brik, der flyttes */

   if (iteration>0) {
       if (man != men_value[w_k] and attack_b_min[fr]>=b_k)
         {b_min=                          men_value[0-(attack_b_min[fr])  ];
          if (attack_w_min[fr]>w_k) w_min=0;
          else                      w_min=men_value[attack_w_min[fr]];
          if (w_min equal 0) pre_value += man;
          else if ((man + w_min) > b_min)
                 {pre_value += ((man - 10)/4 );
                  if (w_min < b_min)
                     pre_value += ((b_min - w_min) /4 );
                 }
         };
   }

       if (attack_b_min[to]>=b_k)
         {b_min=                          men_value[0-(attack_b_min[to]) ];
          if (attack_w_min[to]>w_k) w_min=0;
          else                      w_min=men_value[attack_w_min[to]];
          if (w_min equal 0 or w_min equal man) pre_value -= man;
          else if ((man ) > b_min)
                  pre_value += (b_min - man );
         };
       if (sq[to] != sq_empty) pre_value += men_value[0-(sq[to])];
w_pre_slut:

// a dirty way to try running without prevalue....
       if (bishoppair equal 41) pre_value=0;

       oldpre_value[ply][move_point]=pre_value;
       if (fr equal s_kill1_fr and to equal s_kill1_to)
        {
         if (pre_value+50>s_kill1_oldpre[ply]   and s_kill>=3)

          {if (simple_kill1_vu[ply]>(int_max-100))
              pre_value=simple_kill1_vu[ply];
           else pre_value=simple_kill1_vu[ply] /* hvad med pat m.m....?) */
                 -w_materiel[ply]+b_materiel[ply]
                 +50+(s_kill1_oldpre[ply]/3)
                 ;
            }
         else pre_value+=pre_val(+150);
        }
        if (fr equal s_kill2_fr and to equal s_kill2_to)
        {
         if (pre_value+50>s_kill2_oldpre[ply]   and s_kill>=3)
 
          {if (simple_kill2_vu[ply]>(int_max-100))
              pre_value=simple_kill2_vu[ply];
           else pre_value=simple_kill2_vu[ply] /* hvad med pat m.m....?) */
                 -w_materiel[ply]+b_materiel[ply]
                 +30+(s_kill2_oldpre[ply]/3)
                 ;
 
          }
         else pre_value+=pre_val(+120);
        }

       move_value[ply][move_point]=pre_value;

      }

  }

void b_prevalue_moves()

  {int man, w_min, b_min, pre_value;
   signed char fr, to, to_9_10_11, promote_piece;
   signed char s_kill1_fr, s_kill1_to, s_kill2_fr, s_kill2_to;

   s_kill1_fr=simple_kill1_fr[ply]; s_kill1_to=simple_kill1_to[ply];
   s_kill2_fr=simple_kill2_fr[ply]; s_kill2_to=simple_kill2_to[ply];
   if (s_kill==0) {s_kill1_fr=0; s_kill2_fr=0;}


   for (move_point=0; move_fr[ply][move_point] != stop; ++move_point)
      {fr=move_fr[ply][move_point]; to=move_to[ply][move_point];
       if (fr equal hash.hash_fr and to equal hash.hash_to)
          {pre_value=int_min-2;        ++tv_hash_hit;
           if (info_out==1 and ply==1); 
           goto b_pre_slut;}

       if (attack_b_min[to]<=b_p) pre_value=-5;
       else                       pre_value=0;

       if (to>h8)
         {unpack_promotion(&to, &to_9_10_11, &promote_piece);
          to=fr - to_9_10_11;
          man=300;
          if (promote_piece equal w_q) pre_value -= 100;
          if (promote_piece equal w_n) pre_value -= 100;
          else                         pre_value -= 50;
         }
       else man=men_value[0-(sq[fr])]; /* vrdi af brik, der flyttes */

  if (iteration>0) {
       if (man != men_value[w_k] and attack_w_min[fr]<=w_k)
         {w_min=                          men_value[attack_w_min[fr]     ];
          if (attack_b_min[fr]<b_k) b_min=0;
          else                      b_min=men_value[0-(attack_b_min[fr])];
          if (b_min equal 0) pre_value -= man;
          else if ((man + b_min) > w_min)
                 {pre_value -= ((man - 10)/4 );
                  if (b_min < w_min)
                     pre_value += ((w_min - b_min) /4 );
                 }
         };
   }

       if (attack_w_min[to]<=w_k)
         {w_min=                          men_value[attack_w_min[to]     ];
          if (attack_b_min[to]<b_k) b_min=0;
          else                      b_min=men_value[0-(attack_b_min[to])];
          if (b_min equal 0 or b_min equal man) pre_value += man;
          else if ((man ) > w_min)
                  pre_value -= (w_min - man );
         };
       if (sq[to] != sq_empty) pre_value -= men_value[sq[to]];
b_pre_slut:

// a dirty way to try running without prevalue....
       if (bishoppair equal 41) pre_value=0;


       oldpre_value[ply][move_point]=pre_value;
       if (fr equal s_kill1_fr and to equal s_kill1_to)
        {
         if (pre_value-50<s_kill1_oldpre[ply]   and s_kill>=3)

           {if (simple_kill1_vu[ply]<(int_min+100))
              pre_value=simple_kill1_vu[ply];
           else pre_value=simple_kill1_vu[ply] /* hvad med pat m.m....?) */
                 -w_materiel[ply]+b_materiel[ply]
                 -50+(s_kill1_oldpre[ply]/3)
                 ;
  
          }
         else pre_value+=pre_val(-150);
        }
 
       if (fr equal s_kill2_fr and to equal s_kill2_to)
        {
         if (pre_value-50<s_kill2_oldpre[ply]   and s_kill>=3)
          {if (simple_kill2_vu[ply]<(int_min+100))
              pre_value=simple_kill2_vu[ply];
           else pre_value=simple_kill2_vu[ply] /* hvad med pat m.m....?) */
                 -w_materiel[ply]+b_materiel[ply]
                 -30+(s_kill1_oldpre[ply]/3)
                 ;
   
          }
         else pre_value+=pre_val(-120);
        }
       move_value[ply][move_point]=pre_value;

  }}

void get_next_good_move()
/* Dette ser noget rodet ud, men der sker simpelthen det, at man sikrer
   sig, at det bedste af de resterende trk kommer op som det forreste
   af de resterende trk og alts bliver prvet frst.
*/
  {signed char gem_i, best_i, anne, *lars, *torben; register signed char i, *x;
   int best_z, *jens, dina; register int *hanne;

   signed char *skaerm; /*skaerm=99999; */

   if (wh_bl equal white) best_z=int_min; else best_z=int_max;
   i=move_pointer[ply]; gem_i=i; best_i=i;
   hanne=&move_value[ply][i];
   x=&move_fr[ply][i];
   for (lars=x; *x!=stop; ++x)
      {if ((wh_bl equal white and *hanne>best_z) or
           (wh_bl equal black and *hanne<best_z))
         {best_z=*hanne; best_i=i; torben=x; jens=hanne;}
       ++i; ++hanne;
      };
   if (gem_i != best_i)
     {anne=move_to[ply][gem_i];
                 move_to[ply][gem_i]=move_to[ply][best_i];
                                move_to[ply][best_i]=anne;
      anne=*lars; *lars=*torben; *torben=anne;
      dina=move_value[ply][gem_i];
                 move_value[ply][gem_i]=*jens;
                                *jens=dina;
      dina=oldpre_value[ply][gem_i];
                 oldpre_value[ply][gem_i]=oldpre_value[ply][best_i];
                                oldpre_value[ply][best_i]=dina;
     }
  }


int discovered_check(signed char *fr, signed char *to, signed char *sq_k)
{   if (*fr + *to equal *sq_k) return false; /* fjerner warnings */
/* vil et trk bne for skak mod:
      1) fjendens konge (bruges til at finde skakgivende selektive trk)
      2) egen konge (bruges i make_move nr ply=last_ply til at bestemme
         om et trk er et pseudomove - en bundet brik flyttes.
*/

/*     skal der laves change_black_white()      */

/* hvis x_attack_min[*fr] er >= konge (truet af konge eller udkket)
   kan feltet ikke vre truet af D, T eller L og der
   laves straks en return false.
*/

/* her skal s undersges, om det er true eller false............ */

return false;
}

int is_move_a_check(signed char *fr, signed char *to)
/* denne funktion undersger, om et trk giver skak */
/* input er et trk (fra og til), skakbrttet(sq), wh_bl, sq_b/w_k[ply] */
/* bemrk at ved ply==last_ply er trkket udfrt p brttet.... */
/* denne funktion returnerer false/true */
/* formlet er at udvlge de skakgivende trk til den selektive search. */
/* rokade og forvandling tages der ikke hensyn til her, da disse trk altid
   er med i den selektive search alligevel */

{
   signed char man, *gangart, *idx2, enemy_king, sq_enemy_king, sw=0;

   if (sq[*fr] equal sq_empty) man=sq[*to]; else man=sq[*fr];
   if (man >= w_p) {sq_enemy_king=sqbk; enemy_king=b_k;}
   else            {sq_enemy_king=sqwk; enemy_king=w_k;}


        if (man equal w_p * wh_bl)
          {if ((*to + wh_bl *  9 equal sq_enemy_king) or
               (*to + wh_bl * 11 equal sq_enemy_king)
              )
                return true;
           else goto i_m_a_c_90;
          }
   else if (man equal w_r * wh_bl) gangart=rook;
   else if (man equal w_b * wh_bl) gangart=bishop;
   else if (man equal w_k * wh_bl) goto i_m_a_c_90;
   else if (man equal w_n * wh_bl) {gangart=knight; goto i_m_a_c_knight;}
   else   {                        gangart=queen; sw=1;
          }

i_m_a_c_10:                    /* ny retning */
   if (*++gangart equal stop) goto i_m_a_c_90; /* ikke flere retninger */
   if (*to > sq_enemy_king and *gangart > 0) goto i_m_a_c_10; /* forkert */
   if (*to < sq_enemy_king and *gangart < 0) goto i_m_a_c_10; /* retning */
   idx2=&sq[*to];

i_m_a_c_20:                    /* et skridt mere i den givne retning */
   idx2 += *gangart;
   if (*idx2 equal sq_empty) goto i_m_a_c_20;
   if (*idx2 equal enemy_king) return true;
   goto i_m_a_c_10;

i_m_a_c_knight:
   if (knight[0] equal more_steps) goto i_m_a_c_10; // nightrider
i_m_a_c_knight_55:
   if (*++gangart equal stop) goto i_m_a_c_90; /* ikke flere retninger */
   if (*to + *gangart equal sq_enemy_king) return true;
   goto i_m_a_c_knight_55;

i_m_a_c_90:

   if (variant && chess_variant!=normal and sw==1) {     
   
     if (chess_variant==q_is_rn or chess_variant==q_is_bn) {
                                gangart=knight; sw=2; 
                                goto i_m_a_c_knight_55;
     }
  }

   return false;
}



int is_move_a_sel_move(signed char *fr, signed char *to)
{  int man, enemy_man, gain;
   signed char depth;

/* finder selektive trk -
   denne funktion kaldes ikke med rokade eller forvandling.   */

   if (ply equal 0 and iteration equal 0)    // kun skakker
       return is_move_a_check(fr, to);       // i matesearch ply zero

   depth=ply - first_dynamic_sel_ply[ply]; /* depth er nu 0, 2, 4 osv..nej..*/
   



   if (wh_bl equal white) goto w_moves;
   else                   goto b_moves;


w_moves: /* NB: w_attack_min er ufuldstndig p dette tidspunkt! */

    if (only_recapture equal true)
      {if (sq[*to] != sq_empty and
           (men_value[sq[*to] * -1] +
            w_materiel[ply]-b_materiel[ply]) >=
             (w_materiel[0]-b_materiel[0])
          )
            return true;
       else return is_move_a_check(fr, to);  // 1. jan 98
      }

    if (depth>ant_sel_ply) goto w_m_1;

    if (depth equal 0 and sq[*to] != sq_empty) return true;
          /* alle slag i frste ply i den selektive search tages med */

 
//    if (depth <= 4 and *to>=a7 and sq[*fr] equal w_p) return true;

    if (*to>=a7 and sq[*fr] equal w_p) return true;
    if (*to>=a5 and sq[*fr] equal w_p) 
       {if (sq[*to+9]  != b_p and sq[*to+10] != b_p and sq[*to+11] != b_p and 
            sq[*to+19] != b_p and sq[*to+20] != b_p and sq[*to+21] != b_p 
           ) 
             return true;
       }


    if (sq[*fr] equal w_p and
         (sq[*to+9] < b_p or sq[*to+11] < b_p)
       )                                              return true;
w_m_1:


   {
    if (iteration>0 or ply>(4+last_sel_ply+gem_check_search-2))
                    //        4=last_iteration    11 okt.
     {if (sq[*to] != sq_empty)
        {man=men_value[sq[*fr]]; /* vrdi af brik */
         enemy_man=men_value[sq[*to] * -1];
         if (attack_b_min[*to]==b_k - 1)
// mangler: udaekket hvis daekket af K og truet af en anden brik......
             gain=enemy_man;        /* en udkket brik sls */
         else gain=enemy_man - man; /* modstanderen kan sl igen */
         if ((w_materiel[ply]-b_materiel[ply]+gain) >
             (w_materiel[0]-b_materiel[0]))
 /* slag undersges herefter kun, hvis de kan give materielt overskud */
            return true;
        }
     }
   }
    if (iteration>0 and depth>3) return false;
    else return is_move_a_check(fr, to);


b_moves: /* NB: b_attack_min er ufuldstndig p dette tidspunkt! */

    if (only_recapture equal true)
      {if (sq[*to] != sq_empty and
           (-men_value[sq[*to]     ] +
            w_materiel[ply]-b_materiel[ply]) <=
             (w_materiel[0]-b_materiel[0])
          )
            return true;
       else return is_move_a_check(fr, to);  // 1. jan 98
      }

    if (depth>ant_sel_ply) goto b_m_1;

    if (depth equal 0 and sq[*to] != sq_empty) return true;
          /* alle slag i frste ply i den selektive search tages med */

 

//    if (depth <= 4 and *to<=h2 and sq[*fr] equal b_p) return true;

    if (*to<=h2 and sq[*fr] equal b_p) return true;
    if (*to<=h4 and sq[*fr] equal b_p) 
       {if (sq[*to-9]  != w_p and sq[*to-10] != w_p and sq[*to-11] != w_p and 
            sq[*to-19] != w_p and sq[*to-20] != w_p and sq[*to-21] != w_p 
           ) 
             return true;
       }


    if (sq[*fr] equal b_p and
         (sq[*to-9] > w_p or sq[*to-11] > w_p)
       )                                              return true;

b_m_1:

   {
    if (iteration>0 or ply>(4+last_sel_ply+gem_check_search-2))
                    //        4=last_iteration    11 okt.
     {if (sq[*to] != sq_empty)
        {man=men_value[sq[*fr] * -1]; /* vrdi af brik */
         enemy_man=men_value[sq[*to]];
         if (attack_w_min[*to]==w_k + 1)
             gain=enemy_man;        /* en udkket brik sls */
         else gain=enemy_man - man; /* modstanderen kan sl igen */
         if ((w_materiel[ply]-b_materiel[ply]-gain) <
             (w_materiel[0]-b_materiel[0]))
 /* slag undersges herefter kun, hvis de kan give materielt overskud */
            return true;
        }
     }
   }
    if (iteration>0 and depth>3) return false;
    else return is_move_a_check(fr, to);
}

int sel_move(signed char *ch1, signed char *ch2)
{   int dum;
    dum=is_move_a_sel_move(ch1, ch2);
    if (dum equal false) ++tv_non_sel_move;
    return dum;
}


int pawncovered(signed char x)
{  
     if (variant && sq[x]>=w_p){
                 
     if (sq[x-9]==w_p or sq[x-11]==w_p) 
        return true; 
        else 
        return false;
         }else{
               if (variant && sq[x+9]==b_p or variant && sq[x+11]==b_p) 
               return true; 
               else 
               return false;
               }  
}



void generate_moves_2(signed char *gangart, signed char ch1)
{
   signed char sc1;
   signed char        ch2;


   if (variant && chess_variant equal pawnfreeze and pawncovered(ch1) equal true)
      goto g_m2_exit;


   sc1 = *gangart;   /* husk at D,L & T gr lange ture */

g_m2_10:                    /* ny retning */
   if (*++gangart equal stop) goto g_m2_90; /* ikke flere retninger */

   ch2=ch1; sq_idx2=sq_idx;

g_m2_20:                    /* et skridt mere i den givne retning */
   sq_idx2 += *gangart; ch2 += *gangart;
   if (*sq_idx2 equal sq_illegal) goto g_m2_10; /* udenfor brttet */




   if (wh_bl equal white)
     {if (*sq_idx < attack_w_min[ch2])
        {attack_w_min[ch2]=*sq_idx;
         if (gen_moves_mode equal only_attack)
           {if (ch2 equal sqbk)
              {if (checking_direction1 equal 0)
                 {sq_checking_man=ch1;
                  checking_direction1=*gangart;
                  sq_checked_king=ch2;
                 }
               else checking_direction2=*gangart; /* dobbeltskak! */
              }
           }
         else if (ch2 equal sqbk)
                  {make2_move_status=pseudo_move;

                  }

        }
     }
   else
     {if (*sq_idx > attack_b_min[ch2])
        {attack_b_min[ch2]=*sq_idx;
         if (gen_moves_mode equal only_attack)
           {if (ch2 equal sqwk)
              {if (checking_direction1 equal 0)
                 {sq_checking_man=ch1;
                  checking_direction1=*gangart;
                  sq_checked_king=ch2;
                 }
               else checking_direction2=*gangart; /* dobbeltskak! */
              }
           }
         else if (ch2 equal sqwk)
                  {make2_move_status=pseudo_move;

                  }


        }
     }
   if (wh_bl equal white and *sq_idx2 >= w_p) goto g_m2_10;
   if (wh_bl equal black and *sq_idx2 <= b_p) goto g_m2_10;
                   /* en brik af samme farve */

   if (gen_moves_mode equal only_attack) goto g_m2_80;
   if (*sq_idx equal w_k)
     {if (attack_b_min[ch2]>=b_k) goto g_m2_10;
      else
        {if ( ((ch2 - ch1) equal checking_direction1 and
                sq[sq_checking_man] != b_p
              )
                                                             or
              ((ch2 - ch1) equal checking_direction2 and
                sq[ch1 - checking_direction2] != b_p
              )
            )
           goto g_m2_10;
         else goto g_m2_70;
        }
     }

   if (*sq_idx equal b_k)
     {if (attack_w_min[ch2]<=w_k) goto g_m2_10;
      else
        {if ( ((ch2 - ch1) equal checking_direction1 and
                sq[sq_checking_man] != w_p
              )
                                                             or
              ((ch2 - ch1) equal checking_direction2 and
                sq[ch1 - checking_direction2] != w_p
              )
            )
           goto g_m2_10;
         else goto g_m2_70;
        }
     }

   if (checking_direction1 != 0 and sq_avoid_check[ch2] equal false)
    
     goto g_m2_80;
g_m2_70:
        

   if (sel_ply_now equal false or sel_move(&ch1, &ch2) equal true) 
  
      if (variant && chess_variant!=gridchess or 
          variant && grid[ch1]!=grid[ch2] or 
           !variant) 
        
        {
         {
                            
          move_fr[ply][move_point]=ch1;
          move_to[ply][move_point++]=ch2;

}
}
        

g_m2_80:
   if (*sq_idx2 != sq_empty) goto g_m2_10;
   if (sc1 equal more_steps) goto g_m2_20;
   goto g_m2_10;

g_m2_90:

g_m2_exit:
   ;
}


void pawnmove_into_array(signed char *ch1, signed char *ch2, signed char prom) {
     
     int selmove;
    
     if (checking_direction1 equal 0 or sq_avoid_check[*ch2] equal true or *ch2 equal p[ply].e_p) {


    if (variant && chess_variant!=gridchess && grid[*ch1]!=grid[*ch2] || 
         variant && chess_variant == shatranj ||  variant && chess_variant == knightmate ||
         variant && chess_variant == nightrider || chess_variant==fischerandom ||
         !variant) {

      
      
      if ((wh_bl equal white and *ch1<a7) or (wh_bl equal black and *ch1>h2)) {
                 
                 if (sel_ply_now equal false or sel_move(ch1, ch2) equal true) {
                                 move_fr[ply][move_point]=*ch1;
                                 move_to[ply][move_point++]=*ch2;
            }
            
       
        }else{
        move_fr[ply][move_point]=*ch1;
        move_to[ply][move_point++]=prom; /* promotion to Q, R, B, N */
        
        if  (tv_pat>0 or ((intern equal white and best_score[0]<draw_score) or
                          (intern equal black and best_score[0]>draw_score))) {
                                  
                                  move_fr[ply][move_point]=*ch1;
                                  move_to[ply][move_point++]=prom+1;
                                  move_fr[ply][move_point]=*ch1;
                                  move_to[ply][move_point++]=prom+2;
                                  }
                                  move_fr[ply][move_point]=*ch1;
                                  move_to[ply][move_point++]=prom+3;
       }
       }}}

        
  



void generate_pawn_moves(signed char ch1)
{  signed char ch2;
  

   if (variant && chess_variant equal pawnfreeze and pawncovered(ch1) equal true)
       goto gpm_exit;
       
   if (gen_moves_mode equal move_and_attack){
     ch2 = ch1 + wh_bl * 10;
      
      if (sq[ch2] equal sq_empty) {
      pawnmove_into_array(&ch1, &ch2, prom_q_10);
        
         if (chess_variant !=shatranj) {
        
         if ((wh_bl equal white and ch1<=h2) or
             (wh_bl equal black and ch1>=a7)) {
                                  
                   
             ch2 = ch1 + wh_bl * 20;
                   
             
             if (sq[ch2] equal sq_empty) 
             pawnmove_into_array(&ch1, &ch2, 0); 
             
             }
           
     
          
           }
        }
     }
   if (wh_bl equal white)
      {ch2 = ch1 + 9;
       attack_w_min[ch2]=w_p;
       if (gen_moves_mode equal only_attack and ch2 equal sqbk)
           {sq_checking_man=ch1;
            checking_direction1=9;
            sq_checked_king=ch2;
           }
      }
   else {ch2 = ch1 - 9;
         attack_b_min[ch2]=b_p;
         if (gen_moves_mode equal only_attack and ch2 equal sqwk)
           {sq_checking_man=ch1;
            checking_direction1=-9;
            sq_checked_king=ch2;
           }
         }
   if (gen_moves_mode equal move_and_attack)
     {if ((wh_bl equal white and sq[ch2]<=b_p) or
          (wh_bl equal black and sq[ch2]>=w_p) or
          (ch2 equal p[ply].e_p                ))
          pawnmove_into_array(&ch1, &ch2, prom_q_9);
     }
   if (wh_bl equal white)
      {ch2 = ch1 + 11;
       attack_w_min[ch2]=w_p;
       if (gen_moves_mode equal only_attack and ch2 equal sqbk)
           {sq_checking_man=ch1;
            checking_direction1=11;
            sq_checked_king=ch2;
           }
      }
   else {ch2 = ch1 - 11;
         attack_b_min[ch2]=b_p;
         if (gen_moves_mode equal only_attack and ch2 equal sqwk)
           {sq_checking_man=ch1;
            checking_direction1=-11;
            sq_checked_king=ch2;
           }
         }
   if (gen_moves_mode equal move_and_attack)
     {if ((wh_bl equal white and sq[ch2]<=b_p) or
          (wh_bl equal black and sq[ch2]>=w_p) or
          (ch2 equal p[ply].e_p                ))
          pawnmove_into_array(&ch1, &ch2, prom_q_11);
     }
gpm_exit:
	 ;
}





void generate_moves()
  {signed char sovs, x;

   if (wh_bl equal white) memcpy(attack_w_min+a1, attack_w_nul+a1, h8-a1+2);
   else                   memcpy(attack_b_min+a1, attack_b_nul+a1, h8-a1+2);

   move_point=0;


   if (checking_direction2 != 0 and gen_moves_mode equal move_and_attack ||
   variant && checking_direction2 != 0 and gen_moves_mode equal move_and_attack
    and chess_variant != stationary) {

      
      if (wh_bl equal white) {
                
      sq_idx=&sq[sqwk]; 
      generate_moves_2(king, sqwk);
      }
    // only kingmoves when in doublecheck
       else                 {sq_idx=&sq[sqbk]; generate_moves_2(king, sqbk);}
       goto g_m_exit;
      }



   if (wh_bl equal white)
         {for (x=0; piliwp[x]!=0 and make2_move_status!=pseudo_move; ++x)
              {sq_idx=&sq[piliwp[x]]; generate_pawn_moves(piliwp[x]);}
          for (x=0; piliwr[x]!=0 and make2_move_status!=pseudo_move; ++x)
              {sq_idx=&sq[piliwr[x]]; generate_moves_2(rook , piliwr[x]);}
          
          for (x=0; piliwb[x]!=0 and make2_move_status!=pseudo_move; ++x){
              
              
              sq_idx=&sq[piliwb[x]]; 
                           
           
              generate_moves_2(bishop, piliwb[x]);      
              }        
              
          
          for (x=0; piliwn[x]!=0 and make2_move_status!=pseudo_move; ++x)
              {sq_idx=&sq[piliwn[x]]; generate_moves_2(knight, piliwn[x]);}
      
        
          if (variant && chess_variant!=stationary and
              make2_move_status!=pseudo_move || !variant &&
               make2_move_status!=pseudo_move) {
               
               sq_idx=&sq[sqwk]; 
               generate_moves_2(king , sqwk);
               }

  

          for (x=0; piliwq[x]!=0 and make2_move_status!=pseudo_move; ++x)
              {sq_idx=&sq[piliwq[x]]; generate_moves_2(queen, piliwq[x]);

               if ( variant && chess_variant==q_is_rn or variant && chess_variant==q_is_bn)
                {sq_idx=&sq[piliwq[x]]; generate_moves_2(knight, piliwq[x]);}

              }
         }
   else
         {for (x=0; pilibp[x]!=0 and make2_move_status!=pseudo_move; ++x)
              {sq_idx=&sq[pilibp[x]]; generate_pawn_moves(pilibp[x]);}
          for (x=0; pilibr[x]!=0 and make2_move_status!=pseudo_move; ++x)
              {sq_idx=&sq[pilibr[x]]; generate_moves_2(rook , pilibr[x]);}
         
          for (x=0; pilibb[x]!=0 and make2_move_status!=pseudo_move; ++x){
                       
              sq_idx=&sq[pilibb[x]];
             
       
              generate_moves_2(bishop, pilibb[x]);
               
              }
          
          
          
          for (x=0; pilibn[x]!=0 and make2_move_status!=pseudo_move; ++x)
              {sq_idx=&sq[pilibn[x]]; generate_moves_2(knight, pilibn[x]);}
        
          if (variant && chess_variant!=stationary and
               make2_move_status!=pseudo_move || !variant &&
               make2_move_status!=pseudo_move) {
                                               
               sq_idx=&sq[sqbk]; 
               generate_moves_2(king , sqbk);
               }



          for (x=0; pilibq[x]!=0 and make2_move_status!=pseudo_move; ++x)
              {sq_idx=&sq[pilibq[x]]; generate_moves_2(queen, pilibq[x]);

               if (variant && chess_variant==q_is_rn or variant && chess_variant==q_is_bn)
                {sq_idx=&sq[pilibq[x]]; generate_moves_2(knight, pilibq[x]);}

              }
         }

  
   if (   wh_bl equal white)
     {
          if (  chess_variant != fischerandom and  p[ply].w_o_o     equal allowed
          and sq[f1]           equal sq_empty
          and sq[g1]           equal sq_empty
          and attack_b_min[e1] equal b_k - 1
          and attack_b_min[f1] equal b_k - 1
          and attack_b_min[g1] equal b_k - 1)
         {move_fr[ply][move_point]  =e1;
          move_to[ply][move_point++]=g1;
         }
      
      
      
      if ( chess_variant == fischerandom and  p[ply].w_o_o equal allowed

//frc-jn - in a loop make sure the squares between the king and rook are empty
          and sq[f1]           equal sq_empty
          and sq[g1]           equal sq_empty

//frc-jn - in a loop make sure the king doesn't 'touch' an attacked square
          and attack_b_min[e1] equal b_k - 1
          and attack_b_min[f1] equal b_k - 1
          and attack_b_min[g1] equal b_k - 1)
         {
              
//         if (sq[b1] equal w_k) move_fr[ply][move_point] =b1;
//         if (sq[c1] equal w_k) move_fr[ply][move_point] =c1;
//         if (sq[d1] equal w_k) move_fr[ply][move_point] =d1;
//         if (sq[e1] equal w_k) move_fr[ply][move_point] =e1;
//         if (sq[f1] equal w_k) move_fr[ply][move_point] =f1;
//         if (sq[g1] equal w_k) move_fr[ply][move_point] =g1;

         move_fr[ply][move_point]  =sqwk;         
         move_to[ply][move_point++]=h8;
// if you use g1, you cannot distinguish between castling and an ordinary kingmove
// so use h8 for o-o and a8 for o-o-o



         }
      
        
      
      if (  chess_variant != fischerandom and  p[ply].w_o_o_o   equal allowed
          and sq[d1]           equal sq_empty
          and sq[c1]           equal sq_empty
          and sq[b1]           equal sq_empty
          and attack_b_min[e1] equal b_k - 1
          and attack_b_min[d1] equal b_k - 1
          and attack_b_min[c1] equal b_k - 1)
         {move_fr[ply][move_point]  =e1;
          move_to[ply][move_point++]=c1;
         }
 
 
//frc-jn - change this as above.....

       
        if (  chess_variant == fischerandom and  p[ply].w_o_o_o   equal allowed
          and sq[d1]           equal sq_empty
          and sq[c1]           equal sq_empty
          and sq[b1]           equal sq_empty
          and attack_b_min[e1] equal b_k - 1
          and attack_b_min[d1] equal b_k - 1
          and attack_b_min[c1] equal b_k - 1)
         {
              
         if (sq[b1] equal w_k) move_fr[ply][move_point] =b1;
         if (sq[c1] equal w_k) move_fr[ply][move_point] =c1;
         if (sq[d1] equal w_k) move_fr[ply][move_point] =d1;
         if (sq[e1] equal w_k) move_fr[ply][move_point] =e1;
         if (sq[f1] equal w_k) move_fr[ply][move_point] =f1;
         if (sq[g1] equal w_k) move_fr[ply][move_point] =g1;    
        
         move_to[ply][move_point++]=c1;
         }
 
 
     }
   else
     {
         
       
       
         if ( chess_variant!=fischerandom and p[ply].b_o_o equal allowed
          and sq[f8]           equal sq_empty
          and sq[g8]           equal sq_empty
          and attack_w_min[e8] equal w_k + 1
          and attack_w_min[f8] equal w_k + 1
          and attack_w_min[g8] equal w_k + 1)
         {move_fr[ply][move_point]  =e8;
          move_to[ply][move_point++]=g8;
         }

 
//frc-jn - change this as above.....
     
         if ( chess_variant==fischerandom and p[ply].b_o_o equal allowed
          and sq[f8]           equal sq_empty
          and sq[g8]           equal sq_empty
          and attack_w_min[e8] equal w_k + 1
          and attack_w_min[f8] equal w_k + 1
          and attack_w_min[g8] equal w_k + 1)
         {
         if (sq[b8] equal b_k) move_fr[ply][move_point] =b8;
         if (sq[c8] equal b_k) move_fr[ply][move_point] =c8;
         if (sq[d8] equal b_k) move_fr[ply][move_point] =d8;
         if (sq[e8] equal b_k) move_fr[ply][move_point] =e8;
         if (sq[f8] equal b_k) move_fr[ply][move_point] =f8;
         if (sq[g8] equal b_k) move_fr[ply][move_point] =g8;           
              
          move_to[ply][move_point++]=g8;
         }
         
         
          if (  chess_variant != fischerandom and  p[ply].b_o_o_o  equal allowed
          and sq[d8]           equal sq_empty
          and sq[c8]           equal sq_empty
          and sq[b8]           equal sq_empty
          and attack_w_min[e8] equal w_k + 1
          and attack_w_min[d8] equal w_k + 1
          and attack_w_min[c8] equal w_k + 1)
         {
          
          move_fr[ply][move_point]  =e8;               
          move_to[ply][move_point++]=c8;
         }
     
 
//frc-jn - change this as above.....
     
         
      if (  chess_variant == fischerandom and  p[ply].b_o_o_o  equal allowed
          and sq[d8]           equal sq_empty
          and sq[c8]           equal sq_empty
          and sq[b8]           equal sq_empty
          and attack_w_min[e8] equal w_k + 1
          and attack_w_min[d8] equal w_k + 1
          and attack_w_min[c8] equal w_k + 1)
         {
          
         if (sq[b8] equal b_k) move_fr[ply][move_point] =b8;
         if (sq[c8] equal b_k) move_fr[ply][move_point] =c8;
         if (sq[d8] equal b_k) move_fr[ply][move_point] =d8;
         if (sq[e8] equal b_k) move_fr[ply][move_point] =e8;
         if (sq[f8] equal b_k) move_fr[ply][move_point] =f8;
         if (sq[g8] equal b_k) move_fr[ply][move_point] =g8;        
                         
          move_to[ply][move_point++]=c8;
         }


              
    
    
}  
    
    
    
    
g_m_exit:
;
  }
  

void clear_board()
  {signed char w1_char, w2_char, w3_char;
   for (w1_char=0; w1_char<120; w1_char++)
     {
         sq[w1_char]=sq_illegal;
         sq120_to_koordinat(&w1_char, &w2_char, &w3_char);
         if (w2_char>=1 and w2_char<=8 and w3_char>=1 and w3_char<=8)
             sq[w1_char]=sq_empty;
     }
  }

void turn_sqavoid_false()
  {int x;
   if (checking_direction1 != 0)
      {for (x=sq_checking_man; x != sq_checked_king; x+=checking_direction1)
        sq_avoid_check[x]=false;
      }
  }




void make_move_array()
  {
   int x;
   gen_moves_mode=move_and_attack;
   generate_moves();

   turn_sqavoid_false();

/* fatal error hvis der er overflow i move array..... */
   mobilitet[ply]=move_point; realmoves[ply]=move_point;
   {     if (move_point>32);
    else if (move_point>16) sel_delay[ply] += 1;
    else if (move_point> 8) sel_delay[ply] += 2;
    else if (move_point> 4) sel_delay[ply] += 6;
    else if (move_point> 2) sel_delay[ply] += 12;
    else                    sel_delay[ply] += 18;
   }
   move_fr[ply][ move_point]=stop;
   move_pointer[ply]=0;
   if (move_point>0)
     {if ( wh_bl equal black) b_prevalue_moves(); else w_prevalue_moves();}
  }

void make_only_attack()
  {/* trkgeneratoren kres igennem, men kun attack-arrayet dannes */
   signed char x;
   checking_direction1=0; checking_direction2=0;
   gen_moves_mode=only_attack;
   generate_moves();
   if (checking_direction1 != 0)
     {for (x=sq_checking_man; x != sq_checked_king; x+=checking_direction1)
       sq_avoid_check[x]=true;
     }
  }


void get_solution(signed char w3_char)
 
 /*er det en teststilling lses lsningen (som f.eks. er Qe8xNh5+!).
   Felterne fra og til (e8 og h5) findes ved at finde cifrene (8 og 5).
   Trkket omformes til internt format (solution_fr=95 og to=68).
   Forvandling kan ikke hndteres endnu og er sikkert ikke ndvendig.
*/

  {signed char file_x, row_x;
   solution_fr=false; solution_to=false;
   for (solution_mark='!'; w3_char<81; ++w3_char){
       
       if (xxx[w3_char] equal '?') {
                        solution_mark='?';
                        }
       
       else {
            if (xxx[w3_char] != ' ')
               {if (xxx[w3_char] >='1' and xxx[w3_char] <='8')
                  {file_x = file_x - 'a' + 1;
                   row_x = xxx[w3_char] - '1' + 1;
                   if (solution_fr equal false)
                         solution_fr = (10 + (10 * row_x)) + file_x;
                   else  solution_to = (10 + (10 * row_x)) + file_x;
                  }
                else file_x = xxx[w3_char];
               }
            }
       if ((xxx[w3_char] equal '\n') or
           (xxx[w3_char] equal '\0') or
           (xxx[w3_char] equal ' ' and solution_to != false))
          w3_char=99;
      }
  }


void remove_move(int x)
{   

   r:

    move_to   [0][x]=move_to   [0][x+1];
    move_fr   [0][x]=move_fr   [0][x+1];
    move_value[0][x]=move_value[0][x+1];
    if (move_fr[0][x] != stop) {++x; goto r;}
}



void set_pb_guessmove_last()
{   int x, y; signed char wchar;
    x=find_move_index(&pb_move_fr, &pb_move_to);
    y=mobilitet[0]-1;
    wchar=move_fr[0][y]; move_fr[0][y]=move_fr[0][x]; move_fr[0][x]=wchar;
    wchar=move_to[0][y]; move_to[0][y]=move_to[0][x]; move_to[0][x]=wchar;
}

void gen_moves_ply_zero()
{  signed char gemply=ply;  // slettes?     ingen effekt - stadig slag
   ply=0;

   move_pointer[0]=0;
   change_black_white();
   make_only_attack();
   change_black_white();
   make_move_array();
   if ( (wh_bl equal black and attack_b_min[sqwk]>=b_k) or
        (wh_bl equal white and attack_w_min[sqbk]<=w_k)
      )
        king_in_check[0]=true;
   else king_in_check[0]=false;
   sel_delay[0]=0;
   ply=gemply;              // slettes?     ved ply 0 i mate-search.....
   if (pb_on equal true/* and iteration>0*/) set_pb_guessmove_last();
}

void initialize_best_score()
{int x;
 
   most_recent_best_score=best_score[0];
   for (x=0;x<=max_ply; x++)
 
    {if ((wh_bl equal white and x % 2 equal 0)   or
        (wh_bl equal black and x % 2 equal 1))
     {start_best_score[x]=(int_min + x);
      mate_score[x]=(int_min + x);}
    else
     {start_best_score[x]=(int_max - x);
      mate_score[x]=(int_max - x);}

    if (iteration equal 0 and x % 2 equal 0)
       start_best_score[x] = w_materiel[0]-b_materiel[0]+wh_bl*30;
    if (matesearch_score equal no_good_found)
         best_score[0]=start_best_score[0];
    else {best_score[0]=matesearch_score;}
   }
   mms[0]=start_best_score[0];
}

void nulstil()
{  signed char x;
   p[0].pawnchange=false;
   for (x=a1; x<=h8; sq_avoid_check[x++]=false);
   for (x=a1; x<=h8; ++x)
      {attack_w_nul[x]=w_k+1; attack_b_nul[x]=b_k-1;}
   ply=0; ply_1=-1; mate_ply=-1;
   calculate_hashkey();
   p[0].hash_idx=uli_idx; p[0].hash_id=uli_id;
}

void roll_entries()
 {   int x=0;
  for (; x<game_pointer; ++x)
     {game_id[x]=game_id[x+1]; game_idx[x]=game_idx[x+1];}
 }

void store_hash_for_3xrepeat()
 {
  if (game_pointer<GAME_MAXINDEX) ++game_pointer;
  else                            roll_entries();
  game_id[game_pointer]=p[0].hash_id; game_idx[game_pointer]=p[0].hash_idx;
 }

void make_array_ply_zero()
// reads an epd-position...........................................................
  {signed char w1_char, w2_char, w3_char, x;
   if (disctrace equal true) fprintf(fp,"%s ",xxx);
   strcpy(gem_xxx,xxx);
   clear_board();
   zero_to_pili(piliwp, w_p); zero_to_pili(pilibp, b_p);
   zero_to_pili(piliwn, w_n); zero_to_pili(pilibn, b_n);
   zero_to_pili(piliwb, w_b); zero_to_pili(pilibb, b_b);
   zero_to_pili(piliwr, w_r); zero_to_pili(pilibr, b_r);
   zero_to_pili(piliwq, w_q); zero_to_pili(pilibq, b_q);
 
   p[0].w_o_o=allowed; p[0].w_o_o_o=allowed;
   p[0].b_o_o=allowed; p[0].b_o_o_o=allowed;
   p[0].e_p=not_allowed; p[0].draw50=0; p[0].swnullhash=0;
   w3_char=0;sqwk=0;sqbk=0; mpc=0;
   for (w1_char=a8; w1_char>=a1; w1_char=w1_char - 10)
     {w2_char=w1_char;
      if (xxx[w3_char] equal '/') w3_char++;
      do
       {
              if (xxx[w3_char] equal 'k' or xxx[w3_char] equal 'u')
            {sq[w2_char]=b_k; ++w3_char; sqbk=w2_char; ++w2_char;}
         else if (xxx[w3_char] equal 'K' or xxx[w3_char] equal 'U')
            {sq[w2_char]=w_k; ++w3_char; sqwk=w2_char; ++w2_char;}
         else if (xxx[w3_char] equal 'q')
            {sq[w2_char]=b_q; ++w3_char; ++w2_char;}
         else if (xxx[w3_char] equal 'Q')
            {sq[w2_char]=w_q; ++w3_char; ++w2_char;}
         else if (xxx[w3_char] equal 'r')
            {sq[w2_char]=b_r; ++w3_char; ++w2_char;}
         else if (xxx[w3_char] equal 'R')
            {sq[w2_char]=w_r; ++w3_char; ++w2_char;}
         else if (xxx[w3_char] equal 's')
            {sq[w2_char]=b_r; ++w3_char;                    
             if (w2_char equal a8) p[0].b_o_o_o=not_allowed; //frc-jn - ok?!? - hmmmmmmm.....
             else
             if (w2_char equal h8) p[0].b_o_o=not_allowed;
           
             ++w2_char;
            }
         else if (xxx[w3_char] equal 'S')
            {sq[w2_char]=w_r; ++w3_char;                    
             if (w2_char equal a1) p[0].w_o_o_o=not_allowed;
             else
             if (w2_char equal h1) p[0].w_o_o  =not_allowed;
              
             ++w2_char;
            }
         else if (xxx[w3_char] equal 'n' or xxx[w3_char] equal 'h' or
                  xxx[w3_char] equal 'm')
            {sq[w2_char]=b_n; ++w3_char; ++w2_char;}
         else if (xxx[w3_char] equal 'N' or xxx[w3_char] equal 'H' or
                  xxx[w3_char] equal 'M')
            {sq[w2_char]=w_n; ++w3_char; ++w2_char;}
         else if (xxx[w3_char] equal 'b')
            {sq[w2_char]=b_b; ++w3_char; ++w2_char;}
         else if (xxx[w3_char] equal 'B')
            {sq[w2_char]=w_b; ++w3_char; ++w2_char;}
         else if (xxx[w3_char] equal 'p')
            {sq[w2_char]=b_p; ++w3_char; ++w2_char;}
         else if (xxx[w3_char] equal 'P')
            {sq[w2_char]=w_p; ++w3_char; ++w2_char;}
         else if (xxx[w3_char]>='1' and xxx[w3_char]<='8')
            {
             --xxx[w3_char]; ++w2_char;}
         else if (xxx[w3_char] equal '0'
                  or xxx[w3_char] equal '/' or xxx[w3_char] equal ' '
                  
       
                  )
            {
            ++w3_char;}
  
       }
         while (xxx[w3_char] != '/' and xxx[w3_char] != ' '
                and w3_char<81);        
     }

 /* mangler: check at der er en hvid og sort konge */

     if (xxx[++w3_char] equal 'b')
        wh_bl = black;
     else
        wh_bl = white;
     intern=wh_bl;
   // FRC
   if (chess_variant !=fischerandom) {
   if (sq[a8] != b_r or sq[e8] != b_k)
      p[0].b_o_o_o = not_allowed;
   if (sq[h8] != b_r or sq[e8] != b_k)
      p[0].b_o_o   = not_allowed;
   if (sq[a1] != w_r or sq[e1] != w_k)
      p[0].w_o_o_o = not_allowed;
   if (sq[h1] != w_r or sq[e1] != w_k)
      p[0].w_o_o   = not_allowed;
   }

   w_materiel[0]=0; b_materiel[0]=0;
   for (w1_char=a1; w1_char<=h8; ++w1_char)
       {sq120_to_koordinat(&w1_char, &tablin[w1_char], &tabrow[w1_char]);
        if (sq[w1_char]<=b_p) b_materiel[0] += men_value[sq[w1_char] * -1];
        if (sq[w1_char]>=w_p) w_materiel[0] += men_value[sq[w1_char]     ];
        {     if (sq[w1_char] equal w_k) sqwk=w1_char;
         else if (sq[w1_char] equal b_k) sqbk=w1_char;
         else if (sq[w1_char]>=w_p or sq[w1_char]<=b_p)
                 add_pili(&w1_char, &sq[w1_char]);
        }
       }

   if (!xboard) get_solution(w3_char);

   nulstil();  game_pointer=-1; store_hash_for_3xrepeat();
   pb_move_ready=false; startmovetime=henttid();
  }

void print_pc_speed()
{   printf("\nPC-timetest (50.00 = 50 mhz 486):%5.2f ", pctid);
    printf("\nPC-speedfactor (10 = 50 mhz 486): %d ", speedfactor);
    if (pctid <= 0) // happens sometimes, but no pc is that fast...
          {printf("\n\n\n\nPC-timetest failed - leave Dabbaba and restart.\n");
    }
}

void pc_speed()
{  long int x;
   if (speedfactor>0) return;
   printf("running PC-speedtest...");
   pctid=henttid();
   for(x=0;x<545;++x) {make_array_ply_zero();};
   pctid=henttid()-pctid; if (pctid equal 0) pctid=1;
   speedfactor=((5000/pctid)+5)/10;  // 50 is time used on a 50mhz 486
   print_pc_speed();
}

void p99_seconds_used()
{

   sprintf(p99,"\ntime: white:%6.2f black:%6.2f %s",
          wtid, btid, happens);
          
          if (ponder_on) {
          ponder_move();
          }  
          
}

void show_seconds_used()
{  p99_seconds_used(); printf(p99);}

void init_hash()
{  long unsigned int qqq;
   hash.hash_id=0; hash.hash_idx=0; hash.hash_fr=0; hash.hash_to=0;
   hash.hash_depth=-99; hash.hash_score_final=false;
   hash.hash_mpc=0; hash.hash_ply=99; // hash.hash_score=30222;
///*
   for (qqq=0; qqq<=hash_maxindex; ++qqq)
    { 
     write_hash(qqq);
    }
}

void store_pb_pos()
{  memcpy(sq+h8+22, sq+a1, 78); }

void new_game()
{  
     my_best_score = best_score[0];
     if (intern == black) my_best_score *=-1;
   
     if (my_best_score > 29999 || my_best_score < -29999) {
     printf("\ncomputer mates\n");  
     }else{
     printf("\n\nReady for a new game now...\n\n");
     }      
   
   init_hash();
   
    if (!use_setboard) {
   
    // normal chess starting position
   strcpy(xxx,"rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR/w"); 
   
   if (shatranj_variant) {
   strcpy(xxx,"rnbkqbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBKQBNR/w");
   }else
   if (knightmate_variant) {
   strcpy(xxx,"rmbqubmr/pppppppp/8/8/8/8/PPPPPPPP/RMBQUBMR/w"); 
   }else
   if (nightrider_variant) {
   strcpy(xxx,"rhbqkbhr/pppppppp/8/8/8/8/PPPPPPPP/RHBQKBHR/w");                                                   
}

   make_array_ply_zero(); 
} 
 //  show_board();
   printf("\n");
   pc_speed();
   startmateriel=w_materiel[0]+b_materiel[0]-two_kings;
   
   if (save_games equal true){
         fprintf(pgn,"\n");
        
         if (evermoves_160 equal 160) {
         p99_seconds_used(); 
         fprintf(pgn,p99);
         }

       fprintf(pgn,"\n\n[Event \"x\"]\n");
      }
   wtid=0; btid=0; pb_move_fr=d2; pb_move_to=d4; pb_move_ready=true;
   store_pb_pos(); sq[d2+99]=sq_empty; sq[d4+99]=w_p;
}

void print_vurdering(int vu_rd)
{  if (vu_rd<(int_min+100)) vu_rd=vu_rd * -1;
   if   (vu_rd < (int_max - 100)) printf(" score: %d",vu_rd);
       

   else printf(" mate in %d",(1 + ((int_max - vu_rd) / 2)));

}

void line_with_numbers()
{ 
     
      printf("\n12345678901234567890123456789012345678901234567890");
     }

void print_line() /* udskriver en variant */
  {signed char fedtmule, fr, to, *nora, to_9_10_11, promote_piece, prom;
   printf("\n");
   if (filtrace equal false and info_out equal 1) printf("\n");
   if (filtrace equal true) printf("%6.0f ",tv_nodes);
 
   for (fedtmule=0; fedtmule<ply; ++fedtmule)
      {fr=move_fr[fedtmule][ move_pointer[fedtmule]];
       to=move_to[fedtmule][ move_pointer[fedtmule]];
       if (full_line equal 1 or
           fr!=prt_fr[fedtmule] or
           to!=prt_to[fedtmule] or
           fedtmule equal ply_1)
        {nora=&move_fr_before[fedtmule];
         print_kqrbnp(*nora);
         print_a1_h8(&fr);
         
         if (!xboard) {
         if (move_to_before[fedtmule] equal sq_empty) 
         printf("-");         
         else                                         printf("x"); /* e.p. */
         }
         
         if (gem_sel_vurd[fedtmule] equal 30111) prom=' ';
         else                                    prom='s';
         if (to>h8)
           {unpack_promotion(&to, &to_9_10_11, &promote_piece);
            if (*nora>=w_p) to=fr + to_9_10_11;
            if (*nora<=b_p) to=fr - to_9_10_11;
            prom=men_letter[promote_piece];
           }
         else
           {
            if (king_in_check[fedtmule+1] equal true)
               {if (prom equal ' ') prom='+';
                else                prom='$';
               }
           }
         print_a1_h8(&to);
         printf("%c ",prom);
         prt_fr[fedtmule]=fr;
         prt_to[fedtmule]=to;
        }
       else printf("        ");
      }
   if (filtrace equal true) ++full_line;
   if (full_line equal 10) full_line=1;
   print_vurdering(best_score[ply]);

   if (run_test==true and magic!=13)
     {line_with_numbers();printf("\n%s",solution_xxx);}
  }

int sbauerbewertung(int feld,int reihe, int linie)
{
/*--------------------------------------------------------------------*/
/*- Bewertung eines schwarzen Bauern. Neben den Parameter muessen    -*/
/*- auch die Bauernkontrollen, Bauernlinien und Turmlinien richtig   -*/
/*- belegt sein.                                                     -*/
/*- Gibt die Bewertung aus der Sicht von Schwarz zurueck.            -*/
/*--------------------------------------------------------------------*/
   int wert=0,j;

   reihe = 9-reihe;  /* Reihe umdrehen. Hoehere Reihe ist */
                                     /* damit wie bei WEISS besser.       */
//   if(MatSumme[Tiefe]>ENDSPIELMATERIAL) { /* Eroeffnung oder Mittelspiel */
//      wert=sBFeldWert[feld];
//      /* Entwicklung nicht abgeschlossen. Stosse Randbauern nicht vor */
//      if((entwickelt<4) and ((linie>=F_LINIE)||(linie<=B_LINIE))  and
//         (reihe>REIHE_3)) {  /* reihe wurde umgedreht. */
//         wert = wert - 15;
//      }
//   }
//   else {  /* Im Endspiel sind alle Linien gleich gut. Bringe Bauern nach */
//           /* vorne.                                                      */
//      wert = reihe*4;
//   }
   /**
   *** Ist Bauer ein Isolani ?
   *** Randbauern brauchen nicht extra behandelt werden. Bauern[A_LINIE-1] ist
   *** linker Rand, Bauern[H_LINE+1] rechter Rand. Auf beiden Raendern steht
   *** kein Bauer.
   **/


   if (materiel_10_0<5) wert -= reihe*6*(10-materiel_10_0)/10;
  

   if((sbauern[linie-1]==0) and (sbauern[linie+1]==0)) {
      wert += 10;  /* Isolani */
      if(sbauern[linie]>1) { /* Isolierter Doppelbauer. */
         wert += 3;  // before 12
      }
   }
   if(sbauern[linie]>1) { /* Doppelbauer */
      wert += 4;  // 15---->5    29 sep.
   }
   /* Duo oder unterstuetzter Bauer bekommt Bonus */
   /* Z.B. e5,d5 ist Duo, d6 unterstuetzt e5 */
//                  attack_w_min[to]>=w_p
   if((attack_b_min[feld]==b_p) or (attack_b_min[feld-10]==b_p)) {
      wert -= reihe ;
   }

   /* Rueckstaendiger Bauer wird nicht von eigenen gestuetzt und  */
   /* kann nicht nach vorne, weil gegnerische Bauern Feld vor ihm */
   /* kontrollieren.                                              */
   if (attack_b_min[feld] != b_p
       and attack_b_min[feld-10] != b_p and attack_b_min[feld+10] != b_p)
      {
      wert += 15;
      if ((attack_w_min[feld-10] equal w_p)   or
          (attack_w_min[feld-20] equal w_p and attack_b_min[feld-20] != b_p)
         )
         {wert += 25;
          if (wbauern[linie]==0)
             {wert += 15; // *** rook part 1.sa ***
              if (piliwr[1]>0 and tablin[piliwr[1]] equal linie)
                 wert+=15;
              if (piliwr[0]>0 and tablin[piliwr[0]] equal linie)
                 wert+=15;
             }
         }
    
      if(wbauern[linie]==0) { /* Halboffene Linie */
         if (piliwr[1]>0 and tablin[piliwr[1]] equal linie)
             wert+=12;    // *** rook part 1.sb ***
         if (piliwr[0]>0 and tablin[piliwr[0]] equal linie)
             wert+=12;


      }
   }

      if(wbauern[linie]==0) { /* Halboffene Linie */
         /*
         ** Bauer ist Freibauer, wenn auf halboffenen Linie und die
         ** weiteren Felder auf seiner Linie nicht von gegnerischen
         ** Bauern kontrolliert werden.
         */
         for(j=feld;j>h2;j-=10) {
            if(attack_w_min[j] equal w_p) {
               goto fertig;
            }
         }
         /* Freibauer gefunden. Im Endspiel ist Freibauer wichtiger als */
         /* im Mittelspiel. */
          
            wert -= first_pp_value; first_pp_value=first_pp_value / 3;
            wert -= (reihe*30*(10-materiel_10_0)/10); /* Je weiter vorne, desto besser */
            if (reihe equal 5) wert -= 10; 
            if (reihe >     5) wert -= 18;            
  
            if((attack_b_min[feld]==b_p) or
               (attack_b_min[feld-10]==b_p)) { /* Unterstuetzter Freibauer */
               wert -= reihe*5*(10-materiel_10_0)/10;
            }
            /* Freibauer von weisser Figur blockiert. Figur wird auch */
            /* nicht von eigenen Bauern bedroht.                      */
            if((sq[feld-10]>=w_p) and (attack_b_min[feld-10]!=b_p)) 
               {wert+= reihe*20*(10-materiel_10_0)/10;               
               }
// rook part x - black
            if (pilibr[0]>0 and tablin[pilibr[0]] equal linie) 
               {wert-=reihe*8*(10-materiel_10_0)/10;
               }
            if (pilibr[1]>0 and tablin[pilibr[1]] equal linie) 
               {wert-=reihe*8*(10-materiel_10_0)/10;
               } 
            if (piliwr[0]>0 and tablin[piliwr[0]] equal linie) 
               {wert+=reihe*8*(10-materiel_10_0)/10;
               }  
            if (piliwr[1]>0 and tablin[piliwr[1]] equal linie) 
               {wert+=reihe*8*(10-materiel_10_0)/10;
               }  
               
          fertig:
          return wert;                      
         
      }
      return true;
   }



int wbauerbewertung(int feld,int reihe, int linie)
{
   int wert=0,j;

   if (materiel_10_0<5) wert += reihe*6*(10-materiel_10_0)/10;

   
   if((wbauern[linie-1]==0) and (wbauern[linie+1]==0)) {
      wert -= 10;  /* Isolani */
      if(wbauern[linie]>1) { /* Isolierter Doppelbauer. */
         wert -= 3;   // before 12
      }
   }
   if(wbauern[linie]>1) { /* Doppelbauer */
      wert -= 4;     
   }
   /* Duo oder unterstuetzter Bauer bekommt Bonus */
   /* Z.B. e5,d5 ist Duo, d6 unterstuetzt e5 */
//                  attack_w_min[to]>=w_p
   if((attack_w_min[feld]==w_p) or (attack_w_min[feld+10]==w_p)) {
      wert += reihe;
   }

   /* Rueckstaendier Bauer  */
   /* Rueckstaendiger Bauer wird nicht von eigenen gestuetzt und  */
   /* kann nicht nach vorne, weil gegnerische Bauern Feld vor ihm */
   /* kontrollieren.                                              */

   if (attack_w_min[feld] != w_p
       and attack_w_min[feld+10] != w_p and attack_w_min[feld-10] != w_p)
      {
      wert -= 15;
      if ((attack_b_min[feld+10] equal b_p)   or
          (attack_b_min[feld+20] equal b_p and attack_w_min[feld+20] != w_p)
         )
         {wert -= 25;
          if (sbauern[linie]==0)
             {wert -= 15; // *** rook part 1.wa ***
              if (pilibr[0]>0 and tablin[pilibr[0]] equal linie)
                 wert-=15;
              if (pilibr[1]>0 and tablin[pilibr[1]] equal linie)
                 wert-=15;
             }
         }
   
      if (sbauern[linie]==0) { /* Halboffene Linie */
         if (pilibr[0]>0 and tablin[pilibr[0]] equal linie)
              wert-=12; // *** rook part 1.wb ***
         if (pilibr[1]>0 and tablin[pilibr[1]] equal linie)
              wert-=12;


      }
   }
      
      if(sbauern[linie]==0) { /* Halboffene Linie */
         /*
         ** Bauer ist Freibauer, wenn auf halboffenen Linie und die
         ** weiteren Felder auf seiner Linie nicht von gegnerischen
         ** Bauern kontrolliert werden.
         */
         for(j=feld;j<a7;j+=10) {
            if(attack_b_min[j] equal b_p) {
               goto fertig;
            }
         }
         /* Freibauer gefunden. Im Endspiel ist Freibauer wichtiger als */
         /* im Mittelspiel. */
          
            wert += first_pp_value; first_pp_value=first_pp_value / 3;
            wert += (reihe*30*(10-materiel_10_0)/10); /* Je weiter vorne, desto besser */
            if (reihe equal 5) wert += 10; 
            if (reihe >     5) wert += 18;            
   
            if((attack_w_min[feld]==w_p) or
               (attack_w_min[feld+10]==w_p)) { /* Unterstuetzter Freibauer */
               wert += reihe*5*(10-materiel_10_0)/10;
            }
            /* Freibauer von schwarzer Figur blockiert. Figur wird auch */
            /* nicht von eigenen Bauern bedroht.                      */
            if((sq[feld+10]<=b_p) and (attack_w_min[feld+10]!=w_p)) 
               {wert-= reihe*20*(10-materiel_10_0)/10;               
               }
// rook part x - white
            if (pilibr[0]>0 and tablin[pilibr[0]] equal linie) 
               {wert-=reihe*8*(10-materiel_10_0)/10;
               }
            if (pilibr[1]>0 and tablin[pilibr[1]] equal linie) 
               {wert-=reihe*8*(10-materiel_10_0)/10;
               } 
            if (piliwr[0]>0 and tablin[piliwr[0]] equal linie) 
               {wert+=reihe*8*(10-materiel_10_0)/10;
               }  
            if (piliwr[1]>0 and tablin[piliwr[1]] equal linie) 
               {wert+=reihe*8*(10-materiel_10_0)/10;
               }                   
        
         fertig:
             return wert;
         
      }
   return true;
   }
   
   


void init_bewertung(void)
{
   int i, x;


   // Raender mit initialisieren. Damit braucht man bei Randlinien nicht
   // extra abfragen.

   for(i=0;i<=9;++i) {                  
      wbauern[i]=0; sbauern[i]=0;

   }

   for (x=0; piliwp[x]>0; ++x) ++wbauern[tablin[piliwp[x]]];
   for (x=0; pilibp[x]>0; ++x) ++sbauern[tablin[pilibp[x]]];

   return;
}





int how_open(signed char *rooksq)
{  int x=0, wsq;
   wsq=*rooksq+10;
a: if (sq[wsq] equal sq_empty) {++x; wsq+=10; goto a;}
   wsq=*rooksq-10;
b: if (sq[wsq] equal sq_empty) {++x; wsq-=10; goto b;}
   return x*4;
}

int bewerte_stellung(/*int alpha,int beta,int seite*/)
{
   int wert,/*huskposwert,*/poswert,i,j,k,feld, q, p /*,wlaeufer,slaeufer*/;
   int buhhh;
   signed char x /*,f*/;

   /* Positionelle Bewertungsfaktoren wiegen starkes Materialungleichgewicht */
   /* nicht auf. Daher wird in diesem Fall auf Positionsbewertung verzichtet */
   /* Ausnahme: Spaetes Endspiel. Freibauern haben hohe Bewertung.           */
   /*           Leichtfigur ohne Bauern ist wirkungslos.                      */

                                              //        wert=0;

   /*
   ** Initialisiere die Turm und Bauernlinien und die Bauernkontrollen.
   ** Das koennte man wesentlich schneller auch bei der Ausfuehrung (und
   ** der Zuruecknahme) von  Zuegen inkrementell berechnen. Allerdings ist
   ** diese inkrementelle Berechnung auch wegen der Spezialfaelle Rochade,
   ** Enpassant und Umwandlung laestig und fehleranfaellig.
   ** Koennte auch in init_bewertung Figurenliste aufbauen und dann in
   ** der zweiten Runde diese Figurenliste durchgehen (und nicht mehr
   ** das gesamte Brett).
   ** Die schnellste Loesung besteht darin, auch diese Figurenliste
   ** inkrementell zu berechnen. Allerdings werden dann die Funktionen



   ** 'zugausfuehren' und zugzuruecknehmen' noch komplizierter.
   ** Nach dem KISS (Keep It Simple und Stupid) Prinzip wurde in MiniMAX
   ** diese Loesung gewaehlt.
   */
   init_bewertung();
   poswert=0;           buhhh=0;



   first_pp_value=50;
   for (x=0; piliwp[x]>0; ++x)
      {p=poswert; ++buhhh; poswert+=wbauerbewertung(piliwp[x],
                                           tabrow[piliwp[x]],
                                           tablin[piliwp[x]]);
       if (pawninfo equal true)
              {print_a1_h8(&piliwp[x]); printf(":%d    ",poswert-p);}
      }
   first_pp_value=50;
   for (x=0; pilibp[x]>0; ++x)
      {p=poswert; ++buhhh; poswert+=sbauerbewertung(pilibp[x],
                                           tabrow[pilibp[x]],
                                           tablin[pilibp[x]]);
       if (pawninfo equal true)
              {print_a1_h8(&pilibp[x]); printf(":%d    ",poswert-p);}
      }




// *** rook part 2 ***
   if (pilibr[0]>0 and sbauern[tablin[pilibr[0]]]==0)
       {if (wbauern[tablin[pilibr[0]]]==0) poswert-=(20+how_open(&pilibr[0]));
        else poswert-=10;}
   if (pilibr[1]>0 and sbauern[tablin[pilibr[1]]]==0)
       {if (wbauern[tablin[pilibr[1]]]==0) poswert-=(20+how_open(&pilibr[1]));
        else poswert-=10;}
   if (piliwr[0]>0 and wbauern[tablin[piliwr[0]]]==0)
       {if (sbauern[tablin[piliwr[0]]]==0) poswert+=(20+how_open(&piliwr[0]));
        else poswert+=10;}
   if (piliwr[1]>0 and wbauern[tablin[piliwr[1]]]==0)
       {if (sbauern[tablin[piliwr[1]]]==0) poswert+=(20+how_open(&piliwr[1]));
        else poswert+=10;}


   poswert=(poswert*wpawn)/8; q=abs(poswert);

   if (q>maxpawn)         maxpawn=q;



   if (q>limitpawnscore) {limitpawnscore=q; ++pawnexceed;}
   ++totalexcd;
   return poswert;

}

int opening()
{ int z;
             
z=0;   // playing style dropped .... jn2008



/* BLACK */
  if (pilibq[0]!=0 and (pilibq[0]>h5 or pilibq[0]==a5)) z-=(4*black_8);
  if (sq[a6] equal b_n or sq[h6] equal b_n or sq[a5] equal b_n or
      sq[h5] equal b_n) z+=25;
  if (sq[e6] equal b_p and sq[c8] equal b_b and sq[b7] equal b_p) z+=20;
  if (sq[d6] equal b_p and sq[f8] equal b_b and sq[g7] equal b_p) z+=20;
  if (sq[e7] != b_p) z-=10;
  if (sq[d7] != b_p) z-=10;
  if (sq[c7] != b_p) z-=5;
  if (sq[a7] equal b_p) z-=10;
  if (sq[h7] equal b_p) z-=10;

  if (sq[g7] equal b_b and sq[g6] equal b_p) z-=8;
  if (sq[b7] equal b_b and sq[b6] equal b_p) z-=5;

  if (sq[g8] != b_n) z-=33;
  if (sq[b8] != b_n) z-=23;
  if (sq[f8] != b_b) z-=17;
  if (sq[c8] != b_b) z-=14;

  if (sq[f8] equal b_b and sq[g7] == b_p and sq[e7] != sq_empty) z+=30;
  if (sq[c8] equal b_b and sq[b7] == b_p and sq[d7] != sq_empty) z+=20;
  if (sq[e7] equal b_p and sq[e6] != sq_empty) z+=25;
  if (sq[d7] equal b_p and sq[d6] != sq_empty) z+=25;
  if (sq[c7] equal b_p and sq[c6] != sq_empty
      and sq[d5] equal b_p and sq[d4] equal w_p) z+=11;
  if (pilibr[0]!=0 and pilibr[0]<a7) z+=20;
  if (pilibr[1]!=0 and pilibr[1]<a7) z+=20;

/* WHITE */
  if (piliwq[0]!=0 and piliwq[0]<b4) z+=(4*black_8);
  if (sq[a3] equal w_n or sq[h3] equal w_n or sq[a4] equal w_n or
      sq[h4] equal w_n) z-=25;
  if (sq[e3] equal w_p and sq[c1] equal w_b and sq[b2] equal w_p) z-=20;
  if (sq[d3] equal w_p and sq[f1] equal w_b and sq[g2] equal w_p) z-=20;
  if (sq[e2] != w_p) z+=10;
  if (sq[d2] != w_p) z+=10;
  if (sq[c2] != w_p) z+=5;
  if (sq[a2] equal w_p) z+=10;
  if (sq[h2] equal w_p) z+=10;


  if (sq[g2] equal w_b and sq[g3] equal w_p) z+=8;
  if (sq[b2] equal w_b and sq[b3] equal w_p) z+=5;

  if (sq[g1] != w_n) z+=33;
  if (sq[b1] != w_n) z+=23;
  if (sq[f1] != w_b) z+=17;
  if (sq[c1] != w_b) z+=14;

  if (sq[f1] equal w_b and sq[g2] == w_p and sq[e2] != sq_empty) z-=30;
  if (sq[c1] equal w_b and sq[b2] == w_p and sq[d2] != sq_empty) z-=20;
  if (sq[e2] equal w_p and sq[e3] != sq_empty) z-=25;
  if (sq[d2] equal w_p and sq[d3] != sq_empty) z-=25;
  if (sq[c2] equal w_p and sq[c3] != sq_empty
      and sq[d4] equal w_p and sq[d5] equal b_p) z-=11;
  if (piliwr[0]!=0 and piliwr[0]>h2) z-=20;
  if (piliwr[1]!=0 and piliwr[1]>h2) z-=20;

  // black + white

      {
             if (sq[e7] != b_p and sq[e6] != b_p) z-=(4+2*black_8);
             if (sq[d7] != b_p and sq[d6] != b_p) z-=(4+2*black_8);
             if (sq[e2] != w_p and sq[e3] != w_p) z+=(4+2*black_8);
             if (sq[d2] != w_p and sq[d3] != w_p) z+=(4+2*black_8);
             if (piliwn[1]>0 and tabrow[piliwn[1]]<4) z+=(black_8-2);
             if (piliwn[0]>0 and tabrow[piliwn[0]]<4) z+=(black_8-2);
             if (pilibn[1]>0 and tabrow[pilibn[1]]>5) z-=(black_8-2);
             if (pilibn[0]>0 and tabrow[pilibn[0]]>5) z-=(black_8-2);

             if (sq[e4]==w_p and sq[d4]==w_p) z+=(10+black_8);
             if (sq[c4]==w_p and sq[d4]==w_p) z+=(4+black_8);
             if (sq[e5]==b_p and sq[d5]==b_p) z-=(10+black_8);
             if (sq[c5]==b_p and sq[d5]==b_p) z-=(4+black_8);


             if (sq[e6]==b_p and (sq[d7]==b_b or sq[c8]==b_b)) z+=black_8;
             if (sq[e3]==w_p and (sq[d2]==w_b or sq[c1]==w_b)) z-=black_8;

             if ((sq[d5]==w_p or sq[d5]==b_p) and
                 (sq[c4]==w_b or sq[b3]==w_b)) z-=(black_8-2);
             if ((sq[e5]==w_p or sq[e5]==b_p) and
                 (sq[f4]==w_b or sq[g3]==w_b)) z-=(black_8-2);
             if ((sq[d4]==b_p or sq[d4]==w_p) and
                 (sq[c5]==b_b or sq[b6]==b_b)) z+=(black_8-2);
             if ((sq[e4]==b_p or sq[e4]==w_p) and
                 (sq[f5]==b_b or sq[g6]==b_b)) z+=(black_8-2);

             if (sq[b7]==b_b and
                 (sq[c6]==b_p or sq[d5]==b_p or sq[d5]==w_p)) z+=black_8;
             if (sq[g7]==b_b and
                 (sq[f6]==b_p or sq[e5]==b_p or sq[e5]==w_p)) z+=black_8;
             if (sq[b2]==w_b and
                 (sq[c3]==w_p or sq[d4]==w_p or sq[d4]==b_p)) z-=black_8;
             if (sq[g2]==w_b and
                 (sq[f3]==w_p or sq[e4]==w_p or sq[e4]==b_p)) z-=black_8;


// start new rules jn2008
            if (sq[b1]==w_n and sq[c3]==w_p) z-=black_8;
            if (sq[g1]==w_n and sq[f3]==w_p) z-=black_8;


            if (sq[a1]==w_r and sq[b1] != sq_empty and
                 (sq[a2]==w_p or sq[a3]==w_p)) z-=black_8;
            if (sq[h1]==w_r and sq[g1] != sq_empty and
                 (sq[h2]==w_p or sq[h3]==w_p)) z-=black_8;

            if (sq[e1]==w_k and sq[h4]==w_p) z-=black_8;
            if (sq[e1]==w_k and sq[a4]==w_p) z-=black_8;


            if (sq[b8]==b_n and sq[c6]==b_p) z+=black_8;
            if (sq[g8]==b_n and sq[f6]==b_p) z+=black_8;



            if (sq[a8]==b_r and sq[b8] != sq_empty and
                 (sq[a7]==b_p or sq[a6]==b_p)) z+=black_8;
            if (sq[h8]==b_r and sq[g8] != sq_empty and
                 (sq[h7]==b_p or sq[h6]==b_p)) z+=black_8;

            if (sq[e8]==b_k and sq[h5]==b_p) z+=black_8;
            if (sq[e8]==b_k and sq[a5]==b_p) z+=black_8;


// end new rules jn2008




             if (sq[b5]==w_b and sq[b7]==b_p and sq[c7]==b_p and sq[d7]==b_p)
                if (sq[c6]==b_n) z-=black_8/2;
                else             z-=black_8;
             if (sq[b4]==b_b and sq[b2]==w_p and sq[c2]==w_p and sq[d2]==w_p)
                if (sq[c3]==w_n) z+=black_8/2;
                else             z+=black_8;
             if ((sq[c4]==w_b or sq[b3]==w_b or sq[a2]==w_b) and sq[e6]!=b_p
                  and tablin[sqbk]>4 and sq[d5]!=w_p and sq[d5]!=b_p
                  and sq[c4]!=w_p and sq[c4]!=b_p)  // njagtigere...
                 z+=(black_8*2+4);
             if ((sq[c5]==b_b or sq[b6]==b_b or sq[a7]==b_b) and sq[e3]!=w_p
                  and tablin[sqwk]>4 and sq[d4]!=w_p and sq[d4]!=b_p
                  and sq[c5]!=w_p and sq[c5]!=b_p)
                 z-=(black_8*2+4);
             if ((sq[g5]==w_b or sq[h4]==w_b) and sq[f6]==b_n and
                  (sq[e7]<=b_r or (sq[e7]==sq_empty and sq[d8]<=b_r)))
                  z+=black_8*3;
             if ((sq[g4]==b_b or sq[h5]==b_b) and sq[f3]==w_n and
                  (sq[e2]>=w_r or (sq[e2]==sq_empty and sq[d1]>=w_r)))
                  z-=black_8*3;
             if ((sq[b5]==w_b or sq[a4]==w_b) and sq[c6]==b_n and
                  (sq[d7]<=b_r or (sq[d7]==sq_empty and sq[e8]<=b_r)))
                  z+=black_8*3;
             if ((sq[b4]==b_b or sq[a5]==b_b) and sq[c3]==w_n and
                  (sq[d2]>=w_r or (sq[d2]==sq_empty and sq[e1]>=w_r)))
                  z-=black_8*3;
    
             if (p[ply].w_o_o==allowed and sq[f2]!=w_p)
                {if (sq[h2]==w_p)
                   {if ((sq[f3]==w_p and sq[e4]==w_p) or
                        (sq[f4]==w_p and sq[e3]==w_p) or
                        (sq[f4]==w_p and sq[e5]==w_p)) z-=6;
                    else                               z-=16;
                   }
                 else                                  z-=16;
                }
             if (p[ply].b_o_o==allowed and sq[f7]!=b_p)
                {if (sq[h7]==b_p)
                   {if ((sq[f6]==b_p and sq[e5]==b_p) or
                        (sq[f5]==b_p and sq[e6]==b_p) or
                        (sq[f5]==b_p and sq[e4]==b_p)) z+=6;
                    else                               z+=16;
                   }
                 else                                  z+=16;
                }
             if (p[ply].w_o_o==allowed and sq[g2]!=w_p and sq[g3]!=w_p)
                 {z-=12;
                  if (p[ply].w_o_o_o==not_allowed or
                     (sq[b2]!=w_p and sq[b3]!=w_p) or
                     (sq[c2]!=w_p and sq[c3]!=w_p))
                     z-=12;
                 }
             if (p[ply].b_o_o==allowed and sq[g7]!=b_p and sq[g6]!=b_p)
                 {z+=12;
                  if (p[ply].b_o_o_o==not_allowed or
                     (sq[b7]!=b_p and sq[b6]!=b_p) or
                     (sq[c7]!=b_p and sq[c6]!=b_p))
                     z+=12;
                 }
      }

// old line  return z*wopen/8;
     return z*wopen*black_8/64;   // new line jn2008
}

int king_safety()
{ int k=0, x, sq_king, kinglin;
  
    {sq_king=sqwk; kinglin=tablin[sq_king];
     
     if (chess_variant !=shatranj) {
                                  
     if (sq[sq_king+11]>=w_p) k+=8;
     if (sq[sq_king+10]>=w_p or sq[sq_king+10]==b_p) k+=18;
     if (sq[sq_king+9] >=w_p) k+=8;
     if (sq[sq_king+1] ==w_p) k+=8;
     if (sq[sq_king-1] ==w_p) k+=8;
     if (kinglin equal 1 or kinglin equal 8) k+=12;
     if (sq_king!=e1 and sq[sq_king+1]!=sq_empty and sq[sq_king-1]!=sq_empty)
        k-=12;
     if (kinglin>=5) x=-1; else x=+1;   
     if (sq[sq_king+x] >=w_p) k+=8;
     if (sq[sq_king+x+10] >=w_p) k+=8;
     if (kinglin>=5 and sq[g2]!=w_p and sq[g3]!=w_p) k-=25;
     if (sq_king equal g1 or sq_king equal b1) k+=16;
     else if (sq_king equal e1 and
              (p[ply].w_o_o==allowed or p[ply].w_o_o_o==allowed))  k+=8;
          else if (sq_king equal c1) k+=12;
    }
  
    {sq_king=sqbk; kinglin=tablin[sq_king];
     if (sq[sq_king-11]<=b_p) k-=8;
     if (sq[sq_king-10]<=b_p or sq[sq_king-10]==w_p) k-=18;
     if (sq[sq_king-9] <=b_p) k-=8;
     if (sq[sq_king+1] ==b_p) k-=8;
     if (sq[sq_king-1] ==b_p) k-=8;
     if (kinglin equal 1 or kinglin equal 8) k-=12;
     if (sq_king!=e8 and sq[sq_king+1]!=sq_empty and sq[sq_king-1]!=sq_empty)
        k+=12;
     if (kinglin>=5) x=-1; else x=+1;  
     if (sq[sq_king+x] <=b_p) k-=8;
     if (sq[sq_king+x-10] <=b_p) k-=8;
     if (kinglin>=5 and sq[g7]!=b_p and sq[g6]!=b_p) k+=25;
     if (sq_king equal g8 or sq_king equal b8) k-=16;
     else if (sq_king equal e8 and
              (p[ply].b_o_o==allowed or p[ply].b_o_o_o==allowed))  k-=8;
          else if (sq_king equal c8) k-=12;
    }
}

  return k;
}

int repeat3x_draw()
{
   signed int x=game_pointer-4, y=1;
 r3x:
   if (x<0) return false;
   if (    game_id [game_pointer] equal game_id [x]
       and game_idx[game_pointer] equal game_idx[x])
       {++y; if (y equal 3) return true;}
   x-=2; goto r3x;
}


int all_pawns_on_kingfile(signed char *pilipawn, signed char kinglin)
{  
    
    if (!variant) {
    int x=0;
p: if (tablin[*(pilipawn+x)] != kinglin)
      return false;
   if (*(pilipawn+(++x)) equal 0) return true;
   else                            goto p;
}
return true;
}

int bishops_on_diff_sq_colour(signed char *pilibishop)
{  
    if (!variant) {
    int x0=0, x1=1;
b: if (square_colour(pilibishop+x0) != square_colour(pilibishop+x1))
      return true;
   ++x0; ++x1;  
   if (*(pilibishop+x1) equal 0) return false;
   else                          goto b;
}
return true;
}


int dead_draw()
{ 
    if (!variant) {
    if (b_materiel[ply] <= men_value[w_k] and piliwp[11] equal 0)
    {if (piliwq[11] equal 0 and piliwr[11] equal 0)
        if ((piliwb[11]<=1 and piliwn[11]==0) or
            (piliwb[11]>1 and piliwn[11]==0
             and bishops_on_diff_sq_colour(piliwb) equal false) or
            (piliwn[11]<=1 and piliwb[11]==0)
              // go deeper with 2 knights; not the other cases....
           )
           return true;
    }
  else
  if (w_materiel[ply] <= men_value[w_k] and pilibp[11] equal 0)
     {if (pilibq[11] equal 0 and pilibr[11] equal 0)
        if ((pilibb[11]<=1 and pilibn[11]==0) or
            (pilibb[11]>1 and pilibn[11]==0
             and bishops_on_diff_sq_colour(pilibb) equal false) or
            (pilibn[11]<=1 and pilibb[11]==0)
           )
           return true;
     }
  return false;
}
return true;
}


int b_king_near_corner(signed char sqk, signed char *k_corner)
{ 
    if (!variant) {
    if (sqk==h8 or sqk==h7 or sqk==g7 or sqk==g8)
     {*k_corner=h8; return true;}
  if (sqk==a8 or sqk==a7 or sqk==b7 or sqk==b8)
     {*k_corner=a8; return true;}
  return false;
}
return true;
}

int w_king_near_corner(signed char sqk, signed char *k_corner)
{ 
    if (!variant) {
    if (sqk==h1 or sqk==h2 or sqk==g2 or sqk==g1)
     {*k_corner=h1; return true;}
  if (sqk==a1 or sqk==a2 or sqk==b2 or sqk==b1)
     {*k_corner=a1; return true;}
  return false;
}
return true;
}

int probably_draw()
{ 
    if (!variant) {
    signed char k_corner;
  if (b_materiel[ply] <= men_value[w_k] and piliwq[11]==0 and piliwr[11]==0)
    {if (piliwp[11] equal 0)
       {if (piliwn[11]==2 and piliwb[11]==0)
           return true;
       }
     else if ((b_king_near_corner(sqbk, &k_corner) equal true) and
              (piliwb[11]==1 or
               (piliwb[11]>1 and bishops_on_diff_sq_colour(piliwb)==false)
              ) and
              square_colour(&k_corner) != square_colour(piliwb) and
              all_pawns_on_kingfile(piliwp, tablin[k_corner])==true)
              return true;
    }
  if (w_materiel[ply] <= men_value[w_k] and pilibq[11]==0 and pilibr[11]==0)
    {if (pilibp[11] equal 0)
       {if (pilibn[11]==2 and pilibb[11]==0)
           return true;
       }
     else if ((w_king_near_corner(sqwk, &k_corner) equal true) and
              (pilibb[11]==1 or
               (pilibb[11]>1 and bishops_on_diff_sq_colour(pilibb)==false)
              ) and
              square_colour(&k_corner) != square_colour(pilibb) and
              all_pawns_on_kingfile(pilibp, tablin[k_corner])==true)
              return true;
    }
  return false;
}
return true;
}


void check_insufmat()
{
  if (!variant) {
  if (piliwq[11]==0 and piliwr[11]==0 and piliwp[11]==0)
     {if ((piliwb[11]==0 and (piliwn[11]<=1 or
                              (ply>DRAWPLY and piliwn[11]==2))
          ) or
          (piliwn[11]==0 and
            (piliwb[11]<=1 or bishops_on_diff_sq_colour(piliwb)==false)
          )
         )
         w_insufmat=true;
     }
  if (pilibq[11]==0 and pilibr[11]==0 and pilibp[11]==0)
     {if ((pilibb[11]==0 and (pilibn[11]<=1 or
                              (ply>DRAWPLY and pilibn[11]==2))
          ) or
          (pilibn[11]==0 and
            (pilibb[11]<=1 or bishops_on_diff_sq_colour(pilibb)==false)
          )
         )
         b_insufmat=true;
     }
}
}


int vurdering()
{ int v, exch_pct, vurd_j; 
  int vurd_a, vurd_a2, vurd_b, vurd_c, vurd_d, vurd_e;
  int vurd_f, vurd_f2, vurd_g, vurd_g2, vurd_h, vurd_i;
  int wmatply, bmatply;
  int pnek, ekrow, eklin, prow, plin, difrow, diflin;


  w_insufmat=false; b_insufmat=false;

  if (!variant) check_insufmat();

  wmatply=w_materiel[ply]; bmatply=b_materiel[ply];
  materiel_10_0 = (wmatply+bmatply-two_kings)
                     / (startmateriel / 10);

  if (materiel_10_0>10) materiel_10_0=10;

 

  v=(wmatply-bmatply); vurd_a=v;
  if (full_evalu equal 0    /*or iteration<3*/)    goto retur;
  if (black_8>=opening_limit)
     {v+=opening(); vurd_a2=v; if (wrand>0) v+=random_move;
     }
  else vurd_a2=v; 
  vurd_b=v; v+=king_safety()*(wkingsaf+piliwq[11]+pilibq[11])/8*materiel_10_0/10; vurd_c=v;
  if (ply>=iteration)
     v+=((mobilitet[iteration]-mobilitet[iteration-1]) *
             sgn_wh_bl * wmobil / 8 * materiel_10_0 / 10 / 4);
  vurd_d=v;
  v+=centre[ply]*wcentr/8*materiel_10_0/10;  vurd_e=v;
  if (*(piliwb+11)>1)
     v+=bishoppair * (13 - abs(10-pilibp[11]-piliwp[11])) / 13;
  if (*(pilibb+11)>1)
     v-=bishoppair * (13 - abs(10-pilibp[11]-piliwp[11])) / 13;
  vurd_f=v;





//************************ start new things jn116 *******************************

// pins and pieces near enemy king


  if (P_near_enemy_K != 0)
    {pnek=0;
     ekrow=tabrow[sqbk];
     eklin=tablin[sqbk];
     if (piliwq[0]!=0)
        {prow=tabrow[piliwq[0]];
         plin=tablin[piliwq[0]];
         difrow=abs(ekrow - prow);
         diflin=abs(eklin - plin);
         pnek+=5 * (8 - difrow - diflin);  // get near enemy king
         if (difrow equal 0 or diflin equal 0 or difrow equal diflin)
            pnek+=12; // pointing at the enemy king
         else
            if (difrow + diflin equal 1)
               pnek+=6; // almost pointing at the enemy king
        }
     if (piliwb[0]!=0)
        {prow=tabrow[piliwb[0]];
         plin=tablin[piliwb[0]];
         difrow=abs(ekrow - prow);
         diflin=abs(eklin - plin);
         pnek+=4 * (8 - difrow - diflin);  // get near enemy king
         if (difrow equal diflin)
            pnek+=18; // pointing at the enemy king
         else
            if (difrow + diflin equal 1)
               pnek+=9; // almost pointing at the enemy king
        }

     if (piliwb[1]!=0)
        {prow=tabrow[piliwb[1]];
         plin=tablin[piliwb[1]];
         difrow=abs(ekrow - prow);
         diflin=abs(eklin - plin);
         pnek+=4 * (8 - difrow - diflin);  // get near enemy king
         if (difrow equal diflin)
            pnek+=18; // pointing at the enemy king
         else
            if (difrow + diflin equal 1)
               pnek+=9; // almost pointing at the enemy king
        }
     if (piliwr[0]!=0)
        {prow=tabrow[piliwr[0]];
         plin=tablin[piliwr[0]];
         difrow=abs(ekrow - prow);
         diflin=abs(eklin - plin);
         pnek+=3 * (8 - difrow - diflin);  // get near enemy king
         if (difrow equal 0 or diflin equal 0)
            pnek+=12; // pointing at the enemy king
         else
            if (difrow + diflin equal 1)
               pnek+=6; // almost pointing at the enemy king
        }
     if (piliwr[1]!=0)
        {prow=tabrow[piliwr[1]];
         plin=tablin[piliwr[1]];
         difrow=abs(ekrow - prow);
         diflin=abs(eklin - plin);
         pnek+=3 * (8 - difrow - diflin);  // get near enemy king
         if (difrow equal 0 or diflin equal 0)
            pnek+=12; // pointing at the enemy king
         else
            if (difrow + diflin equal 1)
               pnek+=6; // almost pointing at the enemy king
        }
     if (piliwn[0]!=0 and nightrider_variant equal false)
        {prow=tabrow[piliwn[0]];
         plin=tablin[piliwn[0]];
         difrow=abs(ekrow - prow);
         diflin=abs(eklin - plin);
         pnek+=6 * (8 - difrow - diflin);  // get near enemy king
        }
     if (piliwn[1]!=0 and nightrider_variant equal false)
        {prow=tabrow[piliwn[1]];
         plin=tablin[piliwn[1]];
         difrow=abs(ekrow - prow);
         diflin=abs(eklin - plin);
         pnek+=6 * (8 - difrow - diflin);  // get near enemy king
        }



     ekrow=tabrow[sqwk];
     eklin=tablin[sqwk];
     if (pilibq[0]!=0)
        {prow=tabrow[pilibq[0]];
         plin=tablin[pilibq[0]];
         difrow=abs(ekrow - prow);
         diflin=abs(eklin - plin);
         pnek-=5 * (8 - difrow - diflin);  // get near enemy king
         if (difrow equal 0 or diflin equal 0 or difrow equal diflin)
            pnek-=12; // pointing at the enemy king
         else
            if (difrow + diflin equal 1)
               pnek-=6; // almost pointing at the enemy king
        }
     if (pilibb[0]!=0)
        {prow=tabrow[pilibb[0]];
         plin=tablin[pilibb[0]];
         difrow=abs(ekrow - prow);
         diflin=abs(eklin - plin);
         pnek-=4 * (8 - difrow - diflin);  // get near enemy king
         if (difrow equal diflin)
            pnek-=18; // pointing at the enemy king
         else
            if (difrow + diflin equal 1)
               pnek-=9; // almost pointing at the enemy king
        }

     if (pilibb[1]!=0)
        {prow=tabrow[pilibb[1]];
         plin=tablin[pilibb[1]];
         difrow=abs(ekrow - prow);
         diflin=abs(eklin - plin);
         pnek-=4 * (8 - difrow - diflin);  // get near enemy king
         if (difrow equal diflin)
            pnek-=18; // pointing at the enemy king
         else
            if (difrow + diflin equal 1)
               pnek-=9; // almost pointing at the enemy king
        }
     if (pilibr[0]!=0)
        {prow=tabrow[pilibr[0]];
         plin=tablin[pilibr[0]];
         difrow=abs(ekrow - prow);
         diflin=abs(eklin - plin);
         pnek-=3 * (8 - difrow - diflin);  // get near enemy king
         if (difrow equal 0 or diflin equal 0)
            pnek-=12; // pointing at the enemy king
         else
            if (difrow + diflin equal 1)
               pnek-=6; // almost pointing at the enemy king
        }
     if (pilibr[1]!=0)
        {prow=tabrow[pilibr[1]];
         plin=tablin[pilibr[1]];
         difrow=abs(ekrow - prow);
         diflin=abs(eklin - plin);
         pnek-=3 * (8 - difrow - diflin);  // get near enemy king
         if (difrow equal 0 or diflin equal 0)
            pnek-=12; // pointing at the enemy king
         else
            if (difrow + diflin equal 1)
               pnek-=6; // almost pointing at the enemy king
        }
     if (pilibn[0]!=0 and nightrider_variant equal false)
        {prow=tabrow[pilibn[0]];
         plin=tablin[pilibn[0]];
         difrow=abs(ekrow - prow);
         diflin=abs(eklin - plin);
         pnek-=6 * (8 - difrow - diflin);  // get near enemy king
        }
     if (pilibn[1]!=0 and nightrider_variant equal false)
        {prow=tabrow[pilibn[1]];
         plin=tablin[pilibn[1]];
         difrow=abs(ekrow - prow);
         diflin=abs(eklin - plin);
         pnek-=6 * (8 - difrow - diflin);  // get near enemy king
        }

     
      v+= P_near_enemy_K * pnek / 8; 

    }


vurd_f2=v;


//************************ end new things jn116 *******************************


if (rook_placement != 0)
// *** rook part 3 ***
 {
  if (piliwr[1]!=0) {
                     if (attack_w_min[piliwr[0]] equal w_r or  // unsure
                         attack_w_min[piliwr[1]] equal w_r)    // test...
                         {v+=15;
                          if (tablin[piliwr[0]] equal tablin[piliwr[1]])
                             v+=20;
                          else
                             if ((tabrow[piliwr[0]] equal tabrow[piliwr[1]])
                                 and
                                 (tabrow[piliwr[0]] equal 1 or tabrow[piliwr[0]] equal 7) 
                                )
                             {v+=20;
                              if (tabrow[piliwr[0]] equal 7 and tabrow[sqbk] equal 8)
                                 v+=30; 

                             }
                         }
                    }

 
  if (pilibr[1]!=0) {
                     if (attack_b_min[pilibr[0]] equal b_r or  // unsure
                         attack_b_min[pilibr[1]] equal b_r)    // test...
                         {v-=15;
                          if (tablin[pilibr[0]] equal tablin[pilibr[1]])
                             v-=20;
                           else
                             if ((tabrow[pilibr[0]] equal tabrow[pilibr[1]])
                                 and
                                 (tabrow[pilibr[0]] equal 8 or tabrow[pilibr[0]] equal 2) 
                                )
                             {v-=20;
                              if (tabrow[pilibr[0]] equal 2 and tabrow[sqwk] equal 1)
                                 v-=30; 

                             }
                         }
                    }
 }
vurd_g=v;
 // be carefull to give a piece for 3 pawns; your pawns may be hunted...
  if (piliwq[11]==pilibq[11] and piliwr[11]==pilibr[11])
    {if (piliwb[11]+piliwn[11] > pilibb[11]+pilibn[11])
        v+=16*pilibp[11];
     else
     if (pilibb[11]+pilibn[11] > piliwb[11]+piliwn[11])
        v-=16*piliwp[11];
    }

  vurd_g2=v;


  vurd_h=v;

  if (p[ply].pawnchange equal true) /*             and intern equal black*/
      {if ((wpawn equal 0) or
           (magic equal 4 and
            ((wh_bl equal black and v+limitpawnscore<best_score[ply_1]) or
             (wh_bl equal white and v-limitpawnscore>best_score[ply_1])
            )
           )                
          )
          goto keine_bewerte;
       v+=bewerte_stellung();
      }
 keine_bewerte:
  vurd_i=v;



 
  if (chess_variant !=shatranj) {
  
  if (king_centre != 0)
   {
// keep kings away from the centre until the early endgame
// ERROR: all about the black king (sqbk)
//  v+=(4 - (abs(materiel_10_0 - 3)) *  4,5-tablin[sqbk] * 4,5-tablin[sqbk]);
//  v+=(4 - (abs(materiel_10_0 - 3)) *  4,5-tabrow[sqbk] * 4,5-tabrow[sqbk]);
//  v-   =(4 - (abs(materiel_10_0 - 3)) *  4,5-tablin[sqbk] * 4,5-tablin[sqbk]);  // error in 
//  v+   =(4 - (abs(materiel_10_0 - 3)) *  4,5-tabrow[sqbk] * 4,5-tabrow[sqbk]);  // the sign
    v-=king_centre*(5-materiel_10_0)*abs(4,5-tablin[sqwk])/100;
    v-=king_centre*(5-materiel_10_0)*abs(4,5-tabrow[sqwk])/100;
    v+=king_centre*(5-materiel_10_0)*abs(4,5-tablin[sqbk])/100;
    v+=king_centre*(5-materiel_10_0)*abs(4,5-tabrow[sqbk])/100;
   }
  
  
if (king_corner != 0) {
                if (wmatply-bmatply >= men_value[w_r])
       v+=(  (3 * (tablin[sqbk]) * (tablin[sqbk]) )  // get king into
            + (3 * (tabrow[sqbk]) * (tabrow[sqbk]) )  // the corner

            - (4 * abs(tablin[sqwk]-tablin[sqbk]) )   // attack with
            - (4 * abs(tabrow[sqwk]-tabrow[sqbk]) )   // the king
           );


//////////////////////////
     else
     
    
     if (bmatply-wmatply >= men_value[w_r])
        v-=(  (3 * (tablin[sqwk]) * (tablin[sqwk]))  // get king into
            + (3 * (tabrow[sqwk]) * (tabrow[sqwk]))  // the corner
            - (4 * abs(tablin[sqwk]-tablin[sqbk]) )   // attack with
            - (4 * abs(tabrow[sqwk]-tabrow[sqbk]) )   // the king
           );
    }








  if      (wmatply>(bmatply+250) and pilibp[11]==0) v+=125;  
  else if (bmatply>(wmatply+250) and piliwp[11]==0) v-=125; 

                             
        

}
  
  vurd_j=v;


retur:

  if      (b_insufmat equal true and v<draw_score) v=draw_score;
  else if (w_insufmat equal true and v>draw_score) v=draw_score;




// jn116
if (magic>99)
   {if (magic equal 100) v=vurd_d - vurd_c;                   // only mobility
    if (magic equal 101) v=(vurd_a + vurd_b - vurd_a2);             // material + random
    if (magic equal 102) v=(vurd_b);                                       // + opening
    if (magic equal 103) v=(vurd_a + vurd_b - vurd_a2) + vurd_c - vurd_b;  // + king safety
    if (magic equal 104) v=(vurd_a + vurd_b - vurd_a2) + vurd_d - vurd_c;  // + mobility
    if (magic equal 105) v=(vurd_a + vurd_b - vurd_a2) + vurd_e - vurd_d;  // + centre
    if (magic equal 106) v=(vurd_a + vurd_b - vurd_a2) + vurd_f - vurd_e;  // + bishoppair
    if (magic equal 107) v=(vurd_a + vurd_b - vurd_a2) + vurd_f2 - vurd_f; // + pins & pieces near enemy king
    if (magic equal 108) v=(vurd_a + vurd_b - vurd_a2) + vurd_g - vurd_f2; // + rook part 3
    if (magic equal 109) v=(vurd_a + vurd_b - vurd_a2) + vurd_g2 - vurd_g; // + piece for 3 pawns
    if (magic equal 110) v=(vurd_a + vurd_b - vurd_a2) + vurd_h - vurd_g2; // + exchange
    if (magic equal 111) v=(vurd_a + vurd_b - vurd_a2) + vurd_i - vurd_h;  // + pawnevaluation (+ rooks)
    if (magic equal 112) v=(vurd_a + vurd_b - vurd_a2) + vurd_j - vurd_i;  // + king to centre / corner

   }






  vu=v;  // gem_vurd=v;
  
  return v;
}



signed char msmoves()
{  if (ply equal 0)                return 125;
   if (mate_sch_pos[ply]<       2) return 0;
   if (mate_sch_pos[ply]<mslim[1]) return 1;
   if (mate_sch_pos[ply]<mslim[2]) return 2;
   if (mate_sch_pos[ply]<mslim[3]) return 4;
   if (mate_sch_pos[ply]<mslim[4]) return 8;
   return 125;
}

void is_w_piece_quiet(signed char piecesquare)
{    if (attack_b_min[piecesquare]>=b_k)
        {if (attack_w_min[piecesquare]>w_k or
               ((men_value[-1 * attack_b_min[piecesquare]]
                 - men_value[     sq[piecesquare]])<-120)
            )
                quiet=false;
        }
}

void is_b_piece_quiet(signed char piecesquare)
{    if (attack_w_min[piecesquare]<=w_k)
        {if (attack_b_min[piecesquare]<b_k or
               ((men_value[     attack_w_min[piecesquare]]
                 - men_value[-1 * sq[piecesquare]])<-120)
            )
                quiet=false;
        }
}

signed char quiet_position()
{  signed char x;               quiet=true;
 
   if (wh_bl equal white)
         {
          for (x=0; piliwr[x]!=0 and quiet==true; ++x) // better order...
              {is_w_piece_quiet(piliwr[x]);}
          for (x=0; piliwb[x]!=0 and quiet==true; ++x)
              {is_w_piece_quiet(piliwb[x]);}
          for (x=0; piliwn[x]!=0 and quiet==true; ++x)
              {is_w_piece_quiet(piliwn[x]);}
          for (x=0; piliwq[x]!=0 and quiet==true; ++x)
              {is_w_piece_quiet(piliwq[x]);}
         }
   else
         {
          for (x=0; pilibr[x]!=0 and quiet==true; ++x) // better order...
              {is_b_piece_quiet(pilibr[x]);}
          for (x=0; pilibb[x]!=0 and quiet==true; ++x)
              {is_b_piece_quiet(pilibb[x]);}
          for (x=0; pilibn[x]!=0 and quiet==true; ++x)
              {is_b_piece_quiet(pilibn[x]);}
          for (x=0; pilibq[x]!=0 and quiet==true; ++x)
              {is_b_piece_quiet(pilibq[x]);}
         }



   if (quiet equal false and magic != 6)
      sel_side[ply]*= -1; // does not work as it should........

   return quiet;
}

long unsigned int find_hash_id(signed int x)
{  signed int x2;
   if (x>=0) return p[x].hash_id;
   x2=game_pointer+x;
   if (x2>=0) return game_id[x2]; else return 0;
}

long unsigned int find_hash_idx(signed int x)
{  signed int x2;
   if (x>=0) return p[x].hash_idx;
   x2=game_pointer+x;
   if (x2>=0) return game_idx[x2]; else return 0;
}



int rooksquare_mate()
{       
    if (variant) {
                 
        if (sq[a8]>=w_p or 
            sq[h8]>=w_p or 
            sq[a1]<=b_p or 
            sq[h1]<=b_p)
      return true; 
      else return false;
}
return true;
}



int extinct_mate()
{  
    
    if (variant && var_extinct) {
                
        if (piliwn[11]==0 or pilibn[11]==0 or 
            piliwb[11]==0 or pilibb[11]==0 or
            piliwq[11]==0 or pilibq[11]==0 or 
            piliwr[11]==0 or pilibr[11]==0 or
            piliwp[11]==0 or pilibp[11]==0)
            return true; 
            else 
            return false;
}
return true;
}







int repeat_position()
{  signed int x=ply-4;
 r_p:
   if (x<ply-p[ply].draw50) return false;
   if (    find_hash_id(x)  equal uli_sletigen
       and find_hash_idx(x) equal uli_sletigenx)
       return true;
   x-=2; goto r_p;
}

void make_move(signed char *zfr, signed char *zto, int hop_ud)
  {
   signed char fr, to, fr_before, to_before, to_9_10_11, promote_piece, rr;
   signed char promotion, work_ep, gem_sel_side, fr_li, to_li;
   int man, vurd,  husk  , mobili, gem, r, jub;

  
   fr=*zfr; to=*zto;

   ++ply; ++ply_1;
   if (wh_bl equal white) mms[ply]=int_max+ply;  // flyttes lngere ned...
   else                   mms[ply]=int_min-ply;
   gem_sel_vurd[ply]=30111;


   p[0].pawnchange=false; // skal slettes igen



                       mobilitet[ply]=0; // hjaelper det? nej.........
   sel_side[ply]=sel_side[ply_1];


   if (ply>1)
      {
       if  (best_score[ply-2] equal start_best_score[ply-2])
            best_score[ply]=start_best_score[ply];
       else best_score[ply]=best_score[ply-2];
      }
   else     {best_score[1]=start_best_score[1];
  // ud 8/10 if (iteration equal last_iteration) // not the optimal way...
      
       

            }
   p[ply]=p[ply_1];
   nullmove[ply]=99;
   uli_sletigen=p[ply].hash_id; uli_sletigenx=p[ply].hash_idx;
   uli_sletigen =uli_sletigen  exor randi_id [0][0];
   uli_sletigenx=uli_sletigenx exor randi_idx[0][0];
   sel_delay[ply]=sel_delay[ply_1];
   first_dynamic_sel_ply[ply]=first_dynamic_sel_ply[ply_1];
   w_materiel[ply]=w_materiel[ply_1]; b_materiel[ply]=b_materiel[ply_1];

   promotion=false; p[ply].e_p=not_allowed;
   if (fr equal to)                          /*random_move=0;*/
        {centre[ply]=centre[ply_1]+30*wh_bl; goto nm;}  // nullmove
   fr_before=sq[fr]; move_fr_before[ply_1]=fr_before;
   uli_sletigenx=uli_sletigenx exor randi_idx[fr][bw_index(fr_before)];
   uli_sletigen =uli_sletigen  exor randi_id [fr][bw_index(fr_before)];

   if (fr_before equal w_p * wh_bl)  /* et bondetraek? */
     {p[ply].pawnchange=true; p[ply].draw50=0;
      if (to<=h8)                    /* forvandling? nej */
       {if (abs(to - fr) equal 20)    // bondes dobbeltskridt
          //{p[ply].e_p= fr + 10 * wh_bl; gl. version - hurtigere?!
           p[ply].e_p=((fr+to)/2); //  }
        else
          {if (abs(to - fr) != 10 and sq[to] equal sq_empty) /* e.p. */
                // tablin is probably slower...
             {work_ep=to - 10 * wh_bl;
              delete_pili(&work_ep, &sq[work_ep]);

   uli_sletigenx=uli_sletigenx exor randi_idx[work_ep][bw_index(sq[work_ep])];
   uli_sletigen =uli_sletigen  exor randi_id [work_ep][bw_index(sq[work_ep])];
              sq[work_ep] = sq_empty; /* bonden skal fjernes */
              if (wh_bl equal white) b_materiel[ply] -= men_value[w_p];
              else                   w_materiel[ply] -= men_value[w_p];
             }
          }
       }
      else                          /* forvandling? ja  */
       {promotion=true;
        sel_delay[ply] += 4;
        unpack_promotion(&to, &to_9_10_11, &promote_piece);
        to=fr + wh_bl * to_9_10_11;
        if (wh_bl equal white)
              w_materiel[ply] += men_value[promote_piece] - men_value[w_p];
        else  b_materiel[ply] += men_value[promote_piece] - men_value[w_p];
       }
     }
   else {if (fr_before equal w_r * wh_bl) p[ply].pawnchange=true;
         if (sq[to] equal sq_empty) ++p[ply].draw50; else p[ply].draw50=0;
        }

     if ((p[ply].e_p==not_allowed and p[ply_1].e_p!=not_allowed) or
// billig lsning - kan skrives hurtigere binrt med exor...............
         (p[ply].e_p!=not_allowed and p[ply_1].e_p==not_allowed))
              {uli_sletigenx=uli_sletigenx exor randi_idx[0][1];
               uli_sletigen =uli_sletigen  exor randi_id [0][1];
              }
   if (ply equal 1 and info_out==1) {
      printf("\n  ");
      print_kqrbnp(sq[fr]); print_a1_h8(&fr); print_a1_h8(&to);
      printf(" : ");
    }

   if (ply equal 2 and info_out==1)
     {if (move_pointer[1] < 3)
        {
                          print_kqrbnp(sq[fr]); print_a1_h8(&fr); print_a1_h8(&to);
        printf("  ");
       }
      else 
     printf("*");
     }

   to_before=sq[to]; move_to_before[ply_1]=to_before;

  
 
//frc-jn - change this to test the k+rook-squares in the starting position.....
   if (fr equal e1 or fr equal h1 or to equal h1) p[ply].w_o_o=not_allowed;
   if (fr equal e8 or fr equal h8 or to equal h8) p[ply].b_o_o=not_allowed;
   if (fr equal e1 or fr equal a1 or to equal a1) p[ply].w_o_o_o=not_allowed;
   if (fr equal e8 or fr equal a8 or to equal a8) p[ply].b_o_o_o=not_allowed;

   

   if (to_before != sq_empty)
     {uli_sletigenx=uli_sletigenx exor randi_idx[to][bw_index(to_before)];
      uli_sletigen =uli_sletigen  exor randi_id [to][bw_index(to_before)];
      delete_pili(&to, &to_before);
      if (wh_bl equal white)
            {man=men_value[to_before * -1]; b_materiel[ply] -= man;}
      else  {man=men_value[to_before     ]; w_materiel[ply] -= man;}
           if (man equal men_value[w_q])  sel_delay[ply]  += 4;
      else if (man equal men_value[w_r]) {sel_delay[ply]  += 3;
                                          p[ply].pawnchange=true;
                                         }
      else if (man equal men_value[w_b])  sel_delay[ply]  += 2;
      else if (man equal men_value[w_n])  sel_delay[ply]  += 2;
      else                               {sel_delay[ply]  += 1;
                                          p[ply].pawnchange=true;
                                         }
     }

   if (promotion equal true) {sq[to]=promote_piece * wh_bl;
                              delete_pili(&fr, &fr_before);  // hmmmmmmm
                              add_pili(&to, &sq[to]);        // hmmmmmmm
                             }
   else                      {sq[to]=fr_before;
                              change_pili(&fr, &to, &fr_before);
                             }
   uli_sletigenx=uli_sletigenx exor randi_idx[to][bw_index(sq[to])];
   uli_sletigen =uli_sletigen  exor randi_id [to][bw_index(sq[to])];

   sq[fr]=sq_empty;         /* selve traekket udfoeres */



   if (fr_before>w_p or fr_before<b_p)
      centre[ply]=centre[ply_1]+wh_bl*((centrum[to]-centrum[fr])/4);
   else {if (to_before != sq_empty) // don't care about e.p.....
             {fr_li=tablin[fr]; if (fr_li>4) fr_li=9-fr_li;
              to_li=tablin[to]; if (to_li>4) to_li=9-to_li;
              if (fr_li != to_li) // both may be 4....
                {if ((to_li>fr_li and fr_before equal w_p) or
                    (to_li<fr_li and fr_before equal b_p))
                      centre[ply]=centre[ply_1]+20;
                 else centre[ply]=centre[ply_1]-20;
                }
              else centre[ply]=centre[ply_1];
             }
         else centre[ply]=centre[ply_1];
        }

  
  
   if (fr equal e1 and to equal g1 and fr_before equal w_k)
      {sq[h1]=sq_empty; sq[f1]=w_r;
       change_castle_pili(h1, f1, w_r); p[ply].pawnchange=true;};
   if (fr equal e1 and to equal c1 and fr_before equal w_k)
      {sq[a1]=sq_empty; sq[d1]=w_r;
       change_castle_pili(a1, d1, w_r); p[ply].pawnchange=true;};
   if (fr equal e8 and to equal g8 and fr_before equal b_k)
      {sq[h8]=sq_empty; sq[f8]=b_r;
       change_castle_pili(h8, f8, b_r); p[ply].pawnchange=true;};
   if (fr equal e8 and to equal c8 and fr_before equal b_k)
      {sq[a8]=sq_empty; sq[d8]=b_r;
       change_castle_pili(a8, d8, b_r); p[ply].pawnchange=true;};






   p[ply].hash_id=uli_sletigen; p[ply].hash_idx=uli_sletigenx;
   if (ply<=plydyb+0 and swhash==1 and p[ply].swnullhash==0)
     {


        {uli_id_index=uli_sletigenx & hash_maxindex;
         read_hash(uli_id_index); ++tv_hash_read;
         if (uli_sletigen!=hash.hash_id or uli_sletigenx!=hash.hash_idx)
             hash.hash_fr=0;
         else {++tv_hash_read_ok;


               
               if (ply>=2 and hash.hash_score_final equal false
                   and hash.hash_depth>=iteration-ply)
                 {
                 if (wh_bl equal white)
                   {if (hash.hash_score<=best_score[ply_1]) // and make2_move..
                     {make_move_status=make_cut_off; ++tv_hash_nofinal;
                      
            best_score[ply]=hash.hash_score;
                      goto make_move_slut;
                     }
                   }
                 else
                   {if (hash.hash_score>=best_score[ply_1]) // and make2_move..
                     {make_move_status=make_cut_off; ++tv_hash_nofinal;
                      best_score[ply]=hash.hash_score;
                      goto make_move_slut;
                     }
                   }
                 }


              }
        }
     
     }
   else hash.hash_fr=0;


   if (hop_ud equal true) goto make_move_slut;

 
   if (variant && chess_variant equal rooksquare) {
               
               if (sq[a8]>=w_p or sq[h8]>=w_p) {
                               
               make_move_status=score_is_found;
               best_score[ply]=int_max-ply; 
               goto make_move_slut;
         }
       if (sq[a1]<=b_p or sq[h1]<=b_p)
         {make_move_status=score_is_found;
          best_score[ply]=int_min+ply; goto make_move_slut;
         }
  }


if (variant && var_extinct && chess_variant equal extinct) {
            
            if (fr_before!=sq_empty and extinct_mate() equal true) {
            
            make_move_status=score_is_found;
            if (wh_bl equal white) //(fr_before>=w_p)
                            best_score[ply]=int_max-ply+2;     // hmmmmmm
        else                best_score[ply]=int_min+ply-2;
        goto make_move_slut;
       
     }
}



  if (!variant) {

   if (to_before!=sq_empty or ply equal 1) {
   
          if (dead_draw() equal true){
            make_move_status=score_is_found;
            best_score[ply]=draw_score;
            goto make_move_slut;
          }
      }

   if (ply>DRAWPLY and probably_draw() equal true)
       {make_move_status=score_is_found;
        best_score[ply]=draw_score;
        goto make_move_slut;
       }
       }
       
       
   if ( (p[ply].draw50>=100) or
        (/*everplay_and_black() equal false and*/repeat_position() equal true)

      )
       {make_move_status=score_is_found;
                  if (p[ply].draw50<100) ++tv_repeat;    // dum if
        best_score[ply]=draw_score;
        goto make_move_slut;
       }

   if (hash.hash_fr!=0)
       {if (hash.hash_score_final equal true
            and hash.hash_depth>=iteration-ply)
          {make_move_status=score_is_found;  ++tv_hash_read_ok_final;
           best_score[ply]=hash.hash_score;
           goto make_move_slut;
          }
  
       }

   if (ply equal last_ply)
     {++tv_last_ply;


      if (is_move_a_check(&fr, &to) equal false)
        {realmoves[ply]=1;
         king_in_check[ply]=false;
         goto make_move_slut;
        }
     }


nm:  // jump to here for a nullmove

   make_only_attack();

   if ( (wh_bl equal black and attack_b_min[sqwk]>=b_k) or
        (wh_bl equal white and attack_w_min[sqbk]<=w_k)
      )
        {king_in_check[ply]=true;
         sel_delay[ply] += 2;
        }
   else king_in_check[ply]=false;

   change_black_white();


   if (ply<=first_sel_ply-2
       and king_in_check[ply] equal false
       and nullmove[ply_1] equal 99
       and iteration>0 // ordinary search; not the matesearch
       //and move_pointer[ply_1]>0  // a little slower (330->340) with this.
       and w_materiel[ply]>men_value[w_k]+800
       and b_materiel[ply]>men_value[w_k]+800
       and swnullmove equal 1
       and everplay_and_black() equal false)
       {if (ply equal first_sel_ply-2) rr=-1; else rr=-2;
        p[ply].swnullhash=1;
        nullmove[ply]=rr; first_sel_ply+=rr; last_ply+=rr;
       }


   if (ply>=first_sel_ply
       and first_dynamic_sel_ply[ply] equal 99
       and ply < last_ply
      )  // dynamic change from brute force to selective search
      {first_dynamic_sel_ply[ply]=ply;

       sel_side[ply]=wh_bl;
      }

   husk=false; quiet=true;


// "Positionelle Selektivitt"
   if (ply equal iteration-1 and iteration>=3
       and king_in_check[ply] equal false
       and quiet_position() equal true
       and mateinx equal 0
      )
     {jub=vurdering();
      if (wh_bl equal black)
           {jub-=10;
            if (jub<=best_score[ply_1] and make2_move_status!=pseudo_move)
                goto jubii;

           }
      else
           {jub+=10;
            if (jub>=best_score[ply_1] and make2_move_status!=pseudo_move)
             {
jubii:
              make_move_status=make_cut_off; best_score[ply]=jub;
              change_black_white(); turn_sqavoid_false(); 
              goto make_move_slut;
             }
           }
     }

   gem_sel_side=sel_side[ply];
   if (ply >= first_dynamic_sel_ply[ply]
       and wh_bl equal gem_sel_side        // sel_side[ply]
       and (  (iteration equal 0
               and king_in_check[ply] equal false            // 01 jan. 98
              )
              or
              (king_in_check[ply] equal false
               and (ply > quiet_depth + first_dynamic_sel_ply[ply]
                    or quiet_position() equal true)
              )
           )
      )
      {sel_ply_now=true;
                           husk=true;
       if (iteration equal 0 and ply<7) // don't trust score...
          goto l1;                      // (Nero / Benjamin Good)
          // passer dybde med dybde i is-move-a-sel-move (2x)?

        {vurd=vurdering();   // selektivt move
              gem_sel_vurd[ply]=vurd; mms[ply]=vurd;
         if ((wh_bl equal white and vurd>best_score[ply]) or
             (wh_bl equal black and vurd<best_score[ply])
            )
           {best_score[ply]=vurd;}
         if (ply<=trace)
            {gem=best_score[ply]; best_score[ply]=vurd;
             print_line(); best_score[ply]=gem;
             printf(" (sel) "); 
            }





         if (wh_bl equal black)
           {if (best_score[ply]<=best_score[ply_1] and make2_move_status!=pseudo_move)
                goto jubiii;

           }
         else
           {if (best_score[ply]>=best_score[ply_1] and make2_move_status!=pseudo_move)
             {
jubiii:
              make_move_status=make_cut_off;
              change_black_white(); turn_sqavoid_false();
              goto make_move_slut;
             }
           }
        }

       if (ply equal first_dynamic_sel_ply[ply]
  
                  //                    ikke helt korrekt......
            and sel_delay[ply]>=qdynamic)
         {sel_ply_now=false;

         
       /*   if (magic != 3) */  sel_delay[ply]=-122;  // kan fjernes...
         }


      }
   else {sel_ply_now=false;
         if (ply >= first_dynamic_sel_ply[ply])
           {
            if (gem_sel_side equal wh_bl       // fr sel_side[ply]
                and (king_in_check[ply] equal true
                     // or quiet equal false     no good idea...
                    )
               and skift equal 1)  /* skift....... */
               {++first_dynamic_sel_ply[ply]; /* initiativet skifter! */
                sel_side[ply]*= -1;
               }
           }

        }

l1:
   only_recapture=false;     // bruges til at udvlge selektive trk
   if ((sel_ply_now equal false or iteration > 0) and
       //       sel_side[ply] != wh_bl and
       king_in_check[ply] equal false and

      (iteration equal 0
       or ply > first_dynamic_sel_ply[ply]+3

       )
        and
       ((wh_bl == white and (w_materiel[ply]-b_materiel[ply]) <
                              (w_materiel[0]-b_materiel[0])
        )  or
        (wh_bl == black and (w_materiel[ply]-b_materiel[ply]) >
                              (w_materiel[0]-b_materiel[0])
        )
       )
      )
      {sel_ply_now=true; only_recapture=true;     husk=true;
       best_score[ply]=vurdering();   // only capture - ndvendig?
       mms[ply]=best_score[ply];
       if (ply<=trace)
          {print_line(); printf(" (sel-recap) "); }
      }


   tv_non_sel_move=0;
   make_move_array();
   change_black_white();
   if (iteration equal 0)
     {if (mobilitet[ply]>0)
        {if (wh_bl equal intern)
           {mobili=msmoves();
            if (mobili equal 0) mobili=1;
            else if (mobili>mobilitet[ply]) mobili=mobilitet[ply];
            mate_sch_pos[ply] = mate_sch_pos[ply_1] / (double)mobili;
           }
         else mate_sch_pos[ply] = mate_sch_pos[ply_1]/(double)mobilitet[ply];
        }
      else mate_sch_pos[ply] = mate_sch_pos[ply_1];
     }
   if (husk==true and tv_non_sel_move>0) realmoves[ply]=123;

   if (make2_move_status equal pseudo_move) ++tv_pseudo_moves;

make_move_slut:
                
   ++tv_nodes; change_black_white();

  }

void undo_move()
  {signed char fr, to, to_9_10_11, promote_piece, work_ep;

//   vurd_node=-1;



   --ply; --ply_1; change_black_white();
   make_move_status=normal_move; make2_move_status=normal_move;
 

/* trkket fres tilbage p brttet */
   fr=move_fr[ply][ move_pointer[ply]];
   to=move_to[ply][ move_pointer[ply]];
//frc-jn - by castle change h8 to g1, a8 to c1, a1 to c8 and h1 to g8

   if (nullmove[ply]<99)
      {first_sel_ply-=nullmove[ply];
       last_ply-=nullmove[ply];
       nullmove[ply]=99;
       goto nm;
      }

   sq[fr]=move_fr_before[ply];
   if (to>h8) /* ved forvandling skal to-feltet beregnes */
     {unpack_promotion(&to, &to_9_10_11, &promote_piece);
      to=fr + wh_bl * to_9_10_11;
      add_pili(&fr, &sq[fr]);                                     //hmmmmmm
      delete_pili(&to, &sq[to]/*&move_to_before[ply] &promote_piece*/);//hmmmmmm
     }
   else change_pili(&to, &fr, &sq[fr]);
   sq[to]=move_to_before[ply];



   if (sq[to] != sq_empty) add_pili(&to, &sq[to]);

  

 
//frc-jn - make something like.... 
//   if (to equal h8(see earlier note) and sq[frc-kingstartsquare] equal w_k)
//      {sq[loop those between k and r]=sq_empty; sq[frc_kingsiderookstartsquare]=w_r; change_castle_pili(f1...., h1...., w_r);};  
   if (fr equal e1 and to equal g1 and sq[e1] equal w_k)
      {sq[f1]=sq_empty; sq[h1]=w_r; change_castle_pili(f1, h1, w_r);};
   if (fr equal e1 and to equal c1 and sq[e1] equal w_k)
      {sq[d1]=sq_empty; sq[a1]=w_r; change_castle_pili(d1, a1, w_r);
      };
   if (fr equal e8 and to equal g8 and sq[e8] equal b_k)
      {sq[f8]=sq_empty; sq[h8]=b_r; change_castle_pili(f8, h8, b_r); };
   if (fr equal e8 and to equal c8 and sq[e8] equal b_k)
      {sq[d8]=sq_empty; sq[a8]=b_r; change_castle_pili(d8, a8, b_r);};




 
  
  
  
  
  
   if ((sq[fr] equal w_p * wh_bl) and (abs(to - fr) != 20))
     {if (//tablin[to] != tablin[fr] a little slower than...
              abs(to - fr) != 10       and sq[to] equal sq_empty) // e.p.
         {work_ep=to - 10 * wh_bl;
          sq[work_ep] = b_p * wh_bl;      // set in the pawn
          add_pili(&work_ep, &sq[work_ep]);
         }
     }

   if (best_score[ply] equal start_best_score[ply+1])
          move_pointer[ply]=125;
   else ++move_pointer[ply]; // point at the next move

nm: // jump to here for a nullmove
;
  }



void print_best_move_ply_zero(int I_play)
{  signed char wto, wto_9_10_11, wpromote_piece, prom;
   char t[16], tegn[6];
   prom=' '; wto=best_move_to[0];
     
   
   
   if (wto>h8)
         {unpack_promotion(&wto, &wto_9_10_11, &wpromote_piece);
          wto=best_move_fr[0] + wto_9_10_11 * wh_bl;
          prom=men_letter[wpromote_piece];
         }
   if (I_play equal true and status!=self_play)
      {
              
             
               ////////////////////////// - JA
              my_best_score = best_score[0];
              if(intern == black) my_best_score *=-1;
              
              
              ///////////// offer draw //////////////
              
             
             if (!variant && resign_on) {
                           
              if (mpc == 200 || mpc == 220 || mpc == 240 || mpc == 260 ||
                  mpc == 280 || mpc == 300 || mpc == 320 || mpc > 340 ) {
                        
                  draw_offer = true;
                 
                  if (draw_offer && my_best_score <= 0) {
                        printf("offer draw\n");
                        draw_offer = false;
                        }
                        } 
             
              
            
           
           
           if  (my_best_score > -RESIGNTHRESHOLD) {
                resigncounter = 0;
                }else{                                      
                if (resigncounter > 1) printf("Dabbaba thinking about resigning\n");
                resigncounter++;                
                }
                if (resigncounter == 3) {
                printf("Dabbaba resigns\n");
                printf("computer resigns\n"); 
                return;        				
			}
                   
                   }
                   
               if(intern == white && wh_bl equal white || 
                  intern == black && wh_bl equal black) { 
               
               if (!analyze_on) strcpy(tegn,"\nmove "); 
                                
                                        }
                           
     //  printf("%d%s",(1+((mpc/*-1*/)/2)),tegn);
     printf("%s",tegn);
   if (icc) printf("tellics whisper kibitz %d%s",(1+((mpc/*-1*/)/2)),tegn); 
       
    move_count ++;  
       
       }
               
               
         if (sq[best_move_fr[0]] equal sq_empty)  print_kqrbnp(sq[wto]);
   else                                     print_kqrbnp(sq[best_move_fr[0]]);
   print_a1_h8(&best_move_fr[0]);

   
   
   if (save_games equal true and I_play equal true)
      pgn_a1_h8(&best_move_fr[0]);
   
  // dette med - og x gr vist kun til sidst(I-play).....
   if (sq[best_move_fr[0]] != sq_empty)
     {
     if (!xboard) {
     if (sq[wto] equal sq_empty)                       
     printf("-");
     else                                               printf("x");
     }
     }
   print_a1_h8(&wto);
   if (save_games equal true and I_play equal true)
      {pgn_a1_h8(&wto);
       fprintf(pgn,"%c ",prom);
       if ((mpc+1) % 10 equal 0 and evermoves_160!=16) fprintf(pgn,"\n");
      }
  
   printf("%c",prom);

   
   I_play = false;
   
   
   
   
}

int mate_found()
{      if ((intern==white and best_score[0]>(int_max-100)) or
           (intern==black and best_score[0]<(int_min+100))) return true;
       else                                                 return false;
}

void opdat_hash(signed char fr, signed char to, signed int score)
{  signed char final, surprise, zz;
   if (ply_1<=plydyb and swhash==1  and p[ply].swnullhash==0
        )
      {
       if (move_fr [ply_1][move_pointer[ply_1]+1] equal stop) final=true;
       else                                                   final=false;
       uli_id_index=p[ply_1].hash_idx & hash_maxindex;
       read_hash(uli_id_index);
       if (ply_1==plydyb and hash.hash_mpc>mpc-2) goto ej;
       if (hash.hash_ply<3 and hash.hash_ply<ply_1 and mpc==hash.hash_mpc)
          goto ej; // gerne gemme de verste aht perm.brain
       if (mpc-1>hash.hash_mpc /*or iteration-1>hash.hash_iteration*/)
           goto opdat;
       surprise=move_pointer[ply_1] / 8;
       if (hash.hash_score_final equal false and final equal true) zz=2;
       else                                                        zz=0;
       if ((iteration-ply_1+surprise+zz)>=hash.hash_depth) goto opdat;
   ej: ++tv_hash_ejskriv; goto efter_skriv;
   opdat:
       hash.hash_depth=iteration-ply_1;      ++tv_hash_opdat;
       hash.hash_score=score;
       hash.hash_score_final=final;
       hash.hash_fr=fr; hash.hash_to=to;
   skriv:
       hash.hash_mpc=mpc; hash.hash_ply=ply_1;
       hash.hash_id=p[ply_1].hash_id;
       hash.hash_idx=p[ply_1].hash_idx;

       uli_id_index=hash.hash_idx & hash_maxindex;
       write_hash(uli_id_index);           ++tv_hash_skriv;
   efter_skriv:
	   ;
      }
}

void new_best_move()
  {signed char ch2, ch3; //, final, surprise, zz;
   gem_sel_vurd[ply_1]=30111; // hmmmmmm
   best_score  [ply_1]=best_score[ply];
   best_move_fr[ply_1]=move_fr   [ply_1][move_pointer[ply_1]];
   best_move_to[ply_1]=move_to   [ply_1][move_pointer[ply_1]];

   opdat_hash(best_move_fr[ply_1], best_move_to[ply_1], best_score[ply]);

   if (ply equal 1)
    {most_recent_best_score=best_score[0];
     if (iteration>0 and mate_ply equal -1 and mate_found() equal true
         and mateinx equal 0)
         mate_ply=iteration+1;
     if (iteration>0 and magic==23) matesearch_score=no_good_found;
 // for at undg Bc4xf7+ (se badmoves) fundet i matesearch med score -200....
     if (gameplay equal true and dummy_search equal false
         and status!=everplay)
        {writesecsofar_gi();
         fprintf(gi,"best move so far: ");
         sq120_to_koordinat(&best_move_fr[0], &ch2, &ch3);
         fprintf(gi,"%1c%1c",'a' - 1 + ch2, '0' + ch3);
         sq120_to_koordinat(&best_move_to[0], &ch2, &ch3);
         fprintf(gi,"%1c%1c",'a' - 1 + ch2, '0' + ch3);
         fprintf(gi,"   score: %d",best_score[0]);
        }
     if (disctrace equal true)
        {writesecsofar();
         fprintf(fp,"best move so far: ");
         sq120_to_koordinat(&best_move_fr[0], &ch2, &ch3);
         fprintf(fp,"%1c%1c",'a' - 1 + ch2, '0' + ch3);
         sq120_to_koordinat(&best_move_to[0], &ch2, &ch3);
         fprintf(fp,"%1c%1c",'a' - 1 + ch2, '0' + ch3);
         fprintf(fp,"   score: %d",best_score[0]);
        }
     
     if ((info_out equal 1) or (filtrace equal true) or (run_test==true) or
         (gameplay==true and gameplay_info==true and dummy_search==false
          and pb_on equal false))
       {
        printf("\nbest move so far: ");
        if (analyze_on) printf("\n%d %d %d %8.0f ", iteration, my_best_score, secprmove, tv_nodes/40);
        print_best_move_ply_zero(false);
        print_vurdering(best_score[0]);
        
        
       }
     if (mateinx>0 and mate_found() equal true)
       {
        matelvl_score=best_score[0];
        if (best_score[0]>0) best_score[0]-=1; else best_score[0]+=1;
        matelvl_fr=best_move_fr[0]; matelvl_to=best_move_to[0];
       }
    }
 
 
  }

void minimax()
{ if (ply<=trace) {print_line(); }
  if (ply equal 1)
    {move_value[0] [move_pointer[0]]=best_score[1];
     if (info_out==1) print_vurdering(best_score[1]);
    }
  if (wh_bl equal white)
    {if (best_score[ply] < mms[ply_1]) mms[ply_1]=best_score[ply];
     if (best_score[ply] < best_score[ply_1]) new_best_move();}
  else
    {if (best_score[ply] > mms[ply_1]) mms[ply_1]=best_score[ply];
     if (best_score[ply] > best_score[ply_1]) new_best_move();}
 
}



void gem_simple_kill(signed char *m_fr, signed char *m_to)
{  int y, w_score; signed char c;


if (move_to[ply-2] [move_pointer[ply-2]] equal *m_to) return;

if (gem_sel_vurd[ply] equal 30111) w_score=best_score[ply];
else                               w_score=gem_sel_vurd[ply];


if (simple_kill1_fr[ply_1] == *m_fr and simple_kill1_to[ply_1] == *m_to)
   {++tv_s_kill1[ply_1]; --tv_s_kill2[ply_1];
    simple_kill1_vu[ply_1]=w_score; //best_score[ply+g]; //   +1];
    return;}
if (simple_kill2_fr[ply_1] == *m_fr and simple_kill2_to[ply_1] == *m_to)
   {++tv_s_kill2[ply_1]; --tv_s_kill1[ply_1];
    simple_kill2_vu[ply_1]=w_score; //best_score[ply+g]; //   +1];
    return;}
if (tv_s_kill1[ply_1]>tv_s_kill2[ply_1])
     {simple_kill2_fr[ply_1]=*m_fr;
      simple_kill2_to[ply_1]=*m_to;
      simple_kill2_vu[ply_1]=w_score; //best_score[ply+g]; //   +1];  //vu
      s_kill2_oldpre[ply_1]=oldpre_value[ply_1][move_pointer[ply_1]];
      tv_s_kill2[ply_1]=1001;
     }
else {simple_kill1_fr[ply_1]=*m_fr;
      simple_kill1_to[ply_1]=*m_to;
      simple_kill1_vu[ply_1]=w_score; //best_score[ply+g]; //   +1];  //vu
      s_kill1_oldpre[ply_1]=oldpre_value[ply_1][move_pointer[ply_1]];
      tv_s_kill1[ply_1]=1001;
     };
if (s_kill<=2 and tv_s_kill1[ply_1]<tv_s_kill2[ply_1])
     {y=tv_s_kill1[ply_1]; tv_s_kill1[ply_1]=tv_s_kill2[ply_1];
           tv_s_kill2[ply_1]=y;
      c=simple_kill1_fr[ply_1]; simple_kill1_fr[ply_1]=simple_kill2_fr[ply_1];
           simple_kill2_fr[ply_1]=c;
      c=simple_kill1_to[ply_1]; simple_kill1_to[ply_1]=simple_kill2_to[ply_1];
           simple_kill2_to[ply_1]=c;
      y=simple_kill1_vu[ply_1]; simple_kill1_vu[ply_1]=simple_kill2_vu[ply_1];
           simple_kill2_vu[ply_1]=y;
      y=s_kill1_oldpre[ply_1]; s_kill1_oldpre[ply_1]=s_kill2_oldpre[ply_1];
           s_kill2_oldpre[ply_1]=y;
     }
}

void cut_off()
{  signed char m_fr, m_to;//, final, surprise, zz;
   m_fr=move_fr[ply_1] [move_pointer[ply_1]];
   m_to=move_to[ply_1] [move_pointer[ply_1]];
   best_score[ply] = mms[ply]; // // k o n f l i k t . . . . . . .

   opdat_hash(m_fr, m_to, best_score[ply]);

   if (ply equal 2)
     {if (gem_sel_vurd[2] != 30111) // k o n f l i k t . . .  nogen
           move_value[0] [move_pointer[0]]=gem_sel_vurd[2]; //effekt??? lidt!
      else move_value[0] [move_pointer[0]]=best_score[2];
      if (info_out==1) print_vurdering(best_score[2]);
     }



   if (ply<=trace)
        {if (gem_sel_vurd[ply] != 30111)       // nogen
            best_score[ply]=gem_sel_vurd[ply]; // effekt?
    // k o n f l i k t . . . . . . .
         printf(" Cut %d %d",best_score[ply], best_score[ply-2]);
        }
   ++tv_cutoff;

   if (wh_bl equal white)
         if (best_score[ply]<mms[ply-2]) mms[ply-2]=best_score[ply];
   else  //  fortegn vender ganske givet korrekt...
         if (best_score[ply]>mms[ply-2]) mms[ply-2]=best_score[ply];

   gem_simple_kill(&m_fr, &m_to);

///*
   if (ply equal 2 and iteration != last_iteration
         and ((iteration equal 1 and magic equal 3)
              or
              (always !=1 and iteration equal 2)
             )
//       or (iteration > 2 or iteration < 1)) // ny og gl. pr. 9 j u l i 97
      )
       {if (info_out==1) printf(" no-cut ");}
   else
       {if (make2_move_status!=pseudo_move)
           {undo_move();
           
           }
       }

}

void evt_cut_off()
{
  
  
  if (wh_bl equal white)
    {if (best_score[ply]<=best_score[ply-2]
         )
         {
          cut_off();
         }
    }
  else
    {if (best_score[ply]>=best_score[ply-2]
         )
         {
          cut_off();
         }
    }
}

void everplay_setup()
{   

  if (!experiment_quiet) 
  w_antselply=4; quiet_depth=1; 

}

signed char pb_move_guessed()
{  signed char wmove[5];
     pb_move_received[4]=0;
   p99_a1_h8(&pb_move_fr); strcpy(wmove,p99);
   p99_a1_h8(&pb_move_to); strcpy(wmove+2,p99);
   wmove[4]=0;
   if (strcmp(".",pb_move_received) equal 0)
      strcpy(pb_move_received,wmove);
   if (strcmp(wmove,pb_move_received) equal 0) return true;
   else                                        return false;
}

void add_movetime(double movetime, signed char no_nodes, double oppotid,
                  double opponodes)
{   double estimated_time;
   

    //if (no_nodes equal true)
      {if (movetime<-1 or movetime>360000) // is sometimes -0.00000038575746
         {if (save_games equal true) fprintf(pgn," {midnight-30!?} ");
          happens[3]='3'; movetime=3000;
    // midnightproblem... silly human movetime is set to 30 seconds
         }
      }


    if (intern equal white) wtid+=movetime/100;
    else                    btid+=movetime/100;
   
}
void pb_undo_move_until_root()
{   for (; ply>0; ) {undo_move();} }

void computer()
{
  int finished=false, tpctmsf, tita;
  signed char gem_mobil_zero=0, bioschar, x;
  double tv_nodes_it_zero;
  pv_on = true;

  gem_check_search=check_search; full_line=1;

  if (iteration equal 1) {tpct_it_zero=timepctmovesofar();
                          tv_nodes_it_zero=tv_nodes;}


  if (experiment_quiet) {
  if (secprmove>0 and everplay_and_black() equal false and
      ( (iteration==2 and tv_nodes - tv_nodes_it_zero<   500) or
        (iteration==3 and tv_nodes - tv_nodes_it_zero<  2500) or
        (iteration==4 and tv_nodes - tv_nodes_it_zero< 12500) or
        (iteration==5 and tv_nodes - tv_nodes_it_zero< 60000)
      )
     ) w_antselply+=2;

}




  if (iteration % 2 equal 0) sgn_wh_bl=wh_bl; else sgn_wh_bl=wh_bl * -1;

  

  qdynamic=it4_qdyn*iteration/4; if (qdynamic equal 0) qdynamic=100;
  first_sel_ply=iteration;

  if (//iteration>1   // evt. ogs gres i senere iterationer........
      iteration>0   // ndret 17 mar 97
      and secprmove>0)
    {last_sel_ply=ANTSELPLY+w_antselply;  // lagt ind 17 mar 97
     /*everplay_setup();*/

     ant_sel_ply=last_sel_ply;
       last_sel_ply-=1;
     goto hertil;}

     ant_sel_ply=last_sel_ply;

     check_search=gem_check_search;

hertil:


  last_ply=iteration+ant_sel_ply+check_search;

  if (iteration equal 0)
    {ant_sel_ply=0; last_ply=(char)mslim[0];
     check_search=last_ply;

    }
  else if (limitpawnscore>5) limitpawnscore-=5;

  
  if (pb_on equal true) move_pointer[0]=mobilitet[0]-1;
  else                  move_pointer[0]=0;


  if (disctrace equal true)
        {writesecsofar();
         fprintf(fp,"Search to depth %d",(int)iteration);
        }
  if (gameplay equal true and dummy_search equal false and status!=everplay)
        {writesecsofar_gi();
         fprintf(gi,"Search to depth %d",(int)iteration);
        }
  if ((gameplay==true and gameplay_info equal true and dummy_search!=true
       and pb_on equal false) or
      (run_test equal true))
     printf("\n\n Search to depth %d",(int)iteration);
  if (info_out equal 0 and trace equal 0 and dummy_search!=true
      and run_test equal false and
      (pb_on equal false or pb_sw_move_received equal true)
      and status!=self_play and (gameplay==false or gameplay_info==false))
   
  if (info_out equal 1 or trace > 0)
   {printf("\n\n Search to depth %d",(int)iteration);
    printf("\n    plus a %d ply extended selektive search", (int)ant_sel_ply);
    if (it4_qdyn<80) printf(" (plus dynamic quiet move extension)");
    printf("\n    plus a %d ply check search\n", check_search);
   }


tita=-1;
titanic:
  
   if (show_pv && iteration>0 and mpc > 0 and move_fr[0][tita] != stop)
     {
           ++tita;
                     
                   my_best_score = move_value[0][tita];
                   if (intern == black) my_best_score *=-1;
                  
          
          if(intern == white && wh_bl equal white ||
             intern == black && wh_bl equal black) {
          
          if (pv_on) {
          printf("%d %d %d %8.0f ", iteration, my_best_score, secprmove, tv_nodes/40);
          pv_on = false;
          }
                
           print_a1_h8(&move_fr[0][tita]);
           print_a1_h8(&move_to[0][tita]);
           printf(" ");
          
           }
                 
      if (tita == iteration) goto out;        
      
      goto titanic;
     }

  out:
  // kan stadig g galt ved afbrydelse p tid.... se 15 linier nede....
   
  printf("\n");


  do {
      if (iteration equal 0 and wh_bl equal intern)
        {if (ply>last_ply or tv_nodes>msmax or
             move_pointer[ply]+mobilitet[ply]-realmoves[ply]>=msmoves()
            )
               {move_pointer[ply]=mobilitet[ply];       goto her;}  // nu
        }
g:   if (ply equal 1 and secprmove>0)
       {if (tv_nodes>check_time_at_nodes)
          {check_time_at_nodes=tv_nodes+(1000*speedfactor); // 21 okt
           if (iteration>2 and    timepctmovesofar()>90) // 21 okt 97
             {//if (move_pointer[1] equal 0)  // dette ikke prcist nok!!!
          // test p move_pointer skal evt. vre 1................
              
              best_score[0]=most_recent_best_score;
              undo_move(); mark_nodesstop='#';
             }
          }
       }
   
   
     get_next_good_move();

pb_move_typed_in:
    
    
     if (pb_on equal true)
       {++pb_count_bioskey;
        if (pb_count_bioskey>pb_count_limit)
           {pb_count_bioskey=0;
            if (bioskey()!=0)
              {bioschar=(char)bioskey();
               if (bioschar!='\b') printf("%c",bioschar);
               //pb_count_limit=speedfactor*10; // every 1/20 second
               if (pb_tv_1_4<19)
                  {if (bioschar equal '\b')
                    {if (pb_tv_1_4>0) {--pb_tv_1_4; printf("\b \b");}}
                   else pb_move_received[pb_tv_1_4++]=bioschar;
                   if ((int)bioschar equal 13)
                     {pb_move_received[pb_tv_1_4 - 1] = 0;
                      pb_opponents_time=(henttid() - startmovetime);
                      pb_oppo_nodes=tv_nodes;
                      add_movetime(pb_opponents_time, false, 0, 0);
                      startmovetime=henttid();
                      pb_sw_move_received=true;
                      pb_sw_move_guessed=pb_move_guessed();
                      if (pb_sw_move_guessed!=true) init_hash(); // hmmmmmmm

                      else {if (save_games==true) fprintf(pgn," {guessed:}");}


                      printf("\n"); 
                      if (pb_sw_move_guessed==true and pb_time_used==false)
                        {if (secprmove>0 and iteration>2)
                           {tpctmsf=timepctmovesofar();
                            if (tpctmsf>90 or
                                (move_pointer[1] equal 0 and
                                                 (tpctmsf-tpct_it_zero)>30)
                               )
                                 goto leave_now;
                           }
                        
                printf(" continue thinking...  time left: %d seconds   ",
                            (secprmove-(int)(pb_opponents_time/100)+1));
                        }
                      if (pb_sw_move_guessed==false or pb_time_used==true
                          or iteration equal last_iteration)
leave_now:              {keyboard_stop=true; // virker dette stop....

                         pb_undo_move_until_root();
       
       
       
        move_pointer[x]=mobilitet[x];
                         
                         
                         
                         goto he;
                        }
                     }
                  }
              }
           }
        
        if (iteration equal last_iteration)
           {pb_count_limit=0; goto pb_move_typed_in;}
       }
     if (ply equal 0)
       {
        if (move_fr[0][ move_pointer[0]] equal stop)
           {gem_mobil_zero=mobilitet[0]; mobilitet[0]=-44; goto her;} //dirty

        it_out=iteration; move_out=move_pointer[0];



        if (pb_on equal false)
          {if (iteration>2 and bioskey()!=0)
                        {bioschar=(char)bioskey();
                         if (bioschar equal 's')
                           {keyboard_stop=true;  goto he;}
                        }
          }
        if (secprmove>0 and iteration>2)
          {tpctmsf=timepctmovesofar();
          
           if (tpctmsf>90 or
                (((move_pointer[0] equal 0 and pb_on equal false) or
                  (move_pointer[1] equal 0 and pb_on equal true)
                 )
                   and (tpctmsf-tpct_it_zero)>30
                )
              )
                 if (pb_on equal true)
                    {pb_time_used=true;
                     if (pb_sw_move_received==true)
                        {keyboard_stop=true;
                         goto he;
                        }
                    }
                 else   {time_stop=true; goto he;}
          }
       }


     if (nullmove[ply]<99) make_move(&nullmovesq, &nullmovesq, false);
     else  make_move(&move_fr[ply][ move_pointer[ply]],
                     &move_to[ply][ move_pointer[ply]], false);

undo:
     if (make_move_status equal score_is_found)
        {minimax();
         if (ply>=2) evt_cut_off();
         undo_move();
         goto her;
        }
     if (make2_move_status equal pseudo_move)
       {undo_move(); realmoves[ply]--;
        if (ply equal 0) {move_pointer[0]-=1;
                          remove_move(move_pointer[0]);

             // 7/4-97    if (--mobilitet[0] equal 0) move_pointer[0]=125;

                         } //28/3
       }
     else {if (make_move_status equal make_cut_off)
            {  if (ply equal 1 and gem_sel_vurd[1] != 30111)   // hmmm
                   move_value[0] [move_pointer[0]]=gem_sel_vurd[1];

             if (ply<=trace)                 // and filtrace equal false)
                {  if (gem_sel_vurd[ply] != 30111)              // hmmm
                      best_score[ply]=gem_sel_vurd[ply];
                printf("S/tpo-cut %d %d",best_score[ply], best_score[ply_1]);
        
               }

                 minimax(); // hmmmmmm aht mms
             undo_move();
             goto her;
            }
          }
     if (( ply equal last_ply )

        )
      {
       if (realmoves[ply] equal 0)
         {if (king_in_check[ply] equal false)
           {vu=draw_score; best_score[ply]=draw_score; ++tv_pat;}

         }
       else best_score[ply]=vurdering();  // ply eq last ply
       vu=best_score[ply]; mms[ply]=best_score[ply];
    //   if (trace <= -10000 and tv_printline < tv_nodes)
       //  {tv_printline -= trace; print_line();}
       minimax();
       if (ply>=2) evt_cut_off();
       undo_move();
      }
     goto her;
he:
     best_score[0]=most_recent_best_score; // 28/4/98
     move_pointer[0]=mobilitet[0];
her:
     while ( move_pointer[ply]>=mobilitet[ply] )
     { if (ply_1<=plydyb and swhash==1 and p[ply].swnullhash==0
           
           )
         {uli_id_index=p[ply].hash_idx & hash_maxindex;
          read_hash(uli_id_index);
          if (hash.hash_score_final equal false
              and p[ply].hash_id  equal hash.hash_id
              and p[ply].hash_idx equal hash.hash_idx)
             {hash.hash_score_final=true; write_hash(uli_id_index);}
         }
       if (ply equal 0) { finished=true; break; }
       if (realmoves[ply] equal 0)
         {if (king_in_check[ply] equal false)
           {vu=draw_score; best_score[ply]=draw_score;
            mms[ply]=best_score[ply]; ++tv_pat;}
         }
       minimax();

   // does this work well???? any effect???

       if (ply>=2) evt_cut_off();
       undo_move();
    //   minimax();     // korrekt her.......???


     }                             // end of WHILE
     if (finished==true) break;
 
 
  }
  
  
  while ( true );                  // end of DO
  check_search=gem_check_search;
  if (mobilitet[0] equal -44) mobilitet[0]=gem_mobil_zero; //dirty

}


int game_evt_draw()
{
                
   if (!variant && dead_draw() equal true){
      printf("\ndraw by insuff. mat.\n"); 
      printf("game is a draw\n");
      return true;
      } else

        if (repeat3x_draw() equal true) {
           printf("\ndraw by 3 x repeat\n"); 
           printf("game is a draw\n");
           return true;
           } else 
        
            if (p[0].draw50>=100) {
                printf("draw by 50 move rule\n"); 
                printf("game is a draw\n");
                return true;
                }
             else return false;

             }



void mainline_move(signed char fr, signed char to, signed char maliout)
{  if (ply==1) {pb_move_fr=fr; pb_move_to=to; pb_move_ready=true;}


   if (ply<2 and maliout equal true) print_kqrbnp(sq[fr]);
   if (maliout equal true) {
           
           if (show_pv) {
              print_a1_h8(&fr);
                            print_a1_h8(&to); 
                        printf(" ");
                        }
                        }
   if (ply>0)
      {move_pointer[ply]=0; move_fr[ply][0]=fr; move_to[ply][0]=to;}
   make_move(&fr, &to, true);
}

void mainline(signed char maliout)
{  signed char /*tv=0,*/ wchar; int x;

 if (status equal self_play)  maliout=false;
    
   move_pointer[0]=0; pb_move_ready=false;
   if (best_move_fr[0]==stop) {happens[4]='4'; goto leave;}
   x=find_move_index(&best_move_fr[0], &best_move_to[0]);
   if (x==-1) {happens[5]='5'; goto leave;} // skal slettes igen
 
      {wchar=move_fr[0][0]; move_fr[0][0]=move_fr[0][x]; move_fr[0][x]=wchar;
       wchar=move_to[0][0]; move_to[0][0]=move_to[0][x]; move_to[0][x]=wchar;

      }


   mainline_move(move_fr[0][0], move_to[0][0], maliout);
r: uli_id_index=p[ply].hash_idx & hash_maxindex;
   read_hash(uli_id_index);
   if (    p[ply].hash_id  equal hash.hash_id
       and p[ply].hash_idx equal hash.hash_idx)
      {if (hash.hash_fr==stop) {happens[6]='6'; goto leave;}
       mainline_move(hash.hash_fr, hash.hash_to, maliout);
       if (ply==2 and maliout equal true) store_pb_pos();
       if (ply<14) goto r;
      }
leave:
   pb_undo_move_until_root();
}



void print_move()
{  signed char to, /*to2,*/ to_9_10_11,prom,promote_piece;//,promotion=false;
    if (status equal self_play) printf("  ");  // 3------->2  4/7
  
  
  
   print_best_move_ply_zero(true);
  
   
   if (status != self_play) printf("\n");
   
   
   if (experiment_quiet) {
   if (status != self_play )
      printf("\n  sel.depth=%d", (int)(ANTSELPLY+w_antselply));

    }

   

   game_evt_draw();

   if (disctrace equal true)
      {writesecsofar(); fprintf(fp,"calculation of move ended\n\n\n");}
   if (gameplay equal true and dummy_search equal false and status!=everplay)
      {writesecsofar_gi(); fprintf(gi,"calculation of move ended\n\n");}

   if (status != self_play && show_pv)
      {
                
        my_best_score = best_score[0];
        if (intern == black) my_best_score *=-1;
                         
       if(intern == white && wh_bl equal white ||
             intern == black && wh_bl equal black) {
       printf("%d %d %d %8.0f ", it_out, my_best_score, secprmove, tv_nodes/40);  
   if (icc) printf("tellics whisper kibitz %d %d %d %8.0f ", it_out, my_best_score, secprmove, tv_nodes/40);        
      
      
      
      }
        
 
       }
       
      
   if (swhash equal 1) mainline(true); else pb_move_ready=false;
  
}

void computer_x()
   {signed char x;
    initialize_best_score();
    mslim[1]=1000; mslim[2]=1000000; mslim[3]=100000000; mslim[4]=900000000;
a:  computer();
    if (iteration equal 0)
      {if (best_score[0] != w_materiel[0]-b_materiel[0]+wh_bl*30 and
                // silly.....................
          best_score[0] != w_materiel[0]-b_materiel[0]-wh_bl*30)
          {matesearch_score=best_score[0];
           ms_fr=best_move_fr[0];
           ms_to=best_move_to[0];
          }
       else   matesearch_score=no_good_found;
      }


    if (iteration equal 0 and status != self_play and status != everplay)
       if (!(gameplay==true and gameplay_info != true))
         {for (x=0; x<=max_ply and p[x].e_p != 107; ++x) {};   // dirty...
            printf(" max depth reached = %d halfmoves.",x-1);
            printf("\nnodes: %8.0f;  max: %8.0f ", tv_nodes, msmax);
            if (matesearch_score!=no_good_found and mate_found()==false)
               {printf("\n Something good was found...: ");
                print_best_move_ply_zero(false);
                print_vurdering(best_score[0]);
               }
                printf("\n End of mate-search...");
          }

    if (iteration equal 0 and last_ply<24 and

         ((secprmove equal 0 and (msmax/(tv_nodes+1))>3)
            or   // don't continue matesearch if more than 1/3 is used
          (secprmove > 0 and
    
           ((double)secprmove* MSPCT) / (henttid()-timemovestart+1) >3)
         )
        and mate_found() equal false)
       {if ((mslim[0] equal 8 or mslim[0] equal 16) and secprmove>0)
        {if ((henttid()-timemovestart) > 20)
         {
          {
           msmax=(((double)secprmove*100
                  *MSPCT/100) / // 20% of time for matesearch
                  (double)(henttid()-timemovestart  +1)  // time used so far
                 ) * tv_nodes;
           if (msmax<500*(double)speedfactor)
                                   msmax=500*(double)speedfactor;
          }
         }
         else
         {{//mate_sch_pos[0]=9000+(100*(d/f)speedfactor);  // denne kode ligger
                msmax=(double)secprmove*(double)speedfactor*50; // dobbelt...
          }
         };
        }
         mslim[0]+=8; goto a;
       }
    full_evalu=gem_full_evalu;

    if (run_test equal true and iteration > 1
           and exitsolfound equal true
           and solution_mark equal '!' and solution_to != false
           and best_move_fr[0]==solution_fr and best_move_to[0]==solution_to)
                 q_test=true;
   }



int play_early_game_fast()
{  double q, step;
   if (secprmove<1) secprmove=1;
   q=(double)secprmove / sqrt((double)secprmove/2);
   step=((double)secprmove - q) / 4;
   return ( (double)secprmove - ( ((double)black_8-4  -1  ) * step)    );
}




// jn116
void calculate_secprmove()
{  double used_time, time_left; int moves_left, w_int;
   
    if (Fischerstartmin >0  &&  Fischersecmove == 0)  {  
    if (Fischerstartmin == 1)  { // special case 1 min bullet games
    secprmove = 1;
    }else{                               
    secprmove = (Fischerstartmin*120) / ((moves_inxmin+time_adjust)); 
    secprmove += Fischerstartmin;
}
    }
    else
     
    if (Fischerstartmin > 0 && Fischersecmove > 0)  {
    if (Fischerstartmin == 1)  { // special case 1 min bullet games
    secprmove = 1;
    }else{
    secprmove =  ((Fischerstartmin*120) + (Fischersecmove*60)) / ((moves_inxmin+time_adjust)); 
    secprmove += Fischerstartmin;
}
    }
    else
   
   if (gameinxmin>0)
      secprmove = gameinxmin*120/(40+time_adjust);
   
   
   else
   
   if (moves_inxmin>0)
      secprmove = 1 * min_forxmoves*120/(moves_inxmin+time_adjust);
      
   else
  
  
  secprmove = 2;
}


void make_display()
{  double kommatal;
   tid=henttid();
   kommatal=(tid-timemovestart-pb_opponents_time);
   if (kommatal<=0) kommatal=1;
   if (kommatal>maxmovetime) maxmovetime=kommatal;
   tv_sessionmovetime+=kommatal; ++tv_sessionmoves;
   if (matelvl_score!=30888)
     {best_score[0]=matelvl_score;
      best_move_fr[0]=matelvl_fr; best_move_to[0]=matelvl_to;
     }
   
   if (noprint equal true or pb_on equal true) goto zzz;
   if (status equal self_play) {
              print_move(); 
              goto zzz;}

   if (gameplay equal true) goto y;
   printf("\nnodes: %8.0f;  ", tv_nodes);
   printf("     of these pseudomoves: %8.0f", tv_pseudo_moves);
   printf("\nnodes at last ply: %8.0f", tv_last_ply);
   printf("       cut-off's: %8.0f;  ", tv_cutoff);
   if (tv_cutoff equal 0) tv_cutoff=1;
   printf("\n %8.1f nodes/cut-off.", (tv_nodes/tv_cutoff));
   printf("   repeat:%5.0f", tv_repeat);
   if (tv_error > 0)
     {if (run_test==false)  printf("\n %8.0f errors...", tv_error);}



y: 
     
     print_move();

   if (solution_mark equal '!' and solution_to != false)
     {
        if (best_move_fr[0]==solution_fr and best_move_to[0]==solution_to ||
        best_move_to[0]==solution_fr || best_move_fr[0]==solution_fr) {
        
        printf("\nRight move, DABBABA!\n");
        ++solved;
        solution_xxx[solu-1]='+';
        
        if (disctrace equal true) fprintf(fp,"\nCorrect solution!\n\n");
        
      }else{
       
        printf("\nWrong, DABBABA...  The right move is ");
        ++unsolved;
        solution_xxx[solu-1]='-';
        if (disctrace equal true) fprintf(fp,"\nIncorrect solution!\n\n");
        if (!normal_epd) {
        print_kqrbnp(sq[solution_fr]);
        print_a1_h8(&solution_fr);
                         print_a1_h8(&solution_to);
                         }else{
                         printf("-");
                         print_kqrbnp(sq[solution_fr]);
                         print_a1_h8(&solution_fr);
                        }
        printf("\n");
       }
     }
  
  
zzz:
   ;
}

void computer_and_display()
{  int gem_skift=skift, gem_swhash=swhash;
   signed char x, gem_pb_on;

   pb_opponents_time=0; pb_oppo_nodes=0;             w_antselply=0;
   everplay_setup(); nulstil(); matelvl_score=30888;
   pb_count_bioskey=0; pb_count_limit=speedfactor*10; // every 1/20 second

   tv_hash_error=0; tv_hash_nofinal=0;
   tv_hash_read=0; tv_hash_read_ok=0; tv_hash_read_ok_final=0;
   tv_hash_skriv=0; tv_hash_opdat=0; tv_hash_ejskriv=0; tv_hash_hit=0;

   sort_pili(piliwq); sort_pili(piliwr); sort_pili(piliwb);
   sort_pili(piliwn); sort_pili(piliwp);
   sort_pili(pilibq); sort_pili(pilibr); sort_pili(pilibb);
   sort_pili(pilibn); sort_pili(pilibp);

   limitpawnscore=20 + abs(bewerte_stellung() );
   check_time_at_nodes=10000/16; mark_nodesstop=' '; tpct_it_zero=0;
   black_8=count_black_8_row();
   if (gameinxmin>0 or min_forxmoves>0) calculate_secprmove();
   if (secprmove>0)
     {last_iteration=20; ant_sel_ply=ANTSELPLY+w_antselply;
      /*everplay_setup();*/ last_sel_ply=ant_sel_ply; // ok.....?
      check_search=0;}
   keyboard_stop=false; time_stop=false;
   if (status != self_play)
      {gem_pb_on=pb_on; pb_on=false;  pb_on=gem_pb_on;}
                                                                     vu=0;
   if (status equal everplay)
      printf("\nEverplay score - white: %5.2f  black: %5.2f  (white %3.2f%)",
                w_ever, b_ever, (w_ever*100/(w_ever+b_ever+0.0001)));
   for (x=0; x<=max_ply; ++x)
      {simple_kill1_to[x]=99; simple_kill2_to[x]=99;
       simple_kill1_fr[x]=0;  simple_kill2_fr[x]=0;
       tv_s_kill1[x]=0;       tv_s_kill2[x]=0;
       s_kill1_oldpre[x]=0;   s_kill2_oldpre[x]=0;
       simple_kill1_vu[x]=0;  simple_kill2_vu[x]=0;  // hjaelper det? nej....
       if (x>0) p[x].e_p=107;   // dirty...
       //nu ll mo ve[ply]=99;        // dirtysmart, but not enough...
      }

   random_move=0;      // vurd_node=-1;    
   gem_sel_vurd[0]=30111;
   always=always_cut;
   if (always equal 2)
     {
              if (!analyze_on && last_iteration>=4) {
                              always=0; 
                            //  else always=1;
                              }else{
                               always =1;
                               }
              } // test p secprmove
   centre[0]=0;
   timemovestart=henttid();
   tv_pseudo_moves=0; tv_nodes=0; tv_cutoff=0; tv_last_ply=0; tv_error=0;
   tv_repeat=0; tv_pat=0; matesearch_score=no_good_found;

   gem_full_evalu=full_evalu;
   iteration=1; sel_ply_now=false;
   if (mate_search != 0 and iterativ equal +1 and pb_on equal false)
     {sel_ply_now=true; ant_sel_ply=0;
      iteration=0;
      skift=0; swhash=0;
      full_evalu=0;
      first_dynamic_sel_ply[0]=0;
      sel_side[0]=intern;
      gen_moves_ply_zero();
      if (mobilitet[0] equal 0)
         {iteration=1; skift=gem_skift;
          full_evalu=gem_full_evalu; swhash=gem_swhash;}
      else {mslim[0]=8;
            if (secprmove equal 0)
               {mate_sch_pos[0]=((double)speedfactor/10)*
                         (double)mate_search*1000*(double)last_iteration/4;
                msmax=(((double)last_iteration*20000)-10000)
                         *((double)mate_search/10)
                         *(double)speedfactor/10;
 
               }
            else
               {mate_sch_pos[0]=9000+(100*(double)speedfactor);
 
                msmax=(double)secprmove*(double)speedfactor*50;
    
               }
           }
     }

   tv_printline= -1 * trace;
   initialize_best_score();
   q_test=false;

   if (iterativ != +1 and secprmove equal 0) iteration=last_iteration;

   for (; (iteration<=last_iteration
           and (mate_found() equal false or mate_ply>=iteration
                or pb_on equal true)
           and keyboard_stop equal false  and time_stop equal false
                                     and q_test equal false
           and (iteration<3 or move_fr[0][1] != stop or pb_on equal true));
                               ++iteration)
          {if (iteration equal 1 or iterativ != +1)
             {skift=gem_skift; swhash=gem_swhash;
   
              first_dynamic_sel_ply[0]=99;
              sel_ply_now=false;
              gen_moves_ply_zero();
          
             }
           
           if (move_fr [0][0] equal stop)
             {iteration=last_iteration+1;
              goto zzz2;
             }
           else
             computer_x();
          }

   make_display();
zzz2:

   if (gameinxmin>0 or min_forxmoves>0) secprmove=0;
   tv_allnodes+=tv_nodes;
     skift=gem_skift; swhash=gem_swhash;
     full_evalu=gem_full_evalu; // aht mat i matesch
}


void menu_diverse()
  {

  signed char valg='0', dum; int dumint;
         FILE *fp;
   for (; valg!='X'; )
      {printf("\n 1  Danish=German / English letters   ");
       printf("%s",men_letter);
       
       printf("\n 4  Value of queen : %d",men_value[6]);
       printf("\n 5  Value of knight: %d",men_value[3]);
       printf("\n 6  Moves without capture/pawnmove: %d",(int)p[0].draw50);
       printf("\n 7  Give draw a score of: %d",draw_score);
       printf("\n    total nodes in this session: %8.0f", tv_allnodes);
       printf("\n    max seconds for a move in this session: %6.2f",
                maxmovetime/100);
       printf("\n    avg seconds for the %8.0f moves in this session: ",
                tv_sessionmoves);
       if (tv_sessionmoves equal 0) printf("0");
       else printf("%4.2f",(tv_sessionmovetime / (100*tv_sessionmoves)) );
       printf("\n    max value reached for pawnstructure: %d ", maxpawn);
       printf("\n    pawn limit exceeded %6.0f times", pawnexceed);
       printf(" out of %8.0f\n", totalexcd);
       printf("\n--------------------------------------");
       print_pc_speed();
       printf("\n--------------------------------------\n");
       printf("\n X  Back to the main menu");
       printf("\n\n? ");
       scanf_char(&valg); valg=toupper(valg);
       if (valg equal '1')
          {if (men_letter[0] equal 'B') strcpy(men_letter,"P  NBRQK");
           else                         strcpy(men_letter,"B  SLTDK");
          }
      
       
       if (valg equal '4')
          {printf("queen value ? ");
           scanf_int(&men_value[6]);
          }
       if (valg equal '5')
          {printf("knight value ? ");
           scanf_int(&men_value[3]);
          }
       if (valg equal '6')
          {printf("number of halfmoves ? ");
           scanf_int(&dumint); p[0].draw50=(char)dumint;
          }
       if (valg equal '7')
          {printf("draw value ? ");
           scanf_int(&draw_score);
          }




      }
  }

static void loaded_pos() {
     
     printf("\nposition loaded.\n");
     printf("to analyze this position now,\n");
     printf("go back to main menu and select (2)\n");
     press_any_key_to_continue();
     }                  

void menu_positions()
  {

   signed char valg='0', dum;
   for (; valg!='X'; )
      {printf("\n\n");
      
       printf("\n 1  Quit");
       printf("\n 2  The matesearch finds g4+!! in a few seconds. (1,0,0)");
       printf("\n 3  Mate in 3 - 1.Nh6++ (4,4,0)");
 
       printf("\n 4  1.b7. quiet deep move: 4.Kb6! (4,6,0). Mate in 5 moves.");
       printf("\n 5  Mate in 12!! - in one second by the matesearch.");
       printf("\n 6  Mate in 2 moves by 1.Bb1!  (4,4,0)");
       printf("\n 7  Mate in 4 moves by 1.Rb6! (6,2,0)");
       printf("\n 8  Colditz-test 30: 1.Bxe5! (2,6,0)");
       printf("\n 9  P. Heine <> Larsen.  1.Bh4! (6,4,0) - yet too hard...");
       printf("\n A  Mate in 6 by 1.Kc2+ (discovered check...) (2,10,0)");
       printf("\n B  Kf6! (6,4,0) threat to a piece should extend the search");
       printf("\n C  Rg7+! - draw by repetition");
       printf("\n D  1. Qf1+# (6!,8!,0) - when is the mate in 7 seen?");
       printf("\n E  Type or copy/paste in a position");
       printf("\n F  Rd6 stalemate");
       printf("\n G  -,Rd6 stalemate");
       printf("\n H  -,Qc6 with mate");
       printf("\n I  Qc6 with mate");
       printf("\n J  Rh8+! mate in 6");
       printf("\n K  Re8+! (2,2,0) checksearch/matesearch finds this");
       printf("\n L  Rxf4! (2,2,0) checksearch/matesearch test...");
       printf("\n M  Position: 1.d7 mate in 2");
       printf("\n N  Position: 1.d6 mate in 3");
       printf("\n X  Back to the main menu");
       printf("\n\n? ");

       scanf_char(&valg); valg=toupper(valg);

       if (valg equal '1') {
                exit(0);
                }
       
       
       if (valg equal '2')
         {strcpy(xxx,"q7/1p2pppb/7p/1P5k/4PP1b/2P3PP/1N1N3K/6B1/w g3-g4+!");
          make_array_ply_zero();
          show_board();
          loaded_pos();
         
         }


       if (valg equal '3')
   {strcpy(xxx,"3B1rk1/1B2bNpp/1pP2p2/pp5n/5n1r/RQP3Pq/R4P1P/6K1/w Nf7-h6+!");
          make_array_ply_zero();
          show_board();
          loaded_pos();
          
         }
       if (valg equal '4')
         {strcpy(xxx,"k1b5/P1P5/PPpP4/2K5/8/8/2p5/8/w  b6-b7+!");
          make_array_ply_zero();
          show_board();
          loaded_pos();
          
         }
       if (valg equal '5')
{strcpy(xxx,"3nn3/2p2p1k/1p1pp1p1/p2B3p/r2B2N1/4P2N/3PKPP1/6q1/w  Nh3-g5+!");

          make_array_ply_zero();
          show_board();
          loaded_pos();
          
         }
       if (valg equal '6')
         {strcpy(xxx,"Q7/8/8/8/4B3/2K5/b7/k7/w  Be4-b1!");
          make_array_ply_zero();
          show_board();
          loaded_pos();
          
         }
       if (valg equal '7')
         {strcpy(xxx,"1R6/2p5/p1K5/k7/8/1P6/2P5/8/w Rb8-b6!");
          make_array_ply_zero();
          show_board();
          loaded_pos();
          
         }
       if (valg equal '8')

         {strcpy(xxx,"Q7/p4rkp/3q4/2p1p1N1/P1P5/8/7B/7K/w Bh2xe5!");
          make_array_ply_zero();
          show_board();
          loaded_pos();
         
         }
       if (valg equal '9')
    {strcpy(xxx,"1r3kr1/1bR1bp2/p3p3/3pP3/Rn4p1/6B1/1P2BPP1/3N2K1/w Bg3-h4!");
          make_array_ply_zero();
          show_board();
          loaded_pos();
         
         }
       if (valg equal 'A')
         {strcpy(xxx,"3r2bk/5p1p/4p3/8/1PP5/1PK4r/1Q6/B3b3/w");
          make_array_ply_zero();
          show_board();
          loaded_pos();
         
         }
       if (valg equal 'B')
         {strcpy(xxx,"8/6n1/2p4p/R1P1K3/2P5/4P3/P6P/r5k1/w Ke5-f6!");
          make_array_ply_zero();
          show_board();
          loaded_pos();
         
         }
       if (valg equal 'C')
         {strcpy(xxx,"8/4bK1k/npp4p/3p4/4p3/5nR1/8/8/w Rg3-g7+!");
          make_array_ply_zero();
          show_board();
          loaded_pos();
          
         }
       if (valg equal 'D')
         {strcpy(xxx,"8/8/p5q1/1p6/1P6/5K2/5Q1p/7k/w Qf2-f1+!");
          make_array_ply_zero();
          show_board();
          loaded_pos();
         
         }
       if (valg equal 'E')
         {printf("\n Type or copy/paste in a position - be careful!");
          printf("\n [example:] the startposition look like this");
          printf("\n  rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR/w\n? ");
          scanf_string();
          make_array_ply_zero();
          show_board();
          loaded_pos();
          
         }
         if (valg equal 'F')
          {strcpy(xxx,"K2R4/8/k6q/8/8/8/8/8/w Rd8-d6! ");
           make_array_ply_zero();
           show_board();
           loaded_pos();
          
          }
         if (valg equal 'G')
          {strcpy(xxx,"k2r4/8/K6Q/8/8/8/8/8/b Rd8-d6! ");
           make_array_ply_zero();
           show_board();
           loaded_pos();
           
          }
         if (valg equal 'H')
          {strcpy(xxx,"K2R4/8/k6q/8/8/8/8/8/b Qh6-c6! ");
           make_array_ply_zero();
           show_board();
           loaded_pos();
           
          }
         if (valg equal 'I')
          {strcpy(xxx,"k2r4/8/K6Q/8/8/8/8/8/w Qh6-c6! ");
           make_array_ply_zero();
           show_board();
           loaded_pos();
           
          }
         if (valg equal 'J')
          {strcpy(xxx,"r3rbk1/ppq2pp1/2p3P1/8/2n3P1/2N5/PPP2P2/1KQR3R/w Rh1-h8!");
           make_array_ply_zero();
           show_board();
           loaded_pos();
          
          }
         if (valg equal 'K')
          {strcpy(xxx,"7k/n7/8/8/4Rp2/8/8/7K/w Re4-e8+!");
           make_array_ply_zero();
           show_board();
           loaded_pos();
           
          }
         if (valg equal 'L')
          {strcpy(xxx,"7k/n6r/8/8/4Rp2/8/8/6KN/w Re4xf4+!");
           make_array_ply_zero();
           show_board();
           loaded_pos();
          
          }
         if (valg equal 'M')
          {strcpy(xxx,"k7/8/1K1P4/8/8/8/8/8/w d6-d7!");
           make_array_ply_zero();
           show_board();
           loaded_pos();
         
          }
         if (valg equal 'N')
          {strcpy(xxx,"k7/8/1K6/3P4/8/8/8/8/w d5-d6!");
           make_array_ply_zero();
           show_board();
           loaded_pos();
           
          }
      }
}



void winboard_analyze() {
     
   char *i;
   char path[1024];
   int gem_trace=trace, gem_info=info_out, take_a_look=0, 
   screen_info,posnr;
   int i2, gemwrand=wrand;
   double timeteststart, timefortest;
   trace=-30000; filtrc_error=0; wrand=0;
   scoresum=0,unsolu=0;
   
     last_iteration=100; last_sel_ply=2; check_search=2;
          mate_search=0; wrand=0; it4_qdyn=100; secprmove=0;              
     
     strcpy(solution_xxx,"..................................................");
     run_test = true; init_hash(); mpc=0;
     posnr = 0;
     take_a_look=0;
     disctrace = 0;
     exitsolfound = 0;
     info_out=0;
     filtrace=1;
     strcpy(xxx,gem_xxx);
     if (magic!=5) make_array_ply_zero();
     computer_and_display(); 
     pb_move_ready=false;
     }
      
     
     
 
 
void testfil()
  {FILE *filptr;
   char *i;
   char path[1024];
   int gem_trace=trace, gem_info=info_out, take_a_look=0, 
   screen_info,posnr;
   int gemwrand=wrand, gemposnr;
   double timeteststart, timefortest;
   trace=-30000; filtrc_error=0; wrand=0;
   scoresum=0,unsolu=0;
   

   printf("Type in an epd filename [example: wac.epd]\n");
   printf("(must be in engine folder)\n");
   printf ("or choose from below:\n\n");
   printf("  (e=endgame, i=insufmat, rb=rookbish\n");
   printf("  b=badmoves, bt=bt2630, c=Colditz, l=Larsen1,");
   printf(" m=matesrch, t=timetest)\n\n? ");
   scanf_string(); strcpy(filnavn, xxx);
   if (!strcmp(filnavn,"b")) {
                           strcpy(filnavn,"badmoves.epd");
                           normal_epd = false;
                           }else
   if (!strcmp(filnavn,"bt")) {
                            strcpy(filnavn,"bt2630.epd");
                            normal_epd=false;
                            }else
   if (!strcmp(filnavn,"c")) {
                           strcpy(filnavn,"Colditz.epd");
                           normal_epd=false;
                           }else
   if (!strcmp(filnavn,"e")) {
                           strcpy(filnavn,"endgmate.epd");
                           normal_epd=false;
                           }else
   if (!strcmp(filnavn,"i")     ) {
                           strcpy(filnavn,"insufmat.epd");
                           normal_epd=false;
                           }else
   if (!strcmp(filnavn,"rb")) {
                            strcpy(filnavn,"rookbish.epd");
                            normal_epd=false;
                            }else
   if (!strcmp(filnavn,"l")) {
                           strcpy(filnavn,"Larsen1.epd");
                           normal_epd=false;
                           }else
   if (!strcmp(filnavn,"m")) {
                           strcpy(filnavn,"matesrch.epd");
                           normal_epd=false;
                           }else
   if (!strcmp(filnavn,"t")) {
                           strcpy(filnavn,"timetest.epd");
                           normal_epd=false;
                           }else{
                           normal_epd=true;
                           }


   filptr = fopen(filnavn,"r");
   if (filptr equal NULL)
      {printf("Bad OPEN of file..."); goto testfil_exit;}
   strcpy(solution_xxx,"..................................................");
   run_test = true; init_hash(); mpc=0;
   printf("Which position number do you want (0=all)\n? ");
   scanf_int(&posnr); gemposnr=posnr;
   if (posnr <= 0)
     {printf("Pause at every position (1=yes)\n? ");
      scanf_int(&take_a_look);}
   else take_a_look=1;
   printf("Make a tracefile (dabbaba.trc) (1=yes)\n? ");
   scanf_int(&disctrace);
   if (disctrace equal true) fp=fopen("dabbaba.trc","w");
   printf("Exit position when right move is found (1=yes)\n? ");
   scanf_int(&exitsolfound);
   printf("Show full info? (1=yes)\n? ");
   scanf_int(&screen_info);
   if (screen_info) {
                    info_out=1, filtrace=1;
                    }else{
                    info_out=0, filtrace=0; 
                    }     
    
hopdab4:
   i = fgets(xxx, 120*2, filptr);
   timeteststart=henttid();

   for (; i != NULL and solu<50;)
      {printf("\n%s",xxx);
       if (xxx[0] != '#' and posnr>=0)
         {++solu;
          if (posnr==solu or posnr==0)
            {make_array_ply_zero();
               printf("\n%s",solution_xxx);
             if (take_a_look==1)
                {press_any_key_to_continue();
                 printf("\nComputing a move now.....\n");}
             computer_and_display(); pb_move_ready=false;
             scoresum+=best_score[0];
             mpc+=2;
             if (solution_mark equal '!' and solution_to != false)
                          {if (best_move_fr[0]==solution_fr and
                   best_move_to[0]==solution_to)
                {++solved;  
                if (!normal_epd) solution_xxx[solu-1]='+';
                }
               else
                { ; if (!normal_epd) solution_xxx[solu-1]='-';}   // ++unsolved 
              }
             else if (solution_mark equal '?' and solution_to != false)
                   {if (best_move_fr[0]!=solution_fr or
                        best_move_to[0]!=solution_to)
                     {++solved;  
                     if (!normal_epd) solution_xxx[solu-1]='+';
                     
                     }
                    else
                     {  if (!normal_epd) solution_xxx[solu-1]='-';} //++unsolved;
                   }
                  else { 
                       solution_xxx[solu-1]='?';
                       unsolu++;
                       }
             if (take_a_look equal 1) press_any_key_to_continue();
             i = fgets(xxx, 120*2, filptr);
             if (posnr>0 or keyboard_stop equal true) i=NULL;
            }
          else i = fgets(xxx, 120*2, filptr);
         }
       else
         {if (xxx[1] equal 'x') /* ndlsning indtil videre.. */
              i=NULL;
          else
              {if (posnr<0 and xxx[0] != '#') ++posnr;
               i = fgets(xxx, 120*2, filptr);}
         }
      }

   printf("\n [+ :solved]  [- :wrong]  [? :unsolved]\n"); 
   line_with_numbers();
   printf("\n%s\n",solution_xxx);
   timefortest=(henttid()-timeteststart)/100;
   printf("\n The test lasted for %8.2f sec.     %d positions solved",
                      timefortest, solved);
   printf("\n %d positions wrong solution  |  %d positions unsolved/wrong\n", unsolved, unsolu+unsolved);
   printf(" Sumscore = %10.0f\n",scoresum);
   if (filtrc_error>0) printf("\n*** %8.0f errors found ***",filtrc_error);
   if (gemposnr <= 0) {press_any_key_to_continue();}
   run_test = false; trace=gem_trace; info_out=gem_info;
   fclose(filptr);
testfil_exit:
   wrand=gemwrand;
   if (disctrace equal true)
      {fprintf(fp,"\n%8.2f sec.   End of Disc-trace\n",timefortest);
       disctrace=false;}// i2=fclose(fp);}
  }




void make_real_move()
{  --ply; --ply_1;
   p[0]=p[1]; ++mpc; 
   calculate_hashkey();  // kan slettes.....
   if (p[0].hash_id!=uli_id or p[0].hash_idx!=uli_idx)  // kan slettes.....
    {happens[2]='2';

     p[0].hash_id=uli_id; p[0].hash_idx=uli_idx;  // kan slettes.....
    }
   store_hash_for_3xrepeat();
   b_materiel[0]=b_materiel[1];  w_materiel[0]=w_materiel[1];
}


void remove_evt_pseudomoves()
{  // for ogsaa at fjerne pseudomoves i varianter af skak,
   // laves en minisearch...
   int aa, ab, ac, ad, ae, af, ag, ah, ai, aj, ak, al;
   aa=last_iteration; ab=last_sel_ply; ac=check_search; ad=mate_search;
   ae=iterativ; af=info_out; ag=secprmove; ah=gameinxmin; ai=mateinx;
   aj=swhash; ak=moves_inxmin; al=min_forxmoves;
   last_iteration=1; last_sel_ply=1; check_search=0; mate_search=0;
   iterativ=0; info_out=0; secprmove=0; gameinxmin=0; mateinx=0; swhash=0;
   moves_inxmin=0; min_forxmoves=0;
   intern*=-1; noprint=true;
   computer_and_display();
   intern*=-1; noprint=false;

   last_iteration=aa; last_sel_ply=ab; check_search=ac; mate_search=ad;
   iterativ=ae; info_out=af; secprmove=ag; gameinxmin=ah; mateinx=ai;
   swhash=aj; moves_inxmin=ak; min_forxmoves=al;
}

void end_selfplay_game()
{   status=normal_game;
  
      show_seconds_used();
  
}

void turn_gamesaving_on()
{   
    if (save_games equal false)
      {
       save_games=true;
       pgn=fopen("games.txt","w"); fprintf(pgn,"\n\n\n[Event \"x\"]\n");
  
   }
}

int game_over()
{       
      
        if (variant) {                            
              
        if (game_evt_draw() equal true or 
             chess_variant equal rooksquare and rooksquare_mate() equal true)  {
        return true; 
        }

    
        if (chess_variant equal rooksquare and rooksquare_mate() equal true 
        or chess_variant equal extinct and extinct_mate() equal true )  {
        return true; 
        }}
        
             
        if (!variant && game_evt_draw() equal true) {
        return true; 
        }
        
        
        return false;
      
        }
        
                      



       void helpmenu() {
       signed char valg='0', dum; int dumint, valg2;
       info_out=1, trace=1;
   for (; valg!='!'; ) {
        
        printf("\n");
        printf("\n 0  Level: ");
        if (secprmove>0) printf(" %d seconds pr. move",secprmove);
       if (gameinxmin>0) printf(" Game in %d minutes",gameinxmin);
       if (moves_inxmin>0) printf(" %d moves in %d minutes",
                                    moves_inxmin, min_forxmoves);
       if (mateinx>0) printf(" Mate in %d moves",mateinx);
       if (secprmove equal 0 and gameinxmin equal 0 and mateinx equal 0
           and moves_inxmin equal 0)
        {printf("fixed depth - see next line");
         printf("\n 1  (x,x,x) Brute-force depth: %d",(int)last_iteration);
         printf("  selektive depth: %d",(int)last_sel_ply);
         printf("  check-search depth : %d",check_search);
         }
        printf("\n 1  Quit");
        printf("\n 2  Compute a single move in the current testposition");
      
       printf("\n 3  Menu: positions");
       printf("\n 4  Menu: Special options");
       printf("\n 5  Chesspositions in files");
       printf("\n 6"); //  Top-kill : %d",top_kill);
       printf("  selektiv search dynamic limit: %d",it4_qdyn);
       printf("   initiativ change : %d",skift);
       printf("\n 7  Iterativ search : %d",iterativ);
       printf("   simple-kill : %d",s_kill);
       printf("   always-cutoff it. 2: %d",always_cut);
       printf("\n A  Trace: %d",trace);
       printf("          screen-info: %d",info_out);
       printf("  full evaluation: %d",full_evalu);
       printf("\n C  Weights - mobility : %d",wmobil);
       printf("     centre : %d",wcentr);
       printf("   opening-tips : %d",wopen);
       printf("  king safety : %d",wkingsaf);
       printf("\n D  matesearch : %d              hash : %d      : %d"
               ,mate_search, swhash, wrand);
       printf("\n E  Bishop pair......: %d",bishoppair);
       printf("    exchange factor... : %d",exchf);
       printf("\n J  Magic number.....: %d",magic);
       printf("    weight pawnstruct. : %d",wpawn);
       printf("    quiet-pos sel.depth: %d",quiet_depth);
       printf("\n K  on/off(=0)  King centre: %d",king_centre);
       printf("    King corner: %d",king_corner);
       printf("    P near K: %d",P_near_enemy_K);
       printf("    Rook: %d",rook_placement);
menu_50:
       

       printf("\n\n? ");
       scanf_char(&valg); valg=toupper(valg);

       if (valg equal '1') {
                exit(0);
                }
       
       if (valg equal '0'){
                
         printf("\n 1. x seconds pr. move");
         printf("\n 2. game in x minutes");
         printf("\n 3. y moves in x minutes");
         printf("\n 4. fixed depth");
         printf("\n 5. mate in x moves\n\n? ");
         secprmove=0; gameinxmin=0; mateinx=0; full_evalu=1; mate_search=10;
         moves_inxmin=0; min_forxmoves=0;
         scanf_int(&valg2);
         if (valg2 equal 1)
             {printf("\nseconds pr. move\n? ");
              scanf_int(&dumint); secprmove=dumint;}
         if (valg2 equal 2)
             {printf("\nminutes pr. game\n? ");
              scanf_int(&dumint); gameinxmin=dumint;}
         if (valg2 equal 3)
             {printf("\nnumber of moves\n? ");
              scanf_int(&dumint); moves_inxmin=dumint;
              printf("\nin minutes\n? ");
              scanf_int(&dumint); min_forxmoves=dumint;}
         if (valg2 equal 4) valg='1';
         if (valg2 equal 5)
             {printf("\nnumber of moves\n? ");
              scanf_int(&dumint); mateinx=dumint;
              full_evalu=0; mate_search=0; matelvl_stop=true;
              if (mateinx<0) {mateinx=0-mateinx; matelvl_stop=false;}
              last_iteration=(2*mateinx)-1; ant_sel_ply=1; check_search=0;
             }
        }
       if (valg equal '1')
         {printf("Brute-force depth\n? ");
          scanf_int(&dumint); last_iteration=(char)dumint;
          printf("selektive depth\n? ");
     //     printf("(should be even; 4 evt. 2 is recommended)\n? ");
          scanf_int(&dumint); last_sel_ply=(char)dumint;
          printf("check-search depth\n? ");
     // printf("check-search depth (should be even; 4 evt. 2 is recommended)\n? ");
          scanf_int(&dumint); check_search=dumint;
         }
       if (valg equal '2') {strcpy(xxx,gem_xxx);
                            if (magic!=5) make_array_ply_zero();
                            computer_and_display(); pb_move_ready=false;
                           }
       if (valg equal '3') menu_positions();
       if (valg equal '4') menu_diverse();
       if (valg equal '5') testfil();
       if (valg equal '6')
         {
          printf("selektiv search DYNAMIC limit (100=no)\n? ");
          scanf_int(&dumint); it4_qdyn=dumint;
          printf("initiative change side in selektiv search (1=yes)\n? ");
          scanf_int(&dumint); skift=dumint;
         }
       if (valg equal '7')
         {
          printf("iterative search (1=yes)\n? ");
          scanf_int(&dumint); iterativ=dumint;
          printf("simple killers (0=no, 1,2(mate) (3='advanced'...) )\n? ");
          scanf_int(&dumint); s_kill=dumint;
          printf("always cut off (0=no,1=yes,2=auto)\n? ");
          scanf_int(&dumint); always_cut=dumint;
         }
       if (valg equal 'A')
         {printf("Trace depth 0-99\n");
          printf("   (-30000 = print line every 30000 nodes)\n\n? ");
          scanf_int(&trace);
          printf("information on screen (1=yes)\n? ");
          scanf_int(&dumint); info_out=dumint;

          printf("full evaluation (1=yes, 0=no=only materiel)\n? ");
          scanf_int(&dumint); full_evalu=dumint;
         }
         if (valg equal 'C')
         {printf("weights (8=normal, 16=double, 4=half etc.)\n");
          printf("mobility\n? ");
          scanf_int(&wmobil);
          printf("centre\n? ");
          scanf_int(&wcentr);
          printf("opening-tips\n? ");
          scanf_int(&wopen);
          printf("king safety\n? ");
          scanf_int(&wkingsaf);
         }
       if (valg equal 'D')
          {printf("mate search size at iteration 4 (0=none)\n? ");
           scanf_int(&dumint); mate_search=dumint;
           printf("use hashtables (0=no)\n? ");
           scanf_int(&dumint); swhash=dumint;
        printf("weight random opening moves\n? ");
           scanf_int(&dumint); wrand=dumint;
          }
       if (valg equal 'E')
          {printf("bishoppair weight\n? ");
           scanf_int(&dumint); bishoppair=dumint;
           printf("exchange factor (0=off)\n? ");
           scanf_int(&dumint); exchf=dumint;
          }

       if (valg equal 'J')
         {//printf("  2 also consider promotion to bishop and rook\n");
   //       printf("  3 allow more than one quiet move in each line\n");
          printf("( 3 iteration 1: no cut-off; try all moves)\n");
          printf("( 4 don't try to save time on pawn-evaluation)\n");
          printf("( 5 no extra make-array-ply-zero in 2) compute a move)\n");
          printf("( 6 no change side by non-quiet positions)\n");
          printf("  7 show all positions searched\n");
          printf("  8 show the board slowly\n");
          printf("(13 don't display ++-+-+...... line)\n");
          scanf_int(&magic);
          printf("\n\n weight pawn structure\n\n? ");
          scanf_int(&wpawn);
          printf("\n\n check quiet pos. depth in sel. search(0=never)\n\n? ");
          scanf_int(&quiet_depth);
        }


       if (valg equal 'R') {if (wrand==0) wrand=8; else wrand=0;}
       if (valg equal 'S')
           {if (mate_search==0) mate_search=10; else mate_search=0;}
       if (valg equal 'T')
         {last_iteration=2; last_sel_ply=2; check_search=2;
          mate_search=0; wrand=0; it4_qdyn=100; secprmove=0;
         }

      
       if (valg equal 'Y')
       {strcpy(xxx,"2bq3k/2p4p/p2p4/7P/1nBPPQP1/r1p5/8/1K1R2R1/b   Bc8e6");
       make_array_ply_zero();
       loaded_pos();
            }


}
}  


void ponder_move() {
     
      
    pb_sw_move_guessed=false;
    pb_sw_move_received=false;
    if (pb_move_ready equal true)
       {pb_on=true;
        pb_time_used=false;
        pb_tv_1_4=0;
        
        
        printf("   ...thinking on ");

        print_kqrbnp(sq[pb_move_fr]);
        print_a1_h8(&pb_move_fr); print_a1_h8(&pb_move_to);

        printf("\n");
        intern*=-1;                     
        computer_and_display();  
        intern*=-1; 
        pb_on=false;
       
        strcpy(xxx,pb_move_received);
           
       }
    else {if (save_games equal true) fprintf(pgn," {no perm.brain} ");
          scanf_string();
          
}    
}      



void play_a_game()
{   signed char fr, to, fri, toi, fri2, toi2, x/*, asp*/; int w_int;
    signed char to_9_10_11, promote_piece, y, gem_info=info_out;
    signed char pb_remember_fr, pb_remember_to;
    signed char ch2, ch3, valg;
    int moves;
    double everscore;
    char     command[256*4];
    char        line[256*4];
    char buf[256*4], buf2[30], buf3[30], buf4[30], buf5[30],
         buf6[30], buf7[30], buf8[30], buf9[30], buf10[30];
    char         msg[356];
    char fen[162*4];

   
    gameplay=true; info_out=0; trace=0;
    analyze_on = false;
    gi=fopen("gameinfo.trc","w");

    status=normal_game; solution_mark=false;
    if (count_black_8_row()<8)
      {
                              
     
    new_game();
      }
    intern*=-1;
    
     

 a:
    dummy_search=true;
    remove_evt_pseudomoves();
    dummy_search=false;

   

    if (game_over()==true or move_fr[0][0] equal stop)
       {
       move_fr[0][0]=stop; goto end_the_game;
       }

    startmovetime=henttid();                // undvendig?


signal(SIGINT, catch_sigint);
	 
 	 
 	 
 	 if (!xboard) printf("> "); 
 
  for (;;) {
      
      
      
       if (!fgets(line, 256, stdin)) return;

       if (line[0] == '\n') continue;

       
       
       sscanf(line, "%s", xxx); 
       
      

          
     
if (!strcmp(xxx,"go")) {
     status = normal_game;
     goto b;
     }                      
     

if (!strcmp(xxx,"exit") || !strcmp(xxx,"quit")) {
    
   
 // exit(0);
 ExitProcess(0);  // in final pgo compile change to ExitProcess(0) 
               // to kill process in memory on exit. 
               // hangs sometimes with exit(0)  - JA
              
     }
    

if (!strcmp(xxx,"new")) {
     status=normal_game;  
     move_count = 0;
    
     //******* variant selection must be initialized here before new_game()/setboard ********* - JA
     if (nightrider_variant)     printf("playing nightrider\n"),    nightrider_chess();
     else
     if (chancellor_variant)     printf("playing chancellor\n"),    chancellor_chess();
     else
     if (archbishop_variant)     printf("playing archbishop\n"),    archbishop_chess();
     else
     if (knightwazir_variant)    printf("playing knightwazir\n"),   knightwazir_chess();
     else
     if (knightferz_variant)     printf("playing knightferz\n"),    knightferz_chess();
     else
     if (knightdabbaba_variant)  printf("playing knightdabbaba\n"), knightdabbaba_chess();
     else
     if (knightalfil_variant)    printf("playing knightalfil\n"),   knightalfil_chess();
     else
     if (extinct_variant)        printf("playing extinct\n"),       extinct_chess();
     else
     if (gridchess_variant)      printf("playing gridchess\n"),     grid_chess();
     else
     if (rooksquare_variant)     printf("playing rooksquare\n"),    rooksquare_chess();
     else
     if (pawnfreeze_variant)     printf("playing pawnfreeze\n"),    pawnfreeze_chess();
     else
     if (knightmate_variant)     printf("playing knightmate\n"),    knightmate_chess();
     else
     if (shatranj_variant)       printf("playing shatranj\n"),      shatranj_chess();
     else
     if (fischerandom_variant)   printf("playing fischerandom\n"),  fischerandom_chess();
     //*********************************************************************************
        
     new_game();   
     intern*=-1;  
     if (icc) printf("tellics say Thanks for playing me!\n");
     goto a;
     }    
     
     
if (!strcmp(xxx,"setboard")) {
    
      sscanf(line, "setboard %s %s %s %s %s %s %s %s %s %s", buf, buf2, 
             buf3, buf4, buf5, buf6, buf7, buf8, buf9, buf10);
			
            strcat(buf, " ");
			strcat(buf, buf2);
			strcat(buf, " ");
			strcat(buf, buf3);
			strcat(buf, " ");
			strcat(buf, buf4);
			strcat(buf, " ");
			strcat(buf, buf5);
			strcat(buf, " ");
			strcat(buf, buf6);
			strcat(buf, " ");
			strcat(buf, buf7);
			strcat(buf, " ");
			strcat(buf, buf8);
			strcat(buf, " ");
			strcat(buf, buf9);
			strcat(buf, " ");
			strcat(buf, buf10);
            strcpy(xxx,buf);
            make_array_ply_zero();
         //   show_board();
            use_setboard=true;
            strcpy(fen,xxx);
            new_game();   
            intern*=-1;  
            goto a;        
		}       
                 

if (!strcmp(xxx, "protover")) {
     printf("feature colors=1 myname=\"Dabbaba %s by Jens Bk Nielsen\"\n",VERSION);
     printf("feature time=1 pause=0 name=1 reuse=0 ping=1 draw=1 analyze=1 setboard=1\n"); 
     printf("feature sigint=0 sigterm=0 ics=1\n");
     printf("feature variants=\"normal,knightmate,fairy,shatranj,fischerandom\"\n");
     printf("feature done=1\n");
     continue;
     }
           
    

     
if(!strcmp(xxx,"ping")) {
  int ping;
  sscanf(line,"%*s %d",&ping);
  printf("pong %d",ping); 
}   


if (!strcmp(command, "draw")) { // if opponent offers a draw - JA

           my_best_score = best_score[0];
           if (intern == black) my_best_score *=-1;
           
           if (mpc > 200 && my_best_score <= 0) {         
		   printf("offer draw\n");                          
		  
           continue;
	}else{
  
           printf("draw offer declined!");
           printf("Dabbaba is still optimistic about it's chances\n");
           printf ("to win!\n"); 		
}}
              
       
if (!strcmp(xxx, "result")) {
     char result[256];
     sscanf(line,"result %s",result);
     continue;
     }   
     
     
 if (!strcmp(xxx, "force")) {
     status = monitor;
     continue;
     }       
           
           
           
if (!strcmp(xxx, "white")) {
     continue;
     }


if (!strcmp(xxx, "black")) {
     continue;
     }


 
if (!strcmp(xxx, "sd")) {
			sscanf(line, "sd %d", &max_depth);
			max_time = 1000000;
			last_iteration = max_depth;
			continue;
		}    



if (!strcmp(xxx, "st")) {
	        sscanf(line, "st %d", &max_time);            
            secprmove = max_time;
			continue;                    
            };
 
 
 
 
             
 //secprmove     = seconds per move
 //gameinxmin    = minutes per game
 //moves_inxmin  = number of moves
 //min_forxmoves = minutes for moves
         
       
             
     
if (!strcmp(xxx, "time")) {
     sscanf(line, "time %d", &max_time);
     max_moves = 40;
     max_time /=1000; 
     moves_inxmin = max_moves;
     min_forxmoves = max_time;
     continue;
     }     
           
    
         
if (!strcmp(xxx, "level")) {
     sscanf(line, "level %d%d%d", &max_moves,&max_time,&inc_time);
     if (!max_moves) max_moves = 40; // can't have zero values here
     moves_inxmin = max_moves;
     Fischerstartmin = max_time;    
     Fischersecmove = inc_time;      
   	 continue;        
}       
       
  
        
        
        
if (!strcmp(xxx, "computer")) {    
     continue;          
     }
     
     
     
if (!strcmp(xxx, "help")) {
     helpmenu();
     continue;          
     }   
                
           
        
if (!strcmp(xxx, "hard")) {
     ponder_on = false; // switched off till fixed - JA
     continue;          
     }   
           
                  
if (!strcmp(xxx, "easy")) {
     ponder_on = false;
     continue;          
     }    
     
        
     
if (!strcmp(xxx, "analyze")) {
      max_time = 1000000; 
      max_depth = 32; 
      analyze_on = true;
      status=monitor;                
      winboard_analyze(); 
      goto a;
     }  
     
       
     
 if (!strcmp(xxx, "post")) {
     show_pv = true;
     continue;          
     }  
     
if (!strcmp(xxx, "nopost")) {
     show_pv = false;
     continue;          
     }              
     
     
     
if (!strcmp(xxx, "told")) {
			// told via "tell" msg or left a msg via "message"
			strcpy(msg, (line+5));
			printf("tellics kibitz %s\n",msg);
			printf("tellics draw\n");			
		}
	
if (!strcmp(xxx, "whispered")) {
			// whispered to via "whisper"
	}
		
 if (!strcmp(xxx, "heardkibitz")) {
			// picked up a kibitz
}
		
if (!strcmp(xxx, "heardshout")) {
}
		
if (!strcmp(xxx, "heardsshout")) {

}

if (!strcmp(xxx, "ics")) { // are we on an internet chess server?
			if(line[4] == '-') {
				icc = false;
			} else {
				icc = true;
			}
			continue;
		}

     
     
     
if (!strcmp(xxx, "?")) { 
          goto b;
          }          
     
                                 
                        
           
if (!strcmp(xxx, "xboard")) {
     printf("feature done=0\n");
     xboard = true;
     continue;          
     }      
              
  

          if  (!ponder_on) {
          intern*=-1; add_movetime(henttid() - startmovetime, true, 0, 0);
          intern*=-1;
          startmovetime=henttid();
          }           
      
efter_scanstring:


 
    if (strcmp(xxx,"sg") equal 0) strcpy(xxx,"savegames");
    if (strcmp(xxx,"savegames") equal 0) {turn_gamesaving_on(); goto a;}


     if (strcmp(xxx,"info") equal 0)
       {if (gameplay_info==true) {gameplay_info=false;
                                  printf("\nInfo is now OFF");}
        else                     {gameplay_info=true;
                                  printf("\nInfo is now ON");}
        goto a;}
   
   
   
    if (strcmp(xxx,"e16") equal 0) {strcpy(xxx,"everplay"); evermoves_160=16;}
    if (strcmp(xxx,"e2") equal 0) {strcpy(xxx,"everplay"); evermoves_160=2;}
    if (strcmp(xxx,"e60") equal 0) {strcpy(xxx,"everplay"); evermoves_160=60;}
    if (strcmp(xxx,"e") equal 0) strcpy(xxx,"everplay");
    if (strcmp(xxx,"s") equal 0) strcpy(xxx,"selfplay");
    if (strcmp(xxx,"selfplay") equal 0)
      {status=self_play; goto play2;}
    if (strcmp(xxx,"everplay") != 0) goto play3;
    
    
    
    status=everplay; 
    w_ever=0; 
    b_ever=0; 
    fclose(gi);
    
       
    
play2:
    gameplay_info=-1; moves=0;  goto b;
play3:
    fri=xxx[0]; fri=tolower(fri); fri2=xxx[1];
    fr = (10 + (fri2 - '1' + 1) * 10) + (fri - 'a' + 1);
    toi=xxx[2]; toi=tolower(toi); toi2=xxx[3];
    to = (10 + (toi2 - '1' + 1) * 10) + (toi - 'a' + 1);
promotion:
    if ((sq[fr]==w_p or sq[fr]==b_p) and (to>=a8 or to<=h1))
      {
      w_int=0;
      xxx[4]='Q'; xxx[5]=0; 
      w_int=6; 
      goto prom;  
             
    
prom:
       for (x=prom_q_9; x<=prom_n_11; ++x)
          {unpack_promotion(&x, &to_9_10_11, &promote_piece);
           if (w_int==promote_piece and to==fr + wh_bl * to_9_10_11)
             to=x;
          }

      };
      
    iteration=0; // fjernes engang.....
    x=0;
loop_x:
    if (move_fr[0][x] equal stop)
      { printf("\n\n"); goto a;}
    if ((move_fr[0][x] != fr) or (move_to[0][x] != to))
      {++x; goto loop_x;}

    fprintf(gi,"\n Opponent move: %s\n", xxx);
     
    if (save_games equal true)
       {fprintf(pgn," %s ", xxx);
        if ((mpc+1) % 10 equal 0) fprintf(pgn,"\n");}

    last_ply=77;                        // fjernes engang.....
    if (pb_sw_move_guessed equal true)
       {best_move_fr[0]=pb_move_fr; best_move_to[0]=pb_move_to;
        mainline(false);
        if (pb_move_ready equal false)


           pb_sw_move_guessed=false;
           
        else {pb_remember_fr=pb_move_fr; pb_remember_to=pb_move_to;

             }
       }


    make_move(&fr, &to, true);

      

    make_real_move();
    intern*=-1;
     
    if (status equal monitor) goto a;
b:
    if (game_over() equal true)
       {printf("\n"); move_fr[0][0]=stop; goto end_the_game;}

    intern*=-1;
    if (pb_sw_move_guessed equal false)
       {
      
        computer_and_display();
       
        }
      
    else {best_move_fr[0]=pb_remember_fr; best_move_to[0]=pb_remember_to;
          
          make_display();
          
         }

    add_movetime(henttid() - startmovetime, false,
                 pb_opponents_time, pb_oppo_nodes); // giver midnatsfejl...


    if (status!=self_play) show_seconds_used();

    if (move_fr [0][0] equal stop) goto end_the_game;


               last_ply=1;             // fjernes engang.......
    mainline(false);

    make_move(&best_move_fr[0], &best_move_to[0], true); ++moves;

  
    if (status equal self_play and moves % 8 equal 0) printf("\n");

    make_real_move();
    
    
    if (status equal self_play or status equal everplay)
      {
      if (moves < evermoves_160 and
                 (keyboard_stop equal false or magic>99) ) {
                 startmovetime=henttid(); 
          goto b;
      }
      
           else goto end_the_game;
      }
      
       goto a;
  

end_the_game:
    if (move_fr [0][0] equal stop and status != everplay)
      {
      
       new_game(); 
       moves=0; intern=-1;
       pb_move_ready=false;
       printf("\n Oh, the game is over...   ");
       goto a;
       }
    
    if (status equal self_play) end_selfplay_game();
    if (status equal everplay and keyboard_stop equal false)
       {everscore=abs((double)best_score[0]);
        if (everscore>300) everscore=300;
        everscore=(everscore+((300-everscore)/2))/300;
        if (best_score[0]>0) {
        w_ever+=everscore; b_ever+=(1-everscore);
        }
        else{
        b_ever+=everscore; w_ever+=(1-everscore);
        }    
        new_game(); moves=0; intern=-1; goto b;
       }
    info_out=gem_info; fclose(gi);
    intern*=-1; gameplay=false; 
  }
}

     
  

void main_menu()
  {
          
       static int value;
           
       printf("\n");
       printf("\nWelcome to D A B B A B A  1998 Nov. 06.\n");
       printf("         by: Jens Bk Nielsen\n");          //  Bk made correct (for me....)  jn2008
       printf("         version %s\n",VERSION);
//  deleted jn2008       printf("\ntesters: Torsten Schoop and Torben Osted\n");
       printf("\nD A B B A B A plays chess & variants of chess\n");;
       printf("Winboard support by Jim Ablett [%s]\n",BUILDDATE);
       printf("\n");
       printf("type help for menu or\n");
       printf("type exit or quit to terminate\n");
      
      
      
     
       // set piece values from Dabbaba.ini //  
      
        for (value = 0; value <= 2000; value++) {
            
        if (queen_value  == value) men_value[6] = nc_men_value[6]  = value;  
        if (rook_value   == value) men_value[5] = nc_men_value[5]  = value;  
        if (bishop_value == value) men_value[4] = nc_men_value[4]  = value;   
        if (knight_value == value) men_value[3] = nc_men_value[3]  = value;  
        if (pawn_value   == value) men_value[2] = nc_men_value[2]  = value;  
       
       }
      
      
      
       
       play_a_game();

      }


     

int CDECL
   main()
   {

long unsigned int qqq; int x, y;
nullmove[0]=99;

setbuf(stdout, NULL);
setbuf(stdin, NULL);
setvbuf(stdout, NULL, _IONBF, 0);
setvbuf(stdin, NULL, _IONBF, 0);     

signal(SIGINT, catch_sigint);

ReadINIFile(INI_FILENAME);

//wrand=16;    deleted jn2008

if (experiment_quiet)
   quiet_depth= quiet_depth_ply;





do_alloc:
      hash_totbytes=(hash_maxindex)*sizeof(hash);
    //  hash_totbytes=32768*1000*3;
    hash_totbytes=32768;
    
    farp = (char far *) malloc((unsigned) hash_totbytes);
    
    printf("allocated %lu bytes for hashtables\n", hash_totbytes);
  

//hash_maxindex=256*1000*3;  
hash_maxindex=256;     
hash_maxindex-=1;

#define TTTT
#define TT

    plydyb=4;
    
 
    for (x=0; x<=h8; ++x) {
        for (y=0; y<=11; ++y) {
            
        randi_id [x][y]=random();
        randi_id [x][y] * (100000+random());
        randi_idx[x][y]=random();
        randi_idx[x][y] *(100000+random());
        }
       }


 



   randomize();

  
   intern=white;
   
    normal_chess();
   
   two_kings=2*men_value[w_k];

   status=normal_game;

   turn_gamesaving_on();

   new_game(); 
   {
    filtrace=false; 
    main_menu();
    }

   if (save_games equal true) {new_game(); // to get happens out
                               fclose(pgn);
                              }
  
  free(farp);
shit:
   return true;
  }
