
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

typedef  long long  I64;

#define  cMAX_PROBLEMS  2000    // Maximum number of problems in suite.
#define  cMAX_PLIES      100    // Maximum search depth.
#define  cMAX_FILES       32    // Max files entered on command line.

typedef struct tagPROB {
  I64  argtm[cMAX_PLIES];       // One element per ply complete, each element
                                //  is the time taken to complete the ply.
  int  ctm;                     // Number of plies complete.
}  PROB;

typedef  struct tagRUN {
  PROB  argprob[                // One element per problem, each element is
    cMAX_PROBLEMS];             //  a struct with all of the problem info.
  int  cprob;                   // Number of problems in this file.
}  RUN;

void VCollect(char * szFile, RUN * prun)
{
  FILE * pfI;
  char  aszBuf[256];
  int  cLine;
  
  if ((pfI = fopen(szFile, "r")) == NULL) {
    fprintf(stderr, "Can't open \"%s\"\n", szFile);
    exit(1);
  }
  prun->cprob = 0;
  for (cLine = 1;; cLine++) {
    if (fgets(aszBuf, sizeof(aszBuf), pfI) != aszBuf) break;
    if (aszBuf[0] == '!') {
      if (prun->cprob == cMAX_PROBLEMS) {
        fprintf(stderr, "Maximum problems exceeded: \"%s\", line %d\n",
          szFile, cLine);
        exit(1);
      }
      prun->cprob++;
      prun->argprob[prun->cprob - 1].ctm = 0;
    } else {
      int  ib;
      
      for (ib = 0; aszBuf[ib]; ib++)
        if (aszBuf[ib] != ' ') break;
      if (isdigit(aszBuf[ib])) {
        int  ply;

        for (ply = 0;;) {
          ply = ply * 10 + aszBuf[ib++] - '0';
          if (!isdigit(aszBuf[ib])) break;
        }
        if ((aszBuf[ib++] == '-') && (aszBuf[ib++] == '>')) {
          I64  tm;
          I64  tmMin;
          I64  tmSec;
          I64  tmHund;

          if (ply != prun->argprob[prun->cprob - 1].ctm + 1) {
            fprintf(stderr,
              "Expected ply %d, file: \"%s\", line %d\n",
              prun->argprob[prun->cprob - 1].ctm + 1,
              szFile, cLine);
            exit(1);
          }
          for (;; ib++)
            if (aszBuf[ib] != ' ') break;
          if (!isdigit(aszBuf[ib])) {
            fprintf(stderr, "Expected time: \"%s\", line %d\n",
              szFile, cLine);
            exit(1);
          }
          tmMin = tmSec = tmHund = 0;
          for (tm = 0;;) {
            tm = tm * 10 + aszBuf[ib++] - '0';
            if (aszBuf[ib] == ':') {
              tmMin = tm;
              if ((!isdigit(aszBuf[ib + 1])) ||
                (!isdigit(aszBuf[ib + 2])) ||
                (aszBuf[ib + 3] != ' ')) {
                fprintf(stderr,
                  "Bogus 'MM:SS': \"%s\", line %d\n",
                  szFile, cLine);
                exit(1);
              }
              tmSec = (aszBuf[ib + 1] - '0') * 10 + aszBuf[ib + 2] - '0';
              break;
            } else if (aszBuf[ib] == '.') {
              tmSec = tm;
              if ((!isdigit(aszBuf[ib + 1])) ||
                (!isdigit(aszBuf[ib + 2])) ||
                (aszBuf[ib + 3] != ' ')) {
                fprintf(stderr,
                  "Bogus 'SS.HH': \"%s\", line %d\n",
                  szFile, cLine);
                exit(1);
              }
              tmHund = (aszBuf[ib + 1] - '0') * 10 +
                aszBuf[ib + 2] - '0';
              break;
            } else if (!isdigit(aszBuf[ib])) {
              fprintf(stderr,
                "Bogus time \"%s\", line %d\n",
                szFile, cLine);
              exit(1);
            }
          }
          if (prun->argprob[prun->cprob - 1].ctm == cMAX_PLIES) {
            fprintf(stderr,
              "Maximum plies exceeded: \"%s\", line %d\n",
              szFile, cLine);
            exit(1);
          }
          prun->argprob[prun->cprob - 1].argtm[
            prun->argprob[prun->cprob - 1].ctm++] =
            tmMin * 60000 + tmSec * 1000 + tmHund * 10;
        }
      }
    }
  }
}

void VProcess(RUN * rgrun, int crun)
{
  int  iprob;
  I64  argtm[cMAX_FILES];
  int  irun;

  if (!crun) return;
  printf("             Depth        Time ");
  for (irun = 0; irun < crun; irun++) printf("%8d", irun + 1);
  printf("\n             ------ ---------- ");
  for (irun = 0; irun < crun; irun++) printf(" -------");
  printf("\n");
  for (irun = 0; irun < crun; irun++) argtm[irun] = 0;
  for (iprob = 0; iprob < rgrun[0].cprob; iprob++) {
    int  ctmMin;
    I64  tmFirst;

    ctmMin = cMAX_PLIES;
    for (irun = 0; irun < crun; irun++)
      if (rgrun[irun].argprob[iprob].ctm < ctmMin)
        ctmMin = rgrun[irun].argprob[iprob].ctm;
    tmFirst = (ctmMin == 0) ? 0 :
      rgrun[0].argprob[iprob].argtm[ctmMin - 1];
    printf("Problem %4d [%3d]: %10lld ", iprob + 1, ctmMin, tmFirst);
    for (irun = 0; irun < crun; irun++) {
      double rPercent;
      char  asz[16];

      if (ctmMin == 0) rPercent = 100.0;
      else if (!rgrun[0].argprob[iprob].argtm[ctmMin - 1]) rPercent = 100.0;
      else
        rPercent = 1.0/(
          (double)rgrun[irun].argprob[iprob].argtm[ctmMin - 1] /
          (double)rgrun[0].argprob[iprob].argtm[ctmMin - 1]);
   
      sprintf(asz, "%3.2f", rPercent);
      printf("%8s", asz);
      argtm[irun] += rgrun[irun].argprob[iprob].argtm[ctmMin - 1];
    }
    printf("\n");
  }
  printf("\nTotal             : %10lld ", argtm[0]);
  for (irun = 0; irun < crun; irun++) {
    double rPercent;
    char  asz[16];

    if (argtm[0] == 0) rPercent = 100.0;
    else rPercent = 1.0/( (double)argtm[irun] / (double)argtm[0]);
    sprintf(asz, "%3.2f", rPercent);
    printf("%8s", asz);
  }
  printf("\n");
}

int main(int argc, char * argv[])
{
  int  isz;
  RUN * rgrun;

  if (argc == 1) {
    fprintf(stderr, "Usage: log < file1 > [ file2 ... ]\n");
    exit(1);
  }
  if (argc - 1 > cMAX_FILES) {
    fprintf(stderr, "Maximum files exceeded.\n");
    exit(1);
  }
  if ((rgrun = malloc(sizeof(RUN) * (argc - 1))) == NULL) {
    fprintf(stderr, "Can't malloc.\n");
    exit(1);
  }
  for (isz = 1; isz < argc; isz++) VCollect(argv[isz], rgrun + isz - 1);
  VProcess(rgrun, isz - 1);
  return 0;
}
