#include <stdio.h>
#include <string.h>

static int num_solutions;
static char solutions[200];
static FILE *input;
static char buffer[120];

void main() {
  char filename[30];
  static int results[300];
  int position, i;
  extern int GetSolution(void);
  extern int GetResult(void);
  int notdone;

  printf("filename:");
  scanf("%s",filename);
  input=fopen(filename,"r");
  for (position=0;position<300;position++) {
    num_solutions=0;
    notdone=GetSolution();
    if (!notdone) break;
    results[position]=GetResult();
  }
  printf("    ");
  for (i=0;i<15;i++) 
    printf("%4d",i*20);
  printf("\n   +------------------------------------------------------------\n");

  for (position=0;position<20;position++) {
    printf("%2d |",position+1);
    for (i=0;i<15;i++) 
      if (results[position+i*20] >= 0)
        printf("%4d",results[position+i*20]);
      else
        printf("  --");
    printf("\n");
  }
}
int GetSolution(void) {
  char *noteof, *next;
  char *token;

  while (1) {
    noteof=fgets(buffer,120,input);
    if (!noteof) return(0);
    buffer[strlen(buffer)-1]=0;
    token=strtok(buffer," ");
    if (!token) continue;
    if (!strcmp(token,"solution")) {
      while(1) {
        next=strtok(0," ");
        next=strtok(0," ");
        if (!next) break;
        strcpy(solutions+10*num_solutions++,next);
      }
      return(1);
    }
  }
}

int GetResult(void) {
  char *noteof, *next;
  int secs=-1, ctime, i;

  do {
    noteof=fgets(buffer,120,input);
    buffer[strlen(buffer)-1]=0;
    if (strstr(buffer,"correct")) return(secs);
    while(1) {
      next=strtok(buffer," "); /* depth */
      if (!next) break;
      next=strtok(0," "); /*  time */
      if (!next) break;
      ctime=GetTime(next);
      if (ctime < 0) break;
      if (ctime > 1000) printf("next=%s\n",next);
      next=strtok(0," "); /* value */
      if (!next) break;
      next=strtok(0," "); /*  move */
      if (!next) break;
      if (!IsMove(next)) break;
      for (i=0;i<num_solutions;i++) {
        if (!strcmp(next,solutions+i*10)) {
          if (secs < 0) secs=ctime;
          break;
        }
      }
      if (i == num_solutions) secs=-1;
    }
  } while (noteof);
  return(-9);
}

int GetTime(char *time) {
  if (strchr(time,'s'))
    return(atoi(time));
  else if (strchr(time,':'))
    return(atoi(time)*60+atoi(strchr(time,':')+1));
  else return(-1);
}

int IsMove(char *move) {
  char first[]={"KQRBNabcdefghoO0"};
  char second[]={"KQRBNabcdefgh12345678x#+-="};

  if (!strchr(first,*move)) return(0);
  if (!strchr(second,*(move+1))) return(0);
  if ((strlen(move) > 2) && !strchr(second,*(move+2))) return(0);
  if ((strlen(move) > 3) && !strchr(second,*(move+3))) return(0);
  if ((strlen(move) > 4) && !strchr(second,*(move+4))) return(0);
  if ((strlen(move) > 5) && !strchr(second,*(move+5))) return(0);
  if ((strlen(move) > 6) && !strchr(second,*(move+6))) return(0);
  if ((strlen(move) > 7) && !strchr(second,*(move+7))) return(0);
  if (strlen(move) > 8) return(0);
  return(1);
}
