/*
 * Decompiled with CFR 0.152.
 */
package chess4j.utils;

import chess4j.App;
import chess4j.io.DrawBoard;
import chess4j.io.FenParser;
import chess4j.io.MoveParser;
import chess4j.moves.Move;
import chess4j.search.SearchIterator;
import chess4j.search.SearchStats;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class TestSuite {
    public static void process(File f) throws FileNotFoundException {
        BufferedReader in = new BufferedReader(new FileReader(f));
        String line = null;
        int cntLine = 0;
        int nCorrect = 0;
        int nProblems = 0;
        long totalNodes = 0L;
        long totalTime = 0L;
        ArrayList<Move> solutions = new ArrayList<Move>();
        try {
            while ((line = in.readLine()) != null) {
                System.out.println("====================================");
                System.out.println(String.valueOf(++cntLine) + " " + line);
                String remaining = FenParser.setPos(App.getBoard(), line);
                System.out.println("remaining: " + remaining);
                DrawBoard.drawBoard(App.getBoard());
                assert (remaining.startsWith("bm "));
                String[] strSolutions = remaining.substring(3, remaining.indexOf(59)).split(" ");
                assert (strSolutions.length > 0);
                solutions.clear();
                int i = 0;
                while (i < strSolutions.length) {
                    System.out.println("\tsolution #" + (i + 1) + ": " + strSolutions[i]);
                    Move mv = MoveParser.parseLegalMove(strSolutions[i], App.getBoard());
                    System.out.println("\tparsed: " + mv + "\n");
                    solutions.add(mv);
                    ++i;
                }
                long start = System.currentTimeMillis();
                Thread t = new Thread(SearchIterator.getInstance());
                t.start();
                t.join();
                long time = System.currentTimeMillis() - start;
                totalTime += time;
                ++nProblems;
                Move m = SearchIterator.getInstance().getLastPV().get(0);
                if (solutions.contains(m)) {
                    System.out.println("\nCORRECT! (" + ++nCorrect + "/" + nProblems + ")");
                } else {
                    System.out.println("\nINCORRECT! (" + nCorrect + "/" + nProblems + ")");
                }
                SearchStats stats = SearchIterator.getInstance().getLastSearchStats();
                long nodes = stats.getNodes();
                long hashProbes = stats.getHashProbes();
                long hashHits = stats.getHashHits();
                totalNodes += nodes;
                System.out.print("nodes: " + nodes);
                System.out.print(", time: " + time + " ms");
                System.out.println(", n/s: " + nodes * 1000L / (time + 1L));
                DecimalFormat df = new DecimalFormat("0.00");
                System.out.println("hash probes: " + hashProbes + ", hits: " + hashHits + " (" + df.format(new Double(hashHits) * 100.0 / (double)(hashProbes + 1L)) + "%)");
            }
            System.out.println("======================================================");
            System.out.println("attempted: " + nProblems + "; correct=" + nCorrect);
            System.out.print("nodes: " + totalNodes);
            System.out.print(", time: " + totalTime + " ms");
            System.out.println(", n/s: " + totalNodes * 1000L / (totalTime + 1L));
            System.out.println("======================================================");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

