/*
 * Decompiled with CFR 0.152.
 */
package chess4j.utils;

import chess4j.App;
import chess4j.board.Board;
import chess4j.board.BoardImpl;
import chess4j.io.FenParser;
import chess4j.moves.Move;
import com.megginson.sax.XMLWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Perft {
    public static long perft(Board b, int depth, XMLWriter writer) throws SAXException {
        if (depth <= 0) {
            return 1L;
        }
        if (writer != null) {
            writer.characters("\n");
            AttributesImpl att = new AttributesImpl();
            att.addAttribute("", "depth", "", "Integer", String.valueOf(depth));
            writer.startElement("", "depth", "", att);
        }
        List<Move> moves = App.getMoveGen().genLegalMoves(b);
        long n = 1L;
        for (Move m : moves) {
            if (writer != null) {
                writer.dataElement("move", m.toString());
            }
            b.applyMove(m);
            n += Perft.perft(b, depth - 1, writer);
            b.undoLastMove();
        }
        if (writer != null) {
            writer.endElement("depth");
        }
        return n;
    }

    public static void main(String[] args) {
        int depth = 3;
        String fen = "r3k2r/p1ppqpb1/bn2pnp1/3PN3/1p2P3/2N2Q1p/PPPBBPPP/R3K2R w KQkq -";
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("depth=")) {
                depth = Integer.valueOf(arg.substring(6));
            } else if (arg.startsWith("fen=")) {
                fen = arg.substring(4);
            }
            ++i;
        }
        System.out.println("running perft(" + depth + ")... ");
        System.out.println("fen=" + fen);
        long start = System.currentTimeMillis();
        long n = 0L;
        try {
            XMLWriter w = new XMLWriter(new FileWriter(new File("perft.xml")));
            w.startDocument();
            BoardImpl b = new BoardImpl();
            FenParser.setPos(b, fen);
            n = Perft.perft(b, depth, w);
            w.endDocument();
        }
        catch (ParseException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (SAXException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("perft complete!");
        System.out.println("nodes: " + n);
        long end = System.currentTimeMillis();
        System.out.println("elapsed time: " + (end - start) + " ms");
        System.out.println("rate: " + n * 1000L / (end - start) + " n/s\n");
    }
}

