/*
 * Decompiled with CFR 0.152.
 */
package chess4j.search;

import chess4j.App;
import chess4j.board.Board;
import chess4j.hash.TTable;
import chess4j.io.PrintGameResult;
import chess4j.io.PrintLine;
import chess4j.moves.Move;
import chess4j.search.Search;
import chess4j.search.SearchStats;
import chess4j.utils.GameStatus;
import chess4j.utils.GameStatusChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SearchIterator
implements Runnable {
    private static final SearchIterator INSTANCE = new SearchIterator();
    private static int maxDepth = 3;
    private List<Move> lastPV = new ArrayList<Move>();
    private SearchStats lastSearchStats = new SearchStats();

    private SearchIterator() {
    }

    public static SearchIterator getInstance() {
        return INSTANCE;
    }

    public List<Move> getLastPV() {
        return Collections.unmodifiableList(this.lastPV);
    }

    public SearchStats getLastSearchStats() {
        return this.lastSearchStats;
    }

    private void iterate() {
        Search search = App.getSearch();
        Board board = App.getBoard().deepCopy();
        ArrayList<Move> pv = new ArrayList<Move>();
        TTable.getInstance().clear();
        SearchStats stats = new SearchStats();
        int i = 1;
        while (i <= maxDepth) {
            search.search(pv, -50000, 50000, board, i, stats);
            assert (pv.size() > 0);
            System.out.print(String.valueOf(i) + ". ");
            PrintLine.printLine(pv);
            ++i;
        }
        assert (pv.size() > 0);
        this.lastPV.clear();
        this.lastPV.addAll(pv);
        this.lastSearchStats = stats;
        Move m = (Move)pv.get(0);
        App.getBoard().applyMove(m);
        System.out.println("move " + m);
        GameStatus gs = GameStatusChecker.getGameStatus(App.getBoard());
        if (gs != GameStatus.INPROGRESS) {
            PrintGameResult.printResult(gs);
        }
    }

    @Override
    public void run() {
        this.iterate();
    }
}

