/*
 * Decompiled with CFR 0.152.
 */
package chess4j.search;

import chess4j.App;
import chess4j.board.Board;
import chess4j.moves.Move;
import chess4j.search.Search;
import chess4j.search.SearchStats;
import java.util.ArrayList;
import java.util.List;

public class SearchImpl
implements Search {
    @Override
    public int search(List<Move> parent_pv, int alpha, int beta, Board board, int depth, SearchStats stats) {
        stats.incNodes();
        if (depth <= 0) {
            return App.getEval().eval(board);
        }
        Move bestMove = null;
        int alphaInit = alpha;
        ArrayList<Move> pv = new ArrayList<Move>();
        List<Move> moves = App.getMoveGen().genPseudoLegalMoves(board);
        int numMovesSearched = 0;
        for (Move move : moves) {
            board.applyMove(move);
            if (board.isOpponentInCheck()) {
                board.undoLastMove();
                continue;
            }
            int score = -this.search(pv, -beta, -alpha, board, depth - 1, stats);
            ++numMovesSearched;
            board.undoLastMove();
            if (score <= alpha) continue;
            alpha = score;
            bestMove = move;
        }
        if (numMovesSearched == 0) {
            if (board.isPlayerInCheck()) {
                return -30000;
            }
            return 0;
        }
        if (alpha > alphaInit) {
            parent_pv.clear();
            parent_pv.add(bestMove);
            parent_pv.addAll(pv);
        }
        return alpha;
    }
}

