/*
 * Decompiled with CFR 0.152.
 */
package chess4j.moves;

import chess4j.board.Square;
import chess4j.pieces.Piece;

public class Move {
    private Square _from;
    private Square _to;
    private Piece _captured;
    private Piece _promotion;

    public Move(Square from, Square to) {
        this._from = from;
        this._to = to;
    }

    public Move(Square from, Square to, Piece captured) {
        this(from, to);
        this._captured = captured;
    }

    public Move(Square from, Square to, Piece captured, Piece promotion) {
        this(from, to, captured);
        this._promotion = promotion;
    }

    public Piece captured() {
        return this._captured;
    }

    public Square from() {
        return this._from;
    }

    public Piece promotion() {
        return this._promotion;
    }

    public Square to() {
        return this._to;
    }

    public String toString() {
        return String.valueOf(this._from.toString()) + this._to.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Move)) {
            return false;
        }
        Move mv = (Move)obj;
        if (!mv.from().equals(this.from())) {
            return false;
        }
        if (!mv.to().equals(this.to())) {
            return false;
        }
        if (mv.captured() == null ? this.captured() != null : !mv.captured().equals(this.captured())) {
            return false;
        }
        return !(mv.promotion() == null ? this.promotion() != null : !mv.promotion().equals(this.promotion()));
    }
}

