/*
 * Decompiled with CFR 0.152.
 */
package chess4j.io;

import chess4j.Color;
import chess4j.board.Board;
import chess4j.board.CastlingRights;
import chess4j.board.File;
import chess4j.board.Rank;
import chess4j.board.Square;
import chess4j.pieces.Bishop;
import chess4j.pieces.King;
import chess4j.pieces.Knight;
import chess4j.pieces.Pawn;
import chess4j.pieces.Queen;
import chess4j.pieces.Rook;
import chess4j.utils.BlankRemover;
import java.text.ParseException;

public class FenParser {
    private static boolean debug = true;

    public static String setPos(Board b, String fen) throws ParseException {
        if (fen == null) {
            throw new ParseException("FEN is null", 0);
        }
        fen = fen.trim();
        b.clearBoard();
        fen = BlankRemover.trim(fen);
        String[] fen_pieces = fen.split(" ");
        if (fen_pieces.length < 4) {
            throw new ParseException("not enough parts to FEN.", 0);
        }
        FenParser.setPieces(b, fen_pieces[0]);
        FenParser.setPlayer(b, fen_pieces[1]);
        FenParser.setCastlingRights(b, fen_pieces[2]);
        FenParser.setEP(b, fen_pieces[3]);
        String remaining = "";
        int i = 4;
        while (i < fen_pieces.length) {
            remaining = String.valueOf(remaining) + fen_pieces[i] + " ";
            ++i;
        }
        return remaining;
    }

    private static void setCastlingRights(Board b, String s) throws ParseException {
        if (debug) {
            System.out.println("setCastlingRights: " + s);
        }
        if (s.equals("-")) {
            return;
        }
        char[] arr = s.toCharArray();
        int i = 0;
        while (i < arr.length) {
            switch (arr[i]) {
                case 'K': {
                    b.addCastlingRight(CastlingRights.WHITE_KINGSIDE);
                    break;
                }
                case 'k': {
                    b.addCastlingRight(CastlingRights.BLACK_KINGSIDE);
                    break;
                }
                case 'Q': {
                    b.addCastlingRight(CastlingRights.WHITE_QUEENSIDE);
                    break;
                }
                case 'q': {
                    b.addCastlingRight(CastlingRights.BLACK_QUEENSIDE);
                    break;
                }
                default: {
                    throw new ParseException("invalid character in setCastlingRights: " + s, i);
                }
            }
            ++i;
        }
    }

    private static void setEP(Board b, String s) throws ParseException {
        if (debug) {
            System.out.println("setEP: " + s);
        }
        if (s.equals("-")) {
            return;
        }
        char[] arr = s.toCharArray();
        if (arr.length != 2) {
            throw new ParseException("invalid string in setEP: " + s, 0);
        }
        int epsq = 0;
        if (arr[0] < 'a' || arr[0] > 'h') {
            throw new ParseException("invalid string in setEP: " + s, 0);
        }
        epsq = arr[0] - 97;
        if (arr[1] < '1' || arr[1] > '8') {
            throw new ParseException("invalid string in setEP: " + s, 0);
        }
        b.setEP(Square.allSquares().get(epsq += 8 * (8 - (arr[1] - 48))));
    }

    private static void setPieces(Board b, String s) {
        if (debug) {
            System.out.println("setPieces: " + s);
        }
        char[] arr = s.toCharArray();
        int sq = 0;
        int i = 0;
        while (i < arr.length) {
            File f = File.file(sq & 7);
            Rank r = Rank.rank(sq / 8);
            Square square = Square.valueOf(f, r);
            switch (arr[i]) {
                case 'K': {
                    b.addPiece(King.WHITE_KING, square);
                    ++sq;
                    break;
                }
                case 'k': {
                    b.addPiece(King.BLACK_KING, square);
                    ++sq;
                    break;
                }
                case 'Q': {
                    b.addPiece(Queen.WHITE_QUEEN, square);
                    ++sq;
                    break;
                }
                case 'q': {
                    b.addPiece(Queen.BLACK_QUEEN, square);
                    ++sq;
                    break;
                }
                case 'R': {
                    b.addPiece(Rook.WHITE_ROOK, square);
                    ++sq;
                    break;
                }
                case 'r': {
                    b.addPiece(Rook.BLACK_ROOK, square);
                    ++sq;
                    break;
                }
                case 'N': {
                    b.addPiece(Knight.WHITE_KNIGHT, square);
                    ++sq;
                    break;
                }
                case 'n': {
                    b.addPiece(Knight.BLACK_KNIGHT, square);
                    ++sq;
                    break;
                }
                case 'B': {
                    b.addPiece(Bishop.WHITE_BISHOP, square);
                    ++sq;
                    break;
                }
                case 'b': {
                    b.addPiece(Bishop.BLACK_BISHOP, square);
                    ++sq;
                    break;
                }
                case 'P': {
                    b.addPiece(Pawn.WHITE_PAWN, square);
                    ++sq;
                    break;
                }
                case 'p': {
                    b.addPiece(Pawn.BLACK_PAWN, square);
                    ++sq;
                    break;
                }
                case '8': {
                    sq += 8;
                    break;
                }
                case '7': {
                    sq += 7;
                    break;
                }
                case '6': {
                    sq += 6;
                    break;
                }
                case '5': {
                    sq += 5;
                    break;
                }
                case '4': {
                    sq += 4;
                    break;
                }
                case '3': {
                    sq += 3;
                    break;
                }
                case '2': {
                    sq += 2;
                    break;
                }
                case '1': {
                    ++sq;
                }
            }
            ++i;
        }
        assert (sq == 64);
    }

    private static void setPlayer(Board b, String s) throws ParseException {
        Color ptm;
        if (debug) {
            System.out.println("setPlayer: " + s);
        }
        if (s.equalsIgnoreCase("b")) {
            ptm = Color.BLACK;
        } else if (s.equalsIgnoreCase("w")) {
            ptm = Color.WHITE;
        } else {
            throw new ParseException("could not parse player: " + s, 0);
        }
        if (!ptm.equals(b.getPlayerToMove())) {
            b.swapPlayer();
        }
    }
}

