/*
 * Decompiled with CFR 0.152.
 */
package chess4j.hash;

import chess4j.Color;
import chess4j.board.CastlingRights;
import chess4j.board.Square;
import chess4j.pieces.Bishop;
import chess4j.pieces.King;
import chess4j.pieces.Knight;
import chess4j.pieces.Pawn;
import chess4j.pieces.Piece;
import chess4j.pieces.Queen;
import chess4j.pieces.Rook;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class Zobrist {
    private static Map<Piece, Integer[]> pieceMap = new HashMap<Piece, Integer[]>();
    private static Map<Color, Integer> playerMap = new HashMap<Color, Integer>();
    private static Map<CastlingRights, Integer> castlingMap = new HashMap<CastlingRights, Integer>();
    private static Map<Square, Integer> epMap = new HashMap<Square, Integer>();

    static {
        Random r = new Random();
        Zobrist.createZobristKeys(Pawn.BLACK_PAWN);
        Zobrist.createZobristKeys(Pawn.WHITE_PAWN);
        Zobrist.createZobristKeys(Rook.BLACK_ROOK);
        Zobrist.createZobristKeys(Rook.WHITE_ROOK);
        Zobrist.createZobristKeys(Knight.BLACK_KNIGHT);
        Zobrist.createZobristKeys(Knight.WHITE_KNIGHT);
        Zobrist.createZobristKeys(Bishop.BLACK_BISHOP);
        Zobrist.createZobristKeys(Bishop.WHITE_BISHOP);
        Zobrist.createZobristKeys(Queen.BLACK_QUEEN);
        Zobrist.createZobristKeys(Queen.WHITE_QUEEN);
        Zobrist.createZobristKeys(King.BLACK_KING);
        Zobrist.createZobristKeys(King.WHITE_KING);
        playerMap.put(Color.BLACK, r.nextInt());
        playerMap.put(Color.WHITE, r.nextInt());
        EnumSet<CastlingRights> crs = EnumSet.allOf(CastlingRights.class);
        for (CastlingRights cr : crs) {
            castlingMap.put(cr, r.nextInt());
        }
        List<Square> sqs = Square.allSquares();
        for (Square sq : sqs) {
            epMap.put(sq, r.nextInt());
        }
    }

    private static void createZobristKeys(Piece p) {
        Random r = new Random();
        Integer[] keys = new Integer[64];
        int i = 0;
        while (i < 64) {
            keys[i] = r.nextInt();
            ++i;
        }
        pieceMap.put(p, keys);
    }

    public static int getPieceKey(Square sq, Piece p) {
        return pieceMap.get(p)[sq.value()];
    }

    public static int getPlayerKey(Color c) {
        return playerMap.get((Object)c);
    }

    public static int getCastlingKey(CastlingRights cr) {
        return castlingMap.get((Object)cr);
    }

    public static int getEnPassantKey(Square sq) {
        return epMap.get(sq);
    }
}

