/*
 * Decompiled with CFR 0.152.
 */
package chess4j.eval;

import chess4j.Color;
import chess4j.board.Board;
import chess4j.board.Square;
import chess4j.eval.Evaluator;
import chess4j.pieces.Bishop;
import chess4j.pieces.Knight;
import chess4j.pieces.Pawn;
import chess4j.pieces.Piece;
import chess4j.pieces.Queen;
import chess4j.pieces.Rook;

public class EvalImpl
implements Evaluator {
    private static final int QUEEN_VAL = 900;
    private static final int ROOK_VAL = 500;
    private static final int KNIGHT_VAL = 300;
    private static final int BISHOP_VAL = 320;
    private static final int PAWN_VAL = 100;
    private static final int[] knightPST;
    private static final int[] pawnPST;

    static {
        int[] nArray = new int[64];
        nArray[0] = -5;
        nArray[1] = -5;
        nArray[2] = -5;
        nArray[3] = -5;
        nArray[4] = -5;
        nArray[5] = -5;
        nArray[6] = -5;
        nArray[7] = -5;
        nArray[8] = -5;
        nArray[10] = 10;
        nArray[11] = 10;
        nArray[12] = 10;
        nArray[13] = 10;
        nArray[15] = -5;
        nArray[16] = -5;
        nArray[18] = 15;
        nArray[19] = 20;
        nArray[20] = 20;
        nArray[21] = 15;
        nArray[23] = -5;
        nArray[24] = -5;
        nArray[25] = 5;
        nArray[26] = 10;
        nArray[27] = 15;
        nArray[28] = 15;
        nArray[29] = 10;
        nArray[30] = 5;
        nArray[31] = -5;
        nArray[32] = -5;
        nArray[33] = 5;
        nArray[34] = 10;
        nArray[35] = 15;
        nArray[36] = 15;
        nArray[37] = 10;
        nArray[38] = 5;
        nArray[39] = -5;
        nArray[40] = -5;
        nArray[42] = 8;
        nArray[45] = 8;
        nArray[47] = -5;
        nArray[48] = -5;
        nArray[51] = 5;
        nArray[52] = 5;
        nArray[55] = -5;
        nArray[56] = -10;
        nArray[57] = -10;
        nArray[58] = -5;
        nArray[59] = -5;
        nArray[60] = -5;
        nArray[61] = -5;
        nArray[62] = -10;
        nArray[63] = -10;
        knightPST = nArray;
        int[] nArray2 = new int[64];
        nArray2[8] = 30;
        nArray2[9] = 30;
        nArray2[10] = 30;
        nArray2[11] = 30;
        nArray2[12] = 30;
        nArray2[13] = 30;
        nArray2[14] = 30;
        nArray2[15] = 30;
        nArray2[16] = 14;
        nArray2[17] = 14;
        nArray2[18] = 14;
        nArray2[19] = 18;
        nArray2[20] = 18;
        nArray2[21] = 14;
        nArray2[22] = 14;
        nArray2[23] = 14;
        nArray2[24] = 7;
        nArray2[25] = 7;
        nArray2[26] = 7;
        nArray2[27] = 10;
        nArray2[28] = 10;
        nArray2[29] = 7;
        nArray2[30] = 7;
        nArray2[31] = 7;
        nArray2[32] = 5;
        nArray2[33] = 5;
        nArray2[34] = 5;
        nArray2[35] = 7;
        nArray2[36] = 7;
        nArray2[37] = 5;
        nArray2[38] = 5;
        nArray2[39] = 5;
        nArray2[40] = 3;
        nArray2[41] = 3;
        nArray2[42] = 3;
        nArray2[43] = 5;
        nArray2[44] = 5;
        nArray2[45] = 3;
        nArray2[46] = 3;
        nArray2[47] = 3;
        nArray2[51] = -3;
        nArray2[52] = -3;
        pawnPST = nArray2;
    }

    private EvalImpl() {
    }

    @Override
    public int eval(Board board) {
        int score = 0;
        for (Square sq : Square.allSquares()) {
            int pst;
            Piece p = board.getPiece(sq);
            if (p instanceof Pawn) {
                score += p.isWhite() ? 100 : -100;
                pst = pawnPST[sq.value()];
                score += p.isWhite() ? pst : -pst;
                continue;
            }
            if (p instanceof Rook) {
                score += p.isWhite() ? 500 : -500;
                continue;
            }
            if (p instanceof Knight) {
                score += p.isWhite() ? 300 : -300;
                pst = knightPST[sq.value()];
                score += p.isWhite() ? pst : -pst;
                continue;
            }
            if (p instanceof Bishop) {
                score += p.isWhite() ? 320 : -320;
                continue;
            }
            if (!(p instanceof Queen)) continue;
            score += p.isWhite() ? 900 : -900;
        }
        return board.getPlayerToMove().equals(Color.WHITE) ? score : -score;
    }
}

