/*
 * Decompiled with CFR 0.152.
 */
package chess4j.board;

import chess4j.board.File;
import chess4j.board.Rank;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Square {
    private static final List<Square> _squares;
    private static Map<File, List<Square>> _fileSquares;
    private static Map<Rank, List<Square>> _rankSquares;
    private final Rank _rank;
    private final File _file;

    static {
        Enum rank;
        int n;
        int n2;
        Enum[] enumArray;
        ArrayList<Square> squares;
        _squares = new ArrayList<Square>();
        _fileSquares = new HashMap<File, List<Square>>();
        _rankSquares = new HashMap<Rank, List<Square>>();
        Enum[] enumArray2 = File.values();
        int n3 = enumArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            File file = enumArray2[n4];
            squares = new ArrayList<Square>();
            enumArray = Rank.values();
            n2 = enumArray.length;
            n = 0;
            while (n < n2) {
                Rank rank2 = enumArray[n];
                squares.add(new Square(file, rank2));
                ++n;
            }
            _fileSquares.put(file, squares);
            ++n4;
        }
        enumArray2 = Rank.values();
        n3 = enumArray2.length;
        n4 = 0;
        while (n4 < n3) {
            rank = enumArray2[n4];
            squares = new ArrayList();
            enumArray = File.values();
            n2 = enumArray.length;
            n = 0;
            while (n < n2) {
                Enum file = enumArray[n];
                squares.add(new Square((File)file, (Rank)rank));
                ++n;
            }
            _rankSquares.put((Rank)rank, squares);
            ++n4;
        }
        enumArray2 = Rank.values();
        n3 = enumArray2.length;
        n4 = 0;
        while (n4 < n3) {
            rank = enumArray2[n4];
            File[] fileArray = File.values();
            n = fileArray.length;
            int n5 = 0;
            while (n5 < n) {
                File file = fileArray[n5];
                _squares.add(Square.valueOf(file, (Rank)rank));
                ++n5;
            }
            ++n4;
        }
    }

    private Square(File file, Rank rank) {
        this._file = file;
        this._rank = rank;
    }

    public Rank rank() {
        return this._rank;
    }

    public File file() {
        return this._file;
    }

    public String toString() {
        return String.valueOf(this._file.getLabel()) + this._rank.getLabel();
    }

    public int value() {
        return this._rank.getValue() * 8 + this._file.getValue();
    }

    public static Square valueOf(File file, Rank rank) {
        if (file == null || rank == null) {
            return null;
        }
        return _fileSquares.get((Object)file).get(rank.getValue());
    }

    public static Square valueOf(Rank rank, File file) {
        if (file == null || rank == null) {
            return null;
        }
        return _rankSquares.get((Object)rank).get(file.getValue());
    }

    public static List<Square> allSquares() {
        return Collections.unmodifiableList(_squares);
    }

    public static List<Square> fileSquares(File file) {
        return Collections.unmodifiableList(_fileSquares.get((Object)file));
    }

    public static List<Square> rankSquares(Rank rank) {
        return Collections.unmodifiableList(_rankSquares.get((Object)rank));
    }

    public boolean equals(Object o) {
        if (!(o instanceof Square)) {
            return false;
        }
        Square sq = (Square)o;
        return sq.file().equals(this._file) && sq.rank().equals(this._rank);
    }

    public int hashCode() {
        return this.value();
    }
}

