/*
 * Decompiled with CFR 0.152.
 */
package chess4j.board;

public enum Rank {
    RANK_8(0, "8"),
    RANK_7(1, "7"),
    RANK_6(2, "6"),
    RANK_5(3, "5"),
    RANK_4(4, "4"),
    RANK_3(5, "3"),
    RANK_2(6, "2"),
    RANK_1(7, "1");

    private int _value;
    private String _label;

    private Rank(int value, String label) {
        this._value = value;
        this._label = label;
    }

    public static Rank rank(int value) {
        Rank[] rankArray = Rank.values();
        int n = rankArray.length;
        int n2 = 0;
        while (n2 < n) {
            Rank r = rankArray[n2];
            if (r.getValue() == value) {
                return r;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Rank value not found: " + value);
    }

    public static Rank rank(String value) {
        Rank[] rankArray = Rank.values();
        int n = rankArray.length;
        int n2 = 0;
        while (n2 < n) {
            Rank r = rankArray[n2];
            if (r.getLabel().equalsIgnoreCase(value)) {
                return r;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Rank value not found: " + value);
    }

    public int distance(Rank r) {
        return Math.abs(r.getValue() - this.getValue());
    }

    public boolean equals(Rank r) {
        if (r == null) {
            return false;
        }
        return r.getValue() == this._value;
    }

    public Rank flip() {
        return Rank.rank(7 - this._value);
    }

    public String getLabel() {
        return this._label;
    }

    public int getValue() {
        return this._value;
    }

    public boolean isPromotionRank() {
        return this._value == RANK_1.getValue() || this._value == RANK_8.getValue();
    }

    public Rank north() {
        if (this._value == 0) {
            return null;
        }
        return Rank.rank(this._value - 1);
    }

    public boolean northOf(Rank r) {
        return this.getValue() < r.getValue();
    }

    public Rank south() {
        if (this._value == 7) {
            return null;
        }
        return Rank.rank(this._value + 1);
    }

    public boolean southOf(Rank r) {
        return this.getValue() > r.getValue();
    }

    public static void main(String[] args) {
        Rank[] rankArray = Rank.values();
        int n = rankArray.length;
        int n2 = 0;
        while (n2 < n) {
            Rank r = rankArray[n2];
            System.out.println((Object)((Object)r) + " " + r.getLabel() + " " + (Object)((Object)r.north()) + " " + (Object)((Object)r.south()));
            ++n2;
        }
    }
}

