/*
 * Decompiled with CFR 0.152.
 */
package chess4j.board;

public enum File {
    FILE_A(0, "a"),
    FILE_B(1, "b"),
    FILE_C(2, "c"),
    FILE_D(3, "d"),
    FILE_E(4, "e"),
    FILE_F(5, "f"),
    FILE_G(6, "g"),
    FILE_H(7, "h");

    private int _value;
    private String _label;

    private File(int value, String label) {
        this._value = value;
        this._label = label;
    }

    public boolean equals(File f) {
        if (f == null) {
            return false;
        }
        return f.getValue() == this._value;
    }

    public int getValue() {
        return this._value;
    }

    public String getLabel() {
        return this._label;
    }

    public int distance(File f) {
        return Math.abs(f.getValue() - this.getValue());
    }

    public boolean eastOf(File f) {
        return this.getValue() > f.getValue();
    }

    public boolean westOf(File f) {
        return this.getValue() < f.getValue();
    }

    public File east() {
        if (this._value == 7) {
            return null;
        }
        return File.file(this._value + 1);
    }

    public File west() {
        if (this._value == 0) {
            return null;
        }
        return File.file(this._value - 1);
    }

    public static File file(int value) {
        File[] fileArray = File.values();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getValue() == value) {
                return f;
            }
            ++n2;
        }
        throw new IllegalArgumentException("File value not found: " + value);
    }

    public static File file(String value) {
        File[] fileArray = File.values();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getLabel().equalsIgnoreCase(value)) {
                return f;
            }
            ++n2;
        }
        throw new IllegalArgumentException("File value not found: " + value);
    }

    public static void main(String[] args) {
        File[] fileArray = File.values();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            System.out.println((Object)((Object)f) + " " + f.getLabel() + " " + (Object)((Object)f.east()) + " " + (Object)((Object)f.west()));
            ++n2;
        }
    }
}

